/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as o}from"../../../lit/index.js";import{RichTextEditorToolbarBehaviors as r}from"../../rich-text-editor/lib/toolbars/rich-text-editor-toolbar.js";import{HaxTextEditorButton as n}from"./hax-text-editor-button.js";import{HAXStore as i}from"./hax-store.js";import{HaxContextBehaviors as s}from"./hax-context-behaviors.js";import"./hax-text-editor-paste-button.js";import{I18NMixin as u}from"../../i18n-manager/lib/I18NMixin.js";class HaxTextEditorToolbar extends(r(u(s(t)))){static get styles(){return[...super.baseStyles,...super.stickyStyles,o`
        :host {
          --rich-text-editor-button-color: var(--hax-ui-color);
          --rich-text-editor-button-bg: var(--hax-ui-background-color);
          --rich-text-editor-button-border-color: transparent;
          --rich-text-editor-button-hover-color: var(--hax-ui-color);
          --rich-text-editor-button-hover-bg: var(
            --hax-ui-background-color-secondary
          );
          --rich-text-editor-button-toggled-color: var(--hax-ui-color-accent);
          --rich-text-editor-button-toggled-bg: var(--hax-ui-background-color);
          --rich-text-editor-button-toggled-border-color: var(
            --hax-ui-color-accent
          );
          --rich-text-editor-button-disabled-opacity: 1;
          --rich-text-editor-button-disabled-color: var(
            --hax-ui-disabled-color
          );
          --rich-text-editor-button-disabled-bg: var(--hax-ui-background-color);
          --rich-text-editor-button-disabled-border-color: transparent;
        }
        #morebutton {
          align-self: flex-end;
        }
        ::slotted([icon-position]:hover) {
          --rich-text-editor-button-toggled-bg: var(
            --hax-ui-background-color-accent
          );
        }
        ::slotted(.group) {
          flex: 0 0 auto;
          justify-content: center;
          border-width: 1px;
          margin: -1px;
          padding: 0px;
          --simple-toolbar-button-width: 26px;
          --simple-toolbar-button-height: 26px;
        }
        ::slotted(.list-indent-button-group) {
          line-height: 20px;
        }
        ::slotted(.group),
        ::slotted([icon-position]) {
          z-index: 1;
        }
        ::slotted([icon-position]),
        :host([collapsed]) ::slotted(.group) {
          flex: 0 0 auto;
        }
        :host ::slotted(*:focus),
        :host ::slotted(*:focus-within) {
          z-index: 2 !important;
        }
        :host ::slotted(*:hover) {
          z-index: 3 !important;
        }
        div {
          --simple-toolbar-button-width: 26px;
          --simple-toolbar-button-height: 26px;
          line-height: 30px;
          height: 30px;
        }
        rich-text-editor-button {
          height: 32px;
          --simple-toolbar-button-width: 26px;
          --simple-toolbar-button-height: 26px;
          line-height: 32px;
        }
      `]}get tourTemplate(){return e` <div slot="tour" data-stop-content>
      ${this.t.textEditorToolbarTour}
    </div>`}render(){return super.toolbarTemplate}static get properties(){return{__updated:{type:Boolean}}}static get tag(){return"hax-text-editor-toolbar"}constructor(){super(),this.tag=HaxTextEditorToolbar.tag,this.t={undoButton:"Undo",redoButton:"Redo",formatButton:"Format",blockP:"Paragraph",blockH1:"Heading 1",blockH2:"Heading 2",blockH3:"Heading 3",blockH4:"Heading 4",blockH5:"Heading 5",blockH6:"Heading 6",blockPre:"Preformatted",italicButton:"Italic",boldButton:"Bold",underlineButton:"Underline",strikethroughButton:"Cross out",codeButton:"Code",markButton:"Highlight",abbrButton:"Abbreviation",removeFormatButton:"Remove format",linkButton:"Link",unlinkButton:"Remove Link",cutButton:"Cut",copyButton:"Copy",pasteButton:"Paste Clipboard",subscriptButton:"Subscript",superscriptButton:"Superscript",symbolButton:"Insert Symbol",emojiButton:"Insert Emoticon",imageButton:"Insert Image",orderedListButton:"Numbered list",unorderedListButton:"Bulleted list",blockquoteButton:"Blockquote",indentButton:"Indent",outdentButton:"Outdent",textEditorToolbarTour:"Change how the text is structured and visualized in the page."},this.registerLocalization({context:this,namespace:"hax"}),this.sourceView=!1,this.haxUIElement=!0,this.tourName="hax",globalThis.HaxTextEditorToolbarConfig=globalThis.HaxTextEditorToolbarConfig||{},globalThis.HaxTextEditorToolbarConfig.inlineGizmos=globalThis.HaxTextEditorToolbarConfig.inlineGizmos||{},globalThis.HaxTextEditorToolbarConfig.default=window.HaxTextEditorToolbarConfig.default||[...this.defaultConfig],this.config=globalThis.HaxTextEditorToolbarConfig.default,this.sticky=!1,this.__updated=!1,this.setTarget(void 0),globalThis.addEventListener("hax-store-ready",this._handleHaxStoreReady.bind(this)),globalThis.addEventListener("hax-register-properties",this._handleElementRegister.bind(this))}get undoButton(){return{...super.undoButton,label:this.t.undoButton}}get redoButton(){return{...super.redoButton,label:this.t.redoButton}}get formatButton(){return{...super.formatButton,label:this.t.formatButton,blocks:this.formatBlocks}}get formatBlocks(){return[{label:this.t.blockP,tag:"p"},{label:this.t.blockquoteButton,tag:"blockquote"},{label:this.t.blockH2,tag:"h2"},{label:this.t.blockH3,tag:"h3"},{label:this.t.blockH4,tag:"h4"},{label:this.t.blockH5,tag:"h5"},{label:this.t.blockH6,tag:"h6"},{label:this.t.blockPre,tag:"pre"}]}get boldButton(){return{...super.boldButton,label:this.t.boldButton}}get italicButton(){return{...super.italicButton,label:this.t.italicButton}}get underlineButton(){return{...super.underlineButton,label:this.t.underlineButton}}get strikethroughButton(){return{...super.strikethroughButton,label:this.t.strikethroughButton}}get codeButton(){return{...super.codeButton,icon:"hax:html-code",label:this.t.codeButton}}get markButton(){return{...super.markButton,icon:"editor:highlight",label:this.t.markButton}}get abbrButton(){return{...super.abbrButton,icon:"hax:abbr",label:this.t.abbrButton}}get removeFormatButton(){return{...super.removeFormatButton,label:this.t.removeFormatButton}}get advancedInlineButtonGroup(){return{type:"button-group",subtype:"advanced-inline-button-group",buttons:[this.strikethroughButton,this.markButton,this.abbrButton,this.codeButton,this.underlineButton]}}get linkButton(){return{...super.linkButton,label:this.t.linkButton,allowTarget:!0}}get unlinkButton(){return{...super.unlinkButton,label:this.t.unlinkButton}}get cutButton(){return{...super.cutButton,label:this.t.cutButton}}get copyButton(){return{...super.copyButton,label:this.t.copyButton}}get pasteButton(){return{...super.pasteButton,label:this.t.pasteButton,shortcutKeys:void 0,type:"hax-text-editor-paste-button"}}get subscriptButton(){return{...super.subscriptButton,label:this.t.subscriptButton}}get superscriptButton(){return{...super.superscriptButton,label:this.t.superscriptButton}}get symbolButton(){return{...super.symbolButton,label:this.t.symbolButton}}get emojiButton(){return{...super.emojiButton,label:this.t.emojiButton}}get imageButton(){return{...super.imageButton,label:this.t.imageButton}}get orderedListButton(){return{...super.orderedListButton,label:this.t.orderedListButton}}get unorderedListButton(){return{...super.unorderedListButton,label:this.t.unorderedListButton}}get blockquoteButton(){return{}}get indentButton(){return{...super.indentButton,label:this.t.indentButton}}get outdentButton(){return{...super.outdentButton,label:this.t.outdentButton}}get sourceButton(){return{...super.sourceButton}}get haxSymbolInsertButtonGroup(){return{type:"button-group",subtype:"hax-symbol-insert-button-group",buttons:[this.symbolButton,this.emojiButton]}}get iconButton(){return{}}get defaultConfig(){return[this.basicInlineButtonGroup,this.linkButtonGroup,this.listIndentButtonGroup,this.scriptButtonGroup,this.haxSymbolInsertButtonGroup,this.advancedInlineButtonGroup]}get filteredBlocks(){return this.getFilteredBlocks(this.formatBlocks)}get formatButtonElement(){return this.formatButton.type?this.querySelector(this.formatButton.type):void 0}get isRangeInScope(){return this.range&&this.target&&this.rangeNodeOrParentNode(this.range)&&(this.range.commonAncestorContainer===this.target||this.target.contains(this.range.commonAncestorContainer))}targetHandlers(t){let e=super.targetHandlers(t);return delete e.paste,e}updated(t){super.updated&&super.updated(t),this.__ready&&t.forEach(((t,e)=>{"parentSchema"!==e&&"target"!==e||this.updateBlocks(),"activeNode"===e&&this.activeNode!==t&&this.setTarget(this.activeNode),"t"===e&&this.t!==t&&this.updateToolbarElements()}))}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.config=this.updateToolbarElements(),this.__prompt.haxUIElement=!0,this.__prompt.classList.add("ignore-activation"),this.addEventListener("keypress",this.trapKeys.bind(this)),this.__prompt.addEventListener("keypress",this.trapKeys.bind(this)),this.__prompt.addEventListener("paste",this._handlePaste.bind(this))}_handlePaste(t){t.stopPropagation()}trapKeys(t){t.stopPropagation()}updateBlocks(){let t=this.filteredBlocks;this.formatButtonElement&&this.formatButtonElement.blocks!==t&&(this.formatButtonElement.blocks=t,t.length<2?this.formatButtonElement.setAttribute("disabled","disabled"):this.formatButtonElement.removeAttribute("disabled"))}getRange(){let t=i.getRange();return!t||t.rangeCount<1?void 0:i.getRange()}getSelection(){return i.getSelection()}positionByTarget(t){}_handleElementRegister(t){let e=t.detail||{},o=e.tag||{},r=e.properties||{};this._setInlineElement(o,r)}_handleHaxStoreReady(t){this.__ready=!0;let e=i.elementList||{};Object.keys(e).forEach((t=>this._setInlineElement(t,elemets[t])))}async _setInlineElement(t,e){if(!t||!e||globalThis.HaxTextEditorToolbarConfig.inlineGizmos[t]||t.indexOf("-")<0)return;let o={...e},r=e.gizmo||{},n=t.replace(/-./g,(t=>t.toUpperCase()[1])),i=t.split("-").length>1,s=(r.meta||{}).inlineOnly,u=(r.handles||[]).filter((t=>"inline"===t.type)).length>1,a=i&&(s||u);o.gizmo.title||(o.gizmo.title=n),a&&(globalThis.HaxTextEditorToolbarConfig.inlineGizmos[t]={element:o,type:"hax-text-editor-button"},this.__updated=!1,setTimeout((t=>this.config=this.updateToolbarElements()),500))}updateToolbarElements(){if(this.__updated)return;this.__updated=!0;let t=Object.keys(globalThis.HaxTextEditorToolbarConfig.inlineGizmos||{}).map((t=>globalThis.HaxTextEditorToolbarConfig.inlineGizmos[t]));return 0===t.length?[...this.defaultConfig||[]]:[...this.defaultConfig||[],{type:"button-group",subtype:"hax-insert-button-group",buttons:t}]}}customElements.define("hax-text-editor-toolbar",HaxTextEditorToolbar);export{HaxTextEditorToolbar};