import{LitElement as t,html as a,css as e}from"../../../lit/index.js";import"../../simple-toolbar/lib/simple-button-grid.js";import"../../a11y-collapse/a11y-collapse.js";class HaxStaxBrowser extends t{static get styles(){return[e`
        :host {
          display: flex;
          flex-direction: column;
          align-items: stretch;
          flex: 0 0 auto;
          overflow-y: auto;
        }
        hax-tray-button {
          flex: auto;
          font-size: 12px;
          --hax-ui-font-size-sm: 12px;
          --simple-toolbar-button-height: 22px;
          --simple-toolbar-button-width: 22px;
        }
        hax-tray-button[small] {
          font-size: 8px;
          --hax-ui-font-size-sm: 8px;
          --simple-toolbar-button-height: 16px;
          --simple-toolbar-button-width: 16px;
        }
        hax-tray-button::part(button) {
          font-size: var(hax-ui-font-size-xs);
        }
        simple-button-grid {
          overflow: auto;
          --simple-button-grid-margin: 2px;
        }
        a11y-collapse {
          margin: 0;
          --a11y-collapse-margin: 0;
          --a11y-collapse-vertical-padding: 8px;
          --a11y-collapse-horizontal-padding: 4px;
        }
        a11y-collapse::part(heading) {
          margin: 8px 0px;
        }
      `]}constructor(){super(),this.staxList=[],this.label="Templates"}render(){return a`
      <a11y-collapse heading="${this.label}" heading-button>
        <simple-button-grid columns="2" rows="1" always-expanded>
          ${this.staxList.map((t=>a`
              <hax-tray-button
                icon-position="top"
                show-text-label
                index="${t.index}"
                label="${t.details.title}"
                .stax="${t.stax}"
                icon="hax:templates"
                color="green"
                event-name="insert-stax"
              ></hax-tray-button>
            `))}
        </simple-button-grid>
      </a11y-collapse>
    `}static get tag(){return"hax-stax-browser"}static get properties(){return{staxList:{type:Array},label:{type:String}}}}customElements.define(HaxStaxBrowser.tag,HaxStaxBrowser);export{HaxStaxBrowser};