import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import{HaxComponentStyles as s}from"./hax-ui-styles.js";import{HAXStore as l}from"./hax-store.js";import"./hax-element-demo.js";import"../../simple-toolbar/lib/simple-button-grid.js";import"../../simple-popover/lib/simple-popover-selection.js";class HaxPicker extends e{static get styles(){return[...s,i`
        simple-button-grid {
          overflow-y: auto;
          margin: var(--hax-ui-spacing-sm);
        }
        #filters {
          min-height: 24px;
        }
        simple-icon-button-lite {
          float: right;
          margin-left: -24px;
        }
        hax-tray-button {
          display: block;
        }
        simple-fields-field::part(fieldset-legend) {
          line-height: 24px;
        }
        simple-fields-field::part(fieldset-options) {
          display: grid;
          grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
        }
        simple-fields-field::part(option) {
          display: flex;
          flex-wrap: no-wrap;
          align-items: center;
          justify-content: space-between;
          margin: 0 var(--simple-fields-margin-small, 8px);
          flex-direction: row-reverse;
        }
        simple-fields-field::part(option-inner) {
          flex: 0 0 auto;
          margin: 0 calc(var(--simple-fields-margin-small, 8px) * 0.5) 0 0;
        }
        simple-fields-field::part(option-label) {
          flex: 1 1 auto;
          margin: 0;
          font-size: var(--hax-ui-font-size-sm, 13px);
        }
        :host([filter-on]) simple-button-grid {
          margin-bottom: var(--simple-fields-margin-small, 8px);
        }
        :host([filter-on]) #hax-gizmo-filters {
          margin-bottom: 0;
        }
        :host([filter-on]) ::part(fieldset-options) {
          padding-bottom: var(--simple-fields-margin-small, 8px);
        }
      `]}constructor(){super(),this._elements=[],this.selectionList=[],this.activePreview=null,this.pickerType="gizmo"}render(){return t`
      ${this.keywords?t` <div id="filters">
            <simple-icon-button-lite
              icon="editable-table:filter${this.filterOn?"-off":""}"
              label="Toggle Filters"
              tooltip-position="right"
              @click="${e=>this.filterOn=!this.filterOn}"
            >
            </simple-icon-button-lite>
            <simple-fields-field
              ?hidden="${!this.filterOn}"
              id="hax-gizmo-filters"
              label="Filters"
              type="checkbox"
              .options="${this.keywords}"
              @value-changed="${this._handleFilters}"
            >
            </simple-fields-field>
          </div>`:""}
      <simple-button-grid columns="4" always-expanded>
        ${this.selectionList.map(((e,i)=>this._isFiltered(e.keywords)?t`
                <simple-popover-selection
                  data-index="${i}"
                  @opened-changed="${this._hoverForPreviewChange}"
                  event="hover"
                >
                  <hax-tray-button
                    show-text-label
                    id="picker-item-${i}"
                    @click="${this._selected}"
                    data-selected="${i}"
                    ?disabled="${l.activeGizmo&&l.activeGizmo.tag==e.tag}"
                    label="${e.title}"
                    icon="${e.icon}"
                    icon-position="top"
                    slot="button"
                  ></hax-tray-button>
                  ${this.activePreview===parseInt(i)?t`
                        <hax-element-demo
                          render-tag="${e.tag}"
                          slot="options"
                          active-picker-schema="${i}"
                        ></hax-element-demo>
                      `:""}
                </simple-popover-selection>
              `:""))}
      </simple-button-grid>
    `}_hoverForPreviewChange(e){const t=e.detail;t.opened&&(this.activePreview=parseInt(t.dataset.index),setTimeout((()=>{e.detail.openedChanged(!0)}),10))}static get tag(){return"hax-picker"}static get properties(){return{_elements:{type:Array},activePreview:{type:Number},keywords:{type:Object},selectionList:{type:Array},pickerType:{type:String,attribute:"picker-type"},filters:{type:Array},filterOn:{type:Boolean,attribute:"filter-on",reflect:!0}}}buildOptions(e,t="element",i="Select an option",s="gizmo"){this.pickerType=s;var l=[],addKeywords=t=>{"gizmo"===s?e[t].gizmo.keywords.forEach((e=>{(e=(e||"").toLowerCase()).replace(/[\s\W]*/,"").length>0&&(this.keywords[e]=e)})):"app"===s&&e[t].details.tag.forEach((e=>{(e=(e||"").toLowerCase()).replace(/[\s\W]*/,"").length>0&&(this.keywords[e]=e)}))};switch(this.keywords={},s){case"gizmo":for(var o in e)e[o].__type=t,l.push({icon:e[o].gizmo.icon,title:e[o].gizmo.title,color:e[o].gizmo.color,tag:e[o].gizmo.tag,keywords:e[o].gizmo.keywords}),addKeywords(o);break;case"app":for(var o in e)l.push({icon:e[o].details.icon,title:e[o].details.title,color:e[o].details.color,tag:e[o].details.tags||[],keywords:e[o].details.tags||[]}),addKeywords(o);break;default:l=e}this._elements=e,this.selectionList=[...l],setTimeout((()=>{this.shadowRoot.querySelector("#picker-item-0").focus()}),50)}_handleFilters(e){let t=this.shadowRoot&&this.shadowRoot.querySelector("#hax-gizmo-filters")?this.shadowRoot.querySelector("#hax-gizmo-filters"):void 0;t&&(this.filters=t.value)}_isFiltered(e){let t=0,i=!this.filterOn||!this.filters||this.filters.length<1;for(;!i&&t<this.filters.length;)e.includes(this.filters[t])&&(i=!0),t++;return i}_selected(e){this.activePreview=null;let t=e.target.getAttribute("data-selected");e.preventDefault(),e.stopPropagation(),void 0!==this._elements[t]&&("gizmo"==this.pickerType?(this._elements[t].replace=!0,this.dispatchEvent(new CustomEvent("hax-insert-content",{bubbles:!0,cancelable:!0,composed:!0,detail:this._elements[t]}))):this.dispatchEvent(new CustomEvent("hax-app-picker-selection",{bubbles:!0,cancelable:!0,composed:!0,detail:this._elements[t]}))),this.close()}close(){this.activePreview=null,globalThis.dispatchEvent(new CustomEvent("simple-modal-hide",{bubbles:!0,cancelable:!0,detail:{}}))}}customElements.define(HaxPicker.tag,HaxPicker);export{HaxPicker};