import{html as t,css as i}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"./hax-toolbar-item.js";import"../../hax-iconset/lib/simple-hax-iconset.js";import"../../simple-icon/lib/simple-icon-button-lite.js";import{HAXStore as a}from"./hax-store.js";import{normalizeEventPath as l,nodeToHaxElement as o}from"../../utils/utils.js";import{HaxTrayDetailHeadings as s}from"./hax-ui-styles.js";import{I18NMixin as n}from"../../i18n-manager/lib/I18NMixin.js";import{autorun as r,toJS as h}from"../../../mobx/dist/mobx.esm.js";import{SimpleColors as c}from"../../simple-colors/simple-colors.js";class HaxMap extends(n(c)){static get styles(){return[super.styles,...s,i`
        :host {
          display: block;
        }
        .container {
          text-align: left;
        }
        .stats {
          display: flex;
          align-items: stretch;
          flex-wrap: wrap;
        }
        .stat {
          flex: 1 1 auto;
          text-align: center;
          border: 1px solid var(--hax-ui-border-color);
          font-weight: normal;
          font-size: var(--hax-ui-font-size-xs);
          line-height: 140%;
          padding: var(--hax-ui-spacing-sm);
        }
        .stat > * {
          display: block;
        }
        .stat *:first-child {
          font-weight: bold;
          font-size: 150%;
        }
        ul {
          list-style: none;
          padding: 0;
          margin: 0;
        }
        ul li {
          margin: 0;
          padding: 0;
          display: flex;
          height: 38px;
        }
        li hax-toolbar-item {
          display: inline-flex;
          max-width: 60%;
          height: 38px;
          margin-right: 8px;
          overflow: hidden;
        }
        li simple-icon-button-lite {
          display: inline-flex;
          opacity: 0;
          visibility: hidden;
          --simple-icon-width: 14px;
          --simple-icon-height: 14px;
          height: 38px;
          margin: 0 4px;
          color: var(--ddd-theme-default-coalyGray);
          background-color: var(--simple-colors-default-theme-grey-1, white);
        }
        li simple-icon-button:hover {
          background-color: var(--simple-colors-default-theme-grey-2, white);
        }
        li simple-icon-button.del {
          margin-left: 16px;
        }
        li:hover simple-icon-button-lite {
          visibility: visible;
          opacity: 1;
        }
        hax-toolbar-item[data-active-item]::part(button) {
          color: var(--hax-ui-color);
          background-color: var(--hax-ui-background-color-accent);
          border-color: var(--hax-ui-color-accent);
        }
        li.is-child {
          margin-left: 8px;
        }

        li hax-toolbar-item,
        li.parent-h2 hax-toolbar-item[icon="hax:h2"] {
          margin-left: 0px;
          cursor: pointer;
        }
        li.parent-h2 hax-toolbar-item,
        li.parent-h2 + li.is-child hax-toolbar-item,
        li.parent-h2 + li.is-child ~ li.is-child hax-toolbar-item,
        li.parent-h3 hax-toolbar-item[icon="hax:h3"] {
          margin-left: 8px;
        }
        li.parent-h3 hax-toolbar-item,
        li.parent-h3 + li.is-child hax-toolbar-item,
        li.parent-h3 + li.is-child ~ li.is-child hax-toolbar-item,
        li.parent-h4 hax-toolbar-item[icon="hax:h4"] {
          margin-left: 8px;
        }
        li.parent-h4 hax-toolbar-item,
        li.parent-h4 + li.is-child hax-toolbar-item,
        li.parent-h4 + li.is-child ~ li.is-child hax-toolbar-item,
        li.parent-h5 hax-toolbar-item[icon="hax:h5"] {
          margin-left: 12px;
        }
        li.parent-h5 hax-toolbar-item,
        li.parent-h5 + li.is-child hax-toolbar-item,
        li.parent-h5 + li.is-child ~ li.is-child hax-toolbar-item,
        li.parent-h6 hax-toolbar-item[icon="hax:h6"],
        li.parent-h6 hax-toolbar-item,
        li.parent-h6 + li.is-child hax-toolbar-item,
        li.parent-h6 + li.is-child ~ li.is-child hax-toolbar-item {
          margin-left: 12px;
        }
      `]}constructor(){super(),this.elementList=[],this.t={contentStatistics:"Content Statistics",words:"Words",headings:"Headings",paragraphs:"Paragraphs",widgets:"Widgets",characters:"Characters",listView:"List view"},this.registerLocalization({context:this,namespace:"hax"}),r((()=>{a.editMode&&(this.activeNode=h(a.activeNode),setTimeout((()=>{this.requestUpdate()}),0))}))}async updateHAXMap(t){let e=[];for(var i=0;i<a.activeHaxBody.childNodes.length;i++){const t=a.activeHaxBody.childNodes[i];let s=await o(t,null);if(s.parent=null,s.node=t,e.push(s),t.children&&t.children.length>0)for(var l=0;l<t.children.length;l++){let i=await o(t.children[l],null);i.parent=s.tag,i.node=t.children[l],["span","strong","b","sup","sub","i","em","div","strike"].includes(i.tag)||e.push(i)}}this.calcStats(e);let s=[];for(i=0;i<e.length;i++){let t=a.haxSchemaFromTag(e[i].tag);t.gizmo?s.push({node:e[i].node,tag:e[i].tag,parent:e[i].parent,icon:t.gizmo.icon,name:t.gizmo.title}):e[i].tag&&e[i].tag.includes("-")?s.push({tag:e[i].tag,parent:e[i].parent,icon:"hax:templates",name:"Widget"}):s.push({tag:e[i].tag,parent:e[i].parent,icon:"hax:paragraph",name:"HTML block"})}this.elementList=[...s]}calcStats(t){if(t&&a.activeHaxBody.innerText){let i={c:a.activeHaxBody.innerText.length,w:parseInt(a.activeHaxBody.innerText.split(/\s+/g).length-1),h:0,b:0,p:0,e:0};for(var e in t.forEach((t=>{switch(t.tag){case"blockquote":case"div":case"span":case"p":case"ul":case"ol":case"strong":case"em":i.p++;break;case"h1":case"h2":case"h3":case"h4":case"h5":case"h6":i.h++;break;default:i.e++}})),i)this[`${e}Count`]=i[e]}}render(){return t`${this.hidden?"":t` <h5>${this.t.contentStatistics}</h5>
          <div class="stats">
            <div class="stat">
              <span>${this.wCount}</span>
              <span>${this.t.words}</span>
            </div>
            <div class="stat">
              <span>${this.pCount}</span>
              <span>${this.t.paragraphs}</span>
            </div>
            <div class="stat">
              <span>${this.cCount}</span>
              <span>${this.t.characters}</span>
            </div>
            <div class="stat">
              <span>${this.hCount}</span>
              <span>${this.t.headings}</span>
            </div>
            <div class="stat">
              <span>${this.eCount}</span>
              <span>${this.t.widgets}</span>
            </div>
          </div>
          <h5>${this.t.listView}</h5>
          <ul>
            ${this.indentedElements(this.elementList).map(((e,i)=>t`
                <li
                  class="${e.parent?`parent-${e.parent}`:"no-parent"} ${["h1","h2","h3","h4","h5","h6",e.tag].includes(e.parent)?"":"is-child"}"
                >
                  <hax-toolbar-item
                    align-horizontal="left"
                    @click="${t=>this.goToItem(i)}"
                    @dblclick="${t=>this.editItem(i)}"
                    data-index="${i}"
                    ?data-active-item="${e.node===this.activeNode}"
                    icon="${e.icon}"
                    label="${e.name}"
                    show-text-label
                  >
                  </hax-toolbar-item>
                  ${"page-break"!=e.tag?t`
                        <simple-icon-button-lite
                          icon="${this.isLocked(i)?"icons:lock":"icons:lock-open"}"
                          @click="${t=>this.itemOp(i,"lock")}"
                          title="Lock / Unlock"
                        ></simple-icon-button-lite>
                        <simple-icon-button-lite
                          icon="hax:keyboard-arrow-up"
                          @click="${t=>this.itemOp(i,"up")}"
                          title="Move up"
                          ?disabled="${this.isLocked(i)}"
                        ></simple-icon-button-lite>
                        <simple-icon-button-lite
                          icon="hax:keyboard-arrow-down"
                          @click="${t=>this.itemOp(i,"down")}"
                          title="Move down"
                          ?disabled="${this.isLocked(i)}"
                        ></simple-icon-button-lite>
                        <simple-icon-button-lite
                          class="del"
                          icon="delete"
                          @click="${t=>this.itemOp(i,"delete")}"
                          title="Delete"
                          ?disabled="${this.isLocked(i)}"
                        ></simple-icon-button-lite>
                      `:""}
                </li>
              `))}
          </ul>`} `}editItem(t){!1!==t&&this.elementList[t].node&&this.dispatchEvent(new CustomEvent("hax-context-item-selected",{bubbles:!0,cancelable:!0,composed:!0,detail:{target:this.elementList[t].node,eventName:"content-edit",value:!0}}))}isLocked(t){if(!1!==t&&this.elementList[t].node){let e=this.elementList[t].node;return!!(null!=e.getAttribute("data-hax-lock")||e.parentNode&&null!=e.parentNode.getAttribute("data-hax-lock"))}}itemOp(t,e){if(!1!==t&&this.elementList[t].node&&e){let i=this.elementList[t].node;if(null==i.getAttribute("data-hax-lock")&&i.parentNode&&null==i.parentNode.getAttribute("data-hax-lock"))switch(e){case"lock":i.setAttribute("data-hax-lock","data-hax-lock");break;case"delete":a.activeHaxBody.haxDeleteNode(i);break;case"down":i.nextElementSibling&&a.activeHaxBody.haxMoveGridPlate(i);break;case"up":i.previousElementSibling&&"PAGE-BREAK"!==i.previousElementSibling.tagName&&a.activeHaxBody.haxMoveGridPlate(i,-1)}else"lock"===e&&i.removeAttribute("data-hax-lock");setTimeout((()=>{this.requestUpdate()}),0)}}indentedElements(t){let e="h1";return t.map((t=>{let i=t;return null===i.parent&&(i.parent=e),["h1","h2","h3","h4","h5","h6"].includes(i.tag)&&(i.parent=i.tag,e=i.tag),i}))}goToItem(t){if(!1!==t&&this.elementList[t].node){let e=this.elementList[t].node;a.activeNode=e,e.classList.add("blinkfocus"),"function"==typeof e.scrollIntoViewIfNeeded?e.scrollIntoViewIfNeeded(!1):e.scrollIntoView({behavior:"smooth",inline:"center"}),setTimeout((()=>{e.classList.remove("blinkfocus")}),500)}}scrollInMap(){var t=l(e)[0];this.goToItem(t.getAttribute("data-index"))}static get tag(){return"hax-map"}static get properties(){return{...super.properties,opened:{type:Boolean},hidden:{type:Boolean,reflect:!0},elementList:{type:Array},cCount:{type:String},wCount:{type:String},bCount:{type:String},hCount:{type:String},pCount:{type:String},eCount:{type:String},activeNode:{type:Object}}}}customElements.define(HaxMap.tag,HaxMap);export{HaxMap};