import{LitElement as e,html as t,css as i}from"../../../lit/index.js";import{SimpleFilterMixin as a}from"../../simple-filter/simple-filter.js";import{haxElementToNode as o}from"../../utils/utils.js";import{HAXStore as s}from"./hax-store.js";import"./hax-element-demo.js";import"./hax-tray-button.js";import{autorun as r,toJS as l}from"../../../mobx/dist/mobx.esm.js";import"../../simple-fields/lib/simple-fields-field.js";import"../../simple-toolbar/lib/simple-button-grid.js";import"../../simple-popover/lib/simple-popover-selection.js";import"../../a11y-collapse/a11y-collapse.js";import{I18NMixin as n}from"../../i18n-manager/lib/I18NMixin.js";class HaxGizmoBrowser extends(n(a(e))){static get styles(){return[i`
        :host {
          display: flex;
          flex-direction: column;
          align-items: stretch;
          flex: 0 1 auto;
          overflow-y: auto;
        }
        :host > * {
          max-width: 100%;
        }
        simple-popover-selection {
          display: flex;
        }
        hax-tray-button {
          flex: auto;
          font-size: 12px;
          --hax-ui-font-size-sm: 12px;
          --simple-toolbar-button-height: 22px;
          --simple-toolbar-button-width: 22px;
        }
        hax-tray-button[small] {
          font-size: 8px;
          --hax-ui-font-size-sm: 8px;
          --simple-toolbar-button-height: 16px;
          --simple-toolbar-button-width: 16px;
        }
        .toolbar-inner {
          max-width: 96%;
        }
        hax-tray-button::part(button) {
          font-size: var(hax-ui-font-size-xs);
        }
        simple-button-grid {
          --simple-button-grid-margin: 2px;
        }
        simple-fields-field {
          margin-top: 0;
          margin-bottom: 8px;
        }
        simple-fields-field::part(option-input) {
          padding: 0px 2px;
          font-size: 12px;
        }
        a11y-collapse {
          margin: 0;
          --a11y-collapse-margin: 0;
          --a11y-collapse-vertical-padding: 8px;
          --a11y-collapse-horizontal-padding: 4px;
        }
        a11y-collapse::part(heading) {
          margin: 8px 0px;
        }
      `]}constructor(){super(),this.activePreview=null,this.daemonKeyCombo=null,r((()=>{this.daemonKeyCombo=l(s.daemonKeyCombo)})),this.items=[],this.categories=[],this.like="",this.value="",this.where="index",this.recentGizmoList=[],this.t={filterContentTypes:"Filter Content Types",recent:"Recent"},this.registerLocalization({context:this,namespace:"hax"}),this.addEventListener("mouseleave",this.closePopover.bind(this)),this.addEventListener("mouseout",this.closePopover.bind(this)),r((()=>{if(s.editMode){const e=l(s.recentGizmoList);let t=[],i=[];e.forEach((e=>{e&&e.tag&&(i.includes(e.tag)||(i.push(e.tag),t.push(e),t.length>5&&(i.shift(),t.shift())))})),this.recentGizmoList=t}}))}static get properties(){return{...super.properties,categories:{type:Array},hidden:{type:Boolean,reflect:!0},recentGizmoList:{type:Array},activePreview:{type:Number}}}closePopover(){this.activePreview=null,globalThis.SimplePopoverManager.requestAvailability().opened=!1}render(){return t`${this.hidden?"":t`<div class="toolbar-inner" part="toolbar">
            <simple-fields-field
              id="inputfilter"
              @value-changed="${this.inputfilterChanged}"
              aria-controls="filter"
              label="${this.t.filterContentTypes}"
              type="text"
              auto-validate=""
              part="filter"
            ></simple-fields-field>
          </div>
          <a11y-collapse
            id="recent"
            heading="${this.t.recent}"
            heading-button
            expanded
          >
            <simple-button-grid columns="5" always-expanded part="grid">
              ${this.recentGizmoList.map(((e,i)=>t` <simple-popover-selection
                    data-index="${i}"
                    @opened-changed="${this._hoverForPreviewChange}"
                    event="hover"
                  >
                    <hax-tray-button
                      small
                      show-text-label
                      voice-command="insert ${e.title}"
                      draggable="true"
                      @dragstart="${this._dragStart}"
                      index="${i}"
                      is-current-item
                      label="${e.title}"
                      event-name="insert-tag"
                      event-data="${e.tag}"
                      data-demo-schema="true"
                      icon-position="top"
                      icon="${e.icon}"
                      part="grid-button"
                      slot="button"
                    ></hax-tray-button>
                    ${this.activePreview===parseInt(i)?t`
                          <hax-element-demo
                            render-tag="${e.tag}"
                            slot="options"
                          ></hax-element-demo>
                        `:""}
                  </simple-popover-selection>`))}
            </simple-button-grid>
          </a11y-collapse>
          ${this.categories.map((e=>t` <a11y-collapse
                heading="${this.ucfirst(e)}"
                heading-button
              >
                <simple-button-grid columns="3" always-expanded part="grid">
                  ${this.filtered.map(((i,a)=>t`${i&&i.tags&&i.tags.includes(e)?t` <simple-popover-selection
                            data-index="${a}"
                            @opened-changed="${this._hoverForPreviewChange}"
                            event="hover"
                          >
                            <hax-tray-button
                              show-text-label
                              is-current-item
                              voice-command="insert ${i.title}"
                              draggable="true"
                              @dragstart="${this._dragStart}"
                              index="${a}"
                              label="${i.title}"
                              event-name="insert-tag"
                              event-data="${i.tag}"
                              data-demo-schema="true"
                              icon-position="top"
                              icon="${i.icon}"
                              part="grid-button"
                              slot="button"
                            ></hax-tray-button>
                            ${this.activePreview===parseInt(a)?t`
                                  <hax-element-demo
                                    render-tag="${i.tag}"
                                    slot="options"
                                  ></hax-element-demo>
                                `:""}
                          </simple-popover-selection>`:""}`))}
                </simple-button-grid>
              </a11y-collapse>`))} `}`}static get tag(){return"hax-gizmo-browser"}_hoverForPreviewChange(e){const t=e.detail;t.opened&&(this.activePreview=parseInt(t.dataset.index),setTimeout((()=>{e.detail.openedChanged(!0)}),10))}_dragStart(e){let t=s.haxSchemaFromTag(e.target.eventData);var i;i=t.gizmo.tag&&t.demoSchema&&t.demoSchema[0]?o(t.demoSchema[0]):globalThis.document.createElement(e.target.eventData),s.recentGizmoList.push(t.gizmo),s.__dragTarget=i,e.dataTransfer&&(e.dataTransfer.effectAllowed="move",e.dataTransfer.dropEffect="move"),e.stopPropagation(),e.stopImmediatePropagation()}inputfilterChanged(e){this.like=e.target.value,""==this.like?this.collapseAll():this.expandAll()}expandAll(){this.shadowRoot.querySelectorAll("a11y-collapse").forEach((e=>{e.expanded=!0}))}collapseAll(){this.shadowRoot.querySelectorAll("a11y-collapse:not(#recent)").forEach((e=>{e.expanded=!1}))}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"filtered"==t&&this.requestUpdate(),"items"==t&&this[t]&&this[t].length>0&&(this.categories=[...this.updateCategories(this.items)])}))}ucfirst(e){return e.charAt(0).toUpperCase()+e.slice(1)}updateCategories(e){let t=[];return e.forEach((e=>{e.tags&&e.tags[0]&&(t.includes(e.tags[0])||t.push(e.tags[0]))})),t.sort(),t}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),r((()=>{s.editMode&&this.resetList(l(s.gizmoList))}))}resetList(e){if(e){this.like="",this.value="";const t=e.filter(((e,t)=>!(e&&e.meta&&(e.meta.inlineOnly||e.meta.hidden||e.requiresParent))));t.map(((e,i)=>{t[i].index=e.title+" "+e.tag,e.tags&&(t[i].index+=" "+e.tags.join(" ")),e.meta&&e.meta.author&&(t[i].index+=" "+e.meta.author)})),this.items=[...t]}}}customElements.define(HaxGizmoBrowser.tag,HaxGizmoBrowser);export{HaxGizmoBrowser};