import{LitElement as e,html as a,css as t}from"../../../lit/index.js";import"../../simple-modal/lib/simple-modal-template.js";import{HaxComponentStyles as l}from"./hax-ui-styles.js";import{I18NMixin as i}from"../../i18n-manager/lib/I18NMixin.js";class HaxCancelDialog extends(i(e)){static get styles(){return[...l,t`
        :host {
          display: none;
          --simple-modal-resize: none;
          --simple-modal-width: 200px;
          --simple-modal-height: auto;
          margin: 0;
          padding: 0;
        }
      `]}render(){return a`
      <simple-modal-template
        modal-id="hax-cancel"
        mode="hax-ui"
        id="dialog"
        .title="${this.t.cancelTitle}"
      >
        <div slot="content">${this.t.cancelWithoutSaving}</div>
        <hax-toolbar id="hax-cancel-buttons" always-expanded slot="buttons">
          <hax-tray-button
            id="hax-cancel-no"
            label="${this.t.cancelNo}"
            dialog-dismiss
            show-text-label
          >
          </hax-tray-button>
          <hax-tray-button
            id="hax-cancel-yes"
            dialog-confirm
            @click="${e=>console.log(e)}"
            label="${this.t.cancelYes}"
            show-text-label
          >
          </hax-tray-button>
        </hax-toolbar>
      </simple-modal-template>
    `}static get tag(){return"hax-cancel-dialog"}firstUpdated(){this.dispatchEvent(new CustomEvent("hax-register-core-piece",{bubbles:!0,cancelable:!0,composed:!0,detail:{piece:"haxCancel",object:this}}))}constructor(){super(),this.t={cancelTitle:"Confirm Cancel",cancelWithoutSaving:"Any changes since your last save will be lost. Cancel anyway?",cancelYes:"Yes",cancelNo:"No"},this.registerLocalization({context:this,namespace:"hax"})}}customElements.define(HaxCancelDialog.tag,HaxCancelDialog);export{HaxCancelDialog};