/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{HAXStore as e}from"../hax-body/lib/hax-store.js";import"./lib/h-a-x-dependencies.js";import{localStorageGet as t}from"../utils/utils.js";import{editableTableDisplayStyles as a}from"../editable-table/lib/editable-table-behaviors.js";class HAX extends HTMLElement{get html(){return`\n    <style>\n    ${a.map((e=>e.cssText.replace(/:host/g,"hax-body table"))).join(" ")}\n\n    :host,h-a-x {\n      display: block;\n    }\n\n    :host([hidden]),h-a-x([hidden]) {\n      display: none;\n    }\n\n    :host img, h-a-x img {\n      max-width: 100%;\n      max-width: -moz-available;\n      max-width: -webkit-fill-available;\n      max-width: fill-available;\n    }\n\n    hax-body[edit-mode] page-break[data-hax-active],\n    hax-body[edit-mode] [data-hax-active][contenteditable] {\n      outline-offset: 8px;\n      outline: var(--hax-body-active-outline, 2px solid var(--hax-ui-color-focus, #000)) !important;\n      caret-color: var(--hax-ui-caret-color, auto);\n    }\n\n  :host([edit-mode])\n    #bodycontainer\n    ::slotted([contenteditable][data-hax-ray][data-hax-active]:empty:not([data-instructional-action]))::before {\n    content: "Type / to add blocks";\n    opacity: 0.4;\n  }\n    </style>\n    <hax-body>\n        <slot></slot>\n    </hax-body>`}static get tag(){return"h-a-x"}constructor(e=!1){super(),this.windowControllers=new AbortController,this.windowControllersLoaded=new AbortController,this.windowControllersReady=new AbortController,this.__rendered=!1,this.tag=HAX.tag,this.template=globalThis.document.createElement("template"),this.attachShadow({mode:"open"}),globalThis.document.adoptedStyleSheets&&globalThis.document.adoptedStyleSheets.map((e=>{e.hax&&this.shadowRoot.adoptedStyleSheets.push(e)})),e||this.render(),globalThis.addEventListener("hax-store-ready",this.storeReady.bind(this),{once:!0,passive:!0,signal:this.windowControllersReady.signal}),globalThis.addEventListener("hax-store-app-store-loaded",this.appStoreReady.bind(this),{once:!0,passive:!0,signal:this.windowControllersLoaded.signal}),globalThis.addEventListener("hax-cancel",this.cancelEvent.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("hax-save",this.saveEvent.bind(this),{signal:this.windowControllers.signal})}cancelEvent(e){this.importSlotToHaxBody()}async saveEvent(t){const a=await e.activeHaxBody.haxToContent();this.innerHTML=a,this.dispatchEvent(new CustomEvent("hax-save-body-value",{composed:!0,bubbles:!0,cancelable:!0,detail:{value:a}}))}connectedCallback(){super.connectedCallback&&super.connectedCallback(),this.__HAXApplied||globalThis.__HAXApplied||(globalThis.__HAXApplied=this.__HAXApplied=this.applyHAX())}storeReady(t){t.detail&&(setTimeout((()=>{try{let t={...JSON.parse(this.getAttribute("app-store"))};"object"==typeof t&&(e.appStore=t)}catch(e){console.warn(e)}"hide-panel-ops"===this.hidePanelOps&&(this.hidePanelOps=!0),e.haxTray.hidePanelOps=this.hidePanelOps,"hide-toolbar"===this.hideToolbar&&(this.hideToolbar=!0),e.haxTray.hideToolbar=this.hideToolbar,e.haxTray.offsetMargin=this.offsetMargin,e.elementAlign=this.elementAlign}),0),this.windowControllersReady.abort())}importSlotToHaxBody(){var t=[];t=this.shadowRoot.querySelector("slot")?this.shadowRoot.querySelector("slot").assignedNodes():this.children;let a="";for(let e in t)void 0!==t[e].outerHTML&&(a+=t[e].outerHTML);e.activeHaxBody.importContent(a)}appStoreReady(e){e.detail&&(this.importSlotToHaxBody(),this.windowControllersLoaded.abort())}render(){this.__rendered=!0,this.shadowRoot.innerHTML=null,this.template.innerHTML=this.html,this.shadowRoot.appendChild(this.template.content.cloneNode(!0))}applyHAX(){let e=globalThis.HaxStore.requestAvailability(),a=globalThis.document.createElement("hax-tray");return a.hidePanelOps=this.hidePanelOps,a.hideToolbar=this.hideToolbar,this.elementAlign=t("hax-tray-elementAlign"),this.elementAlign&&null!=this.elementAlign&&""!=this.elementAlign||(this.elementAlign="left"),e.elementAlign=this.elementAlign,globalThis.document.body.appendChild(a),globalThis.document.body.appendChild(globalThis.document.createElement("hax-app-picker")),globalThis.document.body.appendChild(globalThis.document.createElement("hax-autoloader")),globalThis.document.body.appendChild(globalThis.document.createElement("hax-cancel-dialog")),!0}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback&&super.disconnectedCallback()}static get observedAttributes(){return["element-align","offset-margin","app-store","hide-panel-ops"]}get elementAlign(){return this.getAttribute("element-align")}set elementAlign(t){this.__rendered&&(this.setAttribute("element-align",t),e.elementAlign=t)}get offsetMargin(){return this.getAttribute("offset-margin")}set offsetMargin(t){this.setAttribute("offset-margin",t),this.__rendered&&(e.haxTray.offsetMargin=t)}get hideToolbar(){return this.getAttribute("hide-toolbar")}set hideToolbar(t){t&&(this.setAttribute("hide-toolbar","hide-toolbar"),this.__rendered&&(e.haxTray.hideToolbar=t))}get hidePanelOps(){return this.getAttribute("hide-panel-ops")}set hidePanelOps(t){t&&(this.setAttribute("hide-panel-ops","hide-panel-ops"),this.__rendered&&(e.haxTray.hidePanelOps=t))}get appStore(){return this.getAttribute("app-store")}set appStore(t){this.setAttribute("app-store",t),this.__rendered&&(e.appStore={...JSON.parse(this.getAttribute("app-store"))})}attributeChangedCallback(e,t,a){}}customElements.define("h-a-x",HAX);export{HAX};