import{html as e,css as t,LitElement as r}from"../../../lit/index.js";import{GradeBookStore as l}from"./grade-book-store.js";import{autorun as i,toJS as a}from"../../../mobx/dist/mobx.esm.js";class LetterGrade extends r{constructor(){super(),this.pointsSystem="pts",this.score=null,this.total=null,this.gradeScale=[],this.displayOnly=!1,this._letterIndex=null,this.letter="",this.showScale=!1,this.value="",this.mini=!1,this.label="",this.active=!1,i((()=>{this.gradeScale=a(l.gradeScale)}))}static get styles(){return[t`
        :host {
          display: block;
        }
        :host([letter="/"]) {
          --letter-grade-default-letter-background-color: #cccccc;
        }
        :host([letter="F"]) {
          --letter-grade-default-letter-background-color: #ff4444;
        }
        :host([letter="D"]) {
          --letter-grade-default-letter-background-color: #ff7744;
        }
        :host([letter="C"]),
        :host([letter="C+"]) {
          --letter-grade-default-letter-background-color: #ffff00;
        }
        :host([letter="B"]),
        :host([letter="B-"]) {
          --letter-grade-default-letter-background-color: #ffff66;
        }
        :host([letter="B+"]),
        :host([letter="A-"]) {
          --letter-grade-default-letter-background-color: #aaffaa;
        }
        :host([letter="A"]) {
          --letter-grade-default-letter-background-color: #55ff55;
        }
        :host([show-scale]) .wrap {
          height: var(--letter-grade-wrap-height, 64px);
          width: var(--letter-grade-wrap-width, 64px);
        }
        :host([mini]) .wrap {
          height: var(--letter-grade-wrap-height, 20px);
          width: var(--letter-grade-wrap-width, 20px);
          border: 1px solid black;
          border-radius: 0px;
          padding: 8px;
        }
        :host([mini]) .letter {
          font-size: var(--letter-grade-letter-font-size, 12px);
          line-height: var(
            --letter-grade-letter-line-height,
            var(--letter-grade-letter-font-size, 20px)
          );
        }
        .wrap {
          height: var(--letter-grade-wrap-height, 40px);
          width: var(--letter-grade-wrap-width, 40px);
          padding: var(--letter-grade-wrap-padding, 16px);
          border: var(--letter-grade-wrap-border, 4px solid black);
          border-radius: 50%;
          box-shadow: rgb(0 0 0 / 20%) 0px 5px 5px 0px;
          text-align: center;
          justify-content: center;
          vertical-align: middle;
          background-color: var(
            --letter-grade-wrap-background-color,
            var(--letter-grade-default-letter-background-color, transparent)
          );
        }
        .letter {
          font-weight: var(--letter-grade-letter-font-weight, bold);
          font-size: var(--letter-grade-letter-font-size, 40px);
          line-height: var(
            --letter-grade-letter-line-height,
            var(--letter-grade-letter-font-size, 40px)
          );
          letter-spacing: 2px;
        }
        .score,
        .range {
          font-weight: var(--letter-grade-range-font-weight, normal);
          font-size: var(--letter-grade-range-font-size, 12px);
        }
        simple-tooltip {
          --simple-tooltip-background: #000000;
          --simple-tooltip-opacity: 1;
          --simple-tooltip-text-color: #ffffff;
          --simple-tooltip-delay-in: 0;
          --simple-tooltip-duration-in: 200ms;
          --simple-tooltip-duration-out: 0;
          --simple-tooltip-border-radius: 0;
          --simple-tooltip-font-size: 14px;
        }
      `]}render(){return e`
      <div class="wrap">
        <div class="letter">${this.letter}</div>
        ${this.showScale&&null!==this._letterIndex?e`<div class="score">
              (${this.score}/${this.total} ${this.pointsSystem})
            </div>`:""}
        ${this.showScale&&null!==this._letterIndex?e`<div class="range">
              ${this.gradeScale[this._letterIndex].lowRange}% -
              ${this.gradeScale[this._letterIndex].highRange}%
            </div>`:""}
      </div>
      ${this.mini?e`<simple-tooltip position="top"
            >${this.label}<br />${null!=this.score?e`(${this.score}/${this.total} ${this.pointsSystem})`:""}</simple-tooltip
          >`:""}
    `}static get properties(){return{score:{type:Number},total:{type:Number},value:{type:Number},pointsSystem:{type:String,attribute:"points-system"},gradeScale:{type:Array},letter:{type:String,reflect:!0},showScale:{type:Boolean,reflect:!0,attribute:"show-scale"},mini:{type:Boolean,reflect:!0},label:{type:String},displayOnly:{type:Boolean,attribute:"display-only"},active:{type:Boolean,reflect:!0}}}static get tag(){return"letter-grade"}updated(e){e.forEach(((e,t)=>{"mini"===t&&this[t]&&this.label&&import("../../simple-tooltip/simple-tooltip.js"),["total","score","gradeScale"].includes(t)&&!this.displayOnly&&this.gradeScale.length>0&&(this.letter=this.calculateLetterGrade()),"letter"===t&&this.gradeScale[this._letterIndex]&&(this.innerHTML=`\n        <div>---------------------------------------</div>\n        <div style="font-size:36px;line-height:48px;">${this.letter}</div>\n        <div style="font-size:20px;line-height:24px;">${this.score}/${this.total} ${this.pointsSystem}</div>\n        <div style="font-size:16px;line-height:24px;">Range: ${this.gradeScale[this._letterIndex].lowRange}% -\n        ${this.gradeScale[this._letterIndex].highRange}%</div>\n        <div>---------------------------------------</div>\n        `)}))}calculateLetterGrade(){if(null===this.score)return"/";let e=this.score/this.total*100;if(this.gradeScale[0]&&e>=this.gradeScale[0].highRange)return this._letterIndex=0,this.gradeScale[0].letter;for(var t in this.gradeScale){let r=this.gradeScale[t];if(e<=r.highRange&&e>=r.lowRange)return this._letterIndex=t,this.gradeScale[t].letter}return this._letterIndex=this.gradeScale.length-1,this.gradeScale[this.gradeScale.length-1].letter}}customElements.define(LetterGrade.tag,LetterGrade);export{LetterGrade};