import{LitElement as e,html as t,css as i,nothing as s}from"../../../lit/index.js";import{GradeBookStore as r}from"./grade-book-store.js";import{autorun as a,toJS as l}from"../../../mobx/dist/mobx.esm.js";import"./letter-grade.js";class LetterGradePicker extends e{constructor(){super(),this.value=null,this.label=null,this.reveal=!1,this.arrow=!1,this.input=!1,this.possible=0,this.score=0}static get properties(){return{value:{type:String},label:{type:String},reveal:{type:Boolean},arrow:{type:Boolean},input:{type:Boolean},possible:{type:Number},score:{type:Number}}}static get styles(){return[i`
        :host {
          display: block;
          font-size: 18px;
        }
        letter-grade {
          display: inline-flex;
          filter: brightness(80%) saturate(50%);
        }
        .wrapper {
          display: flex;
        }
        span.prefix,
        .wrapper ::slotted(*) {
          margin-right: 10px;
          width: 90px;
          line-height: 38px;
          display: block;
          padding: 0;
          text-align: end;
          height: 38px;
        }
        button {
          background-color: transparent;
          padding: 0;
          margin: 0;
          border: none;
          border-radius: none;
          cursor: pointer;
        }
        button[active="active"] letter-grade,
        letter-grade[active="active"] {
          filter: brightness(90%) saturate(4);
          outline: 2px solid black;
          outline-offset: -2px;
        }
        button[data-selected-value] letter-grade {
          filter: brightness(100%) saturate(1);
          outline: 4px solid black;
          outline-offset: -4px;
        }
        .score-wrapper {
          display: flex;
          font-size: 28px;
          line-height: 36px;
          word-spacing: -4px;
        }
        simple-fields-field {
          width: 64px;
          margin: 0px -8px 0px 16px;
          --simple-fields-font-size: 28px;
        }
      `]}render(){return t`
      <div class="wrapper">
        <slot name="prefix"><span class="prefix">${this.label}</span></slot>
        ${r.gradeScale.map(((e,i)=>t`
            <button
              ?data-selected-value="${e.letter==this.value}"
              letter="${e.letter}"
              id="btn${i}"
              @click="${this.clickScore}"
              @mousedown="${this.activeEventOn}"
              @mouseover="${this.activeEventOn}"
              @focusin="${this.activeEventOn}"
              @mouseout="${this.activeEventOff}"
              @focusout="${this.activeEventOff}"
            >
              <letter-grade
                interactive
                display-only
                letter="${e.letter}"
                mini
              ></letter-grade>
            </button>
          `))}
        ${this.input?t`
              <span class="score-wrapper">
                <simple-fields-field
                  type="number"
                  part="simple-fields-field"
                  min="0"
                  value="${this.score}"
                  max="${this.possible}"
                  @value-changed="${this.scoreUpdated}"
                  maxlength="10"
                ></simple-fields-field>
                / ${this.possible}</span
              >
            `:s}
        <slot name="suffix"></slot>
        ${this.input?t``:s}
      </div>
    `}activeEventOn(e){e.target.setAttribute("active","active")}activeEventOff(e){e.target.removeAttribute("active")}clickScore(e){this.value=e.target.getAttribute("letter");const t=l(r.gradeScale.find((e=>this.value===e.letter)));this.score=Math.round(t.highRange/100*this.possible*100)/100}scoreUpdated(e){const t=Math.round(e.detail.value/this.possible*100*100)/100,i=l(r.gradeScale.find((e=>e.highRange>=t&&t>=e.lowRange)));this.value=i.letter}updated(e){e.forEach(((e,t)=>{"input"===t&&this[t]&&import("../../simple-fields/lib/simple-fields-field.js"),"reveal"===t&&this[t],["value","score"].includes(t)&&this.dispatchEvent(new CustomEvent(`${t}-changed`,{composed:!1,bubbles:!1,cancelable:!0,detail:this}))}))}static get tag(){return"letter-grade-picker"}}customElements.define(LetterGradePicker.tag,LetterGradePicker);export{LetterGradePicker};