/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t,render as i,nothing as a}from"../../../lit/index.js";import{SimpleColors as s}from"../../simple-colors/simple-colors.js";import{I18NMixin as o}from"../../i18n-manager/lib/I18NMixin.js";import{gSheetInterface as r}from"../../utils/lib/gSheetsInterface.js";import{normalizeEventPath as l}from"../../utils/utils.js";import"../../simple-icon/lib/simple-icon-button-lite.js";import"../../simple-icon/lib/simple-icons.js";import"../../hax-iconset/lib/simple-hax-iconset.js";import"../../simple-icon/simple-icon.js";import"../../simple-fields/lib/simple-fields-field.js";import"../../simple-fields/lib/simple-fields-tag-list.js";import"../../a11y-collapse/a11y-collapse.js";import"../../a11y-collapse/lib/a11y-collapse-group.js";import"../../editable-table/lib/editable-table-display.js";import"../../a11y-tabs/a11y-tabs.js";import"../../a11y-tabs/lib/a11y-tab.js";import"../../grid-plate/grid-plate.js";import"../../iframe-loader/lib/loading-indicator.js";import"../../../@github/time-elements/dist/index.js";import{autorun as n,toJS as d}from"../../../mobx/dist/mobx.esm.js";import{get as c,set as p}from"../../../idb-keyval/dist/compat.js";import{XLSXFileSystemBrokerSingleton as h}from"../../file-system-broker/lib/xlsx-file-system-broker.js";import{SimpleFilterMixin as u}from"../../simple-filter/simple-filter.js";import{MicroFrontendRegistry as g}from"../../micro-frontend-registry/micro-frontend-registry.js";import{enableServices as m}from"../../micro-frontend-registry/lib/microServices.js";import{b64toBlob as b}from"../../utils/utils.js";import{UIRenderPieces as v}from"./GradeBookUIPieces.js";import{GradeBookStore as f}from"./grade-book-store.js";import"./grade-book-pop-up.js";import"./letter-grade.js";import"./letter-grade-picker.js";class GradeBookLite extends(v(o(u(s)))){constructor(){super(),this.__pdfLoading=!1,this.__hashLoading=!1,m(["core"]),this.where="term",this.hasFilePicker=!1,this.source="googledocs",globalThis.showOpenFilePicker&&(this.source="filesystem",this.hasFilePicker=!0),this.ready=!1,this.displayMode=0,this.assessmentView=this.resetAssessmentView(),this.totalScore=0,this.activeStudentSubmissions=[],this.scoreLock=!0,this.activeRubric=[],this.activeGrading={},this.disabled=!1,this.loading=!1,this.t={generateHashLink:"Generate hash link",generatingPleaseWait:"Generating please wait..",downloadingPdfPleaseWait:"Downloading PDF please wait..",downloadPdf:"Download PDF",csvURL:"CSV URL",points:"Points",criteria:"Criteria",description:"Description",assessmentWeight:"Assessment weight",overallFeedback:"Overall feedback",letterGrade:"Letter grade",highRange:"High range",lowRange:"Low range",noSubmission:"No submission found",studentSubmission:"Student submission",openInNewWindow:"Open in new window",gradingScale:"Grading scale",activeStudent:"Active student",activeAssignment:"Active assignment",submitted:"Submitted",dueDate:"Due date",firstName:"First name",surname:"Surname",photo:"Photo",email:"Email",previous:"Previous",next:"Next",previousStudent:"Previous student",nextStudent:"Next student",previousAssignment:"Previous assignment",nextAssignment:"Next assignment",student:"Student",assessmentView:"Assessment View",activeAssessment:"Active assessment",studentReportView:"Student report view",loadGradebook:"Load gradebook",load:"Load",saveGradebook:"Save gradebook",selectGradebookSource:"Select gradebook source",sourceData:"Source data",pasteValidJSONHere:"Paste valid JSON here",loadingFilePleaseWait:"LOADING FILE PLEASE WAIT.."},this.registerLocalization({context:this,basePath:import.meta.url,locales:["es","fr","de"]}),this.addEventListener("simple-fields-tag-list-changed",this.qualitativeFeedbackUpdate.bind(this)),this.addEventListener("value-changed",this.rubricCriteriaPointsChange),this.addEventListener("drop",this._handleDragDrop.bind(this)),n((()=>{this.activeStudent=d(f.activeStudent)})),n((()=>{this.activeAssignment=d(f.activeAssignment)})),n((()=>{this.database=d(f.database)})),n((()=>{this.activeSubmission=d(f.activeSubmission)}))}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e);new ResizeObserver((e=>{clearTimeout(this.__resizer),this.__resizer=setTimeout((()=>{var t=0;for(let i of e)t=i.contentBoxSize?Math.round(globalThis.innerHeight-i.contentBoxSize[0].blockSize-122):Math.round(globalThis.innerHeight-i.contentRect.height-122);this.shadowRoot.querySelector("#studentassessment").shadowRoot.querySelector("[part='content']").style.height=t+"px"}),50)}));setTimeout((async()=>{this.prevLocalFileReference=await c("grade-book-prev-file"),this.requestUpdate()}),0)}resetAssessmentView(){return{qualitative:[],written:[]}}getStudentSubmissions(e){let t=[];for(var i in this.database.submissions){let s=this.database.submissions[i];if(s.student===this.database.roster[e].student){for(var a in s)if("student"!==a){let i=this.getAssignmentByShortName(a);i&&t.push({studentScore:this.database.grades[e]&&""!=this.database.grades[e][a]?this.database.grades[e][a]:null,assignmentPoints:i.points,assignmentName:i.name,assignmentIndex:i.index})}return t}}return t}getAssignmentByShortName(e){let t,i=this.database.assignments.filter(((i,a)=>i.shortName===e&&(t=a,!0)));return 1===i.length?(i[0].index=t,i[0]):null}getCurrentScore(e,t){return this.database.grades[e]&&this.database.grades[e][this.database.assignments[t].shortName]?this.database.grades[e][this.database.assignments[t].shortName]:0}getActiveRubric(){return this.database.rubrics.filter((e=>e.shortName==this.database.assignments[this.activeAssignment].rubric))}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{if(!this.loading&&["activeAssignment","activeStudent","database","loading"].includes(t)&&setTimeout((()=>{this.totalScore=this.getCurrentScore(this.activeStudent,this.activeAssignment),this.assessmentView=this.resetAssessmentView(),this.activeRubric=[...this.getActiveRubric()],this.hideRubricInfo=[...this.activeRubric.map((()=>!1))],this.activeStudentSubmissions=[],this.activeStudentSubmissions=[...this.getStudentSubmissions(this.activeStudent)],this.database.tags&&this.database.tags.data&&(this.items=this.database.tags.data)}),0),["sourceData","source"].includes(t))if(this.sourceData)switch(this.source){case"googledocs":this.loading=!0,this.gSheet=new r(this,this.sourceData,{tags:0,roster:118800528,assignments:540222065,rubrics:1744429439,submissions:2104732668,gradeScale:980501320,grades:2130903440,gradesDetails:644559151,settings:1413275461}),setTimeout((async()=>{for(var e in this.gSheet.sheetGids){let t=await this.gSheet.loadSheetData(e);t=this.transformTable(t),"function"==typeof this[`process${e}Data`]&&(t=this[`process${e}Data`](t)),this.database[e]=t,"gradeScale"===e&&this.database.gradeScale&&this.database.gradeScale.length>0&&(f.gradeScale=this.database.gradeScale),this.requestUpdate()}this.importStateCleanup()}),0);break;case"url":this.loading=!0,fetch(this.sourceData).then((e=>{if(e.ok)return e.json()})).then((e=>{f.database=e,this.importStateCleanup()})).catch((e=>{console.warn(e)}));break;case"json":f.database=JSON.parse(this.sourceData),this.importStateCleanup()}else"filesystem"==this.source&&(this.__applied||(this.__applied=!0,globalThis.addEventListener("xlsx-file-system-data",(e=>{let t=e.detail.data;for(var i in t){let e=this.transformTable(t[i]);"function"==typeof this[`process${i}Data`]&&(e=this[`process${i}Data`](e)),f.database[i]=e}this.importStateCleanup()}))))}))}importStateCleanup(){this.loading=!1,this.database.gradeScale&&this.database.gradeScale.length>0&&(f.gradeScale=this.database.gradeScale),this.requestUpdate(),this.ready=!0}transformTable(e){let t=e.shift(),i={},a=[];for(var s in t)i[t[s]]=s;for(var s in e){let t={};for(var o in i)t[o]=e[s][i[o]];a.push(t)}return a}processassignmentsData(e){for(var t in e)if(""!=e[t].dueDate)try{const i=new Date(`${e[t].dueDate} ${e[t].dueTime}`);e[t]._ISODueDate=i.toISOString()}catch(e){}return e}processtagsData(e){let t=new Set([]),i=[];for(var a in e)e[a].category=e[a].category?e[a].category.split(","):[],e[a].associatedMaterial=e[a].associatedMaterial?e[a].associatedMaterial.split(","):[],e[a].category.forEach((e=>{t.add(e)})),i=[...Array.from(t)];return{categories:i,data:e}}processrubricsData(e){for(var t in e)e[t].qualitative=e[t].qualitative?e[t].qualitative.split(","):[];return e}processrosterData(e){for(var t in e)e[t].interests=e[t].interests?e[t].interests.split(","):[];return e}processsettingsData(e){let t={};for(var i in e)t[e[i].key]=e[i].value;return t}static get properties(){return{...super.properties,displayMode:{type:Number},__pdfLoading:{type:Boolean},__hashLoading:{type:Boolean},disabled:{type:Boolean,reflect:!0},loading:{type:Boolean,reflect:!0},ready:{type:Boolean,reflect:!0},activeStudent:{type:Number,attribute:"active-student"},activeAssignment:{type:Number,attribute:"active-assignment"},totalScore:{type:Number},scoreLock:{type:Boolean},source:{type:String},sourceData:{type:String,attribute:"source-data"},activeSubmission:{type:String,attribute:!1},database:{type:Object,attribute:!1},activeRubric:{type:Object,attribute:!1},assessmentView:{type:Object,attribute:!1},activeGrading:{type:Object,attribute:!1},activeStudentSubmissions:{type:Array}}}async changeAssignment(e){"prev"==e.target.getAttribute("value")&&0!==this.activeAssignment?f.activeAssignment--:"next"==e.target.getAttribute("value")&&this.database.assignments.length-1!==f.activeAssignment&&f.activeAssignment++,await this.requestUpdate()}static get styles(){return[super.styles,t`
        :host {
          display: block;
        }
        :host [hidden] {
          display: none !important;
        }
        @media (max-width: 900px) {
          .hide-900 {
            display: none;
          }
        }
        loading-indicator {
          --loading-indicator-background-color: var(
            --simple-colors-default-theme-accent-2,
            grey
          );
          --loading-indicator-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
        }
        loading-indicator[full] {
          top: 0;
          position: absolute;
          left: 0;
          right: 0;
          z-index: 1;
        }
        h1,
        h2,
        h3,
        h4 {
          margin: 0;
        }
        grid-plate {
          --hax-layout-container-transition: none;
          --grid-plate-col-transition: none;
          --grid-plate-item-margin: 0px;
          --grid-plate-item-padding: 8px;
        }
        #studentassessment {
          --a11y-tabs-border-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
          --a11y-tabs-border-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
          color: var(--simple-colors-default-theme-grey-12);
          background-color: var(--simple-colors-default-theme-grey-1);
          --a11y-tabs-faded-color: var(--simple-colors-default-theme-grey-11);
          --a11y-tabs-focus-color: var(--simple-colors-default-theme-grey-10);
          --a11y-tabs-faded-background: var(
            --simple-colors-default-theme-grey-2
          );
        }
        #studentassessment::part(content) {
          overflow: scroll;
        }
        a11y-collapse {
          --a11y-collapse-border-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
          --a11y-collapse-horizontal-padding: 8px;
          --a11y-collapse-vertical-padding: 4px;
        }
        a11y-collapse:not([expanded]):hover {
          background-color: var(--simple-colors-default-theme-accent-1, grey);
        }
        a11y-collapse div[slot="heading"] {
          font-size: 18px;
          font-weight: normal;
          cursor: pointer;
          line-height: 30px;
          display: flex;
        }
        a11y-collapse[expanded] div[slot="heading"] {
          font-weight: bold;
        }
        .active-student-grade-history letter-grade {
          display: inline-flex;
          margin: 2px;
        }
        .active-student-grade-history button {
          opacity: 0.4;
          background-color: transparent;
          border: 0;
          padding: 0;
          margin: 0;
        }
        .active-student-grade-history button.activeAssignment {
          opacity: 0.9;
          background-color: var(--simple-colors-default-theme-yellow-8);
        }
        .active-student-grade-history button:focus,
        .active-student-grade-history button:active,
        .active-student-grade-history button:hover {
          opacity: 1;
          outline: 1px solid black;
          outline-offset: 2px;
        }
        simple-fields-tag-list {
          --simple-fields-tag-list-possible: var(
            --simple-colors-default-theme-accent-2
          );
          --simple-fields-tag-list-focus: var(
            --simple-colors-default-theme-accent-10
          );
        }
        simple-colors[accent-color] {
          display: inline-flex;
          width: 24px;
          height: 24px;
          margin: 4px 6px 0 0;
        }
        simple-colors[accent-color] span {
          display: inline-flex;
          width: 24px;
          height: 24px;
          background-color: var(
            --simple-colors-default-theme-accent-3,
            #eeeeee
          );
        }
        simple-fields-field[type="textarea"] {
          --simple-fields-font-size: 20px;
        }
        .source-selection {
          text-align: center;
          margin-top: 30vh;
          font-size: 32px;
        }
        .source-selection label {
          display: block;
        }
        .source-selection select {
          font-size: 18px;
        }
        #sourcedata,
        #sourcedatablob {
          display: block;
          margin: 16px auto;
          font-size: 24px;
        }
        simple-fields-field[type="number"] {
          --simple-fields-font-size: 40px;
          line-height: 40px;
        }

        .student-feedback-score-heading {
          display: flex;
          font-size: 28px;
          font-weight: bold;
          line-height: 28px;
          padding: 8px;
        }
        .student-feedback-score-heading h3 {
          margin: 0 0 0 8px;
          padding: 0;
        }

        #totalpts {
          width: 84px;
          margin: 0 12px;
        }
        .student-feedback-wrap {
          display: flex;
        }
        .student-feedback-wrap .student-feedback-text {
          width: 80%;
          margin: 0;
        }
        .student-feedback-wrap .student-feedback-text div.heading {
          padding: 20px;
        }
        .student-feedback-wrap .student-feedback-score {
          font-size: 40px;
          line-height: 68px;
          padding: 34px 16px;
          display: flex;
          width: 50%;
        }
        simple-tag {
          margin: 2px;
        }
        simple-tag:focus,
        simple-tag:hover {
          --simple-fields-fieldset-border-color: var(
            --simple-colors-default-theme-accent-10,
            #eeeeee
          );
        }
        .user-info {
          display: flex;
          font-size: 16px;
          min-width: 140px;
          font-family: sans-serif;
          font-weight: normal;
          border-right: 1px solid black;
        }
        .user-left {
          display: inline-flex;
        }
        .user-right {
          display: block;
          padding: 0 4px 0 0;
          margin: 12px 0;
        }
        .user-right div a {
          color: var(--simple-colors-default-theme-grey-12);
          text-decoration: none;
        }
        .user-right div a:hover,
        .user-right div a:focus,
        .user-right div a:active {
          color: var(--simple-colors-default-theme-blue-8);
          text-decoration: underline;
        }
        .user-right div {
          display: block;
          text-align: center;
        }
        .user-photo {
          --simple-icon-height: 48px;
          --simple-icon-width: 48px;
          width: 48px;
          height: 48px;
          border-radius: 50%;
          margin: 12px 6px;
          float: left;
          vertical-align: middle;
        }
        .active-submission {
          max-height: 400px;
          width: 60%;
          overflow: auto;
          margin: 0 auto;
        }
        .active-submission iframe {
          height: 400px;
          width: 60%;
        }
        .tag-group {
          position: sticky;
          top: 0;
        }
        .student-report-wrap {
          display: flex;
          justify-content: space-evenly;
        }
        .student-report-score {
          position: absolute;
          right: 40px;
          margin-top: -20px;
        }
        editable-table-display::part(td),
        editable-table-display::part(th) {
          text-align: center;
          vertical-align: top;
          max-width: 250px;
        }
        editable-table-display::part(simple-fields-field) {
          --simple-fields-font-size: 32px;
          --simple-fields-text-align: center;
          background-color: transparent;
          max-width: 100px;
          padding: 0 0 28px 0;
          margin: 0;
        }

        table thead th {
          padding: 4px !important;
          position: sticky;
          top: -2px;
          z-index: 1;
        }
        table thead th:first-child {
          position: sticky;
          left: 0;
          z-index: 2;
        }
        table tbody th {
          position: sticky;
          left: 0;
          z-index: 1;
        }

        .col-highlight,
        tr:hover td,
        tr:hover th {
          transition: 0.3s ease-in-out all;
          background-color: var(
            --simple-colors-default-theme-yellow-2
          ) !important;
        }
        table {
          width: calc(100% - 2 * var(--editable-table-border-width, 1px));
          border-collapse: collapse;
          border-width: var(--editable-table-border-width, 1px);
          border-style: var(--editable-table-border-style, solid);
          border-color: var(--simple-colors-default-theme-grey-6, #999);
          font-weight: var(--editable-table-light-weight, 200);
          color: var(--simple-colors-default-theme-grey-10, #222);
          background-color: var(--simple-colors-default-theme-grey-1, #fff);
        }
        .th,
        .td {
          font-weight: var(--editable-table-light-weight, 200);
          color: var(--simple-colors-default-theme-grey-10, #222);
          background-color: var(--simple-colors-default-theme-grey-1, #fff);
        }
        caption {
          font-size: var(
            --editable-table-caption-font-size,
            var(--editable-table-font-size, unset)
          );
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(
            --editable-table-caption-color,
            var(--simple-colors-default-theme-grey-10, #222)
          );
          background-color: var(
            --editable-table-caption-bg-color,
            var(--simple-colors-default-theme-grey-1, #fff)
          );
          width: 100%;
        }
        .tr {
          display: table-row;
        }
        .th-or-td {
          display: table-cell;
        }
        .thead .th-or-td {
          height: 32px;
          padding: 0;
          margin: 0;
        }
        .thead-tr .th {
          background-color: var(--simple-colors-default-theme-grey-2, #e0e0e0);
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(--simple-colors-default-theme-grey-12, #000);
        }
        .tbody-tr .th {
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(--simple-colors-default-theme-grey-12, #000);
          background-color: var(--simple-colors-default-theme-grey-1, #fff);
          text-align: left;
        }
        table[bordered] .th,
        table[bordered] .td {
          border-width: var(--editable-table-border-width, 1px);
          border-style: var(--editable-table-border-style, solid);
          border-color: var(--simple-colors-default-theme-grey-6, #999);
        }
        table[condensed] {
          --editable-table-cell-vertical-padding: var(
            --editable-table-cell-vertical-padding-condensed,
            2px
          );
          --editable-table-cell-horizontal-padding: var(
            --editable-table-cell-horizontal-padding-condensed,
            4px
          );
        }
        table[striped] .tbody-tr:nth-child(2n + 1) .th-or-td {
          background-color: var(--simple-colors-default-theme-grey-2, #f0f0f0);
        }
        .tfoot-tr .th,
        .tfoot-tr .td {
          border-top: 2px solid var(--simple-colors-default-theme-grey-10, #222);
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(--simple-colors-default-theme-grey-12, #000);
        }
        caption,
        .th-or-td {
          text-align: left;
        }
        table[numeric-styles] .thead-tr .th-or-td[numeric],
        table[numeric-styles] .tfoot-tr .th-or-td[numeric],
        table[numeric-styles] .th-or-td[numeric] {
          text-align: center;
          font-size: 24px;
          font-family: sans-serif;
          --editable-table-cell-justify: flex-end;
        }
        table[numeric-styles] .tfoot-tr .th-or-td[negative],
        table[numeric-styles] .td[negative] {
          color: var(--simple-colors-default-theme-red-7, red);
          --editable-table-cell-color: var(
            --editable-table-negative-color,
            red
          );
        }

        caption > div {
          display: flex;
          align-items: flex-end;
          justify-content: space-between;
        }
        caption > div > *:not(:last-child) {
          padding: 0 0 5px;
        }
        #column {
          width: calc(var(--simple-picker-option-size) + 6px);
          overflow: visible;
          display: none;
          margin-left: 10px;
          --simple-picker-border-width: 1px;
          --simple-picker-focus-border-width: 1px;
          --simple-picker-border-color: var(
            --simple-colors-default-theme-grey-6,
            #999
          );
        }
        .th,
        .td {
          padding: 0;
        }
        .top-controls {
          background-color: var(--simple-colors-default-theme-accent-12);
          color: var(--simple-colors-default-theme-accent-1);
          height: 36px;
          vertical-align: middle;
          width: 100%;
          display: flex;
        }
        .top-controls .group {
          padding: 0 8px;
        }
        .top-controls .app-name {
          padding: 0 24px 0 16px;
        }
        .top-controls simple-icon-button-lite span {
          padding: 0 8px 0 0;
        }
        .top-controls .divider-left {
          border-left: 1px solid var(--simple-colors-default-theme-accent-1);
        }
        .top-controls .divider-right {
          border-right: 1px solid var(--simple-colors-default-theme-accent-1);
        }
      `]}studentLetterGradeHistoryClick(e){f.activeAssignment=parseInt(e.target.value),this.requestUpdate()}activateOption(e){let t=l(e);t[0].getAttribute("data-student")&&t[0].getAttribute("data-assignment")&&(f.activeAssignment=parseInt(t[0].getAttribute("data-assignment")),f.activeStudent=parseInt(t[0].getAttribute("data-student")))}handleGridScaling(e){let t=l(e);"TABLE"===t[0].tagName&&(""!=t[0].style.height?t[0].style.height=null:t[0].style.height="90vh")}PDFPageButton(t="auto"){return e`
      ${g.has("@core/htmlToPdf")?e` <div class="pdf-page-btn">
            <simple-icon-button-lite
              part="pdf-page-btn"
              class="btn"
              icon="${this.__pdfLoading?"hax:loading":"lrn:pdf"}"
              id="pdf-page-btn"
              @click="${this.downloadPDFviaMicro}"
              icon-position="top"
            >
            </simple-icon-button-lite>
            <simple-tooltip for="pdf-page-btn" position="${t}">
              ${this.__pdfLoading?this.t.downloadingPdfPleaseWait:this.t.downloadPdf}
            </simple-tooltip>
          </div>`:""}
      <div class="hash-page-btn">
        <simple-icon-button-lite
          part="hash-page-btn"
          class="btn"
          icon="${this.__hashLoading?"hax:loading":"link"}"
          id="hash-page-btn"
          @click="${this.createHashLink}"
          icon-position="top"
        >
        </simple-icon-button-lite>
        <simple-tooltip for="pdf-page-btn" position="${t}">
          ${this.__hashLoading?this.t.generatingPleaseWait:this.t.generateHashLink}
        </simple-tooltip>
      </div>
    `}async downloadPDFviaMicro(e){this.__pdfLoading=!0;let t=this.shadowRoot.querySelector("#studentreport").innerHTML.replace(/<\!--.*?-->/g,"").replace(/\s+/g," ").trim();var i="";globalThis.document.querySelector("base")&&(i=globalThis.document.querySelector("base").href);const a=await g.call("@core/htmlToPdf",{base:i,html:t});if(200==a.status&&a.data){const e=globalThis.document.createElement("a");e.href=globalThis.URL.createObjectURL(b(a.data,"application/pdf")),e.download="StudentReport.pdf",e.target="_blank",this.appendChild(e),e.click(),this.removeChild(e)}this.__pdfLoading=!1}async createHashLink(e){this.__hashLoading=!0;let t=this.shadowRoot.querySelector("#studentreport").innerHTML.replace(/<\!--.*?-->/g,"").replace(/\s+/g," ").trim();const i=await g.call("@core/crypto",{op:"hash",data:t});200==i.status&&i.data&&globalThis.open(`https://secure-feedback.vercel.app/?message=${i.data}`,"_blank"),this.__hashLoading=!1}openWindow(e){this.__openWindow&&!this.__openWindow.closed?this.__openWindow.focus():(this.__openWindow=globalThis.open("","studentwork",`left=0,top=0,width=${screen.width/2},height=${screen.height/2},menubar=0,location=0,toolbar=0,status=0`),this.__openWindow.onbeforeunload=()=>{this.displayMode=0,this.__openWindow=null})}render(){return e`
      <loading-indicator full ?loading="${this.loading}"></loading-indicator>
      <div class="top-controls">
        <div class="group divider-right app-name">
          <slot name="app-name"></slot>
        </div>
        <div class="group divider-right">
          ${this.renderActiveAssignmentBtn()}
          <simple-icon-button-lite
            @click="${this.changeAssignment}"
            value="prev"
            title="${this.t.previousAssignment}"
            icon="arrow-back"
            ?disabled="${0===this.activeAssignment||!this.ready}"
          >
            <span class="hide-900" value="prev">${this.t.previous}</span>
          </simple-icon-button-lite>
          <simple-icon-button-lite
            @click="${this.changeAssignment}"
            value="next"
            title="${this.t.nextAssignment}"
            ?disabled="${this.database.assignments.length-1===this.activeAssignment||!this.ready}"
            icon="arrow-forward"
          >
            <span class="hide-900" value="next">${this.t.next}</span>
          </simple-icon-button-lite>
        </div>
        <div class="group">${this.renderGradeScaleBtn()}</div>
        ${this.ready&&"filesystem"===this.source&&this.sourceData?e`
              <div class="group">
                <simple-icon-button-lite
                  @click="${this.saveToFilesystem}"
                  title="${this.t.saveGradebook}"
                  ?disabled="${!this.sourceData}"
                  icon="save"
                >
                  <span class="hide-900">${this.t.saveGradebook}</span>
                </simple-icon-button-lite>
              </div>
            `:a}
      </div>
      <div ?hidden="${this.sourceData}" class="source-selection">
        <label>${this.t.selectGradebookSource}..</label>
        <select id="source" @change="${this.selectSource}">
          ${this.hasFilePicker?e`<option
                value="filesystem"
                ?selected="${"filesystem"===this.source}"
              >
                File system
              </option>`:a}
          <option
            value="googledocs"
            ?selected="${"googledocs"===this.source}"
          >
            Google docs
          </option>
          <option value="url">URL endpoint (JSON)</option>
          <option value="json">JSON data blob</option>
        </select>
        <simple-icon-button-lite
          @click="${this.loadFromSource}"
          title="${this.t.loadGradebook}"
          ?disabled="${this.sourceData}"
          icon="folder-shared"
        >
          <span class="hide-900">${this.t.loadGradebook}</span>
        </simple-icon-button-lite>
        ${"filesystem"==this.source&&this.prevLocalFileReference?e`
              <simple-icon-button-lite
                @click="${this.loadFromExistingSource}"
                title="${this.t.loadGradebook}"
                ?disabled="${this.sourceData}"
                icon="folder-shared"
              >
                <span class="hide-900"
                  >${this.t.load} ${this.prevLocalFileReference.name}</span
                >
              </simple-icon-button-lite>
            `:a}
        <input
          id="sourcedata"
          placeholder="${this.t.sourceData}"
          ?hidden="${!["googledocs","url"].includes(this.source)}"
        />
        <textarea
          id="sourcedatablob"
          rows="10"
          cols="40"
          placeholder="${this.t.pasteValidJSONHere}"
          ?hidden="${"json"!=this.source}"
        ></textarea>
      </div>
      ${"filesystem"===this.source&&this.loading?e`<p class="source-selection">${this.t.loadingFilePleaseWait}</p>`:a}
      <a11y-tabs
        id="studentassessment"
        full-width
        @a11y-tabs-active-changed="${this.updateStudentReport}"
        ?hidden="${!(this.database.assignments&&this.database.assignments[this.activeAssignment])}"
      >
        <a11y-tab
          id="assessment"
          icon="assignment-ind"
          label="${this.t.activeAssessment}"
        >
          ${this.activeRubric[0]?e`
                <grid-plate disable-responsive layout="1-1">
                  <div slot="col-1" class="tag-group">
                    <simple-fields-field
                      id="inputfilter"
                      @value-changed="${this.inputfilterChanged}"
                      .value="${this.like}"
                      aria-controls="filter"
                      label="Filter"
                      placeholder="Tag search"
                      type="text"
                      auto-validate=""
                      autofocus
                      part="filter"
                    ></simple-fields-field>
                    <simple-icon-button-lite
                      @click="${this.collapseAll}"
                      icon="hardware:keyboard-arrow-right"
                      class="control"
                      value=""
                      >Collapse all</simple-icon-button-lite
                    >
                    <simple-icon-button-lite
                      @click="${this.expandAll}"
                      icon="hardware:keyboard-arrow-down"
                      class="control"
                      value=""
                      >Expand all</simple-icon-button-lite
                    >
                    ${this.database.tags.categories.length>0?e`
                          <a11y-collapse-group
                            heading-button
                            id="categoriesgroup"
                            global-options='{"expanded": true}'
                          >
                            ${this.database.tags.categories.map(((t,i)=>e`
                                <a11y-collapse>
                                  <div slot="heading">
                                    <simple-colors
                                      accent-color="${this.pickColor(i)}"
                                      ><span></span></simple-colors
                                    >${t}
                                  </div>
                                  <div slot="content">
                                    ${this.filtered.filter((e=>e.category.includes(t))).map((t=>e`<simple-tag
                                            draggable="true"
                                            tabindex="0"
                                            @keypress="${this.keyDown}"
                                            @dragstart="${this.setDragTransfer}"
                                            accent-color="${this.pickColor(i)}"
                                            value="${t.term}"
                                            .data="${t}"
                                          ></simple-tag>`))}
                                  </div>
                                </a11y-collapse>
                              `))}
                          </a11y-collapse-group>
                        `:a}
                  </div>
                  <div slot="col-2">
                    <h3>${this.activeRubric[0].name}</h3>
                    ${this.PDFPageButton()}
                    ${this.activeRubric.map(((t,i)=>e`
                        <letter-grade-picker></letter-grade-picker>

                        <editable-table-display
                          accent-color="${this.accentColor}"
                          bordered
                          column-header
                          condensed
                          disable-responsive
                          scroll
                          striped
                        >
                          <table>
                            <tbody>
                              <tr>
                                ${t.qualitative.map((t=>e` <td>${t}</td> `))}
                              </tr>
                              <tr>
                                ${t.qualitative.map((i=>e`
                                    <td>
                                      <simple-fields-tag-list
                                        style="background-color:transparent;"
                                        data-criteria="${t.criteria}"
                                        label="${i}"
                                      ></simple-fields-tag-list>
                                    </td>
                                  `))}
                              </tr>
                            </tbody>
                          </table>
                        </editable-table-display>
                        <h4>Additional ${t.criteria} feedback</h4>
                        <simple-fields-field
                          type="textarea"
                          data-rubric-written
                          data-criteria="${t.criteria}"
                        ></simple-fields-field>
                      `))}
                    <div class="student-feedback-wrap">
                      <div class="student-feedback-text">
                        <h3 class="heading">Overall feedback</h3>
                        <simple-fields-field
                          type="textarea"
                          data-criteria="overall"
                          data-rubric-written
                        ></simple-fields-field>
                      </div>
                      <div class="student-feedback-score">
                        <simple-icon-button-lite
                          icon="${this.scoreLock?"lock":"lock-open"}"
                          @click="${this.toggleLock}"
                        ></simple-icon-button-lite>
                        <simple-fields-field
                          ?disabled="${this.scoreLock}"
                          type="number"
                          min="0"
                          id="totalpts"
                          maxlength="10"
                          @value-changed="${this.totalScoreChangedEvent}"
                        ></simple-fields-field>
                        /
                        ${this.database.assignments[this.activeAssignment].points}
                        pts
                        <letter-grade
                          style="margin:-8px 0 0 16px;"
                          total="${this.database.assignments[this.activeAssignment].points}"
                          score="${this.totalScore}"
                        ></letter-grade>
                      </div>
                    </div>
                  </div>
                </grid-plate>
              `:a}
        </a11y-tab>
        <a11y-tab
          id="studentreporttab"
          icon="assignment"
          label="${this.t.studentReportView}"
        >
          <div id="studentreport">
            ${!this.loading&&this.database.assignments&&this.database.assignments[this.activeAssignment]?e`
                  <letter-grade
                    class="student-report-score"
                    show-scale
                    total="${this.database.assignments[this.activeAssignment].points}"
                    score="${this.totalScore}"
                  ></letter-grade>
                  <h2>Feedback report</h2>
                  <div class="student-report-wrap">
                    <a11y-collapse-group
                      heading-button
                      expanded
                      style="width:80%;"
                    >
                      ${this.database.rubrics.filter((e=>e.shortName==this.database.assignments[this.activeAssignment].rubric)).map((t=>e`
                            <a11y-collapse class="student-feedback-text">
                              <div slot="heading" class="heading">
                                <span style="font-size:20px;"
                                  >${t.criteria}</span
                                >
                              </div>
                              <div slot="content">
                                <div class="student-feedback-score-heading">
                                  <div>
                                    ${this.getCriteriaScore(t.criteria)} /
                                    ${Math.round(t.percentage/100*this.database.assignments[this.activeAssignment].points)}
                                  </div>
                                  <h3>Criteria details</h3>
                                </div>
                                <p>${t.description}</p>
                                <h3>Your feedback</h3>
                                <ul>
                                  ${t.qualitative.map((i=>e`
                                      <h4>${i}</h4>
                                      <ul>
                                        ${this.activeGrading[t.criteria]?e`${this.activeGrading[t.criteria][i].map((t=>e` <li>
                                                  <span>${t.term}</span
                                                  >${t.description?e` - ${t.description}`:""}
                                                  ${t.associatedMaterial?e`
                                                        <ul>
                                                          ${t.associatedMaterial.map((t=>e`
                                                              <li>
                                                                <a
                                                                  href="${t}"
                                                                  target="_blank"
                                                                  rel="noopener noreferrer"
                                                                  >${t}</a
                                                                >
                                                              </li>
                                                            `))}
                                                        </ul>
                                                      `:""}
                                                </li>`))}`:""}
                                      </ul>
                                    `))}
                                </ul>
                                <h3>Additional Criteria feedback</h3>
                                <p>
                                  ${this.getCriteriaFeedback(t.criteria)}
                                </p>
                              </div>
                            </a11y-collapse>
                          `))}
                      <a11y-collapse class="student-feedback-text">
                        <div slot="heading" class="heading">
                          <span style="font-size:20px;"
                            >${this.t.overallFeedback}</span
                          >
                        </div>
                        <div slot="content">
                          <p>${this.getCriteriaFeedback("overall")}</p>
                          <h2>Your total Score</h2>
                          <div class="score-display">
                            ${this.totalScore} /
                            ${this.database.assignments[this.activeAssignment].points}
                            pts
                          </div>
                        </div>
                      </a11y-collapse>
                    </a11y-collapse-group>
                  </div>
                `:a}
          </div>
        </a11y-tab>
      </a11y-tabs>
    `}inputfilterChanged(e){""!==e.detail.value&&this.expandAll(),this.like=e.target.value}expandAll(e){this.shadowRoot.querySelectorAll("#categoriesgroup a11y-collapse").forEach((e=>{e.expanded=!0}))}collapseAll(e){this.shadowRoot.querySelectorAll("#categoriesgroup a11y-collapse").forEach((e=>{e.expanded=!1}))}selectSource(e){this.source=this.shadowRoot.querySelector("#source").value}loadFromSource(e){this.source=this.shadowRoot.querySelector("#source").value,"json"===this.source?this.sourceData=this.shadowRoot.querySelector("#sourcedatablob").value:"filesystem"==this.source?this.loadFromFilesystem():this.sourceData=this.shadowRoot.querySelector("#sourcedata").value}loadFromExistingSource(e){this.source=this.shadowRoot.querySelector("#source").value,this.loadFromFilesystem(!0)}loadFromFilesystem(e=!1){e?(this.loading=!0,setTimeout((()=>{h.processFile(this.prevLocalFileReference,"json"),this.sourceData=this.prevLocalFileReference}),0)):h.loadFile("xls").then((async e=>{this.loading=!0,await p("grade-book-prev-file",e),setTimeout((()=>{h.processFile(e,"json"),this.sourceData=e}),0)}))}async saveToFilesystem(e){const t=h.workbookFromJSON(this.database),i=new Blob([t],{type:"application/octet-stream"});(new FileReader).readAsDataURL(i),await h.saveFile("xlsx",t)}rubricCriteriaPointsChange(e){null!=e.detail.getAttribute("data-rubric-score")&&(clearTimeout(this.__debounce),this.__debounce=setTimeout((async()=>{this.loading||(this.updateTotalScore(),this.shadowRoot.querySelector("#totalpts").value=this.totalScore),this.scoreLock=!0}),0))}updateTotalScore(){let e=0,t=this.shadowRoot.querySelectorAll("#assessment simple-fields-field[type='number']:not(#totalpts)");for(var i in Array.from(t))t[i].value&&(e+=parseInt(t[i].value));this.totalScore=e,this.shadowRoot.querySelector("#totalpts").value=e,this.requestUpdate()}totalScoreChangedEvent(e){this.ready&&(e.stopPropagation(),e.stopImmediatePropagation(),e.preventDefault(),this.totalScore=e.detail.value,this.database.grades[this.activeStudent][this.database.assignments[this.activeAssignment].shortName]=this.totalScore,this.activeStudentSubmissions=[],this.activeStudentSubmissions=[...this.getStudentSubmissions(this.activeStudent)],this.requestUpdate())}toggleLock(e){this.scoreLock=!this.scoreLock}updateStudentReport(){this.requestUpdate()}getCriteriaScore(e){let t=this.shadowRoot.querySelectorAll("#assessment editable-table-display");for(var i in Array.from(t))if(t[i].shadowRoot.querySelector(`[data-rubric-score][data-criteria="${e}"]`))return t[i].shadowRoot.querySelector(`[data-rubric-score][data-criteria="${e}"]`).value;return 0}getCriteriaFeedback(e){return this.shadowRoot.querySelector(`#assessment [data-rubric-written][data-criteria="${e}"]`)?this.shadowRoot.querySelector(`#assessment [data-rubric-written][data-criteria="${e}"]`).value:""}qualitativeFeedbackUpdate(e){this.activeGrading[e.detail.getAttribute("data-criteria")]||(this.activeGrading[e.detail.getAttribute("data-criteria")]={}),this.activeGrading[e.detail.getAttribute("data-criteria")][e.detail.label]=e.detail.tagList,this.requestUpdate()}keyDown(e){e.key}pickColor(e){let t=Object.keys(this.colors);for(;e>t.length;)e-=t.length;return t[e]}_handleDragDrop(e){globalThis.dispatchEvent(new CustomEvent("simple-tag-drop",{detail:{value:"drop"}}))}setDragTransfer(e){globalThis.dispatchEvent(new CustomEvent("simple-tag-dragstart",{detail:{value:e.target}}));let t=e.target.data;t.color=e.target.accentColor,e.dataTransfer.setData("text",JSON.stringify(t))}static get tag(){return"grade-book-lite"}}customElements.define(GradeBookLite.tag,GradeBookLite);export{GradeBookLite};globalThis.GradeBook=globalThis.GradeBook||{},globalThis.GradeBook.requestAvailability=()=>(globalThis.GradeBook.instance||(globalThis.document.querySelector("grade-book")?globalThis.GradeBook.instance=globalThis.document.querySelector("grade-book"):(globalThis.GradeBook.instance=globalThis.document.createElement("grade-book"),globalThis.document.body.appendChild(globalThis.GradeBook.instance))),globalThis.GradeBook.instance);