/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t,render as s,nothing as i}from"../../lit/index.js";import{SimpleColors as a}from"../simple-colors/simple-colors.js";import{I18NMixin as o}from"../i18n-manager/lib/I18NMixin.js";import{validURL as r,cleanVideoSource as l,isElementInViewport as d}from"../utils/utils.js";import{gSheetInterface as n}from"../utils/lib/gSheetsInterface.js";import{normalizeEventPath as c}from"../utils/utils.js";import"../simple-fields/lib/simple-fields-field.js";import"../simple-fields/lib/simple-fields-tag-list.js";import"../a11y-collapse/a11y-collapse.js";import"../a11y-collapse/lib/a11y-collapse-group.js";import"../editable-table/lib/editable-table-display.js";import"../a11y-tabs/a11y-tabs.js";import"../a11y-tabs/lib/a11y-tab.js";import"../grid-plate/grid-plate.js";import"../iframe-loader/lib/loading-indicator.js";import"./lib/letter-grade.js";import"./lib/letter-grade-picker.js";import"../../@github/time-elements/dist/index.js";import{UIRenderPieces as h}from"./lib/GradeBookUIPieces.js";import{GradeBookStore as p}from"./lib/grade-book-store.js";import"./lib/grade-book-pop-up.js";import{autorun as u,toJS as g}from"../../mobx/dist/mobx.esm.js";import{get as m,set as b}from"../../idb-keyval/dist/compat.js";import{ESGlobalBridgeStore as v}from"../es-global-bridge/es-global-bridge.js";import{XLSXFileSystemBrokerSingleton as f}from"../file-system-broker/lib/xlsx-file-system-broker.js";class GradeBook extends(h(o(a))){constructor(){super(),this.hasFilePicker=!1,this.source="googledocs",globalThis.showOpenFilePicker&&(this.source="filesystem",this.hasFilePicker=!0),this.ready=!1,this.displayMode=0,this.assessmentView=this.resetAssessmentView(),this.totalScore=0,this.activeStudentSubmissions=[],this.scoreLock=!0,this.activeRubric=[],this.activeGrading={},this.settings={photo:!0,fname:!0,surname:!0,email:!0},this.disabled=!1,this.loading=!1,this.t={csvURL:"CSV URL",points:"Points",criteria:"Criteria",description:"Description",assessmentWeight:"Assessment weight",overallFeedback:"Overall feedback",letterGrade:"Letter grade",highRange:"High range",lowRange:"Low range",noSubmission:"No submission found",studentSubmission:"Student submission",openInNewWindow:"Open in new window",gradingScale:"Grading scale",activeStudent:"Active student",activeAssignment:"Active assignment",submitted:"Submitted",dueDate:"Due date",firstName:"First name",surname:"Surname",photo:"Photo",email:"Email",settings:"Settings",previous:"Previous",next:"Next",previousStudent:"Previous student",nextStudent:"Next student",previousAssignment:"Previous assignment",nextAssignment:"Next assignment",student:"Student",assessmentView:"Assessment View",activeAssessment:"Active assessment",studentReportView:"Student report view",loadGradebook:"Load gradebook",load:"Load",saveGradebook:"Save gradebook",selectGradebookSource:"Select gradebook source",sourceData:"Source data",pasteValidJSONHere:"Paste valid JSON here",loadingFilePleaseWait:"LOADING FILE PLEASE WAIT.."},this.registerLocalization({context:this,basePath:import.meta.url,locales:["es","fr","de"]}),this.addEventListener("simple-fields-tag-list-changed",this.qualitativeFeedbackUpdate.bind(this)),this.addEventListener("value-changed",this.rubricCriteriaPointsChange),this.addEventListener("drop",this._handleDragDrop.bind(this)),u((()=>{this.activeStudent=g(p.activeStudent)})),u((()=>{this.activeAssignment=g(p.activeAssignment)})),u((()=>{this.database=g(p.database)})),u((()=>{this.activeSubmission=g(p.activeSubmission)}))}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e);new ResizeObserver((e=>{clearTimeout(this.__resizer),this.__resizer=setTimeout((()=>{var t=0;for(let s of e)t=s.contentBoxSize?Math.round(globalThis.innerHeight-s.contentBoxSize[0].blockSize-122):Math.round(globalThis.innerHeight-s.contentRect.height-122);this.shadowRoot.querySelector("#studentassessment").shadowRoot.querySelector("[part='content']").style.height=t+"px"}),50)})).observe(this.shadowRoot.querySelector("#studentgrid")),setTimeout((async()=>{this.prevLocalFileReference=await m("grade-book-prev-file"),this.requestUpdate()}),0)}resetAssessmentView(){return{qualitative:[],written:[]}}getStudentSubmissions(e){let t=[];for(var s in this.database.submissions){let a=this.database.submissions[s];if(a.student===this.database.roster[e].student){for(var i in a)if("student"!==i){let s=this.getAssignmentByShortName(i);s&&t.push({studentScore:this.database.grades[e]&&""!=this.database.grades[e][i]?this.database.grades[e][i]:null,assignmentPoints:s.points,assignmentName:s.name,assignmentIndex:s.index})}return t}}return t}getAssignmentByShortName(e){let t,s=this.database.assignments.filter(((s,i)=>s.shortName===e&&(t=i,!0)));return 1===s.length?(s[0].index=t,s[0]):null}getCurrentScore(e,t){return this.database.grades[e]&&this.database.grades[e][this.database.assignments[t].shortName]?this.database.grades[e][this.database.assignments[t].shortName]:0}getActiveRubric(){return this.database.rubrics.filter((e=>e.shortName==this.database.assignments[this.activeAssignment].rubric))}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{if(!this.loading&&["activeAssignment","activeStudent","database","loading"].includes(t)&&(setTimeout((()=>{this.totalScore=this.getCurrentScore(this.activeStudent,this.activeAssignment),this.assessmentView=this.resetAssessmentView(),this.activeRubric=[...this.getActiveRubric()],this.hideRubricInfo=[...this.activeRubric.map((()=>!1))],this.activeStudentSubmissions=[],this.activeStudentSubmissions=[...this.getStudentSubmissions(this.activeStudent)],2==this.displayMode&&this.renderSubmissionInWindow()}),0),this.maintainScrollPosition()),["sourceData","source"].includes(t))if(this.sourceData)switch(this.source){case"googledocs":this.loading=!0,this.gSheet=new n(this,this.sourceData,{tags:0,roster:118800528,assignments:540222065,rubrics:1744429439,submissions:2104732668,gradeScale:980501320,grades:2130903440,gradesDetails:644559151,settings:1413275461}),setTimeout((async()=>{for(var e in this.gSheet.sheetGids){let t=await this.gSheet.loadSheetData(e);t=this.transformTable(t),"function"==typeof this[`process${e}Data`]&&(t=this[`process${e}Data`](t)),this.database[e]=t,"gradeScale"===e&&this.database.gradeScale&&this.database.gradeScale.length>0&&(p.gradeScale=this.database.gradeScale),this.requestUpdate()}this.importStateCleanup()}),0);break;case"url":this.loading=!0,fetch(this.sourceData).then((e=>{if(e.ok)return e.json()})).then((e=>{p.database=e,this.importStateCleanup()})).catch((e=>{console.warn(e)}));break;case"json":p.database=JSON.parse(this.sourceData),this.importStateCleanup()}else"filesystem"==this.source&&(this.__applied||(this.__applied=!0,globalThis.addEventListener("xlsx-file-system-data",(e=>{let t=e.detail.data;for(var s in t){let e=this.transformTable(t[s]);"function"==typeof this[`process${s}Data`]&&(e=this[`process${s}Data`](e)),p.database[s]=e}this.importStateCleanup()}))))}))}importStateCleanup(){this.loading=!1,this.database.gradeScale&&this.database.gradeScale.length>0&&(p.gradeScale=this.database.gradeScale),this.requestUpdate(),this.ready=!0}transformTable(e){let t=e.shift(),s={},i=[];for(var a in t)s[t[a]]=a;for(var a in e){let t={};for(var o in s)t[o]=e[a][s[o]];i.push(t)}return i}maintainScrollPosition(){this.shadowRoot&&this.shadowRoot.querySelector("#studentgrid [data-active]")&&setTimeout((()=>{let e=d(this.shadowRoot.querySelector("#studentgrid [data-active]"),{top:0,right:globalThis.innerWidth,bottom:this.shadowRoot.querySelector("#studentgrid").getBoundingClientRect().height+20,left:192});0===p.activeStudent?this.shadowRoot.querySelector("#studentgrid").scrollTop=0:e||(this.shadowRoot.querySelector("#studentgrid").scrollTop=this.shadowRoot.querySelector("#studentgrid [data-active]").offsetTop-this.shadowRoot.querySelector("#studentgrid").offsetTop),0===p.activeAssignment?this.shadowRoot.querySelector("#studentgrid").scrollLeft=0:e||(this.shadowRoot.querySelector("#studentgrid").scrollLeft=this.shadowRoot.querySelector("#studentgrid [data-active]").offsetLeft-192-this.shadowRoot.querySelector("#studentgrid").offsetLeft)}),0)}processassignmentsData(e){for(var t in e)if(""!=e[t].dueDate)try{const s=new Date(`${e[t].dueDate} ${e[t].dueTime}`);e[t]._ISODueDate=s.toISOString()}catch(e){}return e}processtagsData(e){let t=new Set([]),s=[];for(var i in e)e[i].category=e[i].category?e[i].category.split(","):[],e[i].associatedMaterial=e[i].associatedMaterial?e[i].associatedMaterial.split(","):[],e[i].category.forEach((e=>{t.add(e)})),s=[...Array.from(t)];return{categories:s,data:e}}processrubricsData(e){for(var t in e)e[t].qualitative=e[t].qualitative?e[t].qualitative.split(","):[];return e}processrosterData(e){for(var t in e)e[t].interests=e[t].interests?e[t].interests.split(","):[];return e}processsettingsData(e){let t={};for(var s in e)t[e[s].key]=e[s].value;return t}static get properties(){return{...super.properties,displayMode:{type:Number},settings:{type:Object},disabled:{type:Boolean,reflect:!0},loading:{type:Boolean,reflect:!0},ready:{type:Boolean,reflect:!0},activeStudent:{type:Number,attribute:"active-student"},activeAssignment:{type:Number,attribute:"active-assignment"},totalScore:{type:Number},scoreLock:{type:Boolean},source:{type:String},sourceData:{type:String,attribute:"source-data"},activeSubmission:{type:String,attribute:!1},database:{type:Object,attribute:!1},activeRubric:{type:Object,attribute:!1},assessmentView:{type:Object,attribute:!1},activeGrading:{type:Object,attribute:!1},activeStudentSubmissions:{type:Array}}}async changeStudent(e){this.shadowRoot.querySelectorAll("#studentgrid .th-or-td").forEach((e=>{e.classList.remove("col-highlight")})),"prev"==e.target.getAttribute("value")&&0!==this.activeStudent?p.activeStudent--:"next"==e.target.getAttribute("value")&&this.database.roster.length-1!==this.activeStudent&&p.activeStudent++,await this.requestUpdate()}async changeAssignment(e){this.shadowRoot.querySelectorAll("#studentgrid .th-or-td").forEach((e=>{e.classList.remove("col-highlight")})),"prev"==e.target.getAttribute("value")&&0!==this.activeAssignment?p.activeAssignment--:"next"==e.target.getAttribute("value")&&this.database.assignments.length-1!==p.activeAssignment&&p.activeAssignment++,await this.requestUpdate()}static get styles(){return[super.styles,t`
        :host {
          display: block;
        }
        :host [hidden] {
          display: none !important;
        }
        @media (max-width: 900px) {
          .hide-900 {
            display: none;
          }
        }
        loading-indicator {
          --loading-indicator-background-color: var(
            --simple-colors-default-theme-accent-2,
            grey
          );
          --loading-indicator-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
        }
        loading-indicator[full] {
          top: 0;
          position: absolute;
          left: 0;
          right: 0;
          z-index: 1;
        }
        h1,
        h2,
        h3,
        h4 {
          margin: 0;
        }
        grid-plate {
          --hax-layout-container-transition: none;
          --grid-plate-col-transition: none;
          --grid-plate-item-margin: 0px;
          --grid-plate-item-padding: 8px;
        }
        #studentassessment {
          --a11y-tabs-border-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
          --a11y-tabs-border-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
          color: var(--simple-colors-default-theme-grey-12);
          background-color: var(--simple-colors-default-theme-grey-1);
          --a11y-tabs-faded-color: var(--simple-colors-default-theme-grey-11);
          --a11y-tabs-focus-color: var(--simple-colors-default-theme-grey-10);
          --a11y-tabs-faded-background: var(
            --simple-colors-default-theme-grey-2
          );
        }
        #studentassessment::part(content) {
          overflow: scroll;
        }
        a11y-collapse {
          --a11y-collapse-border-color: var(
            --simple-colors-default-theme-accent-10,
            black
          );
          --a11y-collapse-horizontal-padding: 8px;
          --a11y-collapse-vertical-padding: 4px;
        }
        a11y-collapse:not([expanded]):hover {
          background-color: var(--simple-colors-default-theme-accent-1, grey);
        }
        a11y-collapse div[slot="heading"] {
          font-size: 18px;
          font-weight: normal;
          cursor: pointer;
          line-height: 30px;
          display: flex;
        }
        a11y-collapse[expanded] div[slot="heading"] {
          font-weight: bold;
        }
        .active-student-grade-history letter-grade {
          display: inline-flex;
          margin: 2px;
        }
        .active-student-grade-history button {
          opacity: 0.4;
          background-color: transparent;
          border: 0;
          padding: 0;
          margin: 0;
        }
        .active-student-grade-history button.activeAssignment {
          opacity: 0.9;
          background-color: var(--simple-colors-default-theme-yellow-8);
        }
        .active-student-grade-history button:focus,
        .active-student-grade-history button:active,
        .active-student-grade-history button:hover {
          opacity: 1;
          outline: 1px solid black;
          outline-offset: 2px;
        }
        simple-fields-tag-list {
          --simple-fields-tag-list-possible: var(
            --simple-colors-default-theme-accent-2
          );
          --simple-fields-tag-list-focus: var(
            --simple-colors-default-theme-accent-10
          );
        }
        simple-colors[accent-color] {
          display: inline-flex;
          width: 24px;
          height: 24px;
          margin: 4px 6px 0 0;
        }
        simple-colors[accent-color] span {
          display: inline-flex;
          width: 24px;
          height: 24px;
          background-color: var(
            --simple-colors-default-theme-accent-3,
            #eeeeee
          );
        }
        simple-fields-field[type="textarea"] {
          --simple-fields-font-size: 20px;
        }
        .source-selection {
          text-align: center;
          margin-top: 30vh;
          font-size: 32px;
        }
        .source-selection label {
          display: block;
        }
        .source-selection select {
          font-size: 18px;
        }
        #sourcedata,
        #sourcedatablob {
          display: block;
          margin: 16px auto;
          font-size: 24px;
        }
        simple-fields-field[type="number"] {
          --simple-fields-font-size: 40px;
          line-height: 40px;
        }

        .student-feedback-score-heading {
          display: flex;
          font-size: 28px;
          font-weight: bold;
          line-height: 28px;
          padding: 8px;
        }
        .student-feedback-score-heading h3 {
          margin: 0 0 0 8px;
          padding: 0;
        }

        #totalpts {
          width: 84px;
          margin: 0 12px;
        }
        #studentgrid {
          display: block;
          width: 100%;
          height: 52vh;
          max-height: 90vh;
          min-height: 140px; /** exact height of a row to still be usable */
          resize: vertical;
          overflow: auto;
          scrollbar-color: var(--simple-colors-default-theme-accent-10)
            var(--simple-colors-default-theme-accent-1);
          scrollbar-width: auto;
        }
        /** start scroll bar styling */
        #studentgrid::-webkit-scrollbar-track,
        #studentassessment::-webkit-scrollbar-track {
          -webkit-box-shadow: inset 0 0 2px rgba(0, 0, 0, 0.3);
          border-radius: 20px;
          background-color: var(--simple-colors-default-theme-accent-1);
        }
        #studentgrid::-webkit-scrollbar,
        #studentassessment::-webkit-scrollbar {
          width: 16px;
          height: 16px;
          background-color: var(--simple-colors-default-theme-accent-1);
        }
        #studentgrid::-webkit-scrollbar-thumb {
          border-radius: 20px;
          -webkit-box-shadow: inset 0 0 2px rgba(0, 0, 0, 0.3);
          background-color: var(--simple-colors-default-theme-accent-10);
        }
        #studentgrid::-webkit-scrollbar-thumb:vertical,
        #studentassessment::-webkit-scrollbar-thumb:vertical {
          height: 100px;
          width: 16px;
        }
        #studentgrid::-webkit-scrollbar-corner {
          -webkit-box-shadow: inset 0 0 2px rgba(0, 0, 0, 0.3);
          background-color: var(--simple-colors-default-theme-accent-10);
        }
        /** end scroll bar styling */
        .student-table-label {
          text-align: center;
          vertical-align: middle;
        }
        #studentgrid simple-fields-field.select-all {
          background-color: transparent;
          float: left;
          margin: -2px 0 0 -2px;
          --simple-icon-width: 16px;
          --simple-icon-height: 16px;
        }
        .student-table-label div {
          border-right: 1px solid var(--editable-table-heading-color, #000);
          height: 32px;
          width: 100%;
          line-height: 32px;
          margin-left: 3px;
        }
        #studentgrid [data-active] {
          background-color: var(
            --simple-colors-default-theme-yellow-3
          ) !important;
        }
        #studentgrid button {
          background-color: transparent;
          border: none;
          border-radius: 0;
          height: 80px;
          width: 96px;
          display: block;
          padding: 0;
          margin: 0;
          color: var(--simple-colors-default-theme-grey-12);
        }
        #studentgrid button:focus,
        #studentgrid button:hover {
          cursor: pointer;
          outline: 2px black solid;
          outline-offset: -1px;
          background-color: var(
            --simple-colors-default-theme-yellow-4
          ) !important;
        }
        #studentgrid .assignment-name {
          max-width: 96px;
          width: 96px;
          overflow: hidden;
          padding: 4px;
          font-size: 14px;
          text-align: center;
        }
        .student-feedback-wrap {
          display: flex;
        }
        .student-feedback-wrap .student-feedback-text {
          width: 80%;
          margin: 0;
        }
        .student-feedback-wrap .student-feedback-text div.heading {
          padding: 20px;
        }
        .student-feedback-wrap .student-feedback-score {
          font-size: 40px;
          line-height: 68px;
          padding: 34px 16px;
          display: flex;
          width: 50%;
        }
        simple-tag {
          margin: 2px;
        }
        simple-tag:focus,
        simple-tag:hover {
          --simple-fields-fieldset-border-color: var(
            --simple-colors-default-theme-accent-10,
            #eeeeee
          );
        }
        .user-info {
          display: flex;
          font-size: 16px;
          min-width: 140px;
          font-family: sans-serif;
          font-weight: normal;
          border-right: 1px solid black;
        }
        .user-left {
          display: inline-flex;
        }
        .user-right {
          display: block;
          padding: 0 4px 0 0;
          margin: 12px 0;
        }
        .user-right div a {
          color: var(--simple-colors-default-theme-grey-12);
          text-decoration: none;
        }
        .user-right div a:hover,
        .user-right div a:focus,
        .user-right div a:active {
          color: var(--simple-colors-default-theme-blue-8);
          text-decoration: underline;
        }
        .user-right div {
          display: block;
          text-align: center;
        }
        .user-photo {
          --simple-icon-height: 48px;
          --simple-icon-width: 48px;
          width: 48px;
          height: 48px;
          border-radius: 50%;
          margin: 12px 6px;
          float: left;
          vertical-align: middle;
        }
        .active-submission {
          max-height: 400px;
          width: 60%;
          overflow: auto;
          margin: 0 auto;
        }
        .active-submission iframe {
          height: 400px;
          width: 60%;
        }
        .tag-group {
          position: sticky;
          top: 0;
        }
        .student-report-wrap {
          display: flex;
          justify-content: space-evenly;
        }
        .student-report-score {
          position: absolute;
          right: 40px;
          margin-top: -20px;
        }
        editable-table-display::part(td),
        editable-table-display::part(th) {
          text-align: center;
          vertical-align: top;
          max-width: 250px;
        }
        editable-table-display::part(simple-fields-field) {
          --simple-fields-font-size: 32px;
          --simple-fields-text-align: center;
          background-color: transparent;
          max-width: 100px;
          padding: 0 0 28px 0;
          margin: 0;
        }

        table thead th {
          padding: 4px !important;
          position: sticky;
          top: -2px;
          z-index: 1;
        }
        table thead th:first-child {
          position: sticky;
          left: 0;
          z-index: 2;
        }
        table tbody th {
          position: sticky;
          left: 0;
          z-index: 1;
        }

        .col-highlight,
        tr:hover td,
        tr:hover th {
          transition: 0.3s ease-in-out all;
          background-color: var(
            --simple-colors-default-theme-yellow-2
          ) !important;
        }
        table {
          width: calc(100% - 2 * var(--editable-table-border-width, 1px));
          border-collapse: collapse;
          border-width: var(--editable-table-border-width, 1px);
          border-style: var(--editable-table-border-style, solid);
          border-color: var(--simple-colors-default-theme-grey-6, #999);
          font-weight: var(--editable-table-light-weight, 200);
          color: var(--simple-colors-default-theme-grey-10, #222);
          background-color: var(--simple-colors-default-theme-grey-1, #fff);
        }
        .th,
        .td {
          font-weight: var(--editable-table-light-weight, 200);
          color: var(--simple-colors-default-theme-grey-10, #222);
          background-color: var(--simple-colors-default-theme-grey-1, #fff);
        }
        caption {
          font-size: var(
            --editable-table-caption-font-size,
            var(--editable-table-font-size, unset)
          );
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(
            --editable-table-caption-color,
            var(--simple-colors-default-theme-grey-10, #222)
          );
          background-color: var(
            --editable-table-caption-bg-color,
            var(--simple-colors-default-theme-grey-1, #fff)
          );
          width: 100%;
        }
        .tr {
          display: table-row;
        }
        .th-or-td {
          display: table-cell;
        }
        .thead .th-or-td {
          height: 32px;
          padding: 0;
          margin: 0;
        }
        .thead-tr .th {
          background-color: var(--simple-colors-default-theme-grey-2, #e0e0e0);
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(--simple-colors-default-theme-grey-12, #000);
        }
        .tbody-tr .th {
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(--simple-colors-default-theme-grey-12, #000);
          background-color: var(--simple-colors-default-theme-grey-1, #fff);
          text-align: left;
        }
        table[bordered] .th,
        table[bordered] .td {
          border-width: var(--editable-table-border-width, 1px);
          border-style: var(--editable-table-border-style, solid);
          border-color: var(--simple-colors-default-theme-grey-6, #999);
        }
        table[condensed] {
          --editable-table-cell-vertical-padding: var(
            --editable-table-cell-vertical-padding-condensed,
            2px
          );
          --editable-table-cell-horizontal-padding: var(
            --editable-table-cell-horizontal-padding-condensed,
            4px
          );
        }
        table[striped] .tbody-tr:nth-child(2n + 1) .th-or-td {
          background-color: var(--simple-colors-default-theme-grey-2, #f0f0f0);
        }
        .tfoot-tr .th,
        .tfoot-tr .td {
          border-top: 2px solid var(--simple-colors-default-theme-grey-10, #222);
          font-weight: var(--editable-table-heavy-weight, 600);
          color: var(--simple-colors-default-theme-grey-12, #000);
        }
        caption,
        .th-or-td {
          text-align: left;
        }
        table[numeric-styles] .thead-tr .th-or-td[numeric],
        table[numeric-styles] .tfoot-tr .th-or-td[numeric],
        table[numeric-styles] .th-or-td[numeric] {
          text-align: center;
          font-size: 24px;
          font-family: sans-serif;
          --editable-table-cell-justify: flex-end;
        }
        table[numeric-styles] .tfoot-tr .th-or-td[negative],
        table[numeric-styles] .td[negative] {
          color: var(--simple-colors-default-theme-red-7, red);
          --editable-table-cell-color: var(
            --editable-table-negative-color,
            red
          );
        }

        caption > div {
          display: flex;
          align-items: flex-end;
          justify-content: space-between;
        }
        caption > div > *:not(:last-child) {
          padding: 0 0 5px;
        }
        #column {
          width: calc(var(--simple-picker-option-size) + 6px);
          overflow: visible;
          display: none;
          margin-left: 10px;
          --simple-picker-border-width: 1px;
          --simple-picker-focus-border-width: 1px;
          --simple-picker-border-color: var(
            --simple-colors-default-theme-grey-6,
            #999
          );
        }
        .th,
        .td {
          padding: 0;
        }
        .top-controls {
          background-color: var(--simple-colors-default-theme-accent-12);
          color: var(--simple-colors-default-theme-accent-1);
          height: 36px;
          vertical-align: middle;
          width: 100%;
          display: flex;
        }
        .top-controls .group {
          padding: 0 8px;
        }
        .top-controls .app-name {
          padding: 0 24px 0 16px;
        }
        .top-controls simple-icon-button-lite span {
          padding: 0 8px 0 0;
        }
        .top-controls .divider-left {
          border-left: 1px solid var(--simple-colors-default-theme-accent-1);
        }
        .top-controls .divider-right {
          border-right: 1px solid var(--simple-colors-default-theme-accent-1);
        }
      `]}renderSubmission(t){const s=parseInt(this.shadowRoot.querySelector("#studentgrid").getBoundingClientRect().height);this.shadowRoot.querySelector("#studentassessment").shadowRoot.querySelector("[part='content']").style.height=Math.round(globalThis.innerHeight-s-104)+"px";let i=e`<h3>${this.t.studentSubmission}</h3>
      ${this.t.submitted}
      <relative-time
        .datetime="${this.database.assignments[this.activeAssignment]._ISODueDate}"
      ></relative-time> `;return r(t)?(i=e`${i}<a
          href="${t}"
          target="_blank"
          rel="noopener noreferrer"
          ><simple-icon-button-lite
            label="${this.t.openInNewWindow}"
            icon="open-in-new"
          ></simple-icon-button-lite
        ></a>`,t!=l(t)?(import("../video-player/video-player.js"),e`${i}<video-player
            class="active-submission"
            source="${t}"
            width="60%"
          ></video-player>`):e`${i}
          <div class="active-submission">
            <iframe
              src="${t}"
              loading="lazy"
              width="100%"
              height="100%"
            ></iframe>
          </div>`):(import("../md-block/md-block.js"),e`${i}
        <div class="active-submission">
          <md-block .markdown="${t}"></md-block>
        </div>`)}studentLetterGradeHistoryClick(e){p.activeAssignment=parseInt(e.target.value),this.requestUpdate()}activateOption(e){let t=c(e);t[0].getAttribute("data-student")&&t[0].getAttribute("data-assignment")&&(p.activeAssignment=parseInt(t[0].getAttribute("data-assignment")),p.activeStudent=parseInt(t[0].getAttribute("data-student")),this.shadowRoot.querySelector("#studentgrid").style.height="140px",this.maintainScrollPosition())}mouseHighlight(e){let t=c(e)[0];clearTimeout(this.__mdebounce),this.__mdebounce=setTimeout((()=>{t&&t.getAttribute("data-assignment")!=this.__activeHoverAssignment&&(this.shadowRoot.querySelectorAll('#studentgrid .th-or-td[data-assignment="'+this.__activeHoverAssignment+'"]').forEach((e=>{e.classList.remove("col-highlight")})),this.__activeHoverAssignment=t.getAttribute("data-assignment"),this.shadowRoot.querySelectorAll('#studentgrid .th-or-td[data-assignment="'+this.__activeHoverAssignment+'"]').forEach((e=>{e.classList.add("col-highlight")})))}),10)}mouseLeave(e){clearTimeout(this.__mdebounce),this.__mdebounce=setTimeout((()=>{this.shadowRoot.querySelectorAll("#studentgrid .th-or-td").forEach((e=>{e.classList.remove("col-highlight")}))}),100)}settingChanged(e){e.stopPropagation(),e.stopImmediatePropagation(),e.preventDefault(),this.settings[e.detail.name]=e.detail.value,this.settings={...this.settings}}handleGridScaling(e){let t=c(e);"TABLE"===t[0].tagName&&(""!=t[0].style.height?t[0].style.height=null:t[0].style.height="90vh")}checkTabHeight(e){parseInt(this.shadowRoot.querySelector("#studentgrid").getBoundingClientRect().height)/globalThis.innerHeight>.65&&(this.shadowRoot.querySelector("#studentgrid").style.height=null)}studentreportClick(e){v.import("jspdf",new URL("./lib/grade-book.js",import.meta.url).href+"/../jspdf.min.js").then((()=>{var e=new jsPDF;e.fromHTML(this.shadowRoot.querySelector("#studentreport").outerHTML,15,15);const t=new Date,s=`${t.getFullYear()}-${t.getMonth()}-${t.getDate()}__${t.getHours()}-${t.getMinutes()}-${t.getSeconds()}`,i=`${this.database.roster[this.activeStudent].student}--${this.database.assignments[this.activeAssignment].shortName}--${s}.pdf`;e.save(i)}))}openWindow(e){this.__openWindow&&!this.__openWindow.closed?this.__openWindow.focus():(this.__openWindow=globalThis.open("","studentwork",`left=0,top=0,width=${screen.width/2},height=${screen.height/2},menubar=0,location=0,toolbar=0,status=0`),this.__openWindow.onbeforeunload=()=>{this.displayMode=0,this.__openWindow=null}),this.renderSubmissionInWindow()}renderSubmissionInWindow(){this.__openWindow&&2===this.displayMode&&(this.__openWindow.document.body.style.margin="0",s(e` ${this.database.assignments.length&&this.database.assignments[this.activeAssignment]?e`<grade-book-pop-up></grade-book-pop-up>`:e`${this.t.noSubmission}`}`,this.__openWindow.document.body))}render(){return e`
      <loading-indicator full ?loading="${this.loading}"></loading-indicator>
      <div class="top-controls">
        <div class="group divider-right app-name">
          <slot name="app-name"></slot>
        </div>
        <div class="group divider-right">
          ${this.renderActiveStudentBtn()}
          <simple-icon-button-lite
            @click="${this.changeStudent}"
            value="prev"
            title="${this.t.previousStudent}"
            ?disabled="${0===this.activeStudent||!this.ready}"
            icon="arrow-upward"
          >
            <span class="hide-900" value="prev">${this.t.previous}</span>
          </simple-icon-button-lite>
          <simple-icon-button-lite
            @click="${this.changeStudent}"
            value="next"
            title="${this.t.nextStudent}"
            icon="arrow-downward"
            ?disabled="${this.database.roster.length-1===this.activeStudent||!this.ready}"
          >
            <span class="hide-900" value="next">${this.t.next}</span>
          </simple-icon-button-lite>
        </div>
        <div class="group divider-right">
          ${this.renderActiveAssignmentBtn()}
          <simple-icon-button-lite
            @click="${this.changeAssignment}"
            value="prev"
            title="${this.t.previousAssignment}"
            icon="arrow-back"
            ?disabled="${0===this.activeAssignment||!this.ready}"
          >
            <span class="hide-900" value="prev">${this.t.previous}</span>
          </simple-icon-button-lite>
          <simple-icon-button-lite
            @click="${this.changeAssignment}"
            value="next"
            title="${this.t.nextAssignment}"
            ?disabled="${this.database.assignments.length-1===this.activeAssignment||!this.ready}"
            icon="arrow-forward"
          >
            <span class="hide-900" value="next">${this.t.next}</span>
          </simple-icon-button-lite>
        </div>
        <div class="group">${this.renderGradeScaleBtn()}</div>
        <div class="group">${this.renderSettingsBtn()}</div>
        ${this.ready&&"filesystem"===this.source&&this.sourceData?e`
              <div class="group">
                <simple-icon-button-lite
                  @click="${this.saveToFilesystem}"
                  title="${this.t.saveGradebook}"
                  ?disabled="${!this.sourceData}"
                  icon="save"
                >
                  <span class="hide-900">${this.t.saveGradebook}</span>
                </simple-icon-button-lite>
              </div>
            `:i}
      </div>
      <div ?hidden="${this.sourceData}" class="source-selection">
        <label>${this.t.selectGradebookSource}..</label>
        <select id="source" @change="${this.selectSource}">
          ${this.hasFilePicker?e`<option
                value="filesystem"
                ?selected="${"filesystem"===this.source}"
              >
                File system
              </option>`:i}
          <option
            value="googledocs"
            ?selected="${"googledocs"===this.source}"
          >
            Google docs
          </option>
          <option value="url">URL endpoint (JSON)</option>
          <option value="json">JSON data blob</option>
        </select>
        <simple-icon-button-lite
          @click="${this.loadFromSource}"
          title="${this.t.loadGradebook}"
          ?disabled="${this.sourceData}"
          icon="folder-shared"
        >
          <span class="hide-900">${this.t.loadGradebook}</span>
        </simple-icon-button-lite>
        ${"filesystem"==this.source&&this.prevLocalFileReference?e`
              <simple-icon-button-lite
                @click="${this.loadFromExistingSource}"
                title="${this.t.loadGradebook}"
                ?disabled="${this.sourceData}"
                icon="folder-shared"
              >
                <span class="hide-900"
                  >${this.t.load} ${this.prevLocalFileReference.name}</span
                >
              </simple-icon-button-lite>
            `:i}
        <input
          id="sourcedata"
          placeholder="${this.t.sourceData}"
          ?hidden="${!["googledocs","url"].includes(this.source)}"
        />
        <textarea
          id="sourcedatablob"
          rows="10"
          cols="40"
          placeholder="${this.t.pasteValidJSONHere}"
          ?hidden="${"json"!=this.source}"
        ></textarea>
      </div>
      ${"filesystem"===this.source&&this.loading?e`<p class="source-selection">${this.t.loadingFilePleaseWait}</p>`:i}
      <table
        id="studentgrid"
        @mousemove="${this.mouseHighlight}"
        @mouseleave="${this.mouseLeave}"
        @click="${this.activateOption}"
        @dblclick="${this.handleGridScaling}"
        bordered
        column-header
        condensed
        disable-responsive
        scroll
        striped
        numeric-styles
        sort
        ?hidden="${!(this.database.assignments&&this.database.assignments[this.activeAssignment])}"
      >
        ${this.database.roster.length&&this.database.assignments.length?e`
              <colgroup>
                <col />
              </colgroup>
              ${this.database.assignments.map(((t,s)=>e`<colgroup>
                    <col />
                  </colgroup>`))}
              <thead class="thead">
                <tr class="tr thead-tr" part="tr">
                  <th
                    class="th th-or-td student-table-label"
                    data-assignment="-1"
                  >
                    <div>
                      ${this.t.student} (${parseInt(this.activeStudent+1)} /
                      ${this.database.roster.length})
                    </div>
                  </th>
                  ${this.database.assignments.map(((t,s)=>e`<th
                        class="th th-or-td assignment-name"
                        title="${t.name}"
                        data-assignment="${s}"
                      >
                        <!-- @todo add once we support multi-select <simple-fields-field
                          data-assignment="${s}"
                          type="checkbox"
                          class="select-all"
                          title="Select all submissions ${t.shortName}"
                          name="select-all-submission"
                          aria-label="${t.shortName}"
                        ></simple-fields-field> -->
                        ${t.shortName}
                      </th>`))}
                </tr>
              </thead>
              <tbody class="tbody">
                ${this.database.roster.map(((t,s)=>e` <tr class="tr tbody-tr">
                      <th class="th th-or-td" data-assignment="-1">
                        <div class="user-info">
                          <div class="user-left">
                            ${this.settings.photo?e`${t.photo?e`<img
                                      src="${t.photo}"
                                      loading="lazy"
                                      class="user-photo"
                                    />`:e`<simple-icon-lite
                                      icon="social:person"
                                      class="user-photo"
                                    ></simple-icon-lite>`}`:i}
                          </div>
                          <div class="user-right">
                            ${this.settings.fname?e`<div>${t.student}</div>`:i}
                            ${this.settings.surname?e`<div>${t.student}</div>`:i}
                            ${this.settings.email?e`<div>
                                  <a href="mailto:${t.email}" target="_blank"
                                    >${t.email}</a
                                  >
                                </div>`:i}
                          </div>
                        </div>
                      </th>
                      ${this.database.assignments.map(((i,a)=>e` <td
                            class="td th-or-td"
                            numeric
                            data-student="${s}"
                            data-assignment="${a}"
                            ?data-active="${this.activeStudent===s&&this.activeAssignment===a}"
                          >
                            <button
                              aria-label="${t.student}'s assignement ${i.name}"
                              data-student="${s}"
                              data-assignment="${a}"
                            >
                              ${this.database.grades[s]&&this.database.grades[s][i.shortName]?e`${this.database.grades[s][i.shortName]}`:"-"}
                            </button>
                          </td>`))}
                    </tr>`))}
              </tbody>
            `:i}
      </table>
      <a11y-tabs
        id="studentassessment"
        full-width
        @click="${this.checkTabHeight}"
        @a11y-tabs-active-changed="${this.updateStudentReport}"
        ?hidden="${!(this.database.assignments&&this.database.assignments[this.activeAssignment])}"
      >
        <a11y-tab
          id="assessment"
          icon="assignment-ind"
          label="${this.t.activeAssessment}"
        >
          ${this.activeRubric[0]?e`
                <grid-plate
                  disable-responsive
                  layout="${this.displayModeData()[this.displayMode].layout}"
                >
                  <div slot="col-1" class="tag-group">
                    ${this.renderDisplayModeBtn()}
                    ${this.database.tags.categories.length>0?e`
                          <a11y-collapse-group heading-button>
                            ${this.database.tags.categories.map(((t,s)=>e`
                                <a11y-collapse>
                                  <div slot="heading">
                                    <simple-colors
                                      accent-color="${this.pickColor(s)}"
                                      ><span></span></simple-colors
                                    >${t}
                                  </div>
                                  <div slot="content">
                                    ${this.database.tags.data.filter((e=>e.category.includes(t))).map((t=>e`<simple-tag
                                            draggable="true"
                                            tabindex="0"
                                            @keypress="${this.keyDown}"
                                            @dragstart="${this.setDragTransfer}"
                                            accent-color="${this.pickColor(s)}"
                                            value="${t.term}"
                                            .data="${t}"
                                          ></simple-tag>`))}
                                  </div>
                                </a11y-collapse>
                              `))}
                          </a11y-collapse-group>
                        `:i}
                  </div>
                  <div slot="col-2">
                    <h3>${this.activeRubric[0].name}</h3>
                    ${this.activeRubric.map(((t,s)=>e`
                        ${this.renderRubricInfoBtn(s,t.criteria,t.description)}
                        <letter-grade-picker></letter-grade-picker>

                        <editable-table-display
                          accent-color="${this.accentColor}"
                          bordered
                          column-header
                          condensed
                          disable-responsive
                          scroll
                          striped
                        >
                          <table>
                            <tbody>
                              <tr>
                                ${t.qualitative.map((t=>e` <td>${t}</td> `))}
                              </tr>
                              <tr>
                                ${t.qualitative.map((s=>e`
                                    <td>
                                      <simple-fields-tag-list
                                        style="background-color:transparent;"
                                        data-criteria="${t.criteria}"
                                        label="${s}"
                                      ></simple-fields-tag-list>
                                    </td>
                                  `))}
                              </tr>
                            </tbody>
                          </table>
                        </editable-table-display>
                        <h4>Additional ${t.criteria} feedback</h4>
                        <simple-fields-field
                          type="textarea"
                          data-rubric-written
                          data-criteria="${t.criteria}"
                        ></simple-fields-field>
                      `))}
                    <div class="student-feedback-wrap">
                      <div class="student-feedback-text">
                        <h3 class="heading">Overall feedback</h3>
                        <simple-fields-field
                          type="textarea"
                          data-criteria="overall"
                          data-rubric-written
                        ></simple-fields-field>
                      </div>
                      <div class="student-feedback-score">
                        <simple-icon-button-lite
                          icon="${this.scoreLock?"lock":"lock-open"}"
                          @click="${this.toggleLock}"
                        ></simple-icon-button-lite>
                        <simple-fields-field
                          ?disabled="${this.scoreLock}"
                          type="number"
                          min="0"
                          id="totalpts"
                          maxlength="10"
                          @value-changed="${this.totalScoreChangedEvent}"
                        ></simple-fields-field>
                        /
                        ${this.database.assignments[this.activeAssignment].points}
                        pts
                        <letter-grade
                          style="margin:-8px 0 0 16px;"
                          total="${this.database.assignments[this.activeAssignment].points}"
                          score="${this.totalScore}"
                        ></letter-grade>
                      </div>
                    </div>
                  </div>
                  ${2!=this.displayMode?e`
                        <div slot="col-3">
                          ${this.database.assignments.length&&this.database.assignments[this.activeAssignment]?e`${this.activeSubmission?this.renderSubmission(this.activeSubmission):e`${this.t.noSubmission}`}`:i}
                        </div>
                      `:i}
                </grid-plate>
              `:i}
        </a11y-tab>
        <a11y-tab
          id="studentreporttab"
          icon="assignment"
          label="${this.t.studentReportView}"
        >
          <simple-icon-button-lite
            @click="${this.studentreportClick}"
            title="Download PDF"
            icon="image:picture-as-pdf"
          >
            <span class="hide-900" value="prev">Download PDF</span>
          </simple-icon-button-lite>
          <div id="studentreport">
            ${!this.loading&&this.database.assignments&&this.database.assignments[this.activeAssignment]?e`
                  <letter-grade
                    class="student-report-score"
                    show-scale
                    total="${this.database.assignments[this.activeAssignment].points}"
                    score="${this.totalScore}"
                  ></letter-grade>
                  <h2>Feedback report</h2>
                  <div class="student-report-wrap">
                    <a11y-collapse-group
                      heading-button
                      expanded
                      style="width:80%;"
                    >
                      ${this.database.rubrics.filter((e=>e.shortName==this.database.assignments[this.activeAssignment].rubric)).map((t=>e`
                            <a11y-collapse class="student-feedback-text">
                              <div slot="heading" class="heading">
                                <span style="font-size:20px;"
                                  >${t.criteria}</span
                                >
                              </div>
                              <div slot="content">
                                <div class="student-feedback-score-heading">
                                  <div>
                                    ${this.getCriteriaScore(t.criteria)} /
                                    ${Math.round(t.percentage/100*this.database.assignments[this.activeAssignment].points)}
                                  </div>
                                  <h3>Criteria details</h3>
                                </div>
                                <p>${t.description}</p>
                                <h3>Your feedback</h3>
                                <ul>
                                  ${t.qualitative.map((s=>e`
                                      <h4>${s}</h4>
                                      <ul>
                                        ${this.activeGrading[t.criteria]?e`${this.activeGrading[t.criteria][s].map((t=>e` <li>
                                                  <span>${t.term}</span
                                                  >${t.description?e` - ${t.description}`:""}
                                                  ${t.associatedMaterial?e`
                                                        <ul>
                                                          ${t.associatedMaterial.map((t=>e`
                                                              <li>
                                                                <a
                                                                  href="${t}"
                                                                  target="_blank"
                                                                  rel="noopener noreferrer"
                                                                  >${t}</a
                                                                >
                                                              </li>
                                                            `))}
                                                        </ul>
                                                      `:""}
                                                </li>`))}`:""}
                                      </ul>
                                    `))}
                                </ul>
                                <h3>Additional Criteria feedback</h3>
                                <p>
                                  ${this.getCriteriaFeedback(t.criteria)}
                                </p>
                              </div>
                            </a11y-collapse>
                          `))}
                      <a11y-collapse class="student-feedback-text">
                        <div slot="heading" class="heading">
                          <span style="font-size:20px;"
                            >${this.t.overallFeedback}</span
                          >
                        </div>
                        <div slot="content">
                          <p>${this.getCriteriaFeedback("overall")}</p>
                          <h2>Your total Score</h2>
                          <div class="score-display">
                            ${this.totalScore} /
                            ${this.database.assignments[this.activeAssignment].points}
                            pts
                          </div>
                        </div>
                      </a11y-collapse>
                    </a11y-collapse-group>
                  </div>
                `:i}
          </div>
        </a11y-tab>
      </a11y-tabs>
    `}selectSource(e){this.source=this.shadowRoot.querySelector("#source").value}loadFromSource(e){this.source=this.shadowRoot.querySelector("#source").value,"json"===this.source?this.sourceData=this.shadowRoot.querySelector("#sourcedatablob").value:"filesystem"==this.source?this.loadFromFilesystem():this.sourceData=this.shadowRoot.querySelector("#sourcedata").value}loadFromExistingSource(e){this.source=this.shadowRoot.querySelector("#source").value,this.loadFromFilesystem(!0)}loadFromFilesystem(e=!1){e?(this.loading=!0,setTimeout((()=>{f.processFile(this.prevLocalFileReference,"json"),this.sourceData=this.prevLocalFileReference}),0)):f.loadFile("xls").then((async e=>{this.loading=!0,await b("grade-book-prev-file",e),setTimeout((()=>{f.processFile(e,"json"),this.sourceData=e}),0)}))}async saveToFilesystem(e){const t=f.workbookFromJSON(this.database),s=new Blob([t],{type:"application/octet-stream"});(new FileReader).readAsDataURL(s),await f.saveFile("xlsx",t)}rubricCriteriaPointsChange(e){null!=e.detail.getAttribute("data-rubric-score")&&(clearTimeout(this.__debounce),this.__debounce=setTimeout((async()=>{this.loading||(this.updateTotalScore(),this.shadowRoot.querySelector("#totalpts").value=this.totalScore),this.scoreLock=!0}),0))}updateTotalScore(){let e=0,t=this.shadowRoot.querySelectorAll("#assessment simple-fields-field[type='number']:not(#totalpts)");for(var s in Array.from(t))t[s].value&&(e+=parseInt(t[s].value));this.totalScore=e,this.shadowRoot.querySelector("#totalpts").value=e,this.requestUpdate()}totalScoreChangedEvent(e){this.ready&&(e.stopPropagation(),e.stopImmediatePropagation(),e.preventDefault(),this.totalScore=e.detail.value,this.database.grades[this.activeStudent][this.database.assignments[this.activeAssignment].shortName]=this.totalScore,this.activeStudentSubmissions=[],this.activeStudentSubmissions=[...this.getStudentSubmissions(this.activeStudent)],this.requestUpdate())}toggleLock(e){this.scoreLock=!this.scoreLock}updateStudentReport(){this.requestUpdate()}getCriteriaScore(e){let t=this.shadowRoot.querySelectorAll("#assessment editable-table-display");for(var s in Array.from(t))if(t[s].shadowRoot.querySelector(`[data-rubric-score][data-criteria="${e}"]`))return t[s].shadowRoot.querySelector(`[data-rubric-score][data-criteria="${e}"]`).value;return 0}getCriteriaFeedback(e){return this.shadowRoot.querySelector(`#assessment [data-rubric-written][data-criteria="${e}"]`)?this.shadowRoot.querySelector(`#assessment [data-rubric-written][data-criteria="${e}"]`).value:""}qualitativeFeedbackUpdate(e){this.activeGrading[e.detail.getAttribute("data-criteria")]||(this.activeGrading[e.detail.getAttribute("data-criteria")]={}),this.activeGrading[e.detail.getAttribute("data-criteria")][e.detail.label]=e.detail.tagList,this.requestUpdate()}keyDown(e){e.key}pickColor(e){let t=Object.keys(this.colors);for(;e>t.length;)e-=t.length;return t[e]}_handleDragDrop(e){globalThis.dispatchEvent(new CustomEvent("simple-tag-drop",{detail:{value:"drop"}}))}setDragTransfer(e){globalThis.dispatchEvent(new CustomEvent("simple-tag-dragstart",{detail:{value:e.target}}));let t=e.target.data;t.color=e.target.accentColor,e.dataTransfer.setData("text",JSON.stringify(t))}static get tag(){return"grade-book"}}customElements.define(GradeBook.tag,GradeBook);export{GradeBook};globalThis.GradeBook=globalThis.GradeBook||{},globalThis.GradeBook.requestAvailability=()=>(globalThis.GradeBook.instance||(globalThis.document.querySelector("grade-book")?globalThis.GradeBook.instance=globalThis.document.querySelector("grade-book"):(globalThis.GradeBook.instance=globalThis.document.createElement("grade-book"),globalThis.document.body.appendChild(globalThis.GradeBook.instance))),globalThis.GradeBook.instance);