/**
 * Copyright 2021
 * @license MIT, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import{IntersectionObserverMixin as r}from"../intersection-element/lib/IntersectionObserverMixin.js";class GithubPreview extends(r(e)){static get properties(){let e={};return super.properties&&(e=super.properties),{...e,repo:{type:String},org:{type:String},__description:{type:String},repoLang:{type:String,attribute:"repo-lang",reflect:!0},__stars:{type:Number},__forks:{type:Number},__assetAvailable:{type:Boolean},extended:{type:Boolean,reflect:!0},readmeExtended:{type:Boolean,attribute:"readme-extended",reflect:!0},headers:{type:Object},viewMoreText:{type:String,attribute:"view-more-text"},notFoundText:{type:String,attribute:"not-found-text"},__readmeText:{type:String},branch:{type:String},url:{type:String},apiUrl:{type:String,attribute:"api-url"},rawUrl:{type:String,attribute:"raw-url"},readMe:{type:String,attribute:"read-me"}}}static get styles(){return[i`
        :host {
          display: inline-flex;
        }

        :host([hidden]) {
          display: none;
        }

        :host([repo-lang="JavaScript"]) .lang-circle {
          background-color: #f1e05a;
        }

        :host([repo-lang="C"]) .lang-circle {
          background-color: #555555;
        }

        :host([repo-lang="C#"]) .lang-circle {
          background-color: #178600;
        }

        :host([repo-lang="C++"]) .lang-circle {
          background-color: #f34b7d;
        }

        :host([repo-lang="CSS"]) .lang-circle {
          background-color: #563d7c;
        }

        :host([repo-lang="Dart"]) .lang-circle {
          background-color: #00b4ab;
        }

        :host([repo-lang="Go"]) .lang-circle {
          background-color: #00add8;
        }

        :host([repo-lang="Java"]) .lang-circle {
          background-color: #b07219;
        }

        :host([repo-lang="Kotlin"]) .lang-circle {
          background-color: #f18e33;
        }

        :host([repo-lang="Markdown"]) .lang-circle {
          background-color: #083fa1;
        }

        :host([repo-lang="Python"]) .lang-circle {
          background-color: #3572a5;
        }

        :host([repo-lang="Sass"]) .lang-circle {
          background-color: #a53b70;
        }

        :host([repo-lang="Scala"]) .lang-circle {
          background-color: #c22d40;
        }

        :host([repo-lang="SCSS"]) .lang-circle {
          background-color: #c6538c;
        }

        :host([repo-lang="Rust"]) .lang-circle {
          background-color: #dea584;
        }

        :host([repo-lang="Swift"]) .lang-circle {
          background-color: #ffac45;
        }

        :host([repo-lang="TypeScript"]) .lang-circle {
          background-color: #2b7489;
        }

        :host([repo-lang="Vue"]) .lang-circle {
          background-color: #2c3e50;
        }

        :host([repo-lang="PHP"]) .lang-circle {
          background-color: #4f5d95;
        }

        :host([repo-lang="HTML"]) .lang-circle {
          background-color: #e34c26;
        }

        :host([repo-lang="Lua"]) .lang-circle {
          background-color: #000080;
        }

        a {
          display: inline-flex;
          text-decoration: none;
          color: var(--github-preview-link-text-color, white);
        }

        :host([extended]) .container {
          width: var(--github-preview-container-width, 800px);
          padding: var(--github-preview-container-padding, 10px);
        }

        .container {
          background-color: var(--github-preview-bg-color, black);
          border-radius: var(--github-preview-container-border-radius, 10px);
          width: var(--github-preview-container-width, 400px);
          padding: var(--github-preview-container-padding, 5px);
        }

        @media screen and (max-width: 400px) {
          .container {
            width: var(--github-preview-container-width, 350px);
          }
        }

        .header-container {
          display: flex;
          align-items: center;
        }

        .header-container div {
          margin-left: 10px;
          font-size: var(--github-preview-header-font-size, 22px);
          font-weight: bold;
        }

        .header-container div a:hover {
          font-size: var(--github-preview-header-hover-font-size, 24px);
        }

        .stats-container {
          display: flex;
          align-items: center;
        }

        .lang-circle {
          height: 15px;
          width: 15px;
          background-color: grey;
          border-radius: 50%;
          margin: 0px 5px 0px 5px;
        }

        div {
          color: var(--github-preview-div-text-color, white);
        }

        .description {
          padding: 8px 0px 8px 0px;
        }

        .stats-text {
          margin: 0px 5px 0px 5px;
        }

        :host([readme-extended]) .readme-container {
          overflow-y: scroll;
        }

        .readme-container {
          overflow-y: hidden;
          overflow-x: hidden;
          max-height: var(--github-preview-readme-container-max-height, 300px);
        }

        .readme-btn {
          display: inline-block;
          padding: 0.3em 2em;
          border-radius: 2em;
          box-sizing: border-box;
          text-align: center;
        }

        .readme-btn-container {
          display: flex;
          justify-content: center;
        }
      `]}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Github Preview",description:"Accessible figure with long description",icon:"mdi-social:github-circle",color:"grey",tags:["Other","git","code","github","repo","organization"],handles:[{type:"github",type_exclusive:!0,repo:"repo",org:"org"}],meta:{author:"collinkleest",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"org",title:"Organization",description:"Github organization machine name",inputMethod:"textfield"},{property:"repo",title:"Repository",description:"Repo machine name",inputMethod:"textfield"},{property:"extended",title:"Extended View",description:"Includes readme in element",inputMethod:"boolean"}],advanced:[]},demoSchema:[{tag:"github-preview",properties:{org:"haxtheweb",repo:"webcomponents"},content:""}]}}get haxAppDetails(){return{details:{title:"Github",icon:"mdi-social:github-circle",color:"grey",description:"Preview a github repository.",status:"available",tags:["Other","git","code","github","repo","organization"]},connection:{protocol:"https",url:"api.github.com",data:{format:"json",origin:"*"},operations:{browse:{method:"GET",endPoint:"search/repositories",pagination:{style:"offset"},search:{q:{title:"Search",type:"string"}},data:{},resultMap:{image:"https://github.githubassets.com/images/modules/logos_page/GitHub-Mark.png",defaultGizmoType:"github",items:"items",preview:{title:"name",details:"description",id:"id"},gizmo:{id:"id",repo:"name",org:"owner.login"}}}}}}}static get tag(){return"github-preview"}render(){return this.__assetAvailable&&this.elementVisible?this.extended?t`
            <div class="container">
              <div class="header-container">
                <simple-icon-lite icon="book"></simple-icon-lite>
                <div>
                  <a
                    href="${this.url}/${this.org}"
                    target="_blank"
                    rel="noopener noreferrer"
                    @click="${this._clickLink}"
                  >
                    ${this.org}
                  </a>
                  /
                  <a
                    href="${this.url}/${this.org}/${this.repo}"
                    target="_blank"
                    rel="noopener noreferrer"
                    @click="${this._clickLink}"
                  >
                    ${this.repo}
                  </a>
                </div>
              </div>
              <hr />
              <div>${this.__description}</div>
              <hr />
              <div class="readme-container">
                <wc-markdown>
                  <script type="wc-content">
                    ${this.__readmeText}
                  </script>
                </wc-markdown>
              </div>
              <div class="readme-btn-container">
                <button @click=${this.readmeViewMoreHandler} class="readme-btn">
                  ${this.viewMoreText}
                </button>
              </div>
              <div class="stats-container">
                <span
                  class="lang-circle"
                  part="github-preview-lang-circle"
                ></span>
                <div class="stats-text">${this.repoLang}</div>
                <simple-icon-lite icon="star"></simple-icon-lite>
                <div class="stats-text">${this.__stars}</div>
                <simple-icon-lite icon="social:share"></simple-icon-lite>
                <div class="stats-text">${this.__forks}</div>
              </div>
            </div>
          `:t`
            <a
              href="${this.url}/${this.org}/${this.repo}"
              target="_blank"
              rel="noopener noreferrer"
              @click="${this._clickLink}"
            >
              <div class="container">
                <div class="header-container">
                  <simple-icon-lite icon="book"></simple-icon-lite>
                  <div>${this.repo}</div>
                </div>

                <div class="description">${this.__description}</div>

                <div class="stats-container">
                  <span class="lang-circle"></span>
                  <div class="stats-text">${this.repoLang}</div>
                  <simple-icon-lite icon="star"></simple-icon-lite>
                  <div class="stats-text">${this.__stars}</div>
                  <simple-icon-lite icon="social:share"></simple-icon-lite>
                  <div class="stats-text">${this.__forks}</div>
                </div>
              </div>
            </a>
          `:t`
          <div class="container">
            <h1>${this.notFoundText}</h1>
          </div>
        `}constructor(){super(),this.url="https://github.com",this.apiUrl="https://api.github.com",this.rawUrl="https://raw.githubusercontent.com",this.extended=!1,this.readMe="README.md",this.branch="master",this.viewMoreText="View More",this.notFoundText="Asset not found",this.headers={cache:"force-cache"}}fetchGithubData(e,t,i,r,o,a,n,s){s&&fetch(`${o}/${t}/${e}/${r}/${n}`,i).then((e=>{if(e.ok)return e.text()})).then((e=>{this.__readmeText!==e&&(this.__readmeText=e,this.wcmarkdown&&(this.wcmarkdown.value=this.__readmeText))})).catch((e=>{console.error(e)})),fetch(`${a}/repos/${t}/${e}`).then((e=>{if(e.ok)return e.json()})).then((e=>{this.handleResponse(e)})).catch((e=>{this.__assetAvailable=!1}))}readmeViewMoreHandler(e){this.readmeExtended=!0,this.shadowRoot.querySelector(".readme-btn").remove()}handleResponse(e){e&&(this.__assetAvailable=!0,this.__description=e.description,this.repoLang=e.language,this.__stars=e.stargazers_count,this.__forks=e.forks)}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged",gizmoRegistration:"haxgizmoRegistration"}}haxgizmoRegistration(e){e.validGizmoTypes.push("github"),0===e.appList.filter(((e,t)=>"api.github.com"===e.connection.url)).length&&globalThis.dispatchEvent(new CustomEvent("hax-register-app",{bubbles:!1,composed:!1,cancelable:!1,detail:this.haxAppDetails}))}haxactiveElementChanged(e,t){t&&(this._haxstate=t)}haxeditModeChanged(e){this._haxstate=e}_clickLink(e){this._haxstate&&(e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation())}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this.repo&&this.org&&this.url||(this.__assetAvailable=!1)}updated(e){e.forEach(((e,t)=>{["repo","org","headers","branch","rawUrl","apiUrl","readMe","extended"].includes(t)&&this[t]&&(clearTimeout(this.__debounce),this.__debounce=setTimeout((()=>{this.fetchGithubData(this.repo,this.org,this.headers,this.branch,this.rawUrl,this.apiUrl,this.readMe,this.extended)}),0)),this.extended&&"extended"===t&&import("./lib/wc-markdown.js"),this.elementVisible&&this.extended&&"elementVisible"===t&&(this.wcmarkdown=this.shadowRoot.querySelector("div > div.readme-container > wc-markdown"))}))}}customElements.define(GithubPreview.tag,GithubPreview);export{GithubPreview};