/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as r}from"../../../lit/index.js";import{FutureTerminalTextLiteSuper as a}from"./FutureTerminalTextSuper.js";class FutureTerminalTextLite extends(a(t)){static get styles(){let t=r``;return super.styles&&(t=super.styles),[t,r`
        :host {
          font-weight: bold;
          display: inline-flex;
          --flicker-easing: cubic-bezier(0.32, 0.32, 0, 0.92);
          --flicker-duration: 300ms;
          --fade-in-duration: 500ms;
        }
        span {
          color: var(--future-terminal-text-color, #5fa4a5);
          text-shadow: 0 0 4px var(--future-terminal-text-color, #5fa4a5);
          animation: flicker var(--flicker-duration) var(--flicker-easing);
        }
        :host([red]) span {
          color: #b35b5a;
          text-shadow: 0 0 4px #b35b5a;
        }
        :host([fadein]) span {
          animation:
            fade-in var(--fade-in-duration),
            flicker 300ms var(--flicker-easing)
              calc(var(--fade-in-duration) * 0.8);
          transform: translate(0, 0);
          opacity: 1;
        }
        @keyframes flicker {
          0% {
            opacity: 0.75;
          }
          50% {
            opacity: 0.45;
          }
          100% {
            opacity: 1;
          }
        }
        @keyframes fade-in {
          from {
            transform: translate(-30px, 0px);
            opacity: 0;
          }
        }
        @media (prefers-reduced-motion: reduce) {
          span {
            animation-duration: 0.01ms !important;
            animation-iteration-count: 1 !important;
            transition-duration: 0.01ms !important;
          }
        }
      `]}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"glitch"===e&&this[e]&&void 0!==t&&this._doGlitch()}))}render(){return e`<span part="text"><slot></slot></span>`}static get properties(){return{...super.properties,glitch:{type:Boolean},red:{type:Boolean,reflect:!0},fadein:{type:Boolean,reflect:!0},glitchMax:{type:Number,attribute:"glitch-max"},glitchDuration:{type:Number,attribute:"glitch-duration"}}}static get tag(){return"future-terminal-text-lite"}}customElements.define(FutureTerminalTextLite.tag,FutureTerminalTextLite);export{FutureTerminalTextLite};