/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";class FullWidthImage extends e{static get styles(){return[i`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }

        #image {
          left: 0;
          right: 0;
          position: relative;
          background-repeat: no-repeat;
          background-position: center center;
          background-size: cover;
          width: 100%;
          text-align: center;
        }

        .wrapper {
          opacity: 1;
          background-color: rgba(0, 0, 0, 0.6);
          padding: 100px;
          height: 100px;
          transition: 0.3s all ease-in-out;
        }

        .wrapper:hover {
          opacity: 0;
          background-color: transparent;
        }

        .caption {
          padding: 35px 0;
          font-size: var(--full-width-image-font-size, 25px);
          line-height: 40px;
          color: #fff;
          font-style: italic;
        }
      `]}render(){return t` <div id="image">
      <div class="wrapper">
        <div class="caption">
          ${this.caption}
          <slot></slot>
        </div>
      </div>
    </div>`}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}static get properties(){return{source:{type:String,reflect:!0},caption:{type:String,reflect:!0}}}static get tag(){return"full-width-image"}updated(e){e.forEach(((e,t)=>{"source"==t&&this._sourceChanged(this[t])}))}_sourceChanged(e){void 0!==e&&(this.shadowRoot.querySelector("#image").style.backgroundImage=`url("${e}")`)}}customElements.define("full-width-image",FullWidthImage);export{FullWidthImage};