import{html as t,css as i}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/lib/simple-icon-lite.js";import{SimpleColors as e}from"../../simple-colors/simple-colors.js";export class FlashCardPromptImg extends e{static get tag(){return"flash-card-image-prompt"}static get styles(){return i`
      :host {
        display: block;
        width: 320px;
        height: 265px;
      }

      img {
        display: flex;
        margin: 25px auto auto;
        height: 200px;
        width: 275px;
        border: 5px solid white;
        border-radius: 19px;
        box-shadow: 0 0 10px black;
      }

      .backgroundbox {
        display: flex;
        background-color: var(--simple-colors-default-theme-accent-4);
        border-radius: 19px 19px 0 0;
        height: 265px;
        width: 320px;
      }

      .overlay {
        position: relative;
      }

      .overlay::before {
        content: "";
        width: 100%;
        height: 100%;
        position: absolute;
        border: 1px;
        border-radius: 19px 19px 0px 0px;
      }

      simple-icon-lite {
        --simple-icon-height: 100px;
        --simple-icon-width: 100px;
        color: white;
        transform: translate(-50%, -190%);
        top: 50%;
        left: 50%;
        z-index: 100;
      }

      :host([status="pending"]) .overlay::before {
        display: flex;
        background: transparent;
      }

      :host([status="correct"]) .overlay::before {
        display: flex;
        background: green;
        filter: opacity(0.65);
      }

      :host([status="incorrect"]) .overlay::before {
        display: flex;
        background: red;
        filter: opacity(0.65);
      }
    `}constructor(){super(),this.imgSrc="",this.imgKeyword="grey box",this.status="pending",this.answerIcon=!1,this.icon=""}static get properties(){return{...super.properties,imgSrc:{type:String,reflect:!0,attribute:"img-src"},imgKeyword:{type:String,attribute:"img-keyword"},status:{type:String,reflect:!0},answerIcon:{type:Boolean,reflect:!0},icon:{type:String}}}updated(t){t.forEach(((t,i)=>{"status"===i&&"correct"===this[i]&&(this.answerIcon=!0,this.icon="check"),"status"===i&&"incorrect"===this[i]&&(this.answerIcon=!0,this.icon="cancel"),"status"===i&&"pending"===this[i]&&(this.answerIcon=!1)}))}render(){return t`
      <div>
        <div class="overlay">
          <div class="backgroundbox">
            ${""!==this.imgSrc?t`<img src="${this.imgSrc}" alt="" />`:t`<img
                  src="https://loremflickr.com/320/240/${this.imgKeyword}?lock=1"
                  alt=""
                />`}
          </div>
        </div>
        ${this.answerIcon?t`<simple-icon-lite icon="${this.icon}"></simple-icon-lite>`:""}
      </div>
    `}}customElements.define(FlashCardPromptImg.tag,FlashCardPromptImg);