import{I18NMixin as e}from"../../i18n-manager/lib/I18NMixin.js";import{html as t,css as s}from"../../../lit/index.js";import{SimpleColors as o}from"../../simple-colors/simple-colors.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icon-button-lite.js";import{DDD as i}from"../../d-d-d/d-d-d.js";export class FlashCardAnswerBox extends(e(i)){static get tag(){return"flash-card-answer-box"}constructor(){super(),this.back=!1,this.status="pending",this.correctAnswer="",this.showResult=!1,this.statusIcon="",this.sideToShow="front",this.userAnswer="",this.icon="",this.message="",this.t={yourAnswer:"Your answer",checkAnswer:"Check answer",retry:"Retry"},this.registerLocalization({context:this,localesPath:new URL("../locales/flash-card-answer-box.es.json",import.meta.url).href+"/../",locales:["es","fr","ja"]})}static get properties(){return{...super.properties,back:{type:Boolean,reflect:!0},sideToShow:{type:String,reflect:!0,attribute:"side-to-show"},userAnswer:{type:String,attribute:"user-answer"},status:{type:String,reflect:!0},showResult:{type:Boolean,attribute:"show-result",reflect:!0},statusIcon:{type:String,attribute:!1}}}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"status"===t&&void 0!==e&&this.dispatchEvent(new CustomEvent("flash-card-status-change",{detail:this.status,bubbles:!0})),"back"===t&&(this.sideToShow=this[t]?"back":"front")}))}equalsIgnoringCase(e){return 0===e.localeCompare(this.shadowRoot.querySelector("input").value,void 0,{sensitivity:"base"})}checkUserAnswer(){const e=this.back?"front":"back",t=this.shadowRoot.querySelector(`[name="${e}"]`).assignedNodes({flatten:!0})[0].querySelector(`[name="${e}"]`).assignedNodes({flatten:!0})[0].innerText;this.correct=this.equalsIgnoringCase(t),this.status=this.equalsIgnoringCase(t)?"correct":"incorrect",this.icon=this.equalsIgnoringCase(t)?"check":"cancel",this.message=this.equalsIgnoringCase(t)?"Correct!":"Incorrect!",this.showResult=!this.equalsIgnoringCase(t),this.correctAnswer=this.back?this.shadowRoot.querySelector('[name="front"]').assignedNodes({flatten:!0})[0].querySelector('[name="front"]').assignedNodes({flatten:!0})[0].innerText:this.shadowRoot.querySelector('[name="back"]').assignedNodes({flatten:!0})[0].querySelector('[name="back"]').assignedNodes({flatten:!0})[0].innerText,this.shadowRoot.querySelector("#check").disabled=!0,this.shadowRoot.querySelector("input").disabled=!0}inputChanged(e){this.userAnswer=e.target.value}resetCard(){this.showResult=!1,this.correct=!1,this.userAnswer="",this.status="pending",this.sideToShow=this.back?"back":"front",this.correctAnswer="",this.shadowRoot.querySelector("input").disabled=!1,this.shadowRoot.querySelector("input").value=""}static get styles(){return s`
      :host {
        display: flex;
        flex-direction: column;
        align-items: center;
      }
      .answer-section {
        display: flex;
        flex-direction: row;
        align-items: center;
        justify-content: space-between;
        width: 300px;
        height: 45px;
        border-radius: 20px;
        border: solid 1px var(--simple-colors-default-theme-accent-5);
        background-color: white;
        padding: 0;
      }
      .answer-section:focus-within {
        border-color: var(--simple-colors-default-theme-accent-6);
        box-shadow: 0 0 10px var(--simple-colors-default-theme-accent-6);
      }
      input {
        border: none;
        padding: 10px;
        font-size: 14px;
        height: 25px;
        border-radius: 19px 0 0 19px;
        margin: 0;
        width: 11em;
        background-color: white;
      }
      input:focus {
        outline: none;
      }
      button#check {
        background-color: var(--simple-colors-default-theme-accent-10);
        color: var(--ddd-theme-default-white);
        font-size: 14px;
        margin: none;
        padding: 0px;
        border-radius: 0 19px 19px 0;
        border: none;
        overflow: hidden;
        width: 50em;
        height: 45px;
      }
      .retry simple-icon-button-lite {
        color: red;
        --simple-icon-button-border-radius: none;
        --simple-icon-button-padding: 4px;
      }
      button:hover {
        opacity: 0.8;
      }
      button:disabled {
        opacity: 0.5;
        background-color: #dddddd;
        color: black;
      }
      p {
        font-family: Helvetica;
        color: var(--simple-colors-default-theme-accent-12);
        font-weight: normal;
        font-size: 20px;
        text-align: center;
      }
      :host([side-to-show="front"]) slot[name="back"] {
        display: none;
      }
      :host([side-to-show="back"]) slot[name="front"] {
        display: none;
      }
      :host([status="correct"]) .retry,
      :host([status="incorrect"]) .retry {
        display: flex;
      }

      :host([status="correct"]) #status-message {
        color: green;
      }

      :host([status="correct"]) #status-icon {
        color: green;
      }

      :host([status="incorrect"]) #status-message {
        color: red;
      }

      :host([status="incorrect"]) #status-icon {
        color: red;
      }

      simple-icon-lite {
        --simple-icon-width: 35px;
        --simple-icon-height: 35px;
        color: var(--simple-colors-default-theme-accent-10);
      }

      .sr-only {
        position: absolute;
        left: -10000px;
        top: auto;
        width: 1px;
        height: 1px;
        overflow: hidden;
      }

      .retry {
        display: none;
        width: 100%;
        justify-content: flex-end;
        padding-top: 10px;
      }

      #status-message {
        font-size: 16px;
        margin-right: 15px;
        display: flex;
        align-items: center;
        font-family: Helvetica;
      }

      #status-icon {
        --simple-icon-height: 25px;
        --simple-icon-width: 25px;
      }

      .answer-message {
        font-size: 10pt;
      }
    `}render(){return t`
      <div>
        <p id="question">
          <slot name="front" id="front"></slot>
          <slot name="back" id="back"></slot>
        </p>
        ${this.showResult||this.correct?t`<p class="answer-message">
              Correct Answer: ${this.correctAnswer}
            </p>`:""}
      </div>
      <div class="answer-section">
        <input
          id="answer"
          type="text"
          .placeholder="${this.t.yourAnswer}"
          @input="${this.inputChanged}"
          @keypress="${e=>"Enter"===e.key?this.checkUserAnswer():""}"
          .value="${this.userAnswer}"
        />
        ${"pending"===this.status?t`<button
              id="check"
              ?disabled="${""===this.userAnswer}"
              @click="${this.checkUserAnswer}"
            >
              ${this.t.checkAnswer}
            </button>`:t`<span id="status-message"
              ><simple-icon-lite
                id="status-icon"
                icon="${this.icon}"
              ></simple-icon-lite
              >${this.message}</span
            >`}
      </div>
      <div class="retry">
        <simple-icon-button-lite icon="refresh" @click="${this.resetCard}"
          >${this.t.retry}</simple-icon-button-lite
        >
      </div>
    `}}customElements.define(FlashCardAnswerBox.tag,FlashCardAnswerBox);