/**
 * Copyright 2024
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as s}from"../../lit/index.js";import{MarkTheWords as t}from"../mark-the-words/mark-the-words.js";class FillInTheBlanks extends t{static get tag(){return"fill-in-the-blanks"}renderDirections(){return e`<p>
      Read the sentance and type or select the answer at each input. Once you
      set all your answers you can press
      <strong>${this.t.checkAnswer}</strong> to test your answers. You will get
      feedback indicating correctness of your answer.
    </p>`}static get styles(){return[super.styles,s`
        simple-fields-field {
          display: inline-block;
          margin-bottom: 0;
          vertical-align: middle;
        }
        simple-fields-field[type="textfield"] {
          width: 140px;
          min-height: unset;
          padding: var(--ddd-spacing-1) var(--ddd-spacing-2);
        }
        simple-fields-field[type="select"] {
          width: 140px;
          min-height: unset;
          padding: var(--ddd-spacing-1) var(--ddd-spacing-2);
        }
      `]}isCorrect(){let e=!0;for(var s in this.numberCorrect=0,this.numberGuessed=0,this.answers){let e=this.shadowRoot.querySelector(`[data-answer-index="${s}"]`);if("object"==typeof this.answers[s].answer&&e&&void 0!==e.value&&""!==e.value)for(var t in this.numberGuessed++,this.answers[s].answer)e.value.toLowerCase().trim()===this.answers[s].answer[t].toLowerCase().trim()&&(this.answers[s].userGuessCorrect=!0,this.numberCorrect++);else e&&void 0!==e.value&&""!==e.value&&(this.numberGuessed++,e.value.toLowerCase().trim()===this.answers[s].answer.toLowerCase().trim()&&(this.answers[s].userGuessCorrect=!0,this.numberCorrect++))}return this.numberCorrect!==this.answers.length&&(e=!1),e}resetAnswer(e){if(this.isCorrect()){this.rebuildWordList(this.statement);let e=Array.from(this.shadowRoot.querySelectorAll("[data-answer-index]"));for(var s in e)e[s].value="",this.answers[s].userGuessCorrect=!1,e[s].selectedIndex&&(e[s].selectedIndex=0)}super.resetAnswer(e)}guessCount(){let e=0;for(var s in this.answers){let t=this.shadowRoot.querySelector(`[data-answer-index="${s}"]`);t&&t.value&&e++}return e}rebuildWordList(e){this.answers=[],this.wordList=[];const s=e.trim().split(/\s+/g),t=s.filter((e=>e.startsWith("[")&&e.endsWith("]")));for(var r in t){let e={text:t[r],userGuessCorrect:!1,correct:!0},s=t[r].replace("[","").replace("]","");s.split("~").length>1?e.answer=s.split("~"):s.split("|").length>1?(e.answer=s.split("|")[0],e.possible=s.split("|"),this.shuffleArray(e.possible)):e.answer=s,this.answers.push(e)}for(var r in s)this.wordList.push({text:s[r]});this.requestUpdate()}constructor(){super(),this.question="Fill in the blanks",this.isMarkTheWords=!1}updated(e){super.updated(e),this.shadowRoot&&this.statement&&e.has("statement")&&this.rebuildWordList(this.statement)}renderInteraction(){return e`<div class="text-wrap">
      <div class="text">
        ${this.wordList.map((s=>e`
            ${s.text.startsWith("[")&&s.text.endsWith("]")?this.renderFillInBlankField(s):e`${s.text} `}
          `))}
      </div>
    </div>`}shuffleArray(e){for(let s=e.length-1;s>0;s--){const t=Math.floor(Math.random()*(s+1));[e[s],e[t]]=[e[t],e[s]]}}refreshEvent(e){this.requestUpdate()}renderFillInBlankField(s){const t=this.answers.findIndex((e=>s.text===e.text));if(this.answers[t].possible){let s=[{text:"",value:""},...this.answers[t].possible.map((e=>({text:e,value:e})))];return e`<simple-fields-field
        data-answer-index="${t}"
        @value-changed="${this.refreshEvent}"
        type="select"
        .itemsList="${s}"
        ?disabled="${this.showAnswer}"
        class="tag-option ${this.showAnswer?this.answers[t].userGuessCorrect?"correct":"incorrect":""}"
      ></simple-fields-field>`}return e` <simple-fields-field
        type="textfield"
        @value-changed="${this.refreshEvent}"
        data-answer-index="${t}"
        ?disabled="${this.showAnswer}"
        class="tag-option ${this.showAnswer?this.answers[t].userGuessCorrect?"correct":"incorrect":""}"
      ></simple-fields-field>`}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}globalThis.customElements.define(FillInTheBlanks.tag,FillInTheBlanks);export{FillInTheBlanks};