/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
class FileSystemBroker extends HTMLElement{constructor(){super(),this.dirHandler=null,this.fileHandler=null,this.files=[]}static get tag(){return"file-system-broker"}async loadFile(e,t=!1,i=!0){let a,r=this.typeToAccept(e),l=`${e} file`;return[a]=await globalThis.showOpenFilePicker({types:[{description:l,accept:r}],excludeAcceptAllOption:i,multiple:t}),this.fileHandler=await a.getFile(),this.fileHandler}async getFileContents(e,t=!1,i=!0){return await this.loadFile(e,t,i),await this.fileHandler.text()}typeToAccept(e){let t={};switch(e){case"html":t={"text/html":[".html",".htm"]};break;case"xls":case"xlsx":case"ods":t={"text/csv":[".csv"],"application/*":[".xls",".xlsx",".ods"]};break;case"zip":t={"application/zip":[".zip",".gz",".tar",".tar.gz"]};break;case"csv":t={"text/*":[".csv",".txt"]};break;case"image":t={"image/*":[".jpg",".jpeg",".gif",".png"]};break;case"video":t={"video/*":[".mp4"]};break;case"markdown":t={"text/*":[".txt",".md"]}}return t}async saveFile(e,t){const i={types:[{description:`Save ${e} file`,accept:this.typeToAccept(e)}]};this.fileHandler=await globalThis.showSaveFilePicker(i);const a=await this.fileHandler.createWritable();await a.write(t),await a.close()}async openDir(e=!0,t={}){try{this.dirHandler=await globalThis.showDirectoryPicker(t)}catch(e){console.warn(e)}return this.files=[],this.files=await this.__readDir(this.dirHandler,e,this.dirHandler.name||"",this.dirHandler),this.files}async readFileInDir(e,t={}){try{this.dirHandler=await globalThis.showDirectoryPicker(t);for await(const t of this.dirHandler.values())if(e&&"function"==typeof t.getFile&&t.name===e){const e=await t.getFile();return await e.text()}}catch(e){console.warn(e)}return""}async writeFileInDir(e,t="",i={}){try{this.dirHandler=await globalThis.showDirectoryPicker(i);for await(const i of this.dirHandler.values())if(e&&"function"==typeof i.getFile&&i.name===e){var a=await this.dirHandler.getFileHandle(i.name);const e=await a.createWritable();return await e.write(t),await e.close(),!0}}catch(e){console.warn(e)}return!1}async __readDir(e,t,i,a){const r=[];for await(let[l,s]of e){const{kind:e}=s;"directory"===s.kind?(r.push({name:l,kind:e,handle:s,folder:i,parentHandler:a}),".git"!==l&&t&&r.push(...await this.__readDir(s,t,i+"/"+l,s))):r.push({name:l,kind:e,handle:s,folder:i,parentHandler:a})}return r}}globalThis.FileSystemBroker=globalThis.FileSystemBroker||{},globalThis.FileSystemBroker.requestAvailability=()=>(!globalThis.FileSystemBroker.instance&&globalThis.document&&globalThis.document.body&&(globalThis.FileSystemBroker.instance=globalThis.document.createElement("file-system-broker"),globalThis.document.body.appendChild(globalThis.FileSystemBroker.instance)),globalThis.FileSystemBroker.instance);const e=globalThis.FileSystemBroker.requestAvailability();customElements.define(FileSystemBroker.tag,FileSystemBroker);export{FileSystemBroker,e as FileSystemBrokerSingleton};