/**
 * Copyright 2019 PSU
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{DDD as d}from"../d-d-d/d-d-d.js";class FigureLabel extends d{static get styles(){return[super.styles,t`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }

        #wrap {
          display: flex;
          margin-bottom: var(--ddd-spacing-4);
        }

        #title {
          display: flex;
          align-items: center;
          font-family: var(--ddd-font-primary);
          background-color: var(
            --ddd-component-figure-label-title,
            var(
              --ddd-theme-accent,
              var(
                --simple-colors-default-theme-accent-2,
                var(--ddd-theme-default-limestoneLight)
              )
            )
          );
          color: var(
            --ddd-component-figure-label-title-text,
            var(
              --ddd-theme-primary,
              var(
                --simple-colors-default-theme-accent-11,
                var(--ddd-theme-default-potentialMidnight)
              )
            )
          );
          font-size: var(--ddd-font-size-4xs);
          padding: var(--ddd-spacing-3);
          font-weight: var(--ddd-font-weight-bold);
        }

        #description {
          display: flex;
          align-items: center;
          font-family: var(--ddd-font-primary);
          border: var(--ddd-border-sm);
          border-color: var(
            --ddd-component-figure-label-title,
            var(
              --ddd-theme-accent,
              var(
                --simple-colors-default-theme-accent-2,
                var(--ddd-theme-default-limestoneLight)
              )
            )
          );
          border-left: none;
          padding: var(--ddd-spacing-2);
          font-size: var(--ddd-font-size-4xs);
          background-color: var(
            --ddd-component-figure-label-description-background,
            var(--ddd-theme-default-white)
          );
          color: var(
            --ddd-component-figure-label-description-text,
            var(
              --simple-colors-default-theme-accent-11,
              var(--ddd-theme-default-potentialMidnight)
            )
          );
          font-weight: var(--ddd-font-weight-regular);
        }
      `]}render(){return e`<div id="wrap">
      <div id="title">${this.title}</div>
      <div id="description">${this.description}</div>
    </div>`}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Figure label",description:"Figure label element to mark media assets within content.",icon:"icons:android",color:"green",tags:["content","figure","a11y","accessibility","image","caption","description"],meta:{author:"HAXTheWeb core team",owner:"PSU"}},settings:{configure:[{property:"title",description:"",inputMethod:"textfield",required:!1,icon:"icons:android"},{property:"description",description:"",inputMethod:"textfield",required:!1,icon:"icons:android"}],advanced:[]}}}static get properties(){return{...super.properties,title:{type:String},description:{type:String}}}static get tag(){return"figure-label"}}customElements.define(FigureLabel.tag,FigureLabel);export{FigureLabel};