/**
 * Copyright 2023 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{css as A,svg as a}from"../../lit/index.js";import{SimpleColors as t}from"../simple-colors/simple-colors.js";class EventBadge extends t{static get tag(){return"event-badge"}constructor(){super(),this.title="haxor",this.name="bto.pro",this.position="1337 dev",this.organization="Penn State",this.image="https://avatars1.githubusercontent.com/u/329735?s=400&v=4",this.tvcolor="light-blue",this.accentColor="blue",this.knobcolor="purple",this.logo=null,this.sepia=!1,this.blackwhite=!1}static get properties(){return{...super.properties,title:{type:String},image:{type:String},name:{type:String},position:{type:String},logo:{type:String},organization:{type:String},tvcolor:{type:String},knobcolor:{type:String},sepia:{type:Boolean,reflect:!0},blackwhite:{type:Boolean,reflect:!0}}}static get styles(){return[super.styles,A`
        :host {
          display: inline-flex;
        }
        :host([sepia]) {
          filter: sepia(1);
        }
        :host([blackwhite]) {
          filter: grayscale(1);
        }
        .container,
        .wrapper {
          display: flex;
        }
      `]}render(){return a`
      <div class="wrapper">
      
      <div class="container">
      
      <svg width="300" height="400" id="remix-this" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 1150 1500"><defs><style></style> 
            <filter id="dropshadow" x="0" y="0" width="200%" height="200%">
              <feOffset result="offOut" in="SourceAlpha" dx="3" dy="3"></feOffset>
             <feGaussianBlur result="blurOut" in="offOut" stdDeviation="3"></feGaussianBlur>
              <feBlend in="SourceGraphic" in2="blurOut" mode="normal"></feBlend></filter> 
              <filter id="noise" y="0" x="0">
                <feTurbulence stitchTiles="stitch" baseFrequency="1.5" type="fractalNoise"></feTurbulence>
              </filter>
             <pattern id="plasticpattern" patternUnits="userSpaceOnUse" height="100" width="100" y="0" x="0"><rect x="0" y="0" width="100%" height="100%" fill="transparent" class="bg"></rect> <rect x="0" y="0" width="100%" height="100%" filter="url(#noise)" opacity=".75" class="opacity"></rect></pattern> 
             <filter id="lighting"><feGaussianBlur stdDeviation="10" result="blur3"></feGaussianBlur> <feSpecularLighting result="spec3" in="blur3" specularConstant="1.2" specularExponent="7" lighting-color="#FFF"><feSpotLight x="3000" y="3000" z="300" limitingConeAngle="9"></feSpotLight></feSpecularLighting> <feComposite in="SourceGraphic" in2="spec3" operator="arithmetic" k1="0" k2="1" k3="1" k4="0"></feComposite></filter> 
             <clipPath id="clip-path"><path d="M1093.365,40H56.636a23.3,23.3,0,0,0-23.3,23.295V1436.706a23.3,23.3,0,0,0,23.3,23.3H1093.365a23.3,23.3,0,0,0,23.3-23.3V63.294A23.3,23.3,0,0,0,1093.365,40ZM571.754,163.356a28.289,28.289,0,1,1,28.288-28.288A28.288,28.288,0,0,1,571.754,163.356Z" fill="none"></path></clipPath> 
             <clipPath id="tv-clip-path"><path d="M198.6,445.5l19.5-2.4l192.9-8.4h215.2l154.1,11c0,0,37.4-0.5,39.5,8.2c2.2,8.8,7.2,31.8,7.2,31.8v124.8l-5,179.2l-0.2,96.3c0,0-9.9,51.2-42.9,55S559,934.8,559,934.8l-157,1l-118,2h-90c0,0-36.8-3.2-41.4-37.6c-4.6-34.4-5.3-50.7-5.3-50.7v-64.3l5.3-92.6l3.4-84.8l0.7-96.8l9.4-44.2c0,0,8.8-16.3,13.8-19.1C185,444.8,198.6,445.5,198.6,445.5z"></path></clipPath></defs>
        <g style="isolation:isolate;">
        <g  data-name="Layer 1" filter="url(#dropshadow)">
        <g clip-path="url(#clip-path)"><rect id="main_shadow" x="0" y="0" width="100%" height="100%" fill="#000000"></rect></g></g> 
        <g data-name="Layer 1"><rect id="main_background" data-name="main background" x="-0.018" y="-2.766" width="1150.018" height="1506.952" fill="#ffffff00"></rect> 
        <g clip-path="url(#clip-path)"><rect id="main_background_fallback" x="-0.018" y="-2.766" width="1150.018" height="1506.952" fill="#fff"></rect> 
        <g id="TV"><g data-name="photo"><g clip-path="url(#tv-clip-path)">
        <g id="bgImage">
        <g filter=""><g transform="translate(244 443) translate(250 250) scale(1.45) translate(-250 -250) translate(250 250) rotate(0) translate(-250 -250)" ><image width="500" height="500" href= ${this.image} ></image></g></g></g></g></g> 
        <path id="card_background" data-name="card background" d="M1131.044-31.118H23.479v1554.7H1131.045C1131.045,1133.345,1131.045,359.121,1131.044-31.118Zm-60.1,494.835c-.247,2.829-.428,5.671-.477,8.51-.185,10.687-1.039,21.321-2.046,31.958a138.432,138.432,0,0,0-.368,16.248c.442,18.838.614,37.688-.175,56.5-.551,13.138.058,26.276-.684,39.4-1.018,18,.058,36.048-.907,54.034-1.015,18.936-1.385,37.867-1.678,56.82-.189,12.178.145,24.406-.825,36.534-.816,10.2.28,20.282.577,30.4.27,9.2.154,18.417.7,27.6,1.059,17.742.428,35.492.412,53.235a231.959,231.959,0,0,1-1.955,27.492c-.438,3.633-.321,7.282-.8,10.923-1.135,8.708-2.1,17.446-2.821,26.2-.538,6.571-.665,13.181-.821,19.777a225.652,225.652,0,0,1-2.177,22.972,15.975,15.975,0,0,1-3.645,8.024,44.282,44.282,0,0,1-12.565,10.778,15.177,15.177,0,0,1-10.427,2.153c-4.964-.8-9.972.439-14.975.486-4.471.042-8.942.179-13.414.2-1.683.007-3.2.1-4.322,1.644a5.412,5.412,0,0,1-1.914,1.475c-10.115,5.163-20.012,10.865-31.241,13.412-9.527,2.161-19.133,3.754-28.96,2.76-9.947-1.006-19.943-1.261-29.907-2.074-14.98-1.222-30.027-1.141-45.061-1.245a183.288,183.288,0,0,1-20.62-1.2c-2.411-.29-4.872-.144-7.31-.223-8.924-.286-17.837-.808-26.77-.992-9.994-.205-19.976-.964-29.964-1.45-7.43-.361-14.865-.653-22.293-1-18.116-.854-36.238-1.235-54.364-1.693-12.589-.319-25.175-.757-37.763-.615-12.873.144-25.731-.435-38.566-1.009-16.121-.721-32.243-.73-48.327-.268-16.26.466-32.507.128-48.756.4-8.4.142-16.823-.141-25.206.317-8.792.481-17.6.244-26.367.834-9.067.61-18.13.429-27.187.769-11.5.432-23.023.221-34.5.865-10.694.6-21.377.723-32.069.683-16.391-.061-32.768,1.148-49.157.571-8.251-.291-16.5-.863-24.751-.5-9.195.4-18.384.916-27.59.754-12.723-.225-25.439-1.377-38.163-.744-9.2.459-18.4.494-27.6.535-11.385.051-22.631-1.58-33.91-2.8-3.757-.407-7.569-.2-11.282-1.138-4.095-1.035-7.676-2.75-9.559-6.811a4.181,4.181,0,0,0-3.4-2.407c-3.726-.8-7.525-.634-11.276-1.134-4.261-.569-8.6-.839-12.924-1.045-5.922-.281-11.895-.487-17.736-1.647-6.493-1.289-11.129-5.051-14.453-10.818a55.144,55.144,0,0,1-7.193-28.394c.1-12.78-1.3-25.365-2.915-37.979a91.83,91.83,0,0,1-.453-11.357c-.046-15.186-.261-30.377.038-45.557.44-22.366.1-44.731-.227-67.082-.24-16.527-.447-33.056-.257-49.574.118-10.284.669-20.581.366-30.86-.56-18.966-.246-37.934-.555-56.9-.185-11.387-.189-22.77-.167-34.153.031-15.715-.648-31.413-.818-47.122-.014-1.325-.319-2.711.787-4.587,1.59,4.835,2.578,9.228,5.612,12.578a.8.8,0,0,0,.812-.881c-.183-7.994-.439-15.987-.565-23.981-.222-14.092-1.257-28.182-.638-42.272,1.185-26.962.117-53.96,1.455-80.913.37-7.441,1.125-14.863,1.714-22.293a14.078,14.078,0,0,0-.659-5.563c-1.491-4.66-.264-9.419.154-14.111.226-2.537.362-5.136,1.34-7.388-1.473-2.625-4.194-2.695-6.249-3.8,1.309-7.365,10.344-13.214,15.224-13.372a4.3,4.3,0,0,1,2.01.07c3.016,1.678,5.963.428,8.933-.042a88,88,0,0,1,10.484-1.153c22.887-.843,45.785-.843,68.683-.8,7.723.014,15.469-.148,23.164.369,6.911.465,13.805.28,20.705.436,3.66.084,7.259-.768,10.937-.558,13.8.786,27.619.559,41.426.9q15.813.395,31.6,1.613c16.246,1.229,32.5.62,48.756.726,10.977.071,21.975.218,32.929-.341,15.042-.767,30.076-.155,45.109-.452,2.7-.054,5.405-.243,8.433-.384.139-1.421.32-2.829.522-4.23-.016-.312-.047-.617-.047-.936,0,.319.031.624.047.936A106.406,106.406,0,0,1,472.3,331.34c-3.692-2.3-6.986-4.369-10.287-6.421-19.132-11.892-36.9-25.667-54.56-39.585-15.748-12.415-32-24.137-48.372-35.689C341.152,237,323.392,224.1,305,212.121q-20.786-13.536-40.189-28.969a66.246,66.246,0,0,1-6.2-5.853c-1.233-1.27-2.528-2.1-4.3-1.551-2.282.705-4.284-.115-6.205-1.093a177.625,177.625,0,0,1-17.762-10.64c-3.09-2.057-2.993-2.817-1.117-6.137,1.865-3.3,2.836-7,4.165-10.545.38-1.015.664-2.067,1.075-3.068,1.621-3.954,4.241-5.012,7.636-2.536,6.375,4.649,13.381,8.2,20.118,12.227.925.552,1.9,1.023,2.874,1.488,3.767,1.8,4.258,3.408,2.107,6.93a16.345,16.345,0,0,0-.682,1.551c.356.209.834.462,1.285.756,9.3,6.061,18.462,12.355,27.936,18.133,12.017,7.329,24.317,14.191,36.443,21.341,20.907,12.328,40.733,26.284,60.542,40.269,18.369,12.968,36.958,25.593,56.374,36.987,9.1,5.343,17.793,11.394,26.695,17.084,3.467,2.215,6.209,5.219,9.127,8.045,1.141,1.1,2.009,2.581,3.788,3.1a10.617,10.617,0,0,0,3.811-2.846,80.809,80.809,0,0,1,27.747-17.256,145.762,145.762,0,0,1,36.986-8.939c17.855-1.846,34.663,1.883,50.94,8.895a90.077,90.077,0,0,1,21.473,13c1.981,1.618,3.531,1.728,5.769.381q21.748-13.089,43.653-25.922c47.325-27.7,94.142-56.251,141.6-83.725,25.544-14.787,50.768-30.121,76.035-45.38,11.7-7.065,23.725-13.588,35.609-20.346a7.587,7.587,0,0,0,2.7-1.824c-.089-1.575-1.187-2.7-1.728-4.047-1.164-2.892-.725-4.8,1.96-6.1a141.843,141.843,0,0,0,18.45-11.021c3.613-2.484,7.057-2.791,11.338-.614,8.764,4.456,8.646,7.838,6.7,15.7a9.9,9.9,0,0,1-5.967,7.2,135.94,135.94,0,0,0-12.579,5.649c-1.548.857-2.989,1.583-3.47,3.617-.394,1.667-1.97,3.084-3.613,2.676-2.348-.583-3.852.38-5.5,1.582a3.183,3.183,0,0,1-2.223.712c-1.556-.566-.561-2.312-1.537-3.115-.4-.373-.795-.114-1.09.1q-6.378,4.689-12.729,9.417c-29.147,21.632-58.336,43.2-88.46,63.476q-31.188,20.989-62.193,42.247c-26.275,17.976-52.512,36.006-78.941,53.758-11.919,8.006-23.711,16.189-36.21,23.288-.693.393-1.339.869-2.271,1.48,5.148,10.683,10.386,21.276,9.64,33.416,1.342,1.073,2.751.657,4.053.66,15.041.032,30.085.2,45.123-.04,10.679-.169,21.359-.757,32.022-1.415,14.891-.919,29.8-.85,44.689-.6,11.9.195,23.79.9,35.672,1.595,10.533.616,21.062,1.241,31.607,1.618,11.9.425,23.794.9,35.673,1.637,15,.929,30.011,1.276,45.029,1.691,9.2.255,18.412.309,27.6.78,10.558.541,21.125.317,31.668.822,7.3.35,14.605.76,21.907.668,7.436-.094,14.883.057,22.313-.686,4.608-.461,8.721,1.7,12.821,3.353,7.016,2.821,11.131,8.16,13.044,15.514,2.583,9.926,3.028,19.9,2.353,30.1-.389,5.895.212,11.889.755,17.8A140.317,140.317,0,0,1,1070.947,463.717Z" fill="var(--simple-colors-default-theme-accent-1)"></path> <g id="testcard-bottom">
        <path d="M18.254,1431.005c-.083-19.348-.89-38.486-.353-57.633.011-.39.362-.771.561-1.17,1.087-1.031,2.48-.8,3.776-.793,8.468.05,16.933-.166,25.4.452a118.221,118.221,0,0,0,15.372.135c17.156-.987,34.322-.5,51.484-.6,13.152-.076,26.306-.113,39.458.032,5.532.061,11.059.638,16.885,1,1.118,6.848.372,13.493.453,20.1.084,6.909-.049,13.821-.1,20.732-.053,6.663-.127,13.325-.187,19.483-1.758,2.337-3.788,2.441-5.794,2.488-4.9.114-9.806.235-14.71.233-39.905-.009-79.806-.341-119.7-1.221C26.52,1434.15,22.364,1433.85,18.254,1431.005Z" fill="#0000bf"></path> 
        <path d="M810.733,1434.918c-6.114-.911-11.22-.647-16.319-.654q-62.853-.09-125.706-.185c-3.318-.006-6.635-.3-9.837-.449-1.744-2.189-1.449-4.553-1.474-6.65-.213-17.826-.269-35.653-.348-53.48a4.552,4.552,0,0,1,.444-1.311c1.675-1.459,3.772-.856,5.7-.863,14.933-.055,29.866-.033,44.8-.033q47.808,0,95.617.022c2.4,0,4.869-.4,7.562.574,1.077,6.83.341,13.706.474,20.539.14,7.13.132,14.265.02,21.4C811.557,1420.639,812.258,1427.521,810.733,1434.918Z" fill="#00bfbf"></path> 
        <path d="M337.487,1371.814a21.43,21.43,0,0,1,2.95-.457c50.1-.019,100.192-.017,149.848-.017,1.872,1.508,1.59,3.154,1.591,4.672q.014,24.72-.05,49.441c-.012,2.865.087,5.789-1.16,8.875-50.605-.085-101.26.35-152.351-.4-1.023-5.258-.943-10.322-1-15.37-.057-5.345-.08-10.69-.108-16.035-.027-5.122-.1-10.245-.042-15.366C337.231,1382.1,336.786,1377.013,337.487,1371.814Z" fill="#bf00bf"></path> 
        <path d="M976.779,1372.127a12.536,12.536,0,0,1,2.6-.765c50.31-.025,100.62-.023,150.52-.023,1.746,1.152,1.6,2.553,1.6,3.865q0,26.718-.05,53.437c0,1.948.369,4.065-1.707,5.9-3.187-.091-6.691-.275-10.194-.277q-59.115-.037-118.23-.04c-6.456,0-12.912-.185-19.368-.291-1.318-.022-2.687.155-4.327-1.323C976.332,1412.915,976.974,1392.7,976.779,1372.127Z" fill="#bfbfbf"></path> <path d="M178.708,1433.539c-1.26-5.72-2.082-36.664-1.511-57.209.043-1.535-.2-3.148.989-4.432,5.7-.725,147.625-.713,152.744.013a2.406,2.406,0,0,1,.5.441,1.385,1.385,0,0,1,.183.637c.09,1.551.234,3.1.229,4.653q-.089,27.054-.237,54.107a7.984,7.984,0,0,1-.391,1.781,3.285,3.285,0,0,1-3.072,1.174c-2.65-.238-5.315-.434-7.974-.436q-56.448-.039-112.9-.027c-9.125-.006-18.249-.128-27.373-.226A3.622,3.622,0,0,1,178.708,1433.539Z"></path> 
        <path d="M650.921,1371.917a7.253,7.253,0,0,1,.575,1.917q.012,28.753-.062,57.508a18.064,18.064,0,0,1-.549,2.929c-50.828.056-101.514.324-151.727-.3a3.646,3.646,0,0,1-1.468-3.389q-.26-27.75-.494-55.5a4.142,4.142,0,0,1,.984-3.247,6.336,6.336,0,0,1,1.719-.458q74.562-.045,149.125-.016A7.264,7.264,0,0,1,650.921,1371.917Z"></path> 
        <path d="M970.749,1371.542c.864,6.116,1.169,40.625.576,57.339-.054,1.522.217,3.123-1.129,4.88-1.97.715-4.427.461-6.823.464q-51.125.065-102.248.063c-11.361,0-22.722-.112-34.082-.231-2.865-.03-5.728-.284-7.938-.4a3.645,3.645,0,0,1-1.672-3.464q-.18-28.067-.315-56.132a7.56,7.56,0,0,1,.4-1.789c1.168-1.2,2.566-.96,3.867-.961q72.845-.024,145.688-.007C968.164,1371.3,969.249,1371.441,970.749,1371.542Z"></path></g> 
        
        <g id="testcard-top">
        <path d="M809.494,254.982c-3.3-1.252-6.637-1.056-9.958-1.021-36.1.385-72.192.484-108.288.008-8.464-.112-16.925-.394-25.388-.615-3.281-.086-3.28-.108-6.7,2.287-1.362-1.86-1.5-3.919-1.548-6.134-1.128-49.456-.612-98.92-.6-148.379q.042-144.055.409-288.11c.046-22.727.382-45.453.577-68.18.018-2,.008-4.011-.041-6.015-.054-2.179-1.286-4.849.7-6.348,2.707-2.047,4.977-4.868,9.067-4.912,9.576-.1,19.145-.753,28.721-.98,18.265-.433,36.533-.736,54.8-1.073,12.475-.229,24.949-.536,37.425-.583,5.333-.02,10.677.425,16,.858,4.8.391,5.834,1.528,5.95,6.177.094,3.786-.018,7.576,0,11.363.311,55.927.813,111.853.9,167.78q.263,160.433.149,320.864,0,8.021-.175,16.041C811.455,250.2,811.655,252.487,809.494,254.982Z" fill="#bf00bf"></path> 
        <path d="M489.763,255.023c-3.533-1.37-7.09-1.09-10.625-1.053-35.872.379-71.744.468-107.616,0-8.464-.11-16.926-.377-25.387-.622-2.436-.071-4.953-.578-6.214,3.043a10.455,10.455,0,0,1-2.158-6.842c-.155-26.064-.528-52.129-.513-78.193q.111-184.155.413-368.312c.029-19.607.347-39.213.524-58.82.016-1.782.009-3.565-.045-5.346-.066-2.176-1.313-4.827.7-6.339,2.714-2.042,4.915-5.244,9.042-4.931a51.265,51.265,0,0,0,6-.246C379.932-273.75,406-274.1,432.062-274.5c12.252-.189,24.5-.524,36.756-.568,5.333-.018,10.677.417,16,.854,4.985.41,6.031,1.605,6.071,6.785.1,12.477.056,24.955.133,37.432.937,150.621.81,301.244.9,451.867.006,8.91-.235,17.821-.4,26.731C491.486,250.556,491.721,252.613,489.763,255.023Z" fill="#00bfbf"></path> <path d="M1129.112,255.013c-3.069-1.347-6.2-1.084-9.3-1.05-36.762.394-73.525.467-110.287,0-7.795-.1-15.589-.358-23.382-.582-3.816-.109-3.815-.148-7.191,2.149-1.688-2.041-1.469-4.438-1.5-6.856-1.416-99.145-.436-198.294-.381-297.441.036-65.059.4-130.118.608-195.178q.029-9.023-.066-18.046c-.02-1.979-.861-4.407,1-5.636,2.334-1.544,3.881-4.389,7.121-4.532,2.446-.109,4.886-.362,7.332-.467,26.046-1.118,52.111-1.476,78.175-1.875,12.7-.193,25.394-.522,38.091-.571,5.11-.02,10.232.427,15.329.874,4.724.415,5.667,1.48,5.7,6.37.1,12.254,0,24.509.123,36.763,1.547,152.842.8,305.69,1.017,458.535q.014,10.026-.12,20.052C1131.348,249.929,1131.607,252.457,1129.112,255.013Z" fill="#0000bf"></path> <path d="M19.368-274.382c3.77,2.4,3.768,2.268,8.344,2.184,14.038-.257,28.079-.54,42.119-.559,29.868-.042,59.735.081,89.6.12,3.514,0,7.066.443,10.069-.993,2.331,1.389,2.057,3.314,2.105,5.028.237,8.466.562,16.934.556,25.4q-.066,87.262-.261,174.525-.332,157.808-.711,315.615c-.018,7.673-.8,8.405-8.263,8.884-15.822,1.014-31.638.138-47.457.051-27.195-.151-54.374-.943-81.55-1.909-2.225-.079-4.446-.434-6.667-.415-3.8.034-5.69-3.09-8.359-4.893-.924-.624-1-1.944-.933-3.085.934-16.042-.034-32.083-.044-48.125C17.827,49,17.17-99.446,17.71-247.893c.024-6.686.192-13.371.208-20.057A14.88,14.88,0,0,1,19.368-274.382Z" fill="#bfbfbf"></path> <path d="M330.227,254.637c-7.094-1.189-14.181-.679-21.247-.592-36.773.454-73.544.2-110.315-.172-5.343-.054-10.683-.405-15.972-.617l-2.838,2.6c-.495-.445-.951-.675-1.118-1.038-.864-1.872-.767-3.879-.786-5.889q-.711-74.879-.585-149.762.424-146.755.541-293.511.058-34.431.1-68.863c.006-4.1,3.552-8.107,8.128-8.876a59.529,59.529,0,0,1,7.325-.535c26.053-1.111,52.124-1.489,78.2-1.876,13.146-.195,26.291-.519,39.437-.571a146.33,146.33,0,0,1,14.661.927c3.961.385,4.965,1.524,5.11,5.575.136,3.783-.036,7.576,0,11.364,1.576,158.9.74,317.8,1.052,476.7.019,9.583-.1,19.166-.2,28.748C331.686,250.409,332.091,252.726,330.227,254.637Z" fill="#bfbf00"></path> <path d="M969.769,254.535c-7.683-1.018-15.436-.557-23.175-.467-36.329.425-72.655.17-108.982-.2-5.119-.053-10.236-.405-15.319-.617l-2.956,2.74c-2.183-2.591-1.886-5.506-1.893-8.382-.113-48.808-.351-97.616-.345-146.425q.015-144.085.254-288.173c.028-22.732.2-45.465.307-68.2.009-2.006-.025-4.012-.025-6.017,0-2.172-1.125-4.814.929-6.312,2.586-1.886,4.637-4.871,8.421-4.809,2.223.036,4.45-.219,6.676-.315,26.053-1.124,52.126-1.46,78.2-1.865,12.923-.2,25.847-.513,38.771-.559,4.887-.018,9.788.456,14.662.919,3.936.374,5.089,1.608,5.272,5.5.157,3.335-.023,6.684,0,10.027,1.212,159.8.638,319.6.849,479.4q.018,13.706-.161,27.412C971.228,250.337,971.745,252.688,969.769,254.535Z" fill="#bf0000"></path> <path d="M502.526,253.239l-2.87,2.634c-.437-.423-.871-.671-1.044-1.04a13.565,13.565,0,0,1-.921-5.869c-.138-43.68-.47-87.359-.452-131.039q.066-157.116.39-314.233.047-33.426.13-66.853c0-4.08,3.48-8.123,8.1-8.9a65.185,65.185,0,0,1,7.991-.574c26.052-1.133,52.124-1.462,78.193-1.866,12.923-.2,25.846-.515,38.769-.562,4.887-.018,9.788.453,14.661.919,3.955.378,4.992,1.526,5.169,5.547.148,3.335-.056,6.684-.022,10.025,1.655,162.239.65,324.483,1,486.724q.022,10.362-.156,20.725c-.031,1.926.452,4.063-1.533,5.684-8.283-1.114-16.7-.545-25.107-.458-35.882.37-71.762.135-107.641-.242C512.287,253.806,507.393,253.452,502.526,253.239Z" fill="#00bf00"></path></g> <g transform=""><foreignObject x="40" y="51" width="1070" height="265" style="line-height:1em;font-size:230px;font-family:'Monument Extended Ultrabold';letter-spacing:0.04em;text-transform:uppercase;color:#ffffff;"  ><div style="width:100%;height:100%;display:flex;">
        <div xmlns="http://www.w3.org/1999/xhtml" style="white-space:pre-wrap;text-align:center;border:0px solid #000000;padding-top:5px;width:100%;">${this.title}</div></div></foreignObject></g> 
        
        <g id="TV_fill" data-name="TV fill"><path d="M1067.324,454.5c1.728-10.728,2.809-21.5.919-32.313-.817-4.679-1.7-9.278-.791-14.077a7.088,7.088,0,0,0-2.346-7.033,10.711,10.711,0,0,1-3.684-6.5c-2.055-9.039-7.8-14.265-16.878-15.948a74.635,74.635,0,0,0-11.276-1.359c-7.064-.225-14.078.5-21.115.73a349.115,349.115,0,0,1-39.794-1.219c-16.739-1.367-33.55-1.942-50.34-2.563q-32.709-1.209-65.434-1.918c-12.068-.273-24.067-1.614-36.128-1.921-4.469-.113-8.943-.323-13.4-.686-19.767-1.612-39.537-1.307-59.32-.357-18.816.9-37.619,2.121-56.463,2.359-8.13.1-16.264.125-24.39.373q-40.243,1.225-80.5,1.086c-15.72-.052-31.449-.216-47.155.744-12.714.776-25.412,1.907-38.136,2.379-13.243.492-26.5.739-39.748,1.037,2.472,5.6,6.065,10.707,6.065,17.408,0-6.7-3.593-11.805-6.065-17.408q-4.92.111-9.839.233c-11.366.3-22.721.817-34.1.946-11.794.133-23.587-.053-35.367-.169-15.845-.156-31.708-.6-47.535-1.68a161.03,161.03,0,0,0-18.694-.016c-6.085.292-12.162.683-18.266-.128-12.771-1.7-25.567-2.854-38.5-1.946a253.538,253.538,0,0,1-28.844.856,138.543,138.543,0,0,0-19.092.547,148.3,148.3,0,0,1-28.016-.089c-13.478-1.281-26.888-3.264-40.494-2.638a41.475,41.475,0,0,0-8.855,1.02,48.153,48.153,0,0,1-13.682,1.543,26.832,26.832,0,0,0-8.064.727,56.914,56.914,0,0,1-10.7,2.339,4.655,4.655,0,0,0-4.08,2.306,46.731,46.731,0,0,0-3.794,8.47,75.335,75.335,0,0,1-2.647,8.932,2.79,2.79,0,
                    0,0-.178,2.693c1.526,2.661,1.111,5.47.637,8.316-.547,3.285-1.438,6.589.507,9.813a5.364,5.364,0,0,1,.266,2.8,75.3,75.3,0,0,1-1.677,14.1,30.363,30.363,0,0,0-1.093,6.4c-.118,5.555-.291,11.109-.433,16.663-.253,9.895.651,19.76.726,29.657.166,21.806-1.39,43.627.493,65.421,1.142,13.208.727,26.517,3.269,39.648,2.028,10.48.793,21.127-.491,31.589-1.926,15.7-1.53,31.384-.906,47.087.216,5.424.353,10.828.111,16.246-.32,7.181-.666,14.4,0,21.537.957,10.314.633,20.579.091,30.865a208.256,208.256,0,0,0,.949,33.294A276.981,276.981,0,0,1,93.5,827.04a224.181,224.181,0,0,0-.731,28.423c.543,12.041,1.273,24.083,1.4,36.13.1,10.031,1.007,20.03.855,30.062-.019,1.216.137,2.435.233,3.651.679,8.637,1.506,17.267,1.982,25.915A38.926,38.926,0,0,0,99.1,961.972a87.369,87.369,0,0,1,2.984,11.81c1.985,10.063,7.728,17.419,16.347,22.707a10.072,10.072,0,0,0,6.174,1.656q6.274-.5,12.55-.989c6.993-.557,13.825-.1,20.08,3.485a13.661,13.661,0,0,0,6.99,1.787q7.726,0,15.453.06c1.519.015,3.079-.14,4.523.72-3.1.3-6.2.251-9.292.31-3.151.06-6.343-.3-10.333.427,2.573,2.393,4.952,2.61,7.317,2.839,3.228.313,6.486.43,9.685.928,16.8,2.613,33.709,2.684,50.636,2.173,5.945-.179,11.935-.574,17.83-.4,9.719.28,19.46.344,29.179,1.055,7.835.573,15.674-.787,23.519-.715,29.268.271,58.527-.491,87.792-.581,1.76,0,3.519-.091,5.278-.165,11.348-.48,22.692-1.164,
                    34.045-1.4,12.044-.251,24.09-.13,36.133-.8,7.559-.418,15.139-.452,22.711-.8,13.656-.626,27.338-.389,41.011-.789,19.232-.563,38.485,0,57.732-.316,13.126-.214,26.264-.323,39.387.7,11.205.873,22.456.28,33.693.728,14.6.581,29.236.143,43.856.862,9.319.458,18.667.178,28,.837,7.822.553,15.679.611,23.52.888,2.842.1,5.688.143,8.525.317,11.059.679,22.107,1.641,33.176,2.044,13.517.493,27.035.848,40.542,1.648,12.013.712,24.04,1.446,36.067,1.576,12.866.14,25.694.593,38.509,1.706,6.062.526,12.159.664,18.212,1.258,6.894.677,13.815,1.193,20.665.291a171.27,171.27,0,0,0,42.728-11.018c.7-.286,1.619-.334,1.731-1.609a9.156,9.156,0,0,0-3.865-.269c-6.35.295-12.716.591-19.053.68q-35.547.5-71.091,1.138c-18.413.326-36.8-1.524-55.231-1.035-.27.008-.542-.009-.812-.021-9.723-.441-19.451-.8-29.168-1.349-9.057-.512-18.122-.127-27.192-.669-13.1-.783-26.24-.9-39.365-1.187-15.443-.337-30.881.487-46.336.06-19.223-.532-38.468.377-57.7-.589-9.188-.462-18.392-.611-27.588-.9-2.842-.09-5.706.006-8.522-.312-7.267-.821-14.577-.708-21.858-1.209-8.223-.565-16.472-.768-24.709-1.129,8.4-.853,16.725-1.833,25.146-1.742,14.638.156,29.288.295,43.916-.144,15.724-.473,31.445-.157,47.164-.466,2.164-.042,4.34.074,6.5.247,7.571.608,15.158.737,22.747.887,30.626.605,61.268-.093,91.888,1.192,8.527.358,17.1-.06,25.6.531,16.095,1.118,32.165,2.484,48.321,
                    1.566.945-.054,1.9.009,2.845.023,19.92.293,39.831,1.289,59.762.612,3.789-.128,7.6-.083,11.381.153,14.746.92,29.5,1.756,44.266,2.16,2.858.079,5.664.148,8.333-1.22,1.592-.815,3.419-.732,5.184-.8,10.29-.422,20.578-.9,30.869-1.271a9.845,9.845,0,0,0,5.866-2.377c6.087-4.69,7.865-12.137,11.829-18.178a2.265,2.265,0,0,0,.178-.789c.88-4.656,1.819-9.285,1.556-14.092-.192-3.51-.055-7.043.053-10.563a37.835,37.835,0,0,0-.436-8.1,42.363,42.363,0,0,1-.3-10.13c.362-6.628.949-13.257.992-19.888.072-11,1.871-21.851,2.643-32.789.526-7.437,1.572-14.87.827-22.308-1.314-13.109-1.334-26.239-1.5-39.387-.184-14.371.89-28.7.872-43.066q-.041-32.313.745-64.633c.356-13.809,1.139-27.621.8-41.448a17.249,17.249,0,0,1,.225-3.242c1.154-6.891,1.315-13.727-.835-20.488a27.59,27.59,0,0,1-.833-3.973c-.712-4.424-.527-8.7,2.6-12.29,1.315-1.515,1.076-3.218,1.06-4.99-.091-10.3-1.5-20.557-.811-30.869a169.533,169.533,0,0,0,.351-17.474,88.948,88.948,0,0,1,1.895-20.186,16.151,16.151,0,0,0-.159-8.006,23.585,23.585,0,0,1-.647-10.47,64.855,64.855,0,0,0,.609-8.1c.321-12.714,1.347-25.411.911-38.145-.046-1.345.222-2.7.281-4.051a38.707,38.707,0,0,0,.138-6.486,37.506,37.506,0,0,1,.337-10.52,47.486,47.486,0,0,0,.184-14.172A14.348,14.348,0,0,1,1067.324,454.5ZM195.656,1003.886a46.6,46.6,0,0,1,15.44-1.019C205.892,1004.269,201.257,1004.258,195.656,
                    1003.886Zm295.059-7.66c-10.572.018-21.144-.039-31.716.026-11.1.067-22.184.666-33.275.959-6.353.168-12.714.4-19.066.344-16.118-.134-32.188,1.241-48.311,1.274-12.284.025-24.594.842-36.871,1.57-13.267.788-26.531.257-39.794.607-6.447.17-13-.827-19.369.249-8.092,1.365-16.18,1.158-24.292,1.21-1.078.007-2.156,0-3.235,0,5.388-1.931,10.981-1.492,16.485-1.986a267.12,267.12,0,0,1,30.04-1.318,176.788,176.788,0,0,0,26.348-1.427c10.753-1.364,21.6-1.943,32.432-2.277,15.047-.466,30.022-1.859,45.02-2.959,11.9-.873,23.824-1.051,35.744-1.394,10.564-.3,21.117-1,31.681-1.189,8.122-.142,16.253.23,24.379.42a6.851,6.851,0,0,1,2.344.57,127.734,127.734,0,0,0,16.366,5.133C493.988,996.1,492.352,996.223,490.715,996.226Zm23.334.5c5.3-2.079,10.617-1.291,15.982,0Zm21.857.642c6.989-.763,13.993-1.9,20.847,1.079ZM830.912,671.105c-.208,16.11-.37,32.23-.8,48.335-.34,12.571-.909,25.152-1.586,37.715-.547,10.162.021,20.319-.405,30.463-.733,17.449-1.339,34.909-3.312,52.284-.641,5.652-1.16,11.331-1.386,17.012-.35,8.8-1.057,17.581-1.61,26.362a67.08,67.08,0,0,1-9.2,30.4A46.707,46.707,0,0,1,789,933.861c-3.394,1.356-6.717,2.89-10.059,4.372-1.484.658-3.227,1.084-4.346,2.147-2.641,2.509-5.736,2.633-9.035,2.567-4.471-.089-8.945-.022-13.418-.022-16.115-.058-32.193-1.274-48.321-1.353-11.61-.057-23.255-.795-34.872-1.467-9.585-.555-19.157-1.347-28.74-1.939-4.459-.275-8.935-.267-13.4-.482-16.783-.81-33.576-.739-50.371-.88-9.733-.082-19.464-.808-29.188-1.381-7.731-.456-15.431.135-23.142.381-1.62.051-3.239.246-4.858.249-11.928.022-23.856-.038-35.783.025-12.861.068-25.7.8-38.533,1.543-5.4.313-10.837.328-16.247.345-17.611.058-35.218,1.008-52.826.478-7.581-.228-15.156-.385-22.738-.4q-23.763-.042-47.493,1.237c-5.137.273-10.293.183-15.433.407-12.592.55-25.19.529-37.784.392-5.543-.061-11.1-.759-16.633-.333a187.876,187.876,0,0,1-22.721.68,169.441,169.441,0,0,1-29.762-3.676,18.384,18.384,0,0,1-7.5-3.88c-4.787-3.834-8.812-8.419-13.04-12.8a20.144,20.144,0,0,1-3.648-5.837q-4.608-10.179-9.115-20.4c-1.576-3.592-.792-7.481-1.147-11.223a127.731,127.731,0,0,1-.127-21.893c.236-3.077-.351-6.207-.354-9.313-.007-9.07.472-18.132,1.263-27.157.7-8.017-.3-15.972-.3-23.957,0-3.387-.1-6.774.163-10.149.887-11.37.277-22.756.449-34.134a82.4,82.4,0,0,1,3.665-22.734c1.027-3.4.714-7.229.855-10.869.528-13.678.1-27.371.477-41.045.256-9.344.49-18.687.3-28.023-.281-14.068-.681-28.136-1.474-42.19-.45-7.97-.613-15.957-.9-23.936-.009-.271-.011-.543,0-.813,1.128-18.647.565-37.342,1.776-56,1.118-17.2,3.065-34.245,6.9-51.068,2.4-10.541,7.828-19.545,13.841-28.282,1.458-2.118,3.136-4.087,4.588-6.209a5.917,5.917,0,0,1,4.713-2.726c7.016-.572,14.025-1.118,21.075-1.2,16.926-.189,33.872-.1,50.767-.95,13.119-.661,26.272-.492,39.37-1.748,6.874-.659,13.8.065,20.711-.019,14.916-.181,29.783-1.41,44.692-1.578,5.285-.059,10.569-.221,15.854-.265,33.879-.28,67.752-.964,101.634-1.1,15.995-.066,32.007-.522,47.955.493,22.075,1.4,44.171.648,66.244,1.483,5.277.2,10.57.082,15.854-.018,8.813-.168,17.628.491,26.414.312,9.9-.2,19.764.265,29.645.288,7.047.016,14.106-.118,21.137.243,7.839.4,15.661,1.2,23.474,1.991,6.207.627,12.374,1.174,18.635.526,4.571-.473,9.2-.058,13.808-.27,10.141-.468,20.294-.684,30.443-.964,1.879-.052,3.784-.214,4.738,2.154.477,1.184,1.9,1.391,3.154,1.52,4.446.459,8.884,1.006,13.337,1.372,4.168.343,8.286,1.436,12.528.844a4.464,4.464,0,0,1,1.97.415,66.416,66.416,0,0,1,11.71,5.608,4.358,4.358,0,0,1,2.351,3.1,16.031,16.031,0,0,0,4.773,8.346,8.091,8.091,0,0,1,2.421,5.416c.592,11.078,1.952,22.1,1.734,33.242-.133,6.776-.348,13.542-.969,20.275-1.262,13.665-.785,27.331-.427,41,.23,8.794.6,17.584.862,26.378C831.4,616.371,831.265,643.745,830.912,671.105Zm122.17,113.527c-5.742,3.294-12.264,1.188-16.838-2.7a13.2,13.2,0,0,1-3.493-15.14,14.3,14.3,0,0,1,3.979-6.028c.931-.766,1.909-1.789,3-2,6.141-1.179,12.281-1.952,17.6,2.628a11.3,11.3,0,0,1,4.151,9.146C960.944,776.365,958.669,781.427,953.082,784.632Zm8.08,44.243A25.01,25.01,0,0,1,952.9,841.15a9.025,9.025,0,0,1-6.267,2.2c-9.084-.024-16.523-8.821-14.851-17.61.994-5.226,3.231-9.761,8.275-12.33,1.987-1.011,4-1.641,6.161-.394.807.466,1.686,1.046,2.652.447,2.4-1.487,4.225-.069,5.82,1.348a24.178,24.178,0,0,1,6.135,8.5A7.787,7.787,0,0,1,961.162,828.875Zm-2.189-111.846a10.062,10.062,0,0,1-5.1,7.857,24.3,24.3,0,0,1-9.914,3.255A13.962,13.962,0,0,1,929.077,714.9c-.155-3.461,1.532-5.97,4.215-7.825,3.6-2.491,7.508-4.257,11.538-3.993C953.873,702.431,960.092,708.8,958.973,717.029Zm4.556,204.094a22.413,22.413,0,0,1-11.957,15.509c-9.976,5.206-21.34-3.73-20.338-13.841a23.851,23.851,0,0,1,.946-6.211c2.542-7.981,9.8-12.187,18.067-10.516a28.089,28.089,0,0,1,6.906,2.271A11.451,11.451,0,0,1,963.529,921.123Zm42-381.035a103.867,103.867,0,0,1-27.1,46.893c-6.753,6.74-15,9.956-24.33,10.739-2.83.238-5.675.3-8.513.45-14.8-.341-29.132-2.821-42.285-9.943-16.275-8.811-26.085-22.334-28.82-40.793-2.405-16.221-1.036-32.013,6.868-46.568,10.931-20.13,27.893-31.978,50.835-34.629a153.766,153.766,0,0,1,
                    25.545-.816c16.6.857,29.858,8.225,39.212,21.976C1007.924,503.553,1010.664,521.316,1005.526,540.088Z" fill="var(--simple-colors-default-theme-${this.tvcolor}-5)"></path></g> 
                    
                    <g id="Knobs_fill" data-name="Knobs fill" fill="var(--simple-colors-default-theme-${this.knobcolor}-5)">
                    <path d="M944.83,703.08c-4.03-.264-7.935,1.5-11.538,3.993-2.683,1.855-4.37,4.364-4.215,7.825a13.962,13.962,0,0,0,14.886,13.243,24.3,24.3,0,0,0,9.914-3.255,10.062,10.062,0,0,0,5.1-7.857C960.092,708.8,953.873,702.431,944.83,703.08Z"></path> 
                    <path d="M957.333,761.4c-5.322-4.58-11.462-3.807-17.6-2.628-1.091.21-2.069,1.233-3,2a14.3,14.3,0,0,0-3.979,6.028,13.2,13.2,0,0,0,3.493,15.14c4.574,3.884,11.1,5.99,16.838,2.7,5.587-3.2,7.862-8.267,8.4-14.089A11.3,11.3,0,0,0,957.333,761.4Z"></path> 
                    <path d="M957.722,465.421a153.766,153.766,0,0,0-25.545.816c-22.942,2.651-39.9,14.5-50.835,34.629-7.9,14.555-9.273,30.347-6.868,46.568,2.735,18.459,12.545,31.982,28.82,40.793,13.153,7.122,27.48,9.6,42.285,9.943,2.838-.145,5.683-.212,8.513-.45,9.334-.783,17.577-4,24.33-10.739a103.867,103.867,0,0,0,27.1-46.893c5.138-18.772,2.4-36.535-8.592-52.691C987.58,473.646,974.326,466.278,957.722,465.421Z"></path> 
                    <path d="M957.153,908.335a28.089,28.089,0,0,0-6.906-2.271c-8.264-1.671-15.525,2.535-18.067,10.516a23.851,23.851,0,0,0-.946,6.211c-1,10.111,10.362,19.047,20.338,13.841a22.413,22.413,0,0,0,11.957-15.509A11.451,11.451,0,0,0,957.153,908.335Z"></path>
                    <path d="M501.093,376.273c12.724-.472,25.422-1.6,38.136-2.379,15.706-.96,31.435-.8,47.155-.744q39.043.131,78.064-1.022a35.634,35.634,0,0,0,1.292-3.849,8.6,8.6,0,0,1-3.637-7.867c.059-1.215.485-2.488.032-3.628-2.259-5.7-1.98-12.449-6.987-17.025a3.829,3.829,0,0,1-.653-1.026c-1.749-3.208-1.107-6.042,1.955-8.08a57.683,57.683,0,0,1,5.262-3.077A51.9,51.9,0,0,0,675.45,317.7a44.445,44.445,0,0,1,13.155-9.427,73.148,73.148,0,0,0,10.639-6.586c2.341-1.61,4.763-3.109,7.2-4.567,14.743-8.815,29.642-17.308,42.879-28.494,5.731-4.844,12.227-8.959,18.569-13.105,6.446-4.214,12.755-8.631,19.373-12.606,8.236-4.946,15.936-10.767,24.344-15.463a17.457,17.457,0,0,0,4.276-3.075c6.411-6.749,14.915-10.731,21.954-16.648a9.869,9.869,0,0,1,3.958-2.019,8.773,8.773,0,0,0,2.9-1.394c11.662-8.135,22.5-17.361,34.1-25.6,8.161-5.794,16.025-12.035,24.53-17.344,9.466-5.909,18-13.007,26.473-20.192,2.474-2.1,5.1-3.531,8.469-3.239a6.582,6.582,0,0,0,4.625-1.19c5.045-3.727,10.889-6.029,16.334-9.038a22.878,22.878,0,0,0,7.866-6.774c5.2-7.2,4.027-6.429.4-12.838-1.479-2.615-2.154-2.875-4.9-1.593-7.369,3.436-14.672,7.012-22.027,10.478-1.92.905-3.029,1.975-2.531,4.377.518,2.494-.708,4.509-2.733,5.929-1.437,1.007-3,1.836-4.523,2.72-8.552,4.962-17.546,9.1-25.9,14.453-8.451,5.407-16.3,11.737-25.1,16.576a308.44,308.44,0,0,0-34.539,22.141c-2.931,2.162-6.1,4.139-9.878,4.532a13.237,13.237,0,0,0-5.639,2.108c-11.546,7.079-22.639,14.908-34.651,21.214-10.68,5.607-21.387,11.172-31.6,17.6-16.282,10.257-33.17,19.486-49.595,29.51-11.912,7.27-24.173,13.985-35.395,22.311-5.372,3.985-11.315,6.885-17.022,10.235-2.007,1.178-3.9,2.289-5.258,4.31-1.47,2.193-3.788,3.444-6.209,4.419a84.905,84.905,0,0,0-8.663,3.49c-5.042,2.713-9.807,2.619-14.605-.423a9.753,9.753,0,0,0-3.711-1.6,44.52,44.52,0,0,1-22.573-10.445,12.862,12.862,0,0,0-8.909-3.438,4.247,4.247,0,0,1-3.431-.989c-2.084-2.288-4.767-2.322-7.5-2.306-3.123.018-6.218-.438-9.321-.59-8.2-.4-16.35-1.075-24.507,1.39-7.113,2.151-14.627,3.045-21.262,6.664-6.184,3.372-12.341,6.811-18.343,10.492a64.439,64.439,0,0,0-10.869,7.781c-3.952,3.725-12.694,1.766-15.12-3.341a12.865,12.865,0,0,0-5.91-5.825,29.426,29.426,0,0,1-3.155-1.845,209.93,209.93,0,0,0-29.97-17.918c-14.462-7.306-27.7-16.54-40.794-25.923-12.77-9.149-24.855-19.249-37.96-27.953-5.53-3.673-11.253-7.057-16.76-10.762a113.117,113.117,0,0,0-10.446-6.264c-5.746-3.027-11.524-6.017-17.083-9.364-4.051-2.439-7.743-5.47-11.648-8.161-4.684-3.228-9.22-6.762-14.533-8.907-8.253-3.333-15.466-8.33-22.611-13.486-2.285-1.65-4.045-3.631-4.541-6.477a8.119,8.119,0,0,0-2.612-4.467c-6.439-6.315-14.115-10.345-23.41-12.818-1.192,3.776-3.4,
                    6.539-5.148,9.572-1.614,2.8-1.5,3.254.874,5.6a34.175,34.175,0,0,0,2.78,2.365c4.714,3.746,10.388,5.793,15.553,8.741a14.018,14.018,0,0,0,4.554,1.674,11.568,11.568,0,0,1,6,3.233,128.128,128.128,0,0,0,10.4,8.466c5.787,4.473,11.78,8.713,17.275,13.521a157.976,157.976,0,0,0,16.836,12.7c9.593,6.365,19.609,12.094,28.716,19.2,9.092,7.092,19.655,12.021,28.6,19.355a66.514,66.514,0,0,0,6.665,4.648c8.592,5.437,17.153,10.918,25.21,17.137,8.9,6.865,18.183,13.231,26.331,21.045,5.557,5.33,11.014,10.775,17.352,15.25a102.856,102.856,0,0,1,8.024,6.861c4.889,4.272,9.5,8.895,15.491,11.726,1.956.925,3.881,1.935,5.743,3.036,4.471,2.643,4.96,7.236,1.109,10.764a12.352,12.352,0,0,0-3.115,3.68c-1.287,2.69-2.8,5.281-3.939,8.029-2.03,4.892-3.655,9.837-2.824,15.355a5.511,5.511,0,0,1-2.313,5.613,31.485,31.485,0,0,0,1.42,3.8C474.6,377.012,487.85,376.765,501.093,376.273Z"></path> 
                    <path d="M954.693,814.807c-1.6-1.417-3.419-2.835-5.82-1.348-.966.6-1.845.019-2.652-.447-2.158-1.247-4.174-.617-6.161.394-5.044,2.569-7.281,7.1-8.275,12.33-1.672,8.789,5.767,17.586,14.851,17.61a9.025,9.025,0,0,0,6.267-2.2,25.01,25.01,0,0,0,8.259-12.275,7.787,7.787,0,0,0-.334-5.571A24.178,24.178,0,0,0,954.693,814.807Z"></path></g>
                     
                    <image id="lowlight" width="1085" height="1019" transform="translate(76.005 104.924) scale(0.927)" xlink:href="data:image/png;base64,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" style="mix-blend-mode:multiply;pointer-events:none;"></image> 
                    <image id="highlight" width="1071" height="968" transform="translate(76.005 101.214) scale(0.927)" xlink:href="data:image/png;base64,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" style="mix-blend-mode:screen;pointer-events:none;"></image> 
                    <image id="TV_shadow" data-name="TV shadow" width="1034" height="55" transform="translate(95.483 998.52) scale(0.927)" xlink:href="data:image/png;base64,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" style="mix-blend-mode:multiply;pointer-events:none;"></image> 
                    <g id="TV_Outline" data-name="TV Outline" fill="#000000">
                    <path d="M882.706,166.333l-.4.11a1.018,1.018,0,0,1,0,.176c.04-.019.077-.041.119-.06A1.279,1.279,0,0,1,882.706,166.333Z"></path> 
                    <path d="M1070.817,433.5c-.282-4.6-.853-9.234-.286-13.8.847-6.816-.287-13.527-.5-20.283-.128-4.105-1.663-7.912-2.894-11.753a19.149,19.149,0,0,0-8.969-11.114c-3.816-2.207-8-3.282-12.084-4.683a6,6,0,0,0-2.015-.18c-4.88.093-9.772.026-14.634.371a163.421,163.421,0,0,1-16.664.242c-13.009-.4-26.015-.867-39.025-1.234-15.992-.449-31.987-.822-47.981-1.235-1.49-.039-2.98-.122-4.47-.191q-20.718-.966-41.436-1.927c-9.752-.436-19.508-.761-29.258-1.221-8.4-.4-16.783-.945-25.177-1.367-7.583-.381-15.174-.588-22.752-1.034-15.853-.934-31.714-.921-47.573-.435-12.33.378-24.65,1.06-36.975,1.579-3.251.137-6.507.133-9.759.263-13.829.551-27.655.268-41.481-.121-.169,0-.34-.006-.51-.013a35.5,35.5,0,0,1-2.97,9.135c16.373.362,32.745.6,49.117.241,12.872-.285,25.737-.942,38.6-1.513,12.058-.534,24.118-.931,36.185-.488q15.442.569,30.878,1.352c12.724.656,25.44,1.455,38.162,2.145,6.226.338,12.458.573,18.688.847,9.209.4,18.419.786,27.628,1.2,22.757,1.031,45.534,1.21,68.3,1.654q17.689.345,35.375.839c3.929.1,7.852.407,11.781.516a76.351,76.351,0,0,0,11.372-.406,17.791,17.791,0,0,1,6.453.371c2.1.513,4.268.728,6.4,1.1,2.4.416,4.825.7,6.947,2.094a7.812,7.812,0,0,0,2.275.839c4.567,1.228,6.27,4.792,7.29,8.906a7.453,7.453,0,0,1,.1,1.621,172.192,172.192,0,0,0,1.528,19.449,51.861,51.861,0,0,1,.074,9.659c-.241,4.732.332,9.487-.33,14.215a3.19,3.19,0,0,0,.048,1.2c1.472,5.749.972,11.6.68,17.393-.361,7.178-.688,14.346-.689,21.538a146.238,146.238,0,0,1-.753,14.616,254.014,254.014,0,0,0-.775,37.367c.637,13.682.293,27.383-.226,41.071-.2,5.148-.466,10.295-.547,15.445-.244,15.453-.6,30.907-.56,46.36.052,19.812-.8,39.573-2.294,59.32-.316,4.187-.552,8.4-.508,12.593.178,16.684-.553,33.344-1.082,50.011-.206,6.5-.711,13.008-.29,19.512,1.6,24.78,1.552,49.583,1.178,74.394-.037,2.437.032,4.878.143,7.314a264.656,264.656,0,0,1-.908,34.531c-.471,5.535-.713,11.09-1.087,16.634-.163,2.433-.338,4.868-.611,7.291a163.54,163.54,0,0,0-1.249,25.548c.28,6.389-.617,12.721-.958,19.079-.232,4.331-.506,8.659-.774,12.987-.108,1.757-.219,3.515-.38,5.267-.5,5.508-3.34,9.632-7.712,12.81-.984.716-2.055,1.313-3.076,1.979a8.864,8.864,0,0,1-5.009,1.365c-4.473,0-8.955-.021-13.418.228-21.254,1.187-42.531,1.716-63.806,2.272-5.963.156-11.93.13-17.9.151-8.948.032-17.894.079-26.842.309-12.745.326-25.481-.3-38.215-.822q-10.158-.417-20.328-.49c-11.529-.072-23.034-.712-34.545-1.233-4.739-.215-9.487-.232-14.23-.365-11.655-.326-23.313-.551-34.96-1.042-8.268-.349-16.533-.49-24.8-.5q-23.592-.025-47.183,0v-.136c-17.488-.283-34.979-.453-52.463-.879q-25.207-.614-50.4-1.682c-13.409-.587-26.816-1.158-40.232-1.574-7.585-.235-15.156-.873-22.739-1.222q-14.832-.683-29.684-.6c-11.8.077-23.59.259-35.383-.2-10.309-.4-20.6.394-30.9.534-7.049.1-14.1.255-21.149.215-12.344-.07-24.662.392-36.983,1.156-6.894.428-13.826.209-20.736.434-9.484.308-18.96.844-28.445,1.123-7.858.23-15.723.312-23.585.307-7.458-.006-14.909-.179-22.352.564a30.869,30.869,0,0,1-6.081-.159,101.563,101.563,0,0,0-14.621-.372c-1.733.079-3.44.614-5.171.866-6.061.883-12.18.715-18.273.812a241.423,241.423,0,0,0-25.951,1.747c-7.709.957-15.442.684-23.15.334-5.016-.228-10.022-.395-15.036-.315q-13.428.214-26.82-.75c-8.246-.6-16.514-.921-24.775-1.276-5.523-.237-9.7-3.06-13.381-6.795a10.314,10.314,0,0,1-2.389-5.106c-.653-2.906-1.342-5.812-1.8-8.752-.765-4.952-1.419-9.922-2-14.9-.472-4.033-.688-8.1-1.162-12.13-.963-8.21-2.461-16.356-3.026-24.612-.278-4.055-.489-8.122-.516-12.185-.089-13.693-.2-27.389-.08-41.081.122-14.377-.308-28.74-.605-43.108q-.106-5.083-.111-10.167c-.011-6.1-.058-12.2-.472-18.293-.248-3.651-.367-7.315-.4-10.974-.136-15.456-.125-30.912.206-46.367.2-9.218.21-18.438-.123-27.656-.044-1.219-.084-2.439-.091-3.659-.1-20.746-.169-41.491-.307-62.236-.132-19.794-.279-39.589-.542-59.381-.09-6.774-.649-13.541-.825-20.315-.274-10.572-.375-21.147-.6-31.72-.462-21.7.313-43.379,1.252-65.054.171-3.927.172-7.861.213-11.793.085-8.405-.064-16.827.7-25.2.853-9.324.088-18.663.588-27.983.131-2.436.211-4.875.272-7.314a20.408,20.408,0,0,1,1.045-5.58c1.833-5.876,5.7-9.371,11.938-10.062a230.906,230.906,0,0,1,24.733-1.715c16.948-.053,33.9.042,50.843-.2,10.177-.143,20.325.5,30.49.612,6.228.07,12.46.465,18.7.454a83.993,83.993,0,0,0,12.172-.572,39.957,39.957,0,0,1,6.5-.237,72.318,72.318,0,0,0,11.768-.5,13.145,13.145,0,0,1,3.245-.03c9.987,1.063,20.018,1.2,30.041,1.581,8.395.319,16.777.967,25.167,1.445,23.17,1.318,46.348.773,69.529.337,14.233-.268,28.471-.456,42.706-.416,9.12.026,18.235-.166,27.347-.42-1.88-3.8-3.6-7.665-3.6-12.3,0,4.633,1.722,8.5,3.6,12.3,6.065-.17,12.129-.366,18.193-.548,11.786-.353,23.566-.98,35.339-1.649,10.689-.608,21.357-1.592,32.048-2.141Q602.291,373,656.4,374.338q3.5.082,7.007.16a35.5,35.5,0,0,0,2.97-9.135,1.794,1.794,0,0,1-1.7-.906c.658-4.692-.32-9.313-1.591-13.91a94.4,94.4,0,0,0-6.267-15.858c-.454-.939-1.268-1.777-1.048-3.161,1.052-.649,2.181-1.371,3.334-2.053,6.181-3.66,12.409-7.237,18.356-11.282Q759.335,262.5,841.234,206.832c31.178-21.195,61.341-43.795,91.614-66.241,1.169-.867,2.166-2.05,3.653-2.406.789.9.066,2.3,1.237,2.94,2.338-.072,2.338-.072,5.837-2.17,5.127.181,5.276.086,7.218-4.671A75.4,75.4,0,0,1,962.37,128.6c1.631-.66,3.276-1.309,4.835-2.117a8.294,8.294,0,0,0,4.2-4.771,28.588,28.588,0,0,0,1.627-9.165,7.089,7.089,0,0,0-3.562-6.453c-2.2-1.325-4.5-2.5-6.8-3.657a6,6,0,0,0-4.732-.268,22.231,22.231,0,0,0-5.756,2.962A125.6,125.6,0,0,1,935.04,115.2a4.2,4.2,0,0,0-2.339,5.726c.562,1.51,1.323,2.946,1.962,4.345-.812,1.42-2.215,1.74-3.368,2.4-9.308,5.291-18.745,10.365-27.925,15.868q-55.454,33.24-111.211,65.961c-38.95,22.8-77.668,46-116.486,69.023q-19.758,11.719-39.514,23.441a11.867,11.867,0,0,1-3.968,1.921c-.616-.457-1.176-.836-1.7-1.263-9.231-7.576-19.706-12.833-30.9-16.837a97.611,97.611,0,0,0-46.025-5.053,150.088,150.088,0,0,0-32.644,8.21,84.066,84.066,0,0,0-29.51,18.3,6.4,6.4,0,0,1-2.763,2.071,25.32,25.32,0,0,1-5.234-4.778,33.852,33.852,0,0,0-7.058-6.092c-11.87-7.6-23.541-15.521-35.734-22.611-6.1-3.545-12.021-7.35-17.906-11.235-17.878-11.8-35.2-24.41-52.824-36.58q-26.293-18.159-54.127-33.806c-8.5-4.8-16.995-9.591-25.114-15.03-7.206-4.828-14.519-9.5-21.78-14.242-.56-.366-1.084-.785-1.522-1.1-.142-1.083.615-1.614.933-2.341,1.127-2.572.587-4.768-1.886-5.781-3.3-1.35-6.074-3.55-9.219-5.127a79.057,79.057,0,0,1-13.468-8.321,12.935,12.935,0,0,0-1.346-.913c-3.727-2.221-6.535-1.342-8.13,2.617-.708,1.758-1.17,3.615-1.887,5.368-1.324,3.235-2.066,6.726-4.392,9.532a2.81,2.81,0,0,0,.246,3.745,10.186,10.186,0,0,0,2.136,1.853c5.467,3.525,10.96,7.014,16.72,10.051,2.8,1.478,5.7,2.661,8.7,1.128a14.87,14.87,0,0,1,4.23,3.529,56.013,56.013,0,0,0,7.258,6.511c9.768,7.31,19.43,14.776,29.638,21.469,19.278,12.639,38.11,25.918,56.938,39.208,19.939,14.074,39.724,28.347,58.886,43.477,8.829,6.972,17.847,13.71,26.911,20.376a345.107,345.107,0,0,0,31.264,20.506c.306.178.485.577.862,1.045a102.529,102.529,0,0,0-13.366,41.151c-2.113.085-3.988.215-5.864.225-11.932.068-23.864.053-35.795.173-21.964.221-43.92.914-65.889.852-11.126-.031-22.227-.568-33.325-1.155-9.34-.5-18.67-1.129-28.026-1.284-6.777-.113-13.551-.261-20.326-.557-7.986-.348-15.993-.375-23.987-.273-4.2.053-8.4.271-12.6.224-8.135-.092-16.271-.122-24.4-.232-3.116-.042-6.231-.233-9.346-.354-2.166-.085-4.332-.26-6.5-.237q-27.251.3-54.5.652c-8.409.1-16.8.325-25.069,2.139a4.817,4.817,0,0,1-3.191.013c-3.259-1.536-6.355-.695-9.359.729a20.911,20.911,0,0,0-10.209,10.617,36.162,36.162,0,0,0-3.1,13.8c-.135,3.523-.4,7.03-.615,10.545a57.343,57.343,0,0,0-.208,9.742,77.128,77.128,0,0,1-.029,10.942q-.873,30.492-1.664,60.988c-.576,22.922.651,45.82,1.048,68.728.2,11.385,1.062,22.758,1.226,34.142.312,21.691.329,43.387.486,65.081q.154,21.557.362,43.114c.042,4.338.183,8.676.242,13.014.062,4.472.181,8.946.1,13.415-.443,24.267-.855,48.53-.192,72.8.307,11.246.177,22.5.244,33.757.044,7.321.13,14.643.12,21.964q-.039,26.439-.154,52.878a160.935,160.935,0,0,0,1.877,24.3,100.239,100.239,0,0,1,1.312,20.258,81.368,81.368,0,0,0,1.5,18.606,49.968,49.968,0,0,0,6.489,16.981c3.69,6.192,9.316,9.3,16.283,10.137,3.9.47,7.833.648,11.751.963,6.888.552,13.777,1.09,20.663,1.671,2.959.249,5.91.59,8.891.892a15.135,15.135,0,0,1,1.157,1.738c2.208,4.586,6.1,6.731,10.9,7.542,1.2.2,2.423.263,3.636.385,4.044.406,8.087.831,12.134,1.211,6.745.633,13.481,1.474,20.242,1.8,12.467.6,24.94.232,37.408-.307,4.2-.182,8.408-.2,12.606-.082,7.725.22,15.444.616,23.166.9,2.3.085,4.612.128,6.912.041,12.738-.486,25.473-.811,38.224-.57,9.9.187,19.8.148,29.693.091,23.048-.134,46.088-.525,69.129-1.325,20.455-.711,40.934-.64,61.389-1.639,11.507-.562,23.041-.662,34.564-.809,14.913-.189,29.829-.189,44.744-.327,9.083-.084,18.166-.256,27.248-.422,7.864-.143,15.722-.118,23.586.194,11.785.467,23.575.856,35.367,1.056,14.233.242,28.468.375,42.7.63,21.556.386,43.1,1.1,64.636,1.953,2.167.086,4.336.137,6.5.249,12.589.654,25.175,1.384,37.767,1.963,9.614.442,19.24.629,28.856,1.059,8.936.4,17.859,1.146,26.8,1.427,17.338.545,34.7.085,52.015,1.642,7.422.668,14.87,1.073,22.313,1.466,8.25.435,16.483,1.013,24.736-.462,8.169-1.46,16.206-3.26,23.77-6.743,4.306-1.983,8.517-4.172,12.793-6.223a21.389,21.389,0,0,0,7.349-5.02c3.558-.159,7.073-.33,10.59-.47,7.179-.285,14.361-.825,21.544-.422a18.068,18.068,0,0,0,11.157-3.049,49.721,49.721,0,0,0,11.462-10.278,15.841,15.841,0,0,0,3.685-9.708c.042-1.216.188-2.43.318-3.642.5-4.712,1.217-9.4,1.363-14.151s.372-9.481.567-14.222c.138-3.381.12-6.778.459-10.14.61-6.066,1.5-12.1,2.151-18.167.536-4.984.911-9.986,1.334-14.983.981-11.615,2.163-23.215,2.031-34.9-.1-8.541-.182-17.087-.009-25.625.378-18.587-.909-37.136-1.105-55.708-.009-.813-.079-1.626-.152-2.436a171.813,171.813,0,0,1-.451-21.538c.593-16.4.989-32.8.913-49.206-.046-10.044.406-20.056.922-30.075.781-15.166,1.242-30.345,1.252-45.53.006-9.222.122-18.438.449-27.654.135-3.792.136-7.59.2-11.385.147-8.4.138-16.815.48-25.212q.985-24.2.342-48.394a211.664,211.664,0,0,1,.514-26.82c.845-8.367,1.467-16.742,1.516-25.158.015-2.571.3-5.139.433-7.71.308-6.092.831-12.184.825-18.276C1071.756,444.323,1071.148,438.912,1070.817,433.5ZM950.271,114.934c2.589-1.439,5.138-2.948,7.8-4.482a20.857,20.857,0,0,1,4.559,2.713c.677,1.9.037,3.674-.673,5.766l-12.474,7.509a5.474,5.474,0,0,1-.5-1.074,4.248,4.248,0,0,0-4.266-4.063c-1.243-.1-2.023-.62-2.085-2.265C945.106,117.711,947.708,116.358,950.271,114.934ZM256.206,161.521c-.153.643-.293,1.336-1.049,1.665-5.385-.751-4.4-.285-7.073,2.549-3.866-2.087-7.533-4.065-11.387-6.144a75.067,75.067,0,0,1,4.572-8.423,148.208,148.208,0,0,1,15.84,8.3C257.308,160.357,256.383,160.773,256.206,161.521ZM639.011,307.7c16.267-8.383,31.991-17.738,47.887-26.78,33.1-18.825,65.8-38.325,98.625-57.63,27.1-15.939,54.469-31.4,81.4-47.63q6.093-3.671,12.206-7.31c.744-.442,1.464-1.051,2.42-.815l.08-.064c.04-.016.07-.038.107-.055-.037-.416.226-.633.571-.8a1.018,1.018,0,0,0,0-.176l.4-.11a2,2,0,0,1,1.015-.281l.466-.129c-.173-.242-.007-.332.067-.119.013.036.022.053.033.078.115-.02.1.236,0,0-.04.006-.094.044-.164.152-.134.006-.269.011-.4.018l-1.015.281a1.279,1.279,0,0,0-.282.226c-.042.019-.079.041-.119.06a.863.863,0,0,1-.571.8.831.831,0,0,0,.011.169,1.689,1.689,0,0,0-.2-.05c-1.454,1.148-2.875,2.341-4.371,3.431-25.534,18.592-51.71,36.251-77.891,53.911Q741.141,264.1,683.255,303.7c-8.855,6.025-17.854,11.815-27.158,17.127-1.644.938-3.3,1.847-5.12,2.859-2.6-2.26-4.129-5.349-6.444-7.761-2.246-2.34-4.431-4.737-6.577-7.039C638.015,308.1,638.58,307.921,639.011,307.7Zm-182.773,4.939c-12.472-8.674-24.515-17.921-36.331-27.456-19-15.331-38.6-29.845-58.529-43.937s-39.859-28.138-60.241-41.564c-10.407-6.855-20.387-14.361-30.546-21.593-3.522-2.507-6.39-5.72-9.44-8.622.287-.622.695-.867,1.04-.684a15.546,15.546,0,0,1,2.01,1.368c5.307,3.994,10.632,7.965,15.9,12a198.971,198.971,0,0,0,20.154,13.721q13.32,7.827,26.661,15.618,19.151,11.171,37.386,23.779,26.382,18.327,52.813,36.584c3.344,2.309,6.714,4.608,10.237,6.622,14.716,8.413,28.816,17.817,43.243,26.693,2.888,1.777,5.713,3.608,9.095,4.4,2.127.5,3.734,2.014,5.787,3.356-1.393,1.608-2.635,3-3.832,4.435-1.217,1.456-2.372,2.964-3.588,4.42-1.2,1.439-1.969,3.234-3.447,4.395a3.159,3.159,0,0,1-.841-.348C468.312,320.923,462.247,316.816,456.238,312.638Zm13.568,43.678a112.7,112.7,0,0,1,12.978-24.795c11.007-15.705,25.148-27.518,43.65-33.643a132.809,132.809,0,0,1,35.8-6.771c12.009-.556,23.41,1.931,34.6,5.939,16.251,5.82,29.6,15.736,40.488,28.974a62,62,0,0,1,7.218,11.7,127.366,127.366,0,0,1,9.253,26.4c.055.218-.109.492-.185.8-1.408.6-2.915.285-4.381.272-14.5-.128-29.006-.337-43.5.135-15.034.488-30.071.963-45.1,1.674-9.064.43-18.1,1.326-27.16,1.962s-18.112,1.254-27.173,1.8q-13.39.8-26.79,1.433c-4.331.21-8.669.284-13,.4a2.312,2.312,0,0,1-2.027-.675C465.936,366.7,467.839,361.5,469.806,356.316ZM992.78,1006.107a184.055,184.055,0,0,1-40.017,10.435,63.655,63.655,0,0,1-13.372.545c-11.5-.728-22.982-1.6-34.467-2.482-7.565-.584-15.159-1.01-22.743-1.07-10.579-.085-21.144-.426-31.706-.939-9.341-.453-18.676-1.052-28.018-1.459-9.481-.413-18.973-.564-28.451-1.023-11.1-.539-22.19-1.292-33.286-1.94-1.894-.111-3.792-.161-5.689-.241-19.1-.809-38.2-1.528-57.308-1.984q-21.961-.523-43.921-.7c-11.8-.11-23.579-.641-35.365-1.142-7.582-.323-15.183-.368-22.774-.3q-48.607.411-97.214,1c-10.978.148-21.948.775-32.923,1.134-5.692.187-11.386.369-17.08.375-11.122.012-22.236.37-33.338.912-24.116,1.178-48.252,1.143-72.382,1.491-7.726.112-15.456-.111-23.184-.154-9.221-.051-18.43.115-27.644.639a188.475,188.475,0,0,1-23.572-.231c-9.877-.675-19.786-.55-29.684-.349-4.879.1-9.754.357-14.631.545a196.481,196.481,0,0,1-28.831-1.006c-8.352-.908-16.71-1.761-25.064-2.645-1.45-.154-2.946-.205-4.252-1.481a4.85,4.85,0,0,1,1.242-.423c7.042.009,14.056-.6,21.131-.147a153.306,153.306,0,0,0,30.441-.946,100.653,100.653,0,0,1,14.217-.46c6.508.042,13.017.022,19.524.095,3.282.037,6.453-.774,9.689-1.09a69.683,69.683,0,0,1,16.626-.115,28.631,28.631,0,0,0,6.491.044,136.582,136.582,0,0,1,15.443-.426c14.251.329,28.456-.658,42.672-1.364,4.468-.222,8.943-.377,13.416-.4q18.105-.115,36.17-1.283c2.3-.144,4.608-.131,6.913-.164,13.42-.189,26.838-.238,40.258-.691,25.617-.865,51.25-.367,76.875-.161,9.074.073,18.142.822,27.213,1.264.813.039,1.624.1,2.437.13,11.383.376,22.768.682,34.147,1.14,9.21.372,18.413.907,27.617,1.4,42.132,2.265,84.3,2.074,126.467,1.83,16.416-.095,32.8.423,49.191,1.23,1.76.086,3.523.108,5.285.156,13.417.368,26.842.559,40.249,1.163,9.217.415,18.432.4,27.647.615,10.165.239,20.324.712,30.488.9,18.036.338,36.067-.238,54.1-.531,1.356-.022,2.711-.075,4.066-.1,14.911-.254,29.83-.163,44.727-1.016,1.342-.077,2.691-.01,4.08-.01C994.388,1005.762,993.48,1005.835,992.78,1006.107Z"></path> 
                    <path d="M884.287,165.882c-.011-.025-.02-.042-.033-.078-.074-.213-.24-.123-.067.119l-.466.129c.133-.007.268-.012.4-.018C884.193,165.926,884.247,165.888,884.287,165.882Z"></path> 
                    <path d="M881.734,167.415c-.037.017-.067.039-.107.055l-.08.064a1.689,1.689,0,0,1,.2.05A.831.831,0,0,1,881.734,167.415Z"></path> <path d="M464.155,428.507c45.146.119,90.291.165,135.436.406,11.653.063,23.314.318,34.957,1.036,4.055.25,8.131.168,12.2.2,5.152.043,10.3.028,15.456.074,15.6.141,31.162,1.115,46.67,2.644,13.486,1.33,26.985,2.472,40.484,3.622,8.506.724,17.032,1.19,25.54,1.892s17,1.551,25.493,2.334a31.593,31.593,0,0,1,5.947,1.292c2.468.723,4.95,1.4,7.431,2.078a32.4,32.4,0,0,1,6.06,2.31,12.049,12.049,0,0,1,6.4,7.507,65.838,65.838,0,0,1,2.508,11.919,295.014,295.014,0,0,1,1.518,49.119c-.157,2.84-.547,5.667-.748,8.5a336.25,336.25,0,0,0-.151,39.012c.4,8.8.721,17.61.871,26.419.318,18.57.579,37.142.227,55.716q-.058,3.049.044,6.1c.432,12.476-.012,24.939-.517,37.4-.187,4.605-.362,9.22-.252,13.823.233,9.769-.239,19.508-.631,29.263-.714,17.741-1.7,35.478-1.386,53.25q.2,11.787-.067,23.582c-.244,11.11-.7,22.216-1.045,33.323a81.9,81.9,0,0,1-.724,9.32,33.561,33.561,0,0,0-.3,4.048c-.158,6.372-.793,12.7-1.437,19.042-.452,4.446-.648,8.918-.977,13.376-.439,5.951-1.025,11.868-2.83,17.614a48.82,48.82,0,0,1-11.073,19.2c-2.486,2.63-5.614,4.669-8.53,6.871-1.726,1.3-3.592,2.424-5.416,3.593a33.944,33.944,0,0,1-11.8,5.24c-2.779.542-5.317,1.971-8.144,2.5a30.933,30.933,0,0,1-6.05.575c-7.726-.093-15.454-.086-23.178-.252-4.877-.106-9.762-.3-14.619-.735-5.279-.472-10.557-.556-15.843-.553-17.087.009-34.154-.791-51.19-1.916-15.558-1.027-31.13-1.575-46.694-2.366-13.147-.668-26.287-.648-39.434-.664-9.9-.012-19.773-.738-29.653-1.265a148.467,148.467,0,0,0-17.073-.033q-14.424.894-28.861.551c-17.5-.421-34.965.315-52.428,1.308-1.894.108-3.792.148-5.689.2-25.073.684-50.148,1.067-75.232.809-16.4-.169-32.809-.244-49.21.237-8.129.239-16.256.569-24.381.92-15.582.673-31.17.788-46.76.494a263.907,263.907,0,0,0-26.413.583,93.414,93.414,0,0,1-20.682-.873c-6.568-.929-13.12-1.961-19.687-2.9a11.707,11.707,0,0,1-4.169-1.515,117.306,117.306,0,0,0-11.449-6.131,8.9,8.9,0,0,1-3.118-2.551,63.446,63.446,0,0,1-11.671-19.875,101.444,101.444,0,0,1-5.741-27.358c-.51-6.892-1.238-13.768-1.734-20.661-.33-4.595-.48-9.206-.61-13.812-.58-20.468-.479-40.937-.009-61.4.1-4.2.523-8.386.863-12.574,1.241-15.264,2.584-30.521,3.733-45.793.529-7.025.916-14.075.985-21.118.12-12.341.677-24.661,1.265-36.982.738-15.446.669-30.9.57-46.355-.077-12.064.109-24.134-.2-36.192-.384-15.187-.295-30.371.127-45.544.328-11.778.633-23.584,2.307-35.283.441-3.083,1.011-6.149,1.576-9.213,1.08-5.862,2.215-11.713,3.3-17.575a37.237,37.237,0,0,1,3.079-9.65q3.3-6.757,6.646-13.49a14.885,14.885,0,0,1,3.193-4.18A33.743,33.743,0,0,1,185,440.713a127.376,127.376,0,0,1,22.383-3.931c10.242-1.066,20.482-2.2,30.747-2.978,8.646-.651,17.326-.861,25.994-1.207,11.241-.448,22.483-.911,33.729-1.227,8.943-.252,17.892-.4,26.839-.4,16.136,0,32.266-.37,48.386-.946Q418.606,428.4,464.155,428.507Zm23.612,7.629v-.163c-13.557,0-27.114-.041-40.671.011-16.268.063-32.536,0-48.8.5-10.161.312-20.326.338-30.486.848-7.576.38-15.181.329-22.772.273-17.492-.13-34.97.372-52.45.889-.678.02-1.355.045-2.032.08-8.12.42-16.238.871-24.359,1.259-13.807.659-27.6,1.364-41.312,3.317-11.531,1.642-23.132,2.788-34.7,4.172a14.29,14.29,0,0,0-3.168.613c-2.288.831-4.5,1.862-6.785,2.712a8.728,8.728,0,0,0-4.795,4.115,129.849,129.849,0,0,0-7.985,17.775,23.239,23.239,0,0,0-.963,3.944c-1.144,6.125-2.281,12.252-3.362,18.389-.588,3.334-1.123,6.681-1.569,10.037-.966,7.272-.985,14.606-1.184,21.918q-.786,28.867-.467,57.747.129,13.824-.4,27.647c-.418,10.7-.273,21.416-.387,32.125-.094,8.814-.587,17.61-1.183,26.4-.485,7.166-.894,14.339-1.274,21.512-.6,11.37-.951,22.758-1.773,34.112-1.057,14.6-2.482,29.169-3.736,43.753-.615,7.159-1.128,14.324-1.09,21.518.068,12.472-.067,24.949.2,37.416.333,15.308.465,30.634,2.372,45.867.859,6.856,1.514,13.727,3.255,20.453a68.45,68.45,0,0,0,13.589,27c1.785,2.152,3.788,4.04,6.551,4.514a125.2,125.2,0,0,0,14.072,2.008c4.462.255,8.924.643,13.361,1.177a104.146,104.146,0,0,0,16.631.812c9.349-.373,18.7-.634,28.052-.132,3.113.168,6.225.462,9.339.483,12.336.082,24.673.157,37-.365,9.074-.385,18.151-.713,27.23-.937,13.826-.342,27.655-.253,41.484-.092,10.167.118,20.334.341,30.5.3,11.522-.044,23.045-.266,34.565-.529,9.08-.207,18.163-.448,27.231-.934,16.247-.871,32.492-1.569,48.77-1.364,6.233.078,12.485.089,18.7-.3a314.727,314.727,0,0,1,32.518-.429c12.6.512,25.2.653,37.813.587,6.233-.033,12.483,0,18.7.412,6.365.417,12.731.462,19.1.7,6.637.253,13.274.54,19.9.937,7.034.42,14.057,1.028,21.089,1.48,7.3.47,14.608.967,21.92,1.241,8.8.329,17.586,1.149,26.407,1.085,3.115-.023,6.242.077,9.345.335,5.95.5,11.9.781,17.871.745,4.475-.027,8.939,0,13.412.29,3.645.233,7.316.086,10.976.092a13.888,13.888,0,0,0,5.183-.9c3.272-1.3,6.559-2.578,9.754-4.051A48.989,48.989,0,0,0,805.1,915.483a39.263,39.263,0,0,0,8.886-21.017c.146-1.482.4-2.954.565-4.434.7-6.194,1.68-12.352,2.1-18.583.317-4.728.751-9.463,1.437-14.15a102.6,102.6,0,0,0,.866-19.467c-.151-3.38-.68-6.745-.8-10.125-.236-6.909-.207-13.828-.467-20.735-.817-21.695-.4-43.372.732-65.043.289-5.55.442-11.111.866-16.65.477-6.227.728-12.454.583-18.691-.228-9.766,0-19.515.509-29.27.443-8.527.849-17.069.478-25.61-.324-7.458-.207-14.908-.046-22.363.079-3.66.219-7.322.14-10.979-.395-18.3-.761-36.6-1.317-54.889a410.807,410.807,0,0,1,1.173-49.155,168.734,168.734,0,0,0-.269-34.105c-.336-2.961-.58-5.932-.871-8.9a81.617,81.617,0,0,0-3.1-14.278,7.455,7.455,0,0,0-3.585-4.742,43.009,43.009,0,0,0-14.533-4.972c-5.227-.734-10.514-1.081-15.785-1.454-13.518-.957-27.043-1.8-40.561-2.757-7.163-.508-14.334-1-21.469-1.791-12.264-1.364-24.574-2.088-36.88-2.821-10.282-.613-20.582-.947-30.89-.891q-6.913.037-13.827-.149c-10.839-.3-21.668-.9-32.516-.927Q547.147,436.372,487.767,436.136Z"></path> 
                    <path d="M944.824,597.456a98.627,98.627,0,0,1-31.954-5.314,67.446,67.446,0,0,1-15.991-7.888c-13.519-9.325-21.148-22.249-23.25-38.436a89.022,89.022,0,0,1-.263-22.717c4.125-32.6,28.591-53.039,53.3-57.2a30.727,30.727,0,0,1,4.416-.664c8-.164,15.964-1.087,23.971-.906,15.465.352,28.376,6.059,38.516,17.968,7.65,8.984,11.563,19.453,13.372,30.921a61.939,61.939,0,0,1-1.578,25.772,108.7,108.7,0,0,1-22.691,42.727,66.713,66.713,0,0,1-5.694,5.8,35.99,35.99,0,0,1-21.6,9.408C951.877,597.261,948.343,597.287,944.824,597.456Zm-5.787-123.391c-2.576,0-5.151-.011-7.727,0a14.038,14.038,0,0,0-4.395.683c-23.435,7.784-37.721,23.624-42.11,48.046a72.53,72.53,0,0,0,.35,25.5A41.327,41.327,0,0,0,902.9,575.93a56.478,56.478,0,0,0,12.633,6.452c12.834,4.808,26.151,5.682,39.649,4.69a25.617,25.617,0,0,0,15.105-6.378,62.247,62.247,0,0,0,6.6-6.614,87.308,87.308,0,0,0,19.533-41.427,45.968,45.968,0,0,0,.795-7.262,52.353,52.353,0,0,0-3.506-20.719c-5.746-14.7-15.822-24.69-31.687-28.092A107.335,107.335,0,0,0,939.037,474.065Z"></path> 
                    <path d="M930.494,921.978a23.645,23.645,0,0,1,.94-6c2.067-8.678,9.782-11.239,15.928-11.04a23.266,23.266,0,0,1,8.991,2.338,11.465,11.465,0,0,1,6.78,13.324c-1.322,6.63-5.133,11.492-10.839,15.014-9.1,5.617-20.982-.6-21.794-11.6C930.451,923.335,930.494,922.655,930.494,921.978Zm25.251-2.322a5.631,5.631,0,0,0-2.821-5.457,18.266,18.266,0,0,0-7.482-2.886,5.133,5.133,0,0,0-5.774,2.8,16.086,16.086,0,0,0-1.6,10.981,7.31,7.31,0,0,0,10.45,5.01A12.341,12.341,0,0,0,955.745,919.656Z"></path> 
                    <path d="M947.432,812.931c2.577-1.844,4.727-.915,6.7.815a24.968,24.968,0,0,1,5.751,7.3,9.812,9.812,0,0,1,.557,8.626,28.983,28.983,0,0,1-6.1,9.524,11.465,11.465,0,0,1-11.944,3.1A14.866,14.866,0,0,1,931,826.957a18.653,18.653,0,0,1,2.74-9.251,13.4,13.4,0,0,1,4.184-4.364C940.87,811.435,943.893,810.832,947.432,812.931Zm.574,2.331c-.851.414-1.459.709-2.066,1.006-5.532,2.7-6.91,8.551-6.52,12.51a7.36,7.36,0,0,0,6.187,6.6,4.1,4.1,0,0,0,3.469-.685,14.562,14.562,0,0,0,4.933-7.723,4.93,4.93,0,0,0-.283-3.187C952.414,820.657,950.883,817.664,948.006,815.262Z"></path> 
                    <path d="M944.792,702.042c4.7-.8,11.059,2.412,13.156,7.4a12.122,12.122,0,0,1-6.318,15.924,28.322,28.322,0,0,1-7.38,2.2c-5.281.761-9.624-.855-12.782-5.253a16.507,16.507,0,0,1-2.826-6.25c-.884-4.177.391-7.567,3.895-9.912C936.3,703.633,940.365,701.815,944.792,702.042Zm-1.493,4.9a31.61,31.61,0,0,0-5.422,4.194,3.056,3.056,0,0,0-1.095,2.1c-.183,3.375,3.072,6.706,6.4,6.388a20.56,20.56,0,0,0,4.345-.975c2.969-.965,3.8-2.5,3.233-5.561a6.021,6.021,0,0,0-2.033-3.424A10.992,10.992,0,0,0,943.3,706.939Z"></path> 
                    <path d="M931.112,769.871a15.512,15.512,0,0,1,4.051-9.207c1.86-2.089,4.088-3.483,7.069-3.339a33.675,33.675,0,0,0,3.627-.264,15.176,15.176,0,0,1,11.6,3.826,10.956,10.956,0,0,1,3.633,9.862,22.124,22.124,0,0,1-.983,4.341c-3.334,10.161-14.836,14.759-24.788,6.069C932.454,778.652,931.028,775.309,931.112,769.871Zm22.643.717a7.308,7.308,0,0,0-2.858-6.547,14.43,14.43,0,0,0-4.711-2.3,4.487,4.487,0,0,0-5.1,1.529,11.418,11.418,0,0,0-2.582,9.486c.588,3.476,4.165,6.249,7.961,6.377,3.082.1,5.912-2.34,6.792-5.9C953.48,772.31,953.609,771.368,953.755,770.588Z"></path>
                     <path d="M969.665,540.34a2.81,2.81,0,0,1,1.113,3.121,10.13,10.13,0,0,1-1.714,4.1c-3.859,5.474-8.945,8.921-15.732,9.714a52.057,52.057,0,0,1-20.52-1.706c-11.363-3.241-17.457-11.346-20.041-22.411a21.583,21.583,0,0,1,.482-10.078c3-12.148,10.663-19.8,22.532-23.358a15.322,15.322,0,0,1,8.045-.3c1.6.384,1.788.615,2.52,2.621-.6.734-1.466.515-2.236.59a28.661,28.661,0,0,0-25.4,26.446c-.385,7.028,4.324,16.931,13.365,19.92,5.1,1.687,10.361,1.942,15.658,1.971.541,0,1.084-.08,1.625-.074a20.642,20.642,0,0,0,16.992-8.069,15.005,15.005,0,0,1,2.054-1.951A5.234,5.234,0,0,1,969.665,540.34Z"></path></g></g> 
                    <g><foreignObject x="106" y="1100" width="660" height="300" style="line-height:1.2em;font-size:40px;fill:#3b3b3b;font-family:'Bryso Letter Gothic Bold';color:var(--simple-colors-default-theme-accent-12)"  >
                    <div style="width:100%;height:100%;display:flex;">
                    <div xmlns="http://www.w3.org/1999/xhtml" class="first-line-para">
                    <div style="font-size: 80px;line-height:80px;margin-top:-10px;">${this.name}</div>
                    <div style="font-size: 60px;line-height:60px;margin:10px 0;">${this.position}</div>
                    <div style="font-size: 60px;line-height:60px;margin:10px 0;">${this.organization}</div>
                    <g  data-name="photo"><g clip-path="url(#tv-clip-path)">
                    </div>
                    </div>
                    </foreignObject>
                      ${this.logo?a`<image class="logo" href="${this.logo}" height="300" width="200" x="880" y="1050"/>`:""}
                    </g>
                  </g>  
                </g>     
            </g>
        </svg>
    </div>
</div>

                    
                    
    `}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(EventBadge.tag,EventBadge);export{EventBadge};