/**
 * Copyright 2022 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as m,css as t}from"../../lit/index.js";import{MicroFrontendRegistry as a}from"../micro-frontend-registry/micro-frontend-registry.js";import{enableServices as r}from"../micro-frontend-registry/lib/microServices.js";r(["haxcms"]),a.add({endpoint:"/api/services/text/textVide",name:"@enhancedText/textVide",title:"text-vide",description:"Enhance readability of text based on brain science",params:{body:"Block of text to enhance"}});class EnhancedText extends e{constructor(){super(),this.loading=!1,this.auto=!1,this.fixationPoint=4,this.vide=!1,this.wikipedia=!1,this.haxcmsGlossary=!1,this.haxcmsSiteLocation="",this.haxcmsSite=null,this.haxcmsMarkAll=!1}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this.auto&&this.enhance()}applyTermFromList(e){if(e.status&&e.data&&e.data.length){import("../vocab-term/vocab-term.js");let r=[...this.childNodes].filter((e=>3===e.nodeType)).filter((e=>e.textContent.trim()));if(0===r.length){const e=this.innerText;this.innerHTML="",e.split(/\s|\.+/).forEach((e=>{const m=globalThis.document.createTextNode(e);this.appendChild(m),this.appendChild(document.createTextNode(" "))})),r=[...this.childNodes].filter((e=>3===e.nodeType)).filter((e=>e.textContent.trim()))}if(1===r.length){const e=r[0].textContent;r[0].remove(),e.split(/\s|\.+/).forEach((e=>{const m=globalThis.document.createTextNode(e);this.appendChild(m),this.appendChild(document.createTextNode(" "))})),r=[...this.childNodes].filter((e=>3===e.nodeType)).filter((e=>e.textContent.trim()))}for(var m=0;m<e.data.length;m++){let i=e.data[m],o=!1;for(var t=0;t<r.length;t++){let e=r[t];if(e.textContent.toLowerCase()==i.term.toLowerCase()&&(!o||this.haxcmsMarkAll)){let m=globalThis.document.createElement("vocab-term");if(m.term=e.textContent,m.information=i.definition,i.links&&i.links.length>0){let e=globalThis.document.createElement("div");e.classList.add("links");for(var a=0;a<i.links.length;a++){let m=globalThis.document.createElement("a");m.href=i.links[a].href,m.innerText=i.links[a].title,e.appendChild(m)}m.appendChild(e)}e.parentNode.insertBefore(m,e),m.appendChild(e),o=!0}}}}}async enhance(){const e=this.innerHTML;this.loading=!0,this.vide&&await a.call("@enhancedText/textVide",{body:e,fixationPoint:this.fixationPoint},this.enahncedTextResponse.bind(this)),this.haxcmsGlossary&&(this.haxcmsSiteLocation||this.haxcmsSite)&&(this.haxcmsSite?await a.call("@haxcms/termsInPage",{body:e,type:"site",site:this.haxcmsSite,wikipedia:this.wikipedia},this.applyTermFromList.bind(this)):await a.call("@haxcms/termsInPage",{body:e,type:"link",site:this.haxcmsSiteLocation,wikipedia:this.wikipedia},this.applyTermFromList.bind(this))),this.loading=!1}static get properties(){return{wikipedia:{type:Boolean,reflect:!0},vide:{type:Boolean,reflect:!0},fixationPoint:{type:Number,attribute:"fixation-point"},haxcmsGlossary:{type:Boolean,attribute:"haxcms-glossary"},haxcmsSiteLocation:{type:String,attribute:"haxcms-site-location"},haxcmsSite:{type:Object,attribute:"haxcms-site"},haxcmsMarkAll:{type:Boolean,attribute:"haxcms-mark-all"},loading:{type:Boolean,reflect:!0},auto:{type:Boolean,reflect:!0}}}enahncedTextResponse(e){if(e.status&&e.data&&e.data.length){let m=(new DOMParser).parseFromString(e.data,"text/html");this.innerHTML=m.body.innerHTML}}static get styles(){let e=[];return super.styles&&(e=super.styles),[e,t`
        :host {
          display: block;
        }
        div::slotted(bold) {
          font-weight: 800;
        }
        :host([loading]) .loading {
          margin: 8px 0 0 -12px;
          font-size: 2px;
          width: 4px;
          height: 4px;
          border-radius: 50%;
          position: absolute;
          -webkit-animation: load5 1.1s infinite ease;
          animation: load5 1.1s infinite ease;
          -webkit-transform: translateZ(0);
          -ms-transform: translateZ(0);
          transform: translateZ(0);
        }
        @-webkit-keyframes load5 {
          0%,
          100% {
            box-shadow:
              0em -2.6em 0em 0em var(--enhanced-text-color, #000000),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.5),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7);
          }
          12.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.7),
              1.8em -1.8em 0 0em var(--enhanced-text-color, #000000),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5);
          }
          25% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.5),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7),
              2.5em 0em 0 0em var(--enhanced-text-color, #000000),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          37.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.7),
              1.75em 1.75em 0 0em var(--enhanced-text-color, #000000),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          50% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.5),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.7),
              0em 2.5em 0 0em var(--enhanced-text-color, #000000),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          62.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.5),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.7),
              -1.8em 1.8em 0 0em var(--enhanced-text-color, #000000),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          75% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.5),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.7),
              -2.6em 0em 0 0em var(--enhanced-text-color, #000000),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          87.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.5),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.7),
              -1.8em -1.8em 0 0em var(--enhanced-text-color, #000000);
          }
        }
        @keyframes load5 {
          0%,
          100% {
            box-shadow:
              0em -2.6em 0em 0em var(--enhanced-text-color, #000000),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.5),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7);
          }
          12.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.7),
              1.8em -1.8em 0 0em var(--enhanced-text-color, #000000),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5);
          }
          25% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.5),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.7),
              2.5em 0em 0 0em var(--enhanced-text-color, #000000),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          37.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.5),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.7),
              1.75em 1.75em 0 0em var(--enhanced-text-color, #000000),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          50% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.5),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.7),
              0em 2.5em 0 0em var(--enhanced-text-color, #000000),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.2),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          62.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.5),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.7),
              -1.8em 1.8em 0 0em var(--enhanced-text-color, #000000),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          75% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.5),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.7),
              -2.6em 0em 0 0em var(--enhanced-text-color, #000000),
              -1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2);
          }
          87.5% {
            box-shadow:
              0em -2.6em 0em 0em rgba(255, 255, 255, 0.2),
              1.8em -1.8em 0 0em rgba(255, 255, 255, 0.2),
              2.5em 0em 0 0em rgba(255, 255, 255, 0.2),
              1.75em 1.75em 0 0em rgba(255, 255, 255, 0.2),
              0em 2.5em 0 0em rgba(255, 255, 255, 0.2),
              -1.8em 1.8em 0 0em rgba(255, 255, 255, 0.5),
              -2.6em 0em 0 0em rgba(255, 255, 255, 0.7),
              -1.8em -1.8em 0 0em var(--enhanced-text-color, #000000);
          }
        }
      `]}render(){return m`
      <div class="loading"></div>
      <slot></slot>
    `}static get tag(){return"enhanced-text"}static get haxProperties(){return{gizmo:{title:"Enhanced text",description:"Add content look up to a blob of text"},setttings:{configure:[{slot:"",title:"Text to process",description:"Text that will be enhanced"},{property:"wikipedia",type:"boolean",title:"Wikipedia articles",description:"Enhance found definitions in glossary with possibly related wikipedia article links"},{property:"haxcmsGlossary",type:"boolean",title:"haxcms: Glossary",description:"Automatically link to definitions found on the /glossary page of a haxcms site"},{property:"haxcmsSiteLocation",type:"textfield",title:"haxcms: site url",description:"Link to the HAXcms site to leverage for glossary of terms"},{property:"haxcmsSite",type:"textarea",title:"haxcms: site",description:"JSON blob of the site.json file itself"}]}}}}customElements.define(EnhancedText.tag,EnhancedText);export{EnhancedText};