/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as i,css as e}from"../../lit/index.js";import{SimpleColors as t}from"../simple-colors/simple-colors.js";import"../simple-icon/simple-icon.js";import"../simple-icon/lib/simple-icons.js";import"../hax-iconset/lib/simple-hax-iconset.js";class ElmslnLoading extends t{static get styles(){return[super.styles,e`
        @-moz-keyframes spin {
          100% {
            -moz-transform: rotate(60deg);
            filter: saturate(10) invert(0.9);
          }
        }
        @-webkit-keyframes spin {
          100% {
            -webkit-transform: rotate(60deg);
            filter: saturate(10) invert(0.9);
          }
        }
        @keyframes spin {
          100% {
            -webkit-transform: rotate(60deg);
            transform: rotate(60deg);
          }
        }
        :host simple-icon {
          display: block;
          -webkit-animation: spin 1.25s ease-out infinite;
          -moz-animation: spin 1.25s ease-out infinite;
          animation: spin 1.25s ease-out infinite;
        }
        :host([size="tiny"]) simple-icon {
          --simple-icon-width: 16px;
          --simple-icon-height: 16px;
          -webkit-animation: spin 0.75s ease-out infinite;
          -moz-animation: spin 0.75s ease-out infinite;
          animation: spin 0.75s ease-out infinite;
        }
        :host([size="small"]) simple-icon {
          --simple-icon-width: 32px;
          --simple-icon-height: 32px;
          -webkit-animation: spin 1s ease-out infinite;
          -moz-animation: spin 1s ease-out infinite;
          animation: spin 1s ease-out infinite;
        }
        :host([size="medium"]) simple-icon {
          --simple-icon-width: 64px;
          --simple-icon-height: 64px;
          -webkit-animation: spin 1.25s ease-out infinite;
          -moz-animation: spin 1.25s ease-out infinite;
          animation: spin 1.25s ease-out infinite;
        }
        :host([size="large"]) simple-icon {
          --simple-icon-width: 80px;
          --simple-icon-height: 80px;
          -webkit-animation: spin 1.25s ease-out infinite;
          -moz-animation: spin 1.25s ease-out infinite;
          animation: spin 1.25s ease-out infinite;
        }
        :host([size="epic"]) simple-icon {
          --simple-icon-width: 400px;
          --simple-icon-height: 400px;
          -webkit-animation: spin 2s ease-out infinite;
          -moz-animation: spin 2s ease-out infinite;
          animation: spin 2s ease-out infinite;
        }
      `]}static get tag(){return"elmsln-loading"}constructor(){super(),this.size="medium",this.dark=!1}updated(i){i.forEach(((i,e)=>{"color"==e&&this._getAccentColor(this[e])}))}static get properties(){return{...super.properties,dark:{type:Boolean},color:{type:String},contrast:{type:Number},size:{type:String,reflect:!0}}}render(){return i`
      <simple-icon
        icon="lrn:network"
        accent-color="${this.accentColor}"
        contrast="${this.contrast}"
        ?dark="${this.dark}"
      ></simple-icon>
    `}_getAccentColor(i){i=i.replace("-text",""),this.accentColor&&"grey"!==this.accentColor||!this.colors[i]||(this.accentColor=i)}}customElements.define(ElmslnLoading.tag,ElmslnLoading);export{ElmslnLoading};