/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../lit/index.js";import{DDD as s}from"../../d-d-d/d-d-d.js";import{editableTableCellStyles as o}from"./editable-table-behaviors.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import"../../hax-iconset/lib/simple-hax-iconset.js";import{SimpleToolbarButtonBehaviors as i}from"../../simple-toolbar/lib/simple-toolbar-button.js";class EditableTableSort extends(i(s)){static get styles(){return[...super.styles||[],...o,e`
        :host {
          display: block;
          font-family: inherit;
          font-size: inherit;
        }
        :host > div {
          display: flex;
          align-items: center;
          justify-content: space-between;
          width: 100%;
        }
        button {
          flex: 0 0 auto !important;
          width: auto !important;
        }
        #cell {
          flex: 1 1 auto !important;
          display: inline-block;
          padding: var(--ddd-spacing-1);
        }
      `]}static get tag(){return"editable-table-sort"}static get properties(){return{...super.properties,columnIndex:{attribute:"column-index",type:Number,reflect:!0},sortMode:{attribute:"sort-mode",type:String,reflect:!0},sortColumn:{attribute:"sort-column",type:Number,reflect:!0}}}render(){return t`
      <div>
        <slot id="cell"></slot>
        <span class="offscreen asc">(ascending)</span>
        <span class="offscreen desc">(descending)</span>
        ${super.render()}
      </div>
    `}constructor(){super(),this.sortMode="none",this.sortColumn=-1,this.toggles=!0,this.icon="editable-table:sortable",this.label="Toggle sort mode.",this.tooltip="Toggles sorting by this column.",this.describedby="cell"}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"columnIndex"==e&&(this.toggled=this.columnIndex===this.sortColumn),"sortMode"!=e&&"columnIndex"!=e||(this.icon="asc"==this.sortMode?"arrow-drop-up":"desc"==this.sortMode?"arrow-drop-down":"editable-table:sortable")}))}_handleClick(){this.dispatchEvent(new CustomEvent("change-sort-mode",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}}customElements.define(EditableTableSort.tag,EditableTableSort);export{EditableTableSort};