/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../lit/index.js";import{DDD as i}from"../../d-d-d/d-d-d.js";import{editableTableCellStyles as l}from"./editable-table-behaviors.js";import"../../simple-tooltip/simple-tooltip.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/lib/simple-icon-button-lite.js";import"../../hax-iconset/lib/simple-hax-iconset.js";import{SimpleToolbarButtonBehaviors as o}from"../../simple-toolbar/lib/simple-toolbar-button.js";class EditableTableFilter extends(o(i)){static get styles(){return[...super.styles||[],...l,e`
        :host {
          display: block;
          font-family: inherit;
          font-size: inherit;
        }
        :host > div {
          display: flex;
          align-items: center;
          justify-content: space-between;
          width: 100%;
        }
        button {
          flex: 0 0 auto !important;
          width: auto !important;
        }
        #cell {
          flex: 1 1 auto !important;
          display: inline-block;
          padding: var(--ddd-spacing-1);
        }
      `]}render(){return t`<div><slot id="cell"></slot>${super.render()}</div> `}static get properties(){return{...super.properties,columnIndex:{type:Number,attribute:"column-index"},text:{type:String,attribute:"text"}}}static get tag(){return"editable-table-filter"}constructor(){super(),this.columnIndex=null,this.filtered=!1,this.text="",this.toggles=!0,this.icon="editable-table:filter",this.label="Toggle filter.",this.tooltip="Toggle filter for column.",this.describedby="cell"}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"columnIndex"==e&&(this.tooltip=`Toggle Column ${this.columnIndex} filter.`)}))}_handleClick(t){this.dispatchEvent(new CustomEvent("toggle-filter",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}}customElements.define(EditableTableFilter.tag,EditableTableFilter);export{EditableTableFilter};