/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../lit/index.js";import{DDD as o}from"../../d-d-d/d-d-d.js";import{cellBehaviors as i,editableTableCellStyles as r}from"./editable-table-behaviors.js";import"../../a11y-menu-button/lib/a11y-menu-button-item.js";import{SimpleToolbarMenuBehaviors as s}from"../../simple-toolbar/lib/simple-toolbar-menu.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import"../../hax-iconset/lib/simple-hax-iconset.js";class EditableTableEditorRowcol extends(s(i(o))){static get styles(){return[...super.styles||[],...r,e`
        :host {
          display: block;
        }
        :host [part="button"],
        :host [part="button"]:focus,
        :host(:focus-within) [part="button"],
        :host(:hover) [part="button"],
        :host [part="button"]:hover {
          border-radius: 0;
          background-color: transparent;
          border: none;
        }
        [role="menuitem"] {
          --simple-toolbar-button-hover-border-color: transparent;
        }
        [role="menuitem"]::part(button):hover,
        [role="menuitem"]::part(button):focus,
        [role="menuitem"]::part(button):focus-within {
          border: none;
          background-color: var(
            --editable-table-rowcol-hover-bg-color,
            var(--editable-table-stripe-bg-color, #f0f0f0)
          );
        }
      `]}static get tag(){return"editable-table-editor-rowcol"}static get properties(){return{...super.properties,index:{type:Number},row:{type:Boolean}}}get type(){return this.row?"Row":"Column"}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"index"===e&&(this.controls=this.row?`cell-0-${this.index}`:`cell-${this.index}-0`),"index"!==e&&"row"!==e||(this.label=this.row?this._getLabel(this.index,!0):this._getLabel(this.index,!1)),"row"===e&&(this.position=this.row?"right":"bottom")}))}get listItemTemplate(){return t`
      <slot name="menuitem">
        ${this._getItem()} ${this._getItem(!1,!0)} ${this._getItem(!0)}
      </slot>
      <slot></slot>
    `}rowColAction(t=this.index,e=!0){this.dispatchEvent(new CustomEvent("rowcol-action",{bubbles:!0,cancelable:!0,composed:!0,detail:{insert:e,row:this.row,index:t}}))}_getItem(e=!1,o=!1){let i=`${e?"Delete ":"Insert "}${this.type}${e?"":o?" After ":" Before "}`;return t` <simple-toolbar-menu-item slot="menuitem">
      <simple-toolbar-button
        role="menuitem"
        label="${i}"
        show-text-label
        align-horizontal="left"
        @button-toggled="${e?this._onDelete:o?this._onInsertAfter:this._onInsertBefore}"
      >
      </simple-toolbar-button>
    </simple-toolbar-menu-item>`}_onDelete(t){this.rowColAction(this.index,!1)}_onInsertBefore(t){this.rowColAction(this.row?this.index-1:this.index)}_onInsertAfter(t){this.rowColAction(this.row?this.index:this.index+1)}}customElements.define(EditableTableEditorRowcol.tag,EditableTableEditorRowcol);export{EditableTableEditorRowcol};