/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../lit/index.js";import{DDD as i}from"../../d-d-d/d-d-d.js";import{displayBehaviors as s,editableTableDisplayStyles as l}from"./editable-table-behaviors.js";import{ResponsiveUtilityBehaviors as o}from"../../responsive-utility/lib/responsive-utility-behaviors.js";import"../../simple-picker/simple-picker.js";import"../../simple-toolbar/lib/simple-toolbar-button.js";class EditableTableDisplay extends(s(o(i))){static get styles(){return[...super.styles||[],...l,e`
        :host([hidden]),
        :host([disabled]) {
          display: none !important;
        }
        [part="caption"] simple-toolbar-button {
          --simple-toolbar-button-bg: var(--editable-table-bg-color, #fff);
          --simple-toolbar-button-toggled-bg: var(
            --editable-table-stripe-bg-color,
            #f0f0f0
          );
          --simple-toolbar-button-hover-bg: var(
            --editable-table-bg-color,
            #fff
          );
          --simple-toolbar-button-border-color: var(
            --editable-table-border-color,
            #999
          );
          --simple-toolbar-button-toggled-border-color: var(
            --editable-table-color,
            #222
          );
          --simple-toolbar-button-hover-border-color: unset;
        }
      `]}render(){return t`
      <table
        id="table"
        ?bordered="${this.bordered}"
        class="table"
        ?column-header="${this.columnHeader}"
        ?column-striped="${this.columnStriped}"
        ?condensed="${this.condensed}"
        ?filter="${this.filter}"
        ?footer="${this.footer}"
        ?hidden="${this.hidden||this.disabled}"
        ?numeric-styles="${this.numericStyles}"
        ?row-header="${this.rowHeader}"
        ?sort="${this.sort}"
        ?striped="${this.striped}"
        part="table"
      >
        <caption part="caption">
          <div>
            <div>${this.getHTML(this.caption)}</div>
            <div>
              ${this.downloadable?t`
                    <simple-toolbar-button
                      id="download"
                      icon="file-download"
                      label="Download as CSV."
                      @click="${this.download}"
                    >
                    </simple-toolbar-button>
                  `:""}
              ${this.printable?t`
                    <simple-toolbar-button
                      id="print"
                      icon="print"
                      label="Print Table"
                      @click="${this.print}"
                    >
                    </simple-toolbar-button>
                  `:""}
            </div>
          </div>
        </caption>
        <thead ?hidden="${!this.columnHeader}" class="thead" part="thead">
          <tr class="tr thead-tr" part="tr">
            ${(this.thead[0]||[]).map(((e,i)=>t`
                <th
                  class="th th-or-td"
                  cell-index="${i}"
                  ?numeric="${this._isNumericColumn(i)}"
                  scope="col"
                  part="th"
                  ?xs-hidden="${this._isColHidden(i,this.selected||1)}"
                >
                  ${this.sort?t`
                        <editable-table-sort
                          column-index="${i}"
                          sort-column="${this.sortColumn}"
                          sort-mode="${this.sortColumn===i?this.sortMode:"none"}"
                        >
                          ${this.getHTML(this._replaceBlankCell(e))}
                        </editable-table-sort>
                      `:this.getHTML(this._replaceBlankCell(e))}
                  ${!this.disableResponsive&&i>0&&this.selected==i?t` <simple-picker
                          id="simple-picker-${i}"
                          class="column"
                          align-right
                          aria-label="Select Column"
                          @change="${this._selectedChanged}"
                          hide-sample
                          .options="${this.options}"
                          .value="${i}"
                        >
                        </simple-picker>
                        <simple-tooltip
                          position="top"
                          for="simple-picker-${i}"
                          aria-hidden="true"
                          >Select Column</simple-tooltip
                        >`:""}
                </th>
              `))}
          </tr>
        </thead>
        <tbody class="tbody" part="tbody">
          ${this.sortedTbody.map((t=>this._isRowFiltered(t)?"":this._tbodyTr(t)))}
        </tbody>
        ${this.footer?t`
              <tfoot class="tfoot" part="tfoot">
                ${this._tbodyTr(this.tfoot[0],!0,!0)}
              </tfoot>
            `:""}
      </table>
      <div id="htmlImport" hidden><slot></slot></div>
    `}static get tag(){return"editable-table-display"}static get properties(){return{...s.properties,...o.properties,filterColumn:{type:Number,attribute:"filter-column"},filterContains:{type:Boolean,attribute:"filter-contains"},filterCaseSensitive:{type:Boolean,attribute:"filter-case-sensitive"},filtered:{type:Boolean},filterText:{type:String,attribute:"filter-text"},selected:{type:Number},sortMode:{type:String,attribute:"sort-mode"},sortColumn:{type:Number,attribute:"sort-column"}}}constructor(){super(),this.selected=1,this.sortMode="none",this.sortColumn=-1,this.filterContains=!0,import("./editable-table-sort.js"),import("./editable-table-filter.js"),this._observer=new MutationObserver((t=>{this.shadowRoot&&this.importHTML(this.children.item(0))})),this._observer.observe(this,{childList:!0,subtree:!0})}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"data"===e&&(this.disabled=!this.data||this.data.length<1||this.data[0].length<1),!["disabled","hidden"].includes(e)||this.hidden||this.disabled||this.toggleFilter()}))}connectedCallback(){super.connectedCallback(),setTimeout((()=>{this.addEventListener("change-sort-mode",this._changeSortMode.bind(this)),this.addEventListener("toggle-filter",this.toggleFilter.bind(this))}),0)}disconnectedCallback(){this.removeEventListener("change-sort-mode",this._changeSortMode.bind(this)),this.removeEventListener("toggle-filter",this.toggleFilter.bind(this)),super.disconnectedCallback()}get options(){return((this.thead||[[]])[0]||[]).map(((t,e)=>[{alt:t,value:e}]))}get sortedTbody(){if("none"!==this.sortMode&&!1!==this.sortMode){let t=this.tbody.map((t=>[t[this.sortColumn],...t]));return"asc"===this.sortMode?t.sort():t.reverse(),t.map((t=>t.slice(1,t.length)))}return this.tbody}toggleFilter(t){void 0===t||this.filterColumn==t.detail.columnIndex&&this.filtered?(this.filtered=!1,this.filterText=void 0,this.filterColumn=void 0):(this.filterText=t.detail.text,this.filterColumn=t.detail.columnIndex,this.filtered=!0)}_dataChanged(t,e){if(!t||t.length<1||t[0].length<1){let t=this.children.item(0);null!=t&&"TABLE"===t.tagName&&this.importHTML(t)}this.dispatchEvent(new CustomEvent("change",{bubbles:!0,cancelable:!0,composed:!0,detail:t}))}_changeSortMode(t){this.sortColumn===t.detail.columnIndex&&"asc"===this.sortMode?this.sortMode="desc":this.sortColumn===t.detail.columnIndex&&"desc"===this.sortMode?this.sortMode="none":(this.sortMode="asc",this.sortColumn=t.detail.columnIndex)}_isColHidden(t,e=1){return e=e||1,0!==parseInt(t)&&parseInt(t)!==parseInt(e)}_isCellFiltered(t,e,i){return!!e&&e===t&&i}_selectedChanged(t){t.detail.value&&(this.selected=t.detail.value)}_tableChanged(){this.selected=1}_tbodyTr(e=[],i=!1,s=!1){return t`
      <tr class="tr ${s?"tfoot-tr":"tbody-tr"}">
        ${e.map(((t,e)=>this._isRowHeader(this.rowHeader,e)?this._tbodyTh(t,e):this._tbodyTd(t,e,i)))}
      </tr>
    `}_tbodyTh(e,i){return t`<th
      class="th th-or-td"
      cell-index="${i}"
      ?numeric="${this._isNumericColumn(i)}"
      scope="row"
      ?xs-hidden="${this._isColHidden(i,this.selected||1)}"
    >
      ${this.getHTML(this._replaceBlankCell(e))}
    </th>`}_tbodyTd(e,i,s=!1){return t`<td
      part="td"
      class="td th-or-td"
      cell-index="${i}"
      ?numeric="${this._isNumericColumn(i)}"
      ?negative="${this._isNegative(e)}"
      ?xs-hidden="${this._isColHidden(i,this.selected||1)}"
    >
      ${this.filter?t`
            <editable-table-filter
              class="cell"
              column-index="${i}"
              text="${this._replaceBlankCell(e)}"
              ?toggled="${this._isCellFiltered(i,this.filterColumn,this.filtered)}"
            >
              ${this.getHTML(this._replaceBlankCell(e))}
            </editable-table-filter>
          `:s?this.getHTML(this._replaceBlankCell(e)):t`<span class="cell"
              >${this.getHTML(this._replaceBlankCell(e))}</span
            >`}
    </td>`}_updateCols(t){let e=this.shadowRoot.querySelector("#column").value,i=this.shadowRoot.querySelector("#table").querySelectorAll("th,td");if(i.length>0)for(let t=0;t<i.length;t++){let s=i[t];this._isColHidden(s.cellIndex,e)?s.setAttribute("xs-hidden",!0):s.removeAttribute("xs-hidden")}}}customElements.define(EditableTableDisplay.tag,EditableTableDisplay);export{EditableTableDisplay};