/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../../lit/index.js";export const editableTableCellStyles=[e``];export const editableTableStyles=[e`
    :host {
      display: block;
      width: 100%;
      max-width: 100%;
      margin: var(--ddd-spacing-4) 0;
      font-size: var(--editable-table-font-size, unset);
      font-family: var(--editable-table-font-family, inherit);
      font-weight: var(--editable-table-medium-weight, 300);
      color: var(--editable-table-color, #222);
      background-color: var(--editable-table-bg-color, #fff);
    }
    :host([hidden]) {
      display: none;
    }
    .offscreen {
      position: absolute;
      left: -9999px;
      font-size: 0;
      height: 0;
      width: 0;
      overflow: hidden;
      margin: 0;
      padding: 0;
    }
    table {
      width: calc(100% - 2 * var(--editable-table-border-width, 1px));
      display: table;
      border-collapse: collapse;
      border-width: var(--editable-table-border-width, 1px);
      border-style: var(--editable-table-border-style, solid);
      border-color: var(--editable-table-border-color, #999);
      font-weight: var(--editable-table-light-weight, 200);
      color: var(--editable-table-color, #222);
      background-color: var(
        --editable-table-bg-color,
        var(--ddd-theme-default-white, #fff)
      );
    }
    .th,
    .td,
    .th-or-td .icon-container {
      font-weight: var(--editable-table-light-weight, 200);
      color: var(--editable-table-color, #222);
      background-color: var(
        --editable-table-bg-color,
        var(--ddd-theme-default-white, #fff)
      );
    }
    caption {
      font-size: var(
        --editable-table-caption-font-size,
        var(--editable-table-font-size, unset)
      );
      font-weight: var(--editable-table-heavy-weight, 600);
      color: var(
        --editable-table-caption-color,
        var(--editable-table-color, #222)
      );
      background-color: var(
        --editable-table-caption-bg-color,
        var(--editable-table-bg-color, #fff)
      );
      width: 100%;
    }
    .tr {
      display: table-row;
    }
    .th-or-td {
      display: table-cell;
    }
    .thead-tr .th,
    .thead-tr .th .icon-container {
      background-color: var(
        --editable-table-heading-bg-color,
        var(--ddd-theme-default-limestoneLight, #e0e0e0)
      );
      font-weight: var(--editable-table-heavy-weight, 600);
      color: var(
        --editable-table-heading-color,
        var(--ddd-theme-default-coalyGray, #000)
      );
    }
    .tbody-tr .th,
    .tbody-tr .th .icon-container {
      font-weight: var(--editable-table-heavy-weight, 600);
      color: var(
        --editable-table-heading-color,
        var(--ddd-theme-default-coalyGray, #000)
      );
      background-color: var(
        --editable-table-bg-color,
        var(--ddd-theme-default-white, #fff)
      );
      text-align: left;
    }
    *[bordered] .th,
    *[bordered] .td {
      border-width: var(--editable-table-border-width, 1px);
      border-style: var(--editable-table-border-style, solid);
      border-color: var(
        --editable-table-border-color,
        var(--ddd-theme-default-coalyGray, #999)
      );
    }
    *[condensed] {
      --editable-table-cell-vertical-padding: var(
        --editable-table-cell-vertical-padding-condensed,
        2px
      );
      --editable-table-cell-horizontal-padding: var(
        --editable-table-cell-horizontal-padding-condensed,
        4px
      );
    }
    *[striped] .tbody-tr:nth-child(2n + 1) .th-or-td,
    *[striped] .tbody-tr:nth-child(2n + 1) .th-or-td .icon-container {
      background-color: var(
        --editable-table-stripe-bg-color,
        var(--ddd-theme-default-limestoneMaxLight, #f0f0f0)
      );
    }
    *[column-striped] .tbody-tr .th-or-td:nth-child(2n),
    *[column-striped] .tbody-tr .th-or-td:nth-child(2n) .icon-container,
    *[column-striped] .tfoot-tr .th-or-td:nth-child(2n),
    *[column-striped] .tfoot-tr .th-or-td:nth-child(2n) .icon-container {
      background-color: var(
        --editable-table-stripe-bg-color,
        var(--ddd-theme-default-limestoneMaxLight, #f0f0f0)
      );
    }
    .tfoot-tr .th,
    .tfoot-tr .td {
      border-top: 2px solid var(--editable-table-color, #222);
      font-weight: var(--editable-table-heavy-weight, 600);
      color: var(
        --editable-table-heading-color,
        var(--ddd-theme-default-coalyGray, #000)
      );
    }
    caption,
    .th-or-td {
      text-align: left;
    }
    *[numeric-styles] .thead-tr .th-or-td[numeric],
    *[numeric-styles] .tfoot-tr .th-or-td[numeric],
    *[numeric-styles] .th-or-td[numeric] .cell {
      text-align: right;
      --editable-table-cell-justify: flex-end;
    }
    *[numeric-styles] .tfoot-tr .th-or-td[negative],
    *[numeric-styles] .td[negative] .cell {
      color: var(--editable-table-negative-color, red);
      --editable-table-cell-color: var(--editable-table-negative-color, red);
    }
    editable-table-display ::slotted(table) {
      display: none;
    }
    @media screen {
      :host {
        width: 100%;
        max-width: 100%;
      }
      :host([responsive]) {
        overflow-x: visible;
      }
    }
  `];export const editableTableDisplayStyles=[...editableTableStyles,e`
    caption {
      padding-top: var(--editable-table-cell-vertical-padding, 10px);
      padding-bottom: var(--editable-table-cell-vertical-padding, 10px);
      padding: 0;
    }
    caption > div {
      display: flex;
      align-items: flex-end;
      justify-content: space-between;
    }
    caption > div > div {
      flex: 1 1 auto;
    }
    caption > div > div:last-child {
      flex: 0 0 auto;
    }
    caption button {
      padding: 2px;
      margin: 0;
    }
    .column {
      width: calc(var(--simple-picker-option-size) + 6px);
      overflow: visible;
      display: none;
      margin-right: 0px;
      --simple-picker-border-width: 1px;
      --simple-picker-focus-border-width: 1px;
      --simple-picker-border-color: var(
        --editable-table-border-color,
        var(--ddd-theme-default-coalyGray, #999)
      );
    }
    .th,
    .td {
      padding: var(
          --editable-table-cell-vertical-padding,
          var(--ddd-spacing-3, 10px)
        )
        var(--editable-table-cell-horizontal-padding, var(--ddd-spacing-2, 6px));
    }
    span.cell {
      display: block;
    }
    @media screen {
      :host([responsive][responsive-size="xs"]) .column {
        display: inline-flex;
        width: 30px;
        overflow: visible;
      }
      :host([responsive][responsive-size="xs"]) .th[xs-hidden],
      :host([responsive][responsive-size="xs"]) .td[xs-hidden] {
        display: none;
      }
    }
  `];export const displayProperties={bordered:{attribute:"bordered",type:Boolean},columnStriped:{attribute:"column-striped",type:Boolean},condensed:{attribute:"condensed",type:Boolean},disabled:{type:Boolean,attribute:"disabled",reflect:!0},hidden:{type:Boolean,attribute:"hidden",reflect:!0},numericStyles:{attribute:"numeric-styles",type:Boolean,reflect:!0},responsive:{attribute:"responsive",type:Boolean,reflect:!0},striped:{attribute:"striped",type:Boolean}};export const editProperties={config:{type:Array},hideBordered:{type:Boolean,attribute:"hide-bordered"},hideCondensed:{type:Boolean,attribute:"hide-condensed"},hideDownloadable:{type:Boolean,attribute:"hide-downloadable"},hideFilter:{type:Boolean,attribute:"hide-filter"},hideNumericStyles:{type:Boolean,attribute:"hide-numeric-styles"},hidePrintable:{type:Boolean,attribute:"hide-printable"},hideResponsive:{type:Boolean,attribute:"hide-responsive"},hideSort:{type:Boolean,attribute:"hide-sort"},hideStriped:{type:Boolean,attribute:"hide-striped"}};export const dataProperties={downloadable:{attribute:"downloadable",type:Boolean,reflect:!0},filter:{attribute:"filter",type:Boolean,reflect:!0},printable:{attribute:"printable",type:Boolean,reflect:!0},sort:{attribute:"sort",type:Boolean,reflect:!0}};export const tableHtmlProperties={caption:{type:String},columnHeader:{attribute:"column-header",type:Boolean},csvData:{type:String,attribute:"csv-data"},data:{type:Array},dataCsv:{type:String,attribute:"data-csv"},footer:{attribute:"footer",type:Boolean},rowHeader:{attribute:"row-header",type:Boolean}};export const displayBehaviors=function(t){return class extends t{static get properties(){return{...super.properties,...displayProperties,...dataProperties,...tableHtmlProperties}}constructor(){super(),this.disabled=!1,this.hidden=!1,this.columnHeader=!1,this.downloadable=!1,this.data=[],this.filter=!1,this.footer=!1,this.rowHeader=!1,this.sort=!1,this.dataCsv=void 0,Object.keys(displayProperties).forEach((t=>{this[t]=!1})),this.fetchData()}connectedCallback(){super.connectedCallback(),setTimeout((()=>{this.dataCsv||this.loadSlottedTable(),this.__ready=!0}),0)}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.fetchData()}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"dataCsv"===e&&this[e]&&this.fetchData(),"csvData"===e&&this._loadExternalData(),"striped"===e&&this.striped&&(this.columnStriped=!1),"columnStriped"===e&&this.columnStriped&&(this.striped=!1),"data"==e&&this._dataChanged(this.data,t)}))}get thead(){return this.columnHeader?(this.data||[]).slice(0,1):[]}get tbody(){return(this.data||[]).slice(this.columnHeader?1:0,this.footer?(this.data||[]).length-1:(this.data||[]).length)}get tfoot(){return this.footer?(this.data||[]).slice((this.data||[]).length-1):[]}CSVtoArray(t){let e,i="",o=[""],a=[o],r=0,l=0,d=!0;for(e in t)e=t[e],'"'===e?(d&&e===i&&(o[r]+=e),d=!d):","===e&&d?e=o[++r]="":"\n"===e&&d?("\r"===i&&(o[r]=o[r].slice(0,-1)),o=a[++l]=[e=""],r=0):o[r]+=e,i=e;return a}focus(){let t="simple-toolbar-button,rich-text-editor,rich-text-editor-rowcol,editable-table-filter,editable-table-sort",e=this.shadowRoot&&this.shadowRoot.querySelector(t)?this.shadowRoot.querySelector(t):void 0;e&&setTimeout((function(){e.focus()}),0)}download(){let t=globalThis.document.createElement("a"),e=(this.downloadable&&""!=this.caption.trim()?"Table as CSV":`${this.caption} CSV`).replace(/[^\w\d]/g,""),i=this.getTableCSV();t.setAttribute("href","data:text/plain;charset=UTF-8,"+encodeURIComponent(i)),t.setAttribute("download",e+".csv"),t.style.display="none",globalThis.document.body.appendChild(t),t.click(),globalThis.document.body.removeChild(t),this.dispatchEvent(new CustomEvent("csv-downloaded",{bubbles:!0,composed:!0,cancelable:!1,detail:{table:this,data:i,filename:e}}))}print(){let t=!!(!!this.shadowRoot&&this.shadowRoot.querySelector("table"))&&globalThis.open("","","left=0,top=0,width=552,height=477,toolbar=0,scrollbars=0,status=0");t&&(t.document.head.innerHTML+=`<style>\n          ${editableTableDisplayStyles.map((t=>t.cssText.replace(/:host/g,"table"))).join(" ")}\n          table {\n            -webkit-print-color-adjust: exact !important;\n            color-adjust: exact !important;\n          }\n        </style>`,t.document.body.innerHTML=this.getTableHTML(!0),t.document.close(),t.focus(),t.print(),t.addEventListener("afterprint",(e=>{t.close()}))),this.dispatchEvent(new CustomEvent("table-printed",{bubbles:!0,composed:!0,cancelable:!1,detail:this}))}fetchData(){this.dataCsv&&""!==this.dataCsv&&fetch(this.dataCsv).then((t=>t.text())).then((t=>{this.csvData=t,this.dataCsv=null})).catch((t=>{this.loadSlottedTable()}))}getTableCSV(){return this.data.map((t=>t.map((t=>(t=this._replaceBlankCell(t),this._isNumericCell(t)?t.replace(/,/g,""):`"${t.replace(/"/g,'""')}"`))).join(","))).join("\n")}getHTML(t=" "){return this.__tempDiv=this.__tempDiv||globalThis.document.createElement("template"),this.__tempDiv.innerHTML=t,this.__tempDiv.content.cloneNode(!0)}getTableHTML(t=!1,e=!1){let i=[],o=[],a=[],getTR=(e,i="td",o="td",a="tbody")=>{let r=this.rowHeader?e.slice(0,1):[],l=this.rowHeader?e.slice(1):e;return`\n\t\t<tr${t?` class="${a}-tr tr"`:""}>${r.map((e=>`\n\t\t\t<th scope="row"${t?` class="${o} th-or-td"`:""}>${this._replaceBlankCell(e)}</th>`)).join("")}${l.map((e=>`\n\t\t\t<${i}${t?` class="${o} th-or-td"`:""}>${this._replaceBlankCell(e)}</${o}>`)).join("")}\n\t\t</tr>`};this.thead&&(i=this.thead.map((t=>getTR(t,'th scope="col"',"th","thead")))),this.tbody&&(o=this.tbody.map((t=>getTR(t)))),this.tfoot&&(a=this.tfoot.map((t=>getTR(t,"td","td","tfoot"))));let r=this.getTableProperties(),l="";Object.keys(this.getTableProperties()).forEach((t=>{if(r[t]&&(Object.keys(displayProperties).includes(t)||Object.keys(dataProperties).includes(t))){l+=`${(t=>t.split("").map(((t,e)=>t.toUpperCase()===t?`${0!==e?"-":""}${t.toLowerCase()}`:t)).join(""))(t)} `}}));let d=[`<table ${l}>`,this.caption&&""!==this.caption&&null!==this.caption&&"null"!==this.caption&&"undefined"!==this.caption?`\n\t<caption${t?' class="caption"':""}>\n\t\t${this.caption}\n\t</caption>`:"",i.length>0?`\n\t<thead${t?' class="thead"':""}>${i.join("")}\n\t</thead>`:"",o.length>0?`\n\t<tbody${t?' class="tbody"':""}>${o.join("")}\n\t</tbody>`:"",a.length>0?`\n\t<tfoot${t?' class="tfoot"':""}>${a.join("")}\n\t</tfoot>`:"","\n</table>"].join("");if(e){let t=globalThis.document.createElement("div");return t.innerHTML=d,t.querySelector("table")}return d}getTableHTMLNode(){let t=globalThis.document.createElement("editable-table-display"),e=this.getTableProperties();for(var i in e)t[i]=e[i];return t.innerHTML=this.getTableHTML(),t}getTableProperties(){return{bordered:!this.hideBordered&&this.bordered,caption:this.caption,columnHeader:this.columnHeader,columnStriped:this.columnStriped,condensed:!this.hideCondensed&&this.condensed,data:this.data,downloadable:this.downloadable,filter:!this.hideFilter&&this.filter,footer:this.footer,numericStyles:this.numericStyles,printable:this.printable,rowHeader:this.rowHeader,responsive:!this.hideResponsive&&this.responsive,sort:!this.hideSort&&this.sort,striped:!this.hideStriped&&this.striped,summary:this.summary}}importHTML(t){let e=[],i=[...t.querySelectorAll("tr")].map(((t,i)=>[...t.querySelectorAll("th,td")].map(((t,o)=>{let a=t.matches("th")?"th":"td",r=!!t.matches("[colspan]")&&t.getAttribute("colspan"),l=!!t.matches("[rowspan]")&&t.getAttribute("rowspan");return(r||l)&&e.push({type:a,row:i,col:o,rows:l&&""!==l.trim()?parseInt(l.trim()):void 0,cols:r&&""!==r.trim()?parseInt(r.trim()):void 0}),"string"==typeof t.innerHTML?t.innerHTML.trim():t.innerHTML}))));e.forEach((t=>{if(t.cols)for(let e=1;e<t.cols;e++)i[t.row].splice(t.col+1,0,"&nbsp;");if(t.rows)for(let e=1;e<t.rows;e++)i[t.row+1].splice(t.col,0,"&nbsp;")})),i.length>0&&i[0].length>0&&(this.data=i),this.columnHeader=this.columnHeader||t.querySelectorAll("thead").length>0,this.rowHeader=this.rowHeader||t.querySelectorAll("tbody th").length>0,this.footer=this.footer||t.querySelectorAll("tfoot").length>0,this.caption=t.querySelectorAll("caption").length>0?t.querySelector("caption").innerHTML.trim():void 0,Object.keys(displayProperties).forEach((e=>{t.matches(`.${displayProperties[e].attribute||e}`)&&(this[e]=!0)}))}loadSlottedTable(){let t=this.children.item(0);t&&"EDITABLE-TABLE-DISPLAY"===t.tagName&&(t=t.children.item(0)),t&&"TABLE"===t.tagName&&t.children&&t.children.length>0&&this.importHTML(t)}_dataChanged(t,e){}_isNegative(t){return this._isNumericCell(t)&&0===t.trim().indexOf("-")}_isNumericCell(t){return!!t&&!isNaN(t.trim().replace(/\$/g,""))}_isNumericColumn(t){let e=!0;for(let i=0;i<this.tbody.length;i++)this._isNumericCell(this.tbody[i][t])||(e=!1);return e}_isRowFiltered(t){let e,i=(this.filterText||"").trim(),o=this.filterColumn&&t?t[this.filterColumn].trim():"";return this.filterCaseSensitive||(i=i.toLowerCase(),o=o.toLowerCase()),e=this.filterContains?!o.match(i):o!==i,e}_isRowHeader(t,e){return 0===e&&t}_loadExternalData(t){let e=this.CSVtoArray(this.csvData);e.length>0&&e[0].length>0&&(this.data=e),this.columnHeader=!0}_replaceBlankCell(t){return""===String(t).trim()?"-":t}}};export const editBehaviors=function(t){return class extends(displayBehaviors(t)){static get properties(){return{...super.properties,...editProperties}}constructor(){super(),this.hidden=!1,this.disabled=!1,this.hideBordered=!1,this.hideCondensed=!1,this.hideDownloadable=!1,this.hideFilter=!1,this.hideResponsive=!1,this.hidePrintable=!1,this.hideSort=!1,this.caption="",this.hideStriped=!1,this.config=[{type:"button-group",buttons:[{command:"close",icon:"close",label:"Close toolbar",toggles:!1,type:"rich-text-editor-button"}]},{type:"button-group",buttons:[{command:"bold",icon:"editor:format-bold",label:"Bold",toggles:!0,type:"rich-text-editor-button"},{command:"italic",icon:"editor:format-italic",label:"Italics",toggles:!0,type:"rich-text-editor-button"},{command:"removeFormat",icon:"editor:format-clear",label:"Erase Format",type:"rich-text-editor-button"}]},{type:"button-group",buttons:[{command:"link",icon:"link",label:"Link",toggledCommand:"unlink",toggledIcon:"mdextra:unlink",toggledLabel:"Unink",toggles:!0,type:"rich-text-editor-link"}]},{label:"Subscript and Superscript",buttons:[{command:"subscript",icon:"mdextra:subscript",label:"Subscript",toggles:!0,type:"rich-text-editor-button"},{command:"superscript",icon:"mdextra:superscript",label:"Superscript",toggles:!0,type:"rich-text-editor-button"}]}]}}};export const cellBehaviors=function(t){return class extends t{_getLabel(t,e){if(e)return t+1;{let e="ABCDEFGHIJKLMNOPQRSTUVWXYZ".split(""),i=this._getLetter(t).split("-").reverse(),o="";for(let t=0;t<i.length;t++)""!==i[t]&&(o+=e[i[t]]);return o}}_getLetter(t){let e=Math.floor(t/26),i="";return i+=t-26*e+"-",e>0&&e<26?i+=e-1+"-":e>=26&&(i+=this._getLetter(e-1)),i}}};