/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{DDD as i}from"../d-d-d/d-d-d.js";import{editBehaviors as d,editableTableStyles as s,tableHtmlProperties as o,displayProperties as r,dataProperties as a}from"./lib/editable-table-behaviors.js";import"./lib/editable-table-display.js";import"./lib/editable-table-edit.js";class EditableTable extends(d(i)){static get styles(){return[t`
        :host([hidden]) {
          display: none !important;
          margin: var(--ddd-spacing-4) 0;
        }

        :host > * {
          margin: 0px;
        }
      `]}render(){return e`
      <editable-table-display
        ?bordered="${this.bordered}"
        caption="${this.caption}"
        ?column-header="${this.columnHeader}"
        ?column-striped="${this.columnStriped}"
        ?condensed="${this.condensed}"
        .data="${this.data}"
        ?disabled="${this.disabled}"
        ?hidden="${this.editMode}"
        ?downloadable="${this.downloadable}"
        ?filter="${this.filter}"
        ?footer="${this.footer}"
        ?numeric-styles="${this.numericStyles}"
        ?printable="${this.printable}"
        ?responsive="${this.responsive}"
        ?row-header="${this.rowHeader}"
        ?sort="${this.sort}"
        ?striped="${this.striped}"
      >
        <slot></slot>
      </editable-table-display>
      <editable-table-edit
        ?bordered="${this.bordered}"
        caption="${this.caption}"
        @change="${this._handleSync}"
        .config="${this.config}"
        ?column-header="${this.columnHeader}"
        ?column-striped="${this.columnStriped}"
        ?condensed="${this.condensed}"
        .data="${this.data}"
        ?disabled="${this.disabled}"
        ?hidden="${!this.editMode||this.hidden}"
        ?downloadable="${this.downloadable}"
        ?filter="${this.filter}"
        ?footer="${this.footer}"
        ?hide-bordered="${this.hideBordered}"
        ?hide-condensed="${this.hideCondensed}"
        ?hide-downloadable="${this.hideDownloadable}"
        ?hide-filter="${this.hideFilter}"
        ?hide-responsive="${this.hideResponsive}"
        ?hide-printable="${this.hidePrintable}"
        ?hide-sort="${this.hideSort}"
        ?hide-striped="${this.hideStriped}"
        ?numeric-styles="${this.numericStyles}"
        ?printable="${this.printable}"
        ?responsive="${this.responsive}"
        ?row-header="${this.rowHeader}"
        ?sort="${this.sort}"
        ?striped="${this.striped}"
      >
      </editable-table-edit>
    `}static get tag(){return"editable-table"}haxHooks(){return{preProcessNodeToContent:"haxpreProcessNodeToContent",activeElementChanged:"haxactiveElementChanged"}}async haxpreProcessNodeToContent(e){return e.editMode=!1,e.innerHTML="",await e.appendChild(this.getTableHTML(!0,!0)),e.config=null,e}haxactiveElementChanged(e,t){return this.editMode=t,t&&this.focus(),this}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}constructor(){super(),this.editMode=!1}static get properties(){return{...super.properties,editMode:{type:Boolean,attribute:"edit-mode",reflect:!0}}}get display(){return this.shadowRoot&&this.shadowRoot.querySelector("editable-table-display")}get editor(){return this.shadowRoot&&this.shadowRoot.querySelector("editable-table-edit")}_handleSync(e){this.sync(e.detail)}sync(e){this.editor&&e&&(this[e]=this.editor[e])}focus(){let e=this.editMode?"editable-table-edit":"editable-table-display",t=this.shadowRoot&&this.shadowRoot.querySelector(e)?this.shadowRoot.querySelector(e):void 0;t&&setTimeout((function(){t.focus()}),1)}toggleEditMode(e){this.editMode=void 0!==e?e:!this.editMode,this.focus(),this.dispatchEvent(new CustomEvent("toggle-edit-mode",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}}customElements.define(EditableTable.tag,EditableTable);export{EditableTable};