/**
 * Copyright 2023
 * @license , see License.md for full text.
 */
import{LitElement as t,html as e,css as i,render as r,nothing as s}from"../../lit/index.js";import"../simple-img/simple-img.js";import"../simple-icon/lib/simple-icon-button-lite.js";import"../play-list/play-list.js";import"../code-sample/code-sample.js";import"../code-editor/lib/code-pen-button.js";import{nodeToHaxElement as l}from"../utils/utils.js";class DocumentationPlayer extends t{constructor(){super(),this.label="",this.haxSchema=[],this.imageUrl="",this.url="",setTimeout((async()=>{for(let t=0;t<this.children.length;t++)this.haxSchema.push(await l(this.children[t]))}),0)}static get properties(){return{label:{type:String},haxSchema:{type:Array,attribute:!1},imageUrl:{type:String,attribute:"image-url"},url:{type:String,attribute:"url"}}}static get styles(){let t=[];return super.styles&&(t=super.styles),[t,i`
        :host {
          display: block;
        }
      `]}_getDataString(t){return JSON.stringify(t).replace(/"/g,"&quot;").replace(/'/g,"&apos;")}codePenData(t){return this._getDataString({title:t,html:this.innerHTML.trim(),head:'<script>globalThis.WCGlobalCDNPath="https://cdn.webcomponents.psu.edu/cdn/";<\/script><script src="https://cdn.webcomponents.psu.edu/cdn/build.js"><\/script>'})}renderPlayListTemplate(){let t=globalThis.document.createElement("template");r(e` <div>
          <a href="${this.url}" rel="noopener" target="_blank">${this.label}</a>
          <simple-img
            loading="lazy"
            fetchpriority="low"
            decoding="async"
            src="https://screenshoturl.open-apis.hax.cloud/api/screenshotUrl?quality=10&amp;render=img&amp;urlToCapture=${this.imageUrl}"
            alt=""
            width="300"
            height="200"
            quality="80"
          ></simple-img>
        </div>
        <div id="codesample"></div>
        <code-pen-button
          data-string="${this.codePenData(this.label)}"
        ></code-pen-button>
        ${this.renderHAXInjectButton()}`,t),this.shadowRoot.querySelector("#contentplayertemplate").appendChild(t),setTimeout((()=>{let t=globalThis.document.createElement("template");t.innerHTML=this.innerHTML.trim();let e=globalThis.document.createElement("code-sample");e.innerHTML=t.outerHTML,this.shadowRoot.querySelector("#codesample").appendChild(e)}),10)}render(){return e`<play-list id="contentplayertemplate"></play-list>`}renderHAXInjectButton(){return e`
      <simple-icon-button-lite icon="settings" @click="${this._injectHAX}"
        >Insert into your side</simple-icon-button-lite
      >
    `}_injectHAX(t){globalThis.dispatchEvent(new CustomEvent("hax-insert",{detail:{value:this.haxSchema}}))}static get tag(){return"documentation-player"}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.renderPlayListTemplate()}}customElements.define(DocumentationPlayer.tag,DocumentationPlayer);export{DocumentationPlayer};