import{css as e,html as t}from"../../../lit/index.js";import{DDD as n}from"../d-d-d.js";import"../../simple-modal/simple-modal.js";export class MiniMap extends n{static properties={gridSize:{type:Number},nodeList:{type:Array},lineList:{type:Array},activeNode:{type:Object},availableNodes:{type:Array}};constructor(){super(),this.gridSize=7,this.nodeList=[],this.lineList=[],this.activeNode=null,this.availableNodes=[]}static get styles(){return[super.styles,e`
        :host,
        * {
          font-family: var(--ddd-font-primary, sans-serif);
          font-size: var(--ddd-theme-body-font-size, 16px);
        }
        .grid {
          display: grid;
          gap: 64px;
          margin: 16px;
        }
        .cell {
          margin: auto;
          aspect-ratio: 1 / 1;
        }
        .node {
          position: relative;
          display: inline-block;
          align-content: center;
          text-align: center;
          margin: auto;
          padding: 8px;
          border: 1px solid #ccc;
          text-decoration: none;
          height: calc(100% - 20px);
          width: calc(100% - 20px);
          border-radius: 100%;
          --ddd-theme-accent: lightblue;
          overflow: hidden;
          white-space: nowrap;
          text-overflow: ellipsis;
        }
        .cell:has(.node) {
          width: 138px;
          height: 138px;
        }
      `]}renderCell(e){const n=this.nodeList.find((t=>t.id===e));return t`
      <div class="cell" id="cell-${e}" @click="${this._handleCellClick}">
        ${n?t`<a
              class="node node-${n.type}"
              href="#"
              data-type="${n.type}"
              id="node-${e}"
              @click="${t=>{t.preventDefault(),this.showModal(e)}}"
              >${n.name}</a
            >`:e}
      </div>
    `}_handleCellClick(e){console.log(e.target.id);const t=e.target.id.split("-")[1];this.showModal(t)}showModal(e){const t=globalThis.document.createElement("div");t.classList.add("modal-form");const n=!!this.nodeList&&this.nodeList.includes(e),i=n?n.type:"topic",o=n?n.name:"",d=n?n.url:"",l=!!n&&n.isActive;t.innerHTML=`\n    <style>\n      simple-modal{\n        --simple-modal-width: 30%;\n        font-family: var(--ddd-font-primary, sans-serif);\n      }\n      .modal-form{\n        display: flex;\n        flex-direction: column;\n        gap: 16px;\n        padding: 16px;\n        margin: auto;\n        align-items: center;\n        justify-content: center;\n      }\n      label{\n        display: inline-block;\n        gap: 8px;\n      }\n      input, select{\n        padding: 8px;\n        border-radius: 4px;\n        border: 1px solid #ccc;\n      }\n      button{\n        display: inline-block;\n        padding: 8px;\n        border-radius: 4px;\n        border: 1px solid #ccc;\n        background-color: #ccc;\n        width: fit-content;\n      }\n    </style>\n      <h2>Node ${e}</h2>\n      <span id="node-input-id" hidden>${e}</span>\n      <label>Type: \n        <select id="node-input-type">\n          <option value="topic" ${"topic"===i?"selected":""}>Topic</option>\n          <option value="subsection" ${"subsection"===i?"selected":""}>Subsection</option>\n        </select>\n      </label>\n      <label>Name: <input type="text" id="node-input-name" placeholder="Enter Name" value="${o}"></label>\n      <label>URL: <input type="url" id="node-input-url" placeholder="Enter URL" value="${d}"></label>\n      <div>\n        <label>Active Node? <input type="checkbox" id="node-input-active" ${l?"checked":""}></label>\n      </div>\n    `;const s=globalThis.document.createElement("button");s.id="nodeSaveBtn",s.textContent="Save",s.addEventListener("click",this.saveNode);const a=globalThis.document.createElement("button");a.id="nodeCancelBtn",a.textContent="Cancel",a.addEventListener("click",this.closeModal);const r=globalThis.document.createElement("button");r.id="nodeDeleteBtn",r.textContent="Delete",r.addEventListener("click",this.deleteNode),t.appendChild(s),t.appendChild(a),t.appendChild(r);const c=new CustomEvent("simple-modal-show",{bubbles:!0,cancelable:!0,detail:{elements:{content:t},invokedBy:s,clone:!0,onShow:()=>this.addModalListeners()}});dispatchEvent(c),globalThis.document.addEventListener("simple-modal-opened",(e=>{console.log("Modal opened",e),this.addModalListeners()}))}closeModal(){const e=new CustomEvent("simple-modal-hide",{bubbles:!0,cancelable:!0});dispatchEvent(e)}addModalListeners(){document.querySelector("#nodeSaveBtn").addEventListener("click",this.saveNode),document.querySelector("#nodeCancelBtn").addEventListener("click",this.closeModal)}renderCanvas(){}saveNode(){const e=globalThis.document.querySelector("#node-input-type").value,t=globalThis.document.querySelector("#node-input-name").value,n=globalThis.document.querySelector("#node-input-url").value,i=globalThis.document.querySelector("#node-input-id").innerText;console.log(i,e,t,n),this.nodeList=this.nodeList?this.nodeList:[],0!=this.nodeList.length&&this.nodeList.includes(i)?(document.querySelector("mini-map").shadowRoot.querySelector("#node-"+i).setAttribute("type",e),document.querySelector("mini-map").shadowRoot.querySelector("#node-"+i).setAttribute("name",t),document.querySelector("mini-map").shadowRoot.querySelector("#node-"+i).setAttribute("url",n)):(globalThis.document.querySelector("mini-map").nodeList.push(i),globalThis.document.querySelector("mini-map").addNode(i,e,t,n)),globalThis.document.querySelector("mini-map").closeModal()}async addNode(e,t,n,i){const o=globalThis.document.querySelector("mini-map").shadowRoot,d=o.querySelector(`#cell-${e}`),l=globalThis.document.createElement("a");l.classList.add("node"),l.classList.add(`node-${t}`),l.setAttribute("href","#"),l.setAttribute("data-type",t),l.setAttribute("id",`node-${e}`),l.innerText=n,d.innerHTML="",await d.appendChild(l),o.querySelector(`#node-${e}`).addEventListener("click",(t=>{t.preventDefault(),this.showModal(e)}))}removeNode(){}removeAllNodes(){this.nodeList=[...this.nodeList],this.nodeList.length=0,this.shadowRoot.querySelectorAll(".cell").forEach((e=>e.remove())),this.shadowRoot.querySelector("#gridTarget").innerHTML=Array.from({length:this.gridSize*this.gridSize},((e,t)=>this.renderCell(t)))}addLine(e,t,n,i){this.nodeList.push(e),this.shadowRoot.querySelector(`#cell-${e}`).style.backgroundColor="red"}removeLine(){}render(){return t`
      <button>Edit Nodes</button>
      <button>Edit Lines</button>
      <button @click="${this.removeAllNodes}">Reset</button>
      <button>Save</button>
      <div
        id="gridTarget"
        class="grid"
        style="grid-template-columns: repeat(${this.gridSize}, auto)"
      >
        ${Array.from({length:this.gridSize*this.gridSize},((e,t)=>this.renderCell(t)))}
      </div>
    `}}globalThis.customElements.define("mini-map",MiniMap);