/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../lit/index.js";import{SimpleColors as o}from"../simple-colors/simple-colors.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-button-lite.js";import{IntersectionObserverMixin as i}from"../intersection-element/lib/IntersectionObserverMixin.js";class CsvRender extends(i(o)){static get styles(){return[super.styles,e`
        :host {
          display: block;
        }
        .table {
          width: 100%;
          border: 1px solid var(--simple-colors-default-theme-accent-6);
          border-collapse: collapse;
          white-space: nowrap;
          font-size: 16px;
          background-color: var(--simple-colors-default-theme-grey-1);
        }
        .table thead {
          padding-bottom: 0.16px;
          position: sticky;
        }
        .table caption {
          background-color: var(--simple-colors-default-theme-accent-1);
          font-weight: bold;
          padding: 8px;
          border: 1px solid var(--simple-colors-default-theme-accent-6);
          border-bottom: none;
        }
        :host(:not([accent-color])) .table caption,
        :host([accent-color="grey"]) .table caption {
          background-color: var(--simple-colors-default-theme-accent-2);
        }
        .table tbody tr {
          position: relative;
          height: 48px;
          transition-duration: 0.3s;
          -webkit-transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
          transition-timing-function: cubic-bezier(0.4, 0, 0.2, 1);
          -webkit-transition-property: background-color;
          transition-property: background-color;
        }
        .table tbody tr:hover {
          background-color: var(--simple-colors-default-theme-accent-1);
        }
        :host(:not([accent-color])) .table tbody tr:hover,
        :host([accent-color="grey"]) .table tbody tr:hover {
          background-color: var(--simple-colors-default-theme-accent-2);
        }
        .table td,
        .table thead th,
        .table th {
          padding: 0 1.125em;
          text-align: left;
        }
        .table td {
          border-top: 1px solid var(--simple-colors-default-theme-accent-6);
          border-bottom: 1px solid var(--simple-colors-default-theme-accent-6);
        }
        .table th {
          position: relative;
          vertical-align: bottom;
          text-overflow: ellipsis;
          font-size: 16px;
          font-weight: bold;
          line-height: 24px;
          letter-spacing: 0;
          color: rgba(0, 0, 0, 0.54);
          height: 48px;
          padding-bottom: 8px;
          box-sizing: border-box;
        }
        #loading {
          position: absolute;
          left: calc(50% - 70px);
        }
        simple-icon-lite {
          display: inline-flex;
          margin: 0;
          padding: 0;
        }
        #download button:hover,
        #download button:focus,
        #download button:active {
          color: var(--simple-colors-default-theme-accent-8);
          outline: 2px solid var(--simple-colors-default-theme-accent-6);
        }
      `]}constructor(){super(),this.loading=!1,this.table=[],this.tableHeadings=[],this.tableData=""}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"elementVisible"==e&&this.elementVisible&&(import("../hexagon-loader/hexagon-loader.js"),import("../simple-tooltip/simple-tooltip.js")),["dataSource","elementVisible"].includes(e)&&this.dataSource&&this.elementVisible&&(clearTimeout(this.__debouce),this.loading=!0,this.__debouce=setTimeout((()=>{this.loadCSVData()}),500))}))}render(){return t`
      <hexagon-loader
        id="loading"
        accent-color="${this.accentColor}"
        ?loading="${this.loading}"
        item-count="4"
        size="small"
      ></hexagon-loader>
      <a
        href="${this.dataSource}"
        id="download"
        tabindex="-1"
        title="Download table data"
      >
        <simple-icon-button-lite
          id="ficon"
          aria-labelledby="download"
          label="Download table data"
          icon="file-download"
        ></simple-icon-button-lite>
      </a>
      <simple-tooltip for="ficon" offset="14" position="top"
        >Download table data</simple-tooltip
      >
      <table class="table" summary="${this.summary}">
        ${this.caption?t`
              <caption>
                ${this.caption}
              </caption>
            `:""}
        <thead>
          <tr>
            ${this.tableHeadings.map((e=>t` <th scope="col">${e}</th> `))}
          </tr>
        </thead>
        <tbody>
          ${this.table.map((e=>t`
              <tr>
                ${e.map((e=>t` <td>${e}</td> `))}
              </tr>
            `))}
        </tbody>
      </table>
    `}static get tag(){return"csv-render"}static get properties(){return{...super.properties,dataSource:{type:String,attribute:"data-source"},loading:{type:Boolean},caption:{type:String},summary:{type:String},table:{type:Array},tableHeadings:{type:Array},tableData:{type:String,attribute:"table-data"}}}handleResponse(){this.table=this.CSVtoArray(this.tableData),this.tableHeadings=this.table.shift(),this.loading=!1}CSVtoArray(t){let e,o="",i=[""],a=[i],l=0,r=0,s=!0;for(e in t)e=t[e],'"'===e?(s&&e===o&&(i[l]+=e),s=!s):","===e&&s?e=i[++l]="":"\n"===e&&s?("\r"===o&&(i[l]=i[l].slice(0,-1)),i=a[++r]=[e=""],l=0):i[l]+=e,o=e;return a}async loadCSVData(){await fetch(this.dataSource,{method:this.method}).then((t=>{if(t.ok)return t.text()})).then((t=>{this.tableData=t,this.handleResponse()}))}}customElements.define(CsvRender.tag,CsvRender);export{CsvRender};