import{LitElement as t,html as e,css as i}from"../../../lit/index.js";class ModelOption extends t{static get properties(){return{title:{type:String},url:{type:String},src:{type:String}}}constructor(){super(),this.title="",this.url="",this.src=""}static get styles(){return[i`
        :host {
          display: block;
        }

        a {
          text-decoration: none;
          color: #fff;
        }

        h2 {
          margin-bottom: 10px;
        }

        @media screen and (min-width: 320px) {
          h2 {
            font-size: 24px;
        }
  
        @media screen and (min-width: 920px) {
          h2 {
            font-size: 36px;
          }
        }

        #option-wrap {
          padding: 15px 25px 15px;
        }

        #accent-color {
          background-color: #e2801e;
          width: 80px;
          height: 5px;
        }

        .button {
          width: 100%;
        }
      `]}render(){return e`
      <a @click="${this._handleClick}">
        <div class="button">
          <div id="option-wrap">
            <div id="accent-color"></div>
            <div id="title">
              <h2>${this.title}</h2>
            </div>
            <slot></slot>
          </div>
        </div>
      </a>
    `}_handleClick(t){let e=new CustomEvent("model-select",{detail:this,bubbles:!0,composed:!0});this.dispatchEvent(e)}static get tag(){return"model-option"}}customElements.define("model-option",ModelOption);export{ModelOption};