import{LitElement as t,html as e,css as o}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/lib/simple-icon-lite.js";export class WorksheetDownload extends t{static get properties(){return{title:{type:String},link:{type:String}}}static get tag(){return"worksheet-download"}static get haxProperties(){return{canScale:!1,canEditSource:!1,gizmo:{title:"Worksheet Download",description:"A button for displaying files available for download.",icon:"icons:file-download",color:"blue",tags:["Instructional","link","worksheet","download","url","file"],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"title",title:"Title",description:"The title of the download.",inputMethod:"textfield",icon:"editor:title"},{property:"link",title:"Link",description:"The link for the download.",inputMethod:"haxupload",icon:"editor:insert-link"}],advanced:[]},demoSchema:[{tag:"worksheet-download",properties:{title:"Download worksheet"},content:""}]}}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(t,e){e&&(this._haxstate=e)}haxeditModeChanged(t){this._haxstate=t}_clickLink(t){this._haxstate&&(t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation())}constructor(){super(),this.title="",this.link=""}static get styles(){return[o`
        :host {
          display: block;
        }

        a {
          text-decoration: none;
          color: #0c7cd5;
          display: block;
        }

        button {
          text-transform: none;
          border: solid 2px #dcdcdc;
          width: 100%;
          margin: 0 auto 0;
          min-height: 48px;
          text-align: center;
        }

        button:active,
        button:focus,
        button:hover {
          cursor: pointer;
          background-color: #0c7cd5;
          color: #fff;
        }

        simple-icon {
          margin-right: 5px;
        }
      `]}render(){return e`
      <div id="button_wrap">
        <a
          tabindex="-1"
          href="${this.link}"
          target="_blank"
          download
          rel="noopener noreferrer"
          @click="${this._clickLink}"
        >
          <button>
            <simple-icon-lite icon="icons:file-download"></simple-icon-lite
            >${this.title}
          </button>
        </a>
      </div>
    `}}customElements.define(WorksheetDownload.tag,WorksheetDownload);