import{LitElement as t,html as e,css as i}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/lib/simple-icon-lite.js";export class EbookButton extends t{static get properties(){return{link:{type:String},title:{type:String},icon:{type:String}}}static get haxProperties(){return{canScale:!1,canEditSource:!1,gizmo:{title:"Ebook button",description:"A button that links to an Ebook.",icon:"icons:book",color:"blue",tags:["Instructional","link","ebook","book"],handles:[{type:"link",source:"link",title:"title"}],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"title",title:"Title",description:"The title of the button.",inputMethod:"textfield",icon:"editor:title"},{property:"link",title:"Link",description:"The link to redirect to on click.",inputMethod:"textfield",icon:"editor:insert-link"},{property:"icon",title:"Icon",description:"Icon to represent this link",inputMethod:"iconpicker",icon:"editor:insert-link"}],advanced:[]},demoSchema:[{tag:"ebook-button",properties:{title:"Access Ebook",icon:"icons:book"},content:""}]}}constructor(){super(),this.link="",this.title="",this.icon="icons:book"}static get styles(){return[i`
        :host {
          display: inline-block;
          --link-color: #aeaeae;
        }

        button {
          min-height: 48px;
          text-transform: none;
          padding: 10px 25px 10px 0;
        }

        button:active,
        button:focus,
        button:hover {
          outline: 2px solid black;
          cursor: pointer;
        }

        simple-icon-lite {
          height: 55px;
          width: 55px;
          margin-right: 5px;
        }

        .title {
          font-size: 16px;
          font-weight: bold;
          display: inline-flex;
        }
        a,
        a:-webkit-any-link {
          display: block;
          color: var(--link-color);
          text-decoration: none;
        }
      `]}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(t,e){e&&(this._haxstate=e)}haxeditModeChanged(t){this._haxstate=t}_clickLink(t){this._haxstate&&(t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation())}render(){return e`
      <div id="button wrapper">
        <a
          href="${this.link}"
          target="_blank"
          rel="noopener noreferrer"
          @click="${this._clickLink}"
        >
          <button id="book">
            <simple-icon-lite icon="${this.icon}"></simple-icon-lite>
            <div class="title">${this.title}</div>
          </button>
        </a>
      </div>
    `}static get tag(){return"ebook-button"}}customElements.define(EbookButton.tag,EbookButton);