/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import{IntersectionObserverMixin as r}from"../intersection-element/lib/IntersectionObserverMixin.js";import{CountUp as s}from"./lib/countup.js";class CountUpElement extends(r(t)){static get styles(){return[i`
        :host {
          display: inline-flex;
          --count-up-color: #000000;
        }

        :host([hidden]) {
          display: none;
        }

        .wrapper {
          display: block;
          text-align: center;
          width: 100%;
          height: 100%;
        }

        #counter {
          color: var(--count-up-color);
          font-weight: var(--count-up-number-font-weight);
          font-size: var(--count-up-number-font-size);
        }
      `]}render(){return e` <div class="wrapper">
      <slot name="prefix"></slot>
      <div id="counter"></div>
      <slot name="suffix"></slot>
    </div>`}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Count up",description:"count up js wrapper with minimal styling",icon:"icons:android",color:"green",groups:["Up"],handles:[],meta:{author:"HAXTheWeb core team",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"start",description:"",inputMethod:"textfield"},{property:"end",description:"",inputMethod:"textfield"},{property:"duration",description:"",inputMethod:"textfield"},{property:"noeasing",description:"",inputMethod:"boolean"},{property:"decimalplaces",description:"",inputMethod:"textfield"},{property:"separator",description:"",inputMethod:"textfield"},{property:"decimal",description:"",inputMethod:"textfield"},{property:"prefix",description:"",inputMethod:"textfield"},{property:"suffix",description:"",inputMethod:"textfield"}],advanced:[]},saveOptions:{unsetAttributes:["element-visible"]}}}static get properties(){return{...super.properties,start:{type:Number},end:{type:Number},duration:{type:Number},noeasing:{type:Boolean},decimalplaces:{type:Number},separator:{type:String},decimal:{type:String},prefixtext:{type:String},suffixtext:{type:String},thresholds:{type:Array},rootMargin:{type:String,attribute:"root-margin"},ratio:{type:Number,reflect:!0},elementVisible:{type:Boolean}}}static get tag(){return"count-up"}constructor(){super(),this.start=0,this.end=100,this.duration=2.5,this.noeasing=!1,this.decimalplaces=0,this.separator=",",this.decimal=".",this.prefixtext=" ",this.suffixtext=" "}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this._buildCountUp()}_buildCountUp(){const t={startVal:this.start,decimalPlaces:this.decimalplaces,duration:this.duration,useEasing:!this.noeasing,separator:this.separator,decimal:this.decimal,prefix:this.prefixtext,suffix:this.suffixtext};this._countUp=new s(this.shadowRoot.querySelector("#counter"),this.end,t)}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"elementVisible"==e&&this[e]&&this._countUp.start(),this.shadowRoot&&"end"==e&&this[e]&&(this._buildCountUp(),this.elementVisible&&this._countUp.start())}))}}customElements.define(CountUpElement.tag,CountUpElement);export{CountUpElement,s as CountUp};