/**
 * Copyright 2023
 * @license , see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import"../responsive-utility/responsive-utility.js";import{DDD as r}from"../d-d-d/d-d-d.js";class CollectionList extends r{constructor(){super(),this.responsiveSize="lg"}static get properties(){return{responsiveSize:{type:String,reflect:!0,attribute:"responsive-size"}}}static get styles(){let e=[];return super.styles&&(e=super.styles),[e,t`
        :host {
          display: block;
          container-type: inline-size;
        }
        .wrapper {
          display: grid;
          grid-template-columns: repeat(1, 1fr);
          column-gap: 2vw;
          row-gap: 2vw;
          --cssIdealSize: 200px;
        }
        .wrapper > * {
          /* Targets all direct children of the wrapper */
          grid-column: span 1; /* Ensures each item takes up exactly one column */
        }

        @container (min-width: 480px) {
          .wrapper {
            grid-template-columns: repeat(2, 1fr);
          }
        }

        @container (min-width: 720px) {
          .wrapper {
            grid-template-columns: repeat(3, 1fr);
          }
        }

        @container (min-width: 960px) {
          .wrapper {
            grid-template-columns: repeat(4, 1fr);
          }
        }

        @container (min-width: 1200px) {
          .wrapper {
            grid-template-columns: repeat(5, 1fr);
          }
        }

        @container (min-width: 1440px) {
          .wrapper {
            grid-template-columns: repeat(6, 1fr);
          }
        }
      `]}render(){return e`
      <div class="wrapper" style="--cssIdealSize: ${this.size}">
        <slot></slot>
      </div>
    `}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}static get tag(){return"collection-list"}}customElements.define(CollectionList.tag,CollectionList);export{CollectionList};