export default"\nvar eventTypes = {\n  ready: 'ready',\n  valueChanged: 'valueChanged',\n  languageChanged: 'languageChanged',\n  themeChanged: 'themeChanged',\n};\n\nclass MonacoEditor {\n  constructor() {\n    this.language = 'javascript';\n    this.value = '';\n    this.editor = null;\n    this.setupEventListener('message', this.handleMessage.bind(this));\n    this.setupEditor();\n  }\n\n  setupEditor() {\n    require.config({ paths: { vs: 'node_modules/monaco-editor/min/vs' } });\n    require(['vs/editor/editor.main'], () => {\n      this.editor = monaco.editor.create(globalThis.document.getElementById('container'), {\n        value: this.value,\n        language: this.language,\n        scrollBeyondLastLine: false,\n        minimap: {\n          enabled: false\n        }\n      });\n\n      const model = this.editor.getModel();\n      model.onDidChangeContent(() => {\n        const value = model.getValue();\n        this.onValueChanged(value);\n      });\n\n      this.ready();\n    });\n  }\n\n  ready() {\n    this.postMessage(eventTypes.ready, null);\n    this.setupEventListener(\n      eventTypes.valueChanged,\n      this.onValueChanged.bind(this)\n    );\n  }\n\n  _handleMessage(data) {\n    switch (data.event) {\n      case eventTypes.valueChanged:\n        this.onInputValueChanged(data.payload);\n        break;\n      case eventTypes.languageChanged:\n        this.onLanguageChanged(data.payload);\n        break;\n      case eventTypes.themeChanged:\n        this.onThemeChanged(data.payload);\n        break;\n      default:\n        break;\n    }\n  }\n\n  handleMessage(message) {\n    try {\n      const data = JSON.parse(message.data);\n      this._handleMessage(data);\n    } catch (error) {\n      console.error(error);\n      return;\n    }\n  }\n\n  postMessage(event, payload) {\n    globalThis.parent.postMessage(\n      JSON.stringify({ event, payload }),\n      globalThis.parent.location.href\n    );\n  }\n\n  setupEventListener(type, callback) {\n    globalThis.addEventListener(type, data => {\n      callback(data);\n    });\n  }\n\n  onInputValueChanged(newValue) {\n    if (newValue !== this.value) {\n      this.value = newValue;\n      this.editor.getModel().setValue(newValue);\n      this.postMessage(eventTypes.valueChanged, newValue);\n    }\n  } \n\n  onValueChanged(newValue) {\n    if (newValue !== this.value) {\n      this.value = newValue;\n      this.postMessage(eventTypes.valueChanged, newValue);\n    }\n  }\n\n  onLanguageChanged(newLang) {\n    monaco.editor.setModelLanguage(this.editor.getModel(), newLang);\n  }\n\n  onThemeChanged(newValue) {\n    monaco.editor.setTheme(newValue);\n  }\n}\n\nnew MonacoEditor();\n";