/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as o}from"../../lit/index.js";import{SchemaBehaviors as i}from"../schema-behaviors/schema-behaviors.js";import"./lib/monaco-element/monaco-element.js";import{ReplaceWithPolyfill as r}from"../utils/utils.js";Element.prototype.replaceWith||(Element.prototype.replaceWith=r),CharacterData.prototype.replaceWith||(CharacterData.prototype.replaceWith=r),DocumentType.prototype.replaceWith||(DocumentType.prototype.replaceWith=r);class CodeEditor extends(i(e)){static get styles(){return[o`
        :host {
          display: flex;
          flex-direction: column;
          font-family: unset;
          align-items: stretch;
          margin: var(--code-pen-margin, 16px 0);
          width: calc(100% - 2px);
          background-color: #1e1e1e;
          color: #c6c6c6;
          border: var(--code-editor-code-border);
          border-radius: var(--code-editor-code-border-radius);
          border: 1px solid var(--code-editor-label-color, #ddd);
        }
        :host([theme-colors="vs-dark"]) {
          background-color: #1e1e1e;
          color: #c6c6c6;
          border: 1px solid var(--code-editor-label-color, #000);
        }
        :host([theme-colors="vs"]) {
          background-color: #fffffe;
          color: #000;
          border: 1px solid var(--code-editor-label-color, #ddd);
        }
        :host([hidden]) {
          display: none !important;
        }
        .code-pen-container:not([hidden]) {
          width: calc(100% - 2 * var(--code-editor-margin, 12px));
          display: flex;
          height: 40px;
          justify-content: flex-end;
          align-items: center;
          margin: var(--code-editor-margin, 12px);
        }
        .code-pen-container span {
          display: inline-flex;
          line-height: 16px;
          font-size: 16px;
          padding: 12px 0;
        }
        code-pen-button {
          float: right;
          height: 40px;
          flex: 0 0 40px;
        }
        :host([theme-colors="vs"]) code-pen-button::part(button) {
          filter: invert(1);
        }
        label {
          color: var(--code-editor-label-color, #444);
          transition: all 0.5s;
          flex: 0 0 auto;
          margin: var(--code-editor-margin, 12px);
        }
        :host([theme-colors="vs"]) label {
          color: var(--code-editor-label-color, #444);
        }
        :host([theme-colors="vs-dark"]) label {
          color: var(--code-editor-label-color, #bbb);
        }
        :host([hidden]) {
          display: none !important;
        }

        :host([focused]) label {
          color: var(
            --code-editor-float-label-active-color,
            var(--code-editor-label-color, currentColor)
          );
        }

        #loading {
          padding: 0 74px;
          flex: 1 1 auto;
          overflow: hidden;
          white-space: pre-wrap;
          text-overflow: ellipsis;
          font-family: monospace;
        }
        #codeeditor {
          flex: 1 1 auto;
          height: 100%;
        }
        #codeeditor[data-hidden] {
          height: 0px;
        }

        :host([focused]) #codeeditor {
          border: var(--code-editor-focus-code-border);
        }
      `]}constructor(){super(),this.codePenData=null,this.haxUIElement=!0,this.showCodePen=!1,this.readOnly=!1,this.theme="vs-dark",this.language="javascript",this.fontSize=16,this.wordWrap=!1,this.tabSize=2,this.autofocus=!1,this.hideLineNumbers=!1,this.focused=!1,globalThis.WCGlobalBasePath?this.libPath=globalThis.WCGlobalBasePath:this.libPath=new URL("./code-editor.js",import.meta.url).href+"/../../../",this.libPath+="monaco-editor/min/vs",setTimeout((()=>{this.addEventListener("monaco-element-ready",this.editorReady.bind(this))}),0)}render(){return t`
      <label for="codeeditor" ?hidden="${!this.title}" part="label"
        >${this.title}</label
      >
      <monaco-element
        id="codeeditor"
        ?data-hidden="${!this.ready}"
        ?autofocus="${this.autofocus}"
        ?hide-line-numbers="${this.hideLineNumbers}"
        lib-path="${this.libPath}"
        language="${this.language}"
        tab-size="${this.tabSize}"
        theme="${this.getTheme(this.theme)}"
        @value-changed="${this._editorDataChanged}"
        font-size="${this.fontSize}"
        ?word-wrap="${this.wordWrap}"
        ?read-only="${this.readOnly}"
        @code-editor-focus="${this._handleFocus}"
        @code-editor-blur="${this._handleBlur}"
        @monaco-element-ready="${e=>this.ready=!0}"
        part="code"
      >
      </monaco-element>
      <pre
        id="loading"
        ?hidden="${this.ready}"
        style="font-size:${this.fontSize}px"
        part="preview"
      ><code>
  ${this.placeholder}</code></pre>
      <slot hidden></slot>
      ${this.showCodePen?t`<div class="code-pen-container" part="code-pen">
            <span>Check it out on code pen: </span
            ><code-pen-button .data="${this.codePenData}"></code-pen-button>
          </div>`:""}
    `}getTheme(e){let t=globalThis.matchMedia&&"auto"==e,o=t&&globalThis.matchMedia("(prefers-color-scheme: dark)").matches,i=t&&globalThis.matchMedia("(prefers-color-scheme: light)").matches,r=o?"vs-dark":i?"vs":e&&"auto"!=e?e:"vs-dark";return this.setAttribute("theme-colors",r),r}get placeholder(){return`${this.editorValue||this.innerHTML}`.replace(/\s*<\/?template.*>\s*/gm,"").replace(/\s*<\/?iframe>\s*/gm,"")}static get tag(){return"code-editor"}static get properties(){return{...super.properties,libPath:{type:String},title:{type:String},showCodePen:{type:Boolean,reflect:!0,attribute:"show-code-pen"},readOnly:{type:Boolean,reflect:!0,attribute:"read-only"},codePenData:{type:Object,attribute:"code-pen-data"},editorValue:{type:String,attribute:"editor-value"},value:{type:String},theme:{type:String,reflect:!0,attribute:"theme"},mode:{type:String},language:{type:String},fontSize:{type:Number,attribute:"font-size"},wordWrap:{type:Boolean,attribute:"word-wrap"},autofocus:{type:Boolean,reflect:!0},hideLineNumbers:{type:Boolean,attribute:"hide-line-numbers"},focused:{type:Boolean,reflect:!0},tabSize:{type:Number,attribute:"tab-size"},ready:{type:Boolean}}}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{"editorValue"==t&&this._editorValueChanged(this[t]),"mode"==t&&this._modeChanged(this[t],e),"showCodePen"===t&&(this.dispatchEvent(new CustomEvent("show-code-pen-changed",{detail:{value:this[t]}})),this[t]&&!globalThis.customElements.get("code-pen-button")&&import("./lib/code-pen-button.js")),"value"===t&&this.dispatchEvent(new CustomEvent("value-changed",{detail:{value:this[t]}})),"focused"===t&&this.dispatchEvent(new CustomEvent("focused-changed",{detail:{focused:this[t]}})),["title","value"].includes(t)&&(this.codePenData=this._computeCodePenData(this.title,this.value))}))}_computeCodePenData(e,t){return{title:e,html:t,head:'<script>globalThis.WCGlobalCDNPath="https://cdn.webcomponents.psu.edu/cdn/";<\/script><script src="https://cdn.webcomponents.psu.edu/cdn/build.js"><\/script>'}}_handleFocus(e){this.focused=!0}_handleBlur(e){this.focused=!1}_modeChanged(e){this.language=this.mode}_editorDataChanged(e){this.value=e.detail}updateEditorValue(){var e="",t=this.children;if(this.childNodes[0]&&"TEMPLATE"!==this.childNodes[0].tagName&&0===this.children.length){if((t=this.childNodes).length>0)for(var o=0,i=t.length;o<i;o++)t[o].tagName?e+=t[o].outerHTML:e+=t[o].textContent}else this.children[0]&&(e=this.children[0].content&&this.children[0].content.children&&1===this.children[0].content.children.length&&"IFRAME"===this.children[0].content.children[0].tagName&&this.children[0].content.children[0].innerHTML?this.children[0].content.children[0].innerHTML:this.children[0].innerHTML);e&&(this.shadowRoot.querySelector("#codeeditor").value=e.trim())}_editorValueChanged(e){e&&(this.innerHTML="",this.innerHTML=`<template>${e}</template>`,this.updateEditorValue())}haxHooks(){return{preProcessNodeToContent:"haxpreProcessNodeToContent",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(e,t){if(!t){let t=this.getValueAsNode(e);e&&e.replaceWith(t),e=t}return e}haxpreProcessNodeToContent(e){return e.editorValue=null,e.codePenData=null,e.value=null,e.removeAttribute("value"),e.removeAttribute("code-pen-data"),e}getValueAsNode(e=null){return null==e&&(e=globalThis.document.createElement("p")),this.value&&(e.innerHTML=this.value),e.firstElementChild&&1===e.children.length&&e.firstElementChild.tagName===e.tagName?e.firstElementChild:e}connectedCallback(){super.connectedCallback(),this._observer=new MutationObserver((e=>{this.updateEditorValue()}))}disconnectedCallback(){this._observer&&(this._observer.disconnect(),this._observer=null),super.disconnectedCallback()}editorReady(e){this.editorValue?this.shadowRoot.querySelector("#codeeditor").value=this.editorValue:this.updateEditorValue(),this._observer&&this._observer.observe(this,{childList:!0,subtree:!0,characterData:!0,attributes:!0})}}customElements.define(CodeEditor.tag,CodeEditor);export{CodeEditor};