import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{SchemaBehaviors as s}from"../schema-behaviors/schema-behaviors.js";import{licenseList as n}from"../license-element/license-element.js";import{generateResourceID as r}from"../utils/utils.js";import{DDDSuper as o}from"../d-d-d/d-d-d.js";import{DDDReset as c}from"../d-d-d/lib/DDDStyles.js";class CitationElement extends(s(o(e))){static get styles(){return[i`
        :host {
          display: block;
        }
        :host([display-method="footnote"]) {
          visibility: hidden;
          opacity: 0;
        }
        :host([display-method="popup"]) {
          display: block;
        }
        .license-link {
          font-style: italic;
        }
        .license-link img {
          margin-right: var(--ddd-spacing-2);
        }
        cite {
          display: block;
          font-style: normal;
          margin-bottom: var(--ddd-spacing-2);
        }

        a {
          color: var(--ddd-theme-default-link);
          font-weight: var(--ddd-font-weight-bold);
        }
      `]}render(){return t`
      <meta
        about="${this.relatedResource}"
        property="cc:attributionUrl"
        content="${this.source}"
      />
      <meta
        about="${this.relatedResource}"
        property="cc:attributionName"
        typeof="oer:Text"
        content="${this.title}"
      />
      <meta
        rel="cc:license"
        href="${this.licenseLink}"
        content="License: ${this.licenseName}"
      />
      <cite
        ><a
          target="_blank"
          rel="noopener noreferrer"
          class="license-link"
          href="${this.source}"
          >${this.title}</a
        >
        by
        ${this.creator}${this.licenseName?t`, licensed under
              <a
                class="license-link"
                rel="noopener noreferrer"
                target="_blank"
                href="${this.licenseLink}"
                ><img
                  loading="lazy"
                  alt="${this.licenseName} graphic"
                  src="${this.licenseImage}"
                  ?hidden="${!this.licenseImage}"
                  width="44px"
                  height="16px"
                />${this.licenseName}</a
              >`:""}.
        Accessed <span class="license-link">${this.date}</span>.</cite
      >
    `}static get tag(){return"citation-element"}constructor(){super(),this.scope="sibling",this.source=""}updated(e){e.forEach(((e,t)=>{"scope"==t&&this._scopeChanged(this[t]),"license"==t&&this._licenseUpdated(this[t]),["relatedResource","licenseLink"].includes(t)&&(this._aboutLink=this._generateAboutLink(this.relatedResource,this.licenseLink)),"source"==t&&(this._licenseLink=this._generateLicenseLink(this.source))}))}static get properties(){return{...super.properties,title:{type:String},scope:{type:String},displayMethod:{type:String,reflect:!0,attribute:"display-method"},creator:{type:String},source:{type:String},date:{type:String},licenseName:{type:String,attribute:"license-name"},licenseLink:{type:String,attribute:"license-link"},license:{type:String}}}_generateLicenseLink(e){this._licenseLink&&globalThis.document.head.removeChild(this._licenseLink);let t=globalThis.document.createElement("link");return t.setAttribute("typeof","resource"),t.setAttribute("rel","license"),t.setAttribute("src",e),globalThis.document.head.appendChild(t),t}_generateAboutLink(e,t){this._aboutLink&&globalThis.document.head.removeChild(this._aboutLink);let i=globalThis.document.createElement("link");return i.setAttribute("about",e),i.setAttribute("property","cc:license"),i.setAttribute("content",t),globalThis.document.head.appendChild(i),i}_scopeChanged(e){if("sibling"===e&&null!==this.previousElementSibling){if(this.previousElementSibling.getAttribute("resource"))this.relatedResource=this.previousElementSibling.getAttribute("resource");else{let e=r();this.relatedResource=e,this.previousElementSibling.setAttribute("resource",e)}this.previousElementSibling.setAttribute("prefix",this.getAttribute("prefix"))}else if("parent"===e){if(this.parentNode.getAttribute("resource"))this.relatedResource=this.parentNode.getAttribute("resource");else{let e=r();this.relatedResource=e,this.parentNode.setAttribute("resource",e)}this.parentNode.setAttribute("prefix",this.getAttribute("prefix"))}}static get haxProperties(){return{canScale:!1,canEditSource:!0,gizmo:{title:"Citation",description:"A basic citation element with 3 presentation modes",icon:"editor:title",color:"grey",tags:["Authoring","content","citation","reference","cc0","cc-by","cc-by-sa","cc-by-nd","cc-by-nc","cc-by-nc-sa","cc-by-nc-nd"],handles:[{type:"citation",source:"source",title:"title",author:"creator",license:"license",accessDate:"date"}],meta:{author:"HAXTheWeb core team"}},settings:{configure:[{property:"title",title:"Title",description:"The title of the work being cited.",inputMethod:"textfield",icon:"editor:title"},{property:"source",title:"Source link",description:"The source url for the element this is citing.",inputMethod:"textfield",icon:"link",validationType:"url"},{property:"date",title:"Date accessed",description:"The date this was accessed.",inputMethod:"textfield",icon:"link"},{property:"scope",title:"Scope",description:"Scope of what to cite.",inputMethod:"select",options:{sibling:"Sibling element",parent:"Parent element"},icon:"code"},{property:"license",title:"License",description:"The source url for the element this is citing.",inputMethod:"select",options:new n("select"),icon:"link"},{property:"creator",title:"Creator",description:"Who made or owns this.",inputMethod:"textfield",icon:"link"}],advanced:[]},demoSchema:[{tag:"citation-element",properties:{creator:"Cool Joe",license:"by",title:"Te Futr Da Biz",source:"https://duckduckgo.com/",date:"03/07/2020"},content:""}]}}_licenseUpdated(e){if(void 0!==e){var t=new n;void 0!==t[e]&&(this.licenseName=t[e].name,this.licenseLink=t[e].link,this.licenseImage=t[e].image)}}}customElements.define(CitationElement.tag,CitationElement);export{CitationElement};