/**
 * Copyright 2021
 * @license MIT, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-lite.js";import{IntersectionObserverMixin as o}from"../intersection-element/lib/IntersectionObserverMixin.js";class CheckItOut extends(o(t)){static get tag(){return"check-it-out"}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}static get properties(){return{...super.properties,checkedOut:{type:Boolean,attribute:"checked-out",reflect:!0},source:{type:String},icon:{type:String},__computedSource:{type:String},type:{type:String,reflect:!0},label:{type:String,reflect:!0},filePath:{type:String,attribute:"file-path"},modalTitle:{type:String,attribute:"modal-title"},hideExplorer:{type:Boolean,attribute:"hide-explorer"},ctl:{type:Boolean},view:{type:String},modal:{type:Boolean,reflect:!0}}}static get styles(){return[i`
        :host {
          display: block;
          --check-it-out-content-width: var(
            --check-it-out-container-width,
            800px
          );
          --check-it-out-content-height: 500px;
        }

        .container {
          display: none;
          position: relative;
          width: var(--check-it-out-container-width, 800px);
        }

        :host([checked-out]) .container {
          display: flex;
        }

        .check-it-out-btn {
          display: inline-flex;
          background-color: transparent;
          font-size: var(--check-it-out-modal-button-font-size, 18px);
          border: 2px solid var(--check-it-out-button-border-color, #000);
          font-weight: 700;
          padding: 10px 25px;
        }

        .check-it-out-btn:active,
        .check-it-out-btn:focus,
        .check-it-out-btn:hover {
          outline: 2px dashed var(--check-it-out-button-border-color, #000);
          outline-offset: 2px;
        }

        :host([checked-out]) .check-it-out-btn {
          display: none;
        }

        :host([checked-out]) .close-btn {
          display: flex;
        }

        .close-btn {
          display: none;
          border-radius: 50%;
          padding: 0.5em;
          width: 30px;
          height: 30px;
          border: 2px solid black;
          color: grey;
          position: absolute;
          top: -10px;
          right: -10px;
          z-index: 2;
        }

        .close-btn:hover {
          border: 2px solid black;
          background-color: grey;
          color: #ffffff;
        }

        .close-btn::before {
          content: " ";
          position: absolute;
          background-color: black;
          width: 2px;
          left: 12px;
          top: 5px;
          bottom: 5px;
          transform: rotate(45deg);
        }

        .close-btn::after {
          content: " ";
          position: absolute;
          background-color: black;
          height: 2px;
          top: 12px;
          left: 5px;
          right: 5px;
          transform: rotate(45deg);
        }
        simple-modal-template[modal-id="m1"] {
          --simple-modal-width: var(--check-it-out-modal-width, 80vw);
          --simple-modal-height: var(--check-it-out-modal-height, 55vh);
          --simple-modal-min-width: var(--check-it-out-modal-width, 80vw);
          --simple-modal-min-height: var(--check-it-out-modal-height, 55vh);
        }

        .iframe-container {
          width: var(--check-it-out-content-width, 800px);
          height: var(--check-it-out-content-height, 500px);
        }

        .video-player {
          width: var(--check-it-out-content-width, 800px);
          height: var(--check-it-out-content-height, 500px);
        }
        iframe-loader {
          text-align: center;
          display: block;
          width: var(--check-it-out-content-width, 800px);
        }
      `]}render(){return this.icon=this.icon?this.icon:this.typeIconObj[this.type],e` ${this.elementVisible?e`
          <button
            class="check-it-out-btn"
            @click="${this._handleClick}"
            controls="m1"
          >
            <simple-icon-lite icon="${this.icon}"> </simple-icon-lite>
            ${this.label}
            <slot></slot>
          </button>
          ${this.modal?e`
                <simple-modal-template
                  title="${this.modalTitle}"
                  @click="${this._handleClick}"
                  modal-id="m1"
                >
                  <div slot="content">
                    <!-- bandaid and a terrible one -->
                    <style>
                      simple-modal .container {
                        display: block;
                        position: relative;
                        width: var(--check-it-out-container-width, 70vw);
                      }
                      simple-modal .container .iframe-container {
                        width: var(--check-it-out-content-width, 70vw);
                        height: var(--check-it-out-content-height, 45vh);
                      }

                      simple-modal .container .video-player {
                        width: var(--check-it-out-content-width, 70vw);
                        height: var(--check-it-out-content-height, 45vh);
                      }
                      simple-modal .container iframe-loader {
                        text-align: center;
                        display: block;
                        width: var(--check-it-out-content-width, 45vh);
                      }
                    </style>
                    ${this.renderLogic()}
                  </div>
                </simple-modal-template>
              `:e` ${this.renderLogic()} `}
        `:""}`}renderLogic(){return e`
      ${["code","pdf"].includes(this.type)?e`<div class="container">
            <iframe-loader>
              <iframe
                class="iframe-container"
                src=${this.__computedSource}
                loading="lazy"
              ></iframe>
              ${this.modal?"":e`
                    <button
                      class="close-btn"
                      @click="${this._handleClick}"
                    ></button>
                  `}
            </iframe-loader>
          </div>`:e`
            <div class="container">
              <video-player
                class="video-player"
                source=${this.__computedSource}
              >
              </video-player>
              ${this.modal?"":e`
                    <button
                      class="close-btn"
                      @click="${this._handleClick}"
                    ></button>
                  `}
            </div>
          `}
    `}constructor(){super(),this.typeIconObj={code:"code",pdf:"book",video:"av:play-arrow"},this.icon="code",this.modalTitle="",this.checkedOut=!1,this.type="",this.hideExplorer=!1,this.ctl=!1,this.view="both"}_handleClick(t){this._haxstate&&this.modal?(t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation()):this._haxstate||this.modal||(this.checkedOut?this.checkedOut=!1:this.checkedOut=!0)}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(t,e){e&&(this._haxstate=e)}haxeditModeChanged(t){this._haxstate=t}checkType(t){return[".mp4",".mkv",".flv",".wmv",".ovg",".webm",".mov"].filter((e=>t.endsWith(e))).length>0||t.includes("youtube.com")?(this.type="video",import("../video-player/video-player.js")):t.endsWith(".pdf")?this.type="pdf":t.includes("stackblitz.com")?(this.type="code",t.includes("embed=1")||(t.includes("?")?t+="&embed=1":t+="?embed=1"),t=this.checkStackblitzProps(t)):t.includes("codepen.io")&&(this.type="code",t.includes("embed")||(t=t.replace("/pen/","/embed/"))),"video"!=this.type&&import("../iframe-loader/iframe-loader.js"),t}checkStackblitzProps(t){return this.filePath&&(t+="&file="+this.filePath),this.hideExplorer&&(t+="&hideExplorer=1"),this.ctl&&(t+="&ctl=1"),t+=`&view=${this.view}`}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"modal"===e&&this[e]&&this.elementVisible&&import("../simple-modal/lib/simple-modal-template.js").then((()=>{this.shadowRoot&&this.shadowRoot.querySelector('[modal-id="m1"]').associateEvents(this.shadowRoot.querySelector('[controls="m1"]'))})),"source"===e&&this[e]&&(clearTimeout(this.__debounce),this.__debounce=setTimeout((()=>{this.__computedSource=this.checkType(this.source)}),0))}))}}customElements.define(CheckItOut.tag,CheckItOut);export{CheckItOut};