/**
 * Copyright 2024 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{DDD as e}from"../../d-d-d/d-d-d.js";import{css as t,html as s}from"../../../lit/index.js";import{autorun as i,toJS as r}from"../../../mobx/dist/mobx.esm.js";import{ChatStore as o}from"./chat-agent-store.js";class ChatSuggestion extends e{static get tag(){return"chat-suggestion"}constructor(){super(),this.chosenPrompt=!1,this.disabled=!1,this.promptType="",this.suggestion="",
//! mobx
this.messageIndex=null,this.userIndex=null,i((()=>{this.messageIndex=r(o.messageIndex)})),i((()=>{this.userIndex=r(o.userIndex)}))}static get styles(){return[super.styles,t`
        /* https://haxtheweb.org/documentation/ddd */

        :host {
          container-type: inline-size;
          display: block;
        }

        .chat-suggestion-wrapper {
          align-items: center;
          border: var(--ddd-border-sm);
          background-color: var(--ddd-theme-default-successLight);
          border-color: var(--ddd-theme-default-potentialMidnight);
          border-radius: var(--ddd-radius-xl);
          box-shadow: var(--ddd-boxShadow-xl);
          cursor: pointer;
          display: flex;
          flex-direction: row;
          justify-content: center;
          opacity: 1;
        }

        .suggestion-icon {
          align-items: center;
          border-right-style: solid;
          border-right: var(--ddd-border-md);
          display: flex;
          justify-content: center;
          width: 20%;
        }

        .circle-wrapper {
          background-color: white;
          border-radius: var(--ddd-radius-circle);
          padding: var(--ddd-spacing-2);
          margin: var(--ddd-spacing-1) var(--ddd-spacing-0);
        }

        simple-icon-lite {
          --simple-icon-height: var(--ddd-icon-xxs);
          --simple-icon-width: var(--ddd-icon-xxs);
        }

        .suggestion-text {
          align-items: center;
          display: flex;
          justify-content: center;
          width: 80%;

          /* Prevent text highlighting in button */
          -moz-user-select: none;
          -ms-user-select: none;
          -webkit-user-select: none;
          user-select: none;
        }

        :host([disabled]) .chat-suggestion-wrapper {
          background-color: var(--ddd-theme-default-discoveryCoral);
          cursor: default;
          opacity: 0.6;
        }

        :host([chosen-prompt]) .chat-suggestion-wrapper {
          background-color: var(--ddd-theme-default-futureLime);
        }

        .chat-suggestion-wrapper:hover,
        .chat-suggestion-wrapper:focus {
          background-color: var(--ddd-theme-default-futureLime);
        }

        .chat-suggestion-wrapper:hover p,
        .chat-suggestion-wrapper:focus p {
          text-decoration: underline;
        }

        :host([disabled]) p {
          text-decoration: none;
        }

        p {
          color: var(--ddd-theme-default-potentialMidnight);
          font-family: var(--ddd-font-primary);
          font-size: var(--ddd-font-size-4xs);
          text-align: center;
          width: 80%;
          margin: 0px;
        }

        @container (max-width: 216px) {
          .suggestion-icon {
            display: none;
          }
        }
      `]}render(){return s`
      <div
        class="chat-suggestion-wrapper"
        @click=${this.handleSuggestion}
        @keypress=${this.handleSuggestion}
        tabindex="0"
        aria-label='Send suggestion "${this.suggestion}" to Merlin'
      >
        <div class="suggestion-icon">
          <div class="circle-wrapper">
            <simple-icon-lite></simple-icon-lite>
          </div>
        </div>
        <div class="suggestion-text">
          <p class="chat-suggestion">${this.suggestion}</p>
        </div>
      </div>
    `}handleSuggestion(){this.disabled?o.devStatement("Suggestion buttons disabled, ignoring request","warn"):(o.devStatement(`Suggestion button pressed. Suggested prompt to send to Merlin: ${this.suggestion}`,"info"),o.handleMessage(o.userName,this.suggestion))}firstUpdated(){let e=this.shadowRoot.querySelector("simple-icon-lite");switch(this.promptType){case"suggestion":e.setAttribute("icon","question-answer"),e.style.color="var(--data-theme-primary, var(--ddd-primary-13))";break;case"network":e.setAttribute("icon","device:signal-cellular-connected-no-internet-0-bar"),e.style.color="var(--ddd-theme-default-coalyGray)";break;case"help":e.setAttribute("icon","help-outline"),e.style.color="var(--ddd-theme-default-original87Pink)";break;case"hax":e.setAttribute("icon","hax:hax2022"),e.style.color="var(--data-theme-primary, var(--ddd-primary-13))";break;default:e.setAttribute("icon","lrn:info"),e.style.color="var(--ddd-theme-default-skyBlue)"}}updated(){this.disabled&&this.shadowRoot.querySelector(".chat-suggestion-wrapper").removeAttribute("tabindex")}static get properties(){return{...super.properties,chosenPrompt:{type:Boolean,attribute:"chosen-prompt"},disabled:{type:Boolean},promptType:{type:String,attribute:"prompt-type"},suggestion:{type:String}}}}globalThis.customElements.define(ChatSuggestion.tag,ChatSuggestion);export{ChatSuggestion};