/**
 * Copyright 2024 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{DDD as e}from"../../d-d-d/d-d-d.js";import"../../type-writer/type-writer.js";import{css as t,html as s}from"../../../lit/index.js";import{autorun as a,toJS as d}from"../../../mobx/dist/mobx.esm.js";import{ChatStore as r}from"./chat-agent-store.js";class ChatMessage extends e{static get tag(){return"chat-message"}constructor(){super(),this.darkMode=null,this.editMode=null,this.hasSuggestedPrompts=!1,this.hat="none",this.isSentPrompt=!1,this.message="",this.messageWasSuggestedPrompt=!1,this.suggestedPrompts=r.currentSuggestions,a((()=>{this.darkMode=d(r.darkMode)})),a((()=>{this.editMode=d(r.editMode)}))}static get styles(){return[super.styles,t`
        /* https://haxtheweb.org/documentation/ddd */

        :host {
          container-type: inline-size;
          display: block;
        }

        .chat-message-wrapper {
          border-bottom-style: dashed;
          border-bottom: var(--ddd-border-md);
          padding: var(--ddd-spacing-2) var(--ddd-spacing-3);
        }

        .sent-chat-message,
        .message {
          align-items: center;
          display: flex;
          flex-direction: row;
          gap: var(--ddd-spacing-3);
        }

        .received-chat-message {
          display: flex;
          flex-direction: column;
        }

        .author-icon {
          align-items: center;
          background-color: var(--ddd-theme-default-white);
          border-radius: var(--ddd-radius-circle);
          border: var(--ddd-border-md);
          border-color: var(--ddd-theme-default-coalyGray);
          display: flex;
          height: var(--ddd-spacing-18);
          justify-content: center;
          width: var(--ddd-spacing-18);
        }

        :host([dark-mode]) .author-icon {
          border-color: var(--ddd-theme-default-slateGray);
        }

        .received-chat-message .author-icon {
          border-radius: var(--ddd-radius-xl);
        }

        simple-icon-lite {
          color: var(--data-theme-primary, var(--ddd-primary-13));
          --simple-icon-height: var(--ddd-icon-md);
          --simple-icon-width: var(--ddd-icon-md);
        }

        rpg-character {
          height: var(--ddd-spacing-12);
          margin-bottom: var(--ddd-spacing-3);
          width: var(--ddd-spacing-12);
        }

        .message-content {
          border-radius: var(--ddd-radius-sm);
          border: var(--ddd-border-md);
          border-color: var(--ddd-theme-default-coalyGray);
          color: var(--ddd-theme-default-coalyGray);
          font: var(--ddd-font-primary);
          font-size: var(--ddd-font-size-4xs);
          margin: var(--ddd-spacing-0);
          padding: var(--ddd-spacing-2);
          width: 80%;
        }

        :host([dark-mode]) .message-content {
          border-color: var(--ddd-theme-default-slateGray);
          color: var(--ddd-theme-default-white);
          background-color: var(--ddd-theme-default-coalyGray);
        }

        .suggested-prompts {
          display: flex;
          flex-direction: column;
          gap: var(--ddd-spacing-2);
          justify-content: center;
          padding-top: var(--ddd-spacing-3);
        }

        @container (max-width: 190px) {
          .author-icon {
            display: none;
          }

          .received-chat-message .message-content {
            background: rgba(73, 29, 112, 0.1);
          }

          .message {
            align-items: center;
            display: flex;
            justify-content: center;
          }
        }
      `]}render(){return s`
      <div class="chat-message-wrapper">
        ${this.isSentPrompt?this.renderSentMessage():this.renderReceivedMessage()}
      </div>
    `}renderReceivedMessage(){return s`
      <div class="received-chat-message">
        <div class="message">
          <div class="author-icon">
            <simple-icon-lite icon="hax:wizard-hat"></simple-icon-lite>
          </div>
          <type-writer
            class="message-content"
            text="${this.message}"
            speed="${r.merlinTypeWriterSpeed}"
          ></type-writer>
        </div>
        <div class="suggested-prompts">
          ${this.suggestedPrompts.map((e=>s`
              <chat-suggestion
                suggestion="${e.suggestion}"
                prompt-type="${e.type}"
                @click=${this.disableSuggestions}
                @keypress=${this.disableSuggestions}
              ></chat-suggestion>
            `))}
        </div>
      </div>
    `}renderSentMessage(){return s`
      <div class="sent-chat-message">
        <p class="message-content">${this.message}</p>
        <div class="author-icon">
          <rpg-character
            seed="${r.userName}"
            hat="${this.hat}"
          ></rpg-character>
        </div>
      </div>
    `}firstUpdated(){this.pickHat()}pickHat(){2===r.month&&12===r.day?this.hat="party":6===r.month&&6===r.day?this.hat="cowboy":7===r.month&&27===r.day?this.hat="bunny":8===r.month&&15===r.day?this.hat="watermelon":9===r.month&&19===r.day?this.hat="pirate":10===r.month&&1===r.day?this.hat="coffee":10===r.month&&5===r.day?this.hat="education":12===r.month&&5===r.day?this.hat="ninja":12===r.month&&18===r.day?this.hat="knight":this.hat="none",this.editMode&&(this.hat="construction"),this.requestUpdate()}disableSuggestions(e){const t=this.shadowRoot.querySelectorAll("chat-suggestion");if(r.devStatement("Disabling previous suggestions.","info"),t.forEach((e=>{e.hasAttribute("disabled")||e.setAttribute("disabled","")})),!e.currentTarget.hasAttribute("chosen-prompt")){let s=!1;t.forEach((e=>{e.hasAttribute("chosen-prompt")&&(s=!0)})),s||e.currentTarget.setAttribute("chosen-prompt","")}}static get properties(){return{...super.properties,darkMode:{type:Boolean,attribute:"dark-mode",reflect:!0},editMode:{type:Boolean,attribute:"edit-mode",reflect:!0},hasSuggestedPrompts:{type:Boolean,attribute:"suggested-prompts"},hat:{type:String,attribute:"hat"},isSentPrompt:{type:Boolean,attribute:"sent-prompt"},message:{type:String,attribute:"message"},messageWasSuggestedPrompt:{type:Boolean,attribute:"suggested-message"},suggestedPrompts:{type:Array}}}}globalThis.customElements.define(ChatMessage.tag,ChatMessage);export{ChatMessage};