/**
 * Copyright 2024 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{DDD as e}from"../../d-d-d/d-d-d.js";import{css as t,html as s}from"../../../lit/index.js";import{autorun as a,toJS as i}from"../../../mobx/dist/mobx.esm.js";import{ChatStore as r}from"./chat-agent-store.js";class ChatInput extends e{static get tag(){return"chat-input"}constructor(){super(),this.chatLog=[],this.darkMode=null,this.messageIndex=null,this.userIndex=null,this.previousMessagesIndex=null,this.userName=null,a((()=>{this.chatLog=i(r.chatLog)})),a((()=>{this.darkMode=i(r.darkMode)})),a((()=>{this.messageIndex=i(r.messageIndex),this.previousMessagesIndex=i(this.messageIndex)})),a((()=>{this.userIndex=i(r.userIndex)})),a((()=>{this.userName=i(r.userName)}))}static get styles(){return[super.styles,t`
        /* https://haxtheweb.org/documentation/ddd */

        :host {
          display: block;
          font-family: var(--ddd-font-primary);
        }

        .chat-input-wrapper {
          align-items: center;
          display: flex;
          gap: var(--ddd-spacing-3);
          justify-content: center;
          padding: var(--ddd-spacing-2) var(--ddd-spacing-3);
          border-radius: var(--ddd-radius-lg);
        }

        :host([dark-mode]) .chat-input-wrapper {
          background-color: var(--ddd-theme-default-coalyGray);
          color: var(--ddd-theme-default-white);
        }

        #user-input {
          background-color: var(--ddd-theme-default-white);
          border-radius: var(--ddd-radius-lg);
          color: var(--ddd-theme-default-coalyGray);
          padding: var(--ddd-spacing-2) var(--ddd-spacing-3);
          resize: none;
          scrollbar-width: none;
          width: 85%;
        }

        :host([dark-mode]) #user-input {
          background-color: var(--ddd-theme-default-coalyGray);
          color: var(--ddd-theme-default-white);
        }

        button {
          align-items: center;
          background-color: #2b2a33;
          border-radius: var(--ddd-radius-sm);
          color: var(--ddd-theme-default-white);
          cursor: pointer;
          display: flex;
          gap: var(--ddd-spacing-1);
          justify-content: center;
        }

        button:hover,
        button:focus-visible {
          background-color: #52525e;
        }

        .send-button {
          align-items: center;
          background-color: var(--data-theme-primary, var(--ddd-primary-1));
          border-radius: var(--ddd-radius-circle);
          box-shadow: 0 4px rgba(0, 3, 33, 0.2);
          cursor: pointer;
          display: flex;
          height: 52px;
          justify-content: center;
          width: 52px;
        }

        #send-button:hover,
        #send-button:focus-visible {
          box-shadow: 0 6px rgba(0, 3, 33, 0.2);
          transform: translateY(-2px);
        }

        #send-button:active,
        #send-button.active-mimic {
          box-shadow: 0 1px rgba(0, 3, 33, 0.2);
          transform: translateY(3px);
        }

        simple-icon-lite {
          color: var(
            --lowContrast-override,
            var(--ddd-theme-bgContrast, white)
          );
        }

        simple-tooltip {
          --simple-tooltip-delay-in: 1000ms;
        }
      `]}render(){return s`
      <div class="chat-input-wrapper">
        <textarea
          name="prompt-input"
          id="user-input"
          placeholder="${r.promptPlaceholder}"
          @keydown=${this.handleKeyPress}
        ></textarea>
        <div class="up-down-btns">
          <button
            id="input-up-btn"
            @click=${this.handleDirectionButtons}
            aria-label="Display previously sent message (up)"
          >
            <simple-icon-lite
              icon="hardware:keyboard-arrow-up"
            ></simple-icon-lite>
          </button>
          <button
            id="input-down-btn"
            @click=${this.handleDirectionButtons}
            aria-label="Display previously sent message (down)"
          >
            <simple-icon-lite
              icon="hardware:keyboard-arrow-down"
            ></simple-icon-lite>
          </button>
        </div>
        <div
          class="send-button"
          id="send-button"
          @click=${this.handleSendButton}
          @keydown=${this.handleSendButtonKeyPress}
          tabindex="0"
          aria-label="Send Prompt"
        >
          <simple-icon-lite icon="icons:send"></simple-icon-lite>
        </div>
        <simple-tooltip for="send-button" position="left"
          >Send Prompt to Merlin</simple-tooltip
        >
      </div>
    `}handleKeyPress(e){switch(e.key){case"Enter":e.preventDefault(),this.handleSendButton();break;case"ArrowUp":e.preventDefault(),this.displayPreviousMessages("up");break;case"ArrowDown":e.preventDefault(),this.displayPreviousMessages("down")}}handleSendButtonKeyPress(e){if("Enter"===e.key){e.preventDefault();const t=this.shadowRoot.querySelector("#send-button");t.classList.contains("active-mimic")?t.classList.remove("active-mimic"):t.classList.add("active-mimic"),setTimeout((()=>{t.classList.remove("active-mimic")}),100),this.handleSendButton()}}handleDirectionButtons(e){const t=e.currentTarget.id;switch(r.devStatement(`${t} button pressed.`,"info"),t){case"input-up-btn":this.displayPreviousMessages("up");break;case"input-down-btn":this.displayPreviousMessages("down")}}handleSendButton(){const e=this.shadowRoot.querySelector("#user-input").value;r.promptCharacterLimit>0&&e.length>r.promptCharacterLimit&&alert(`Please shorten your prompt to no more than ${r.promptCharacterLimit} characters.`),""!==e?(r.devStatement(`Send function activated. "${e}" sent to Merlin.`,"info"),r.handleMessage(r.userName,e),this.shadowRoot.querySelector("#user-input").value=""):r.devStatement("Send button activated. No prompt to send.","warn")}displayPreviousMessages(e){let t=this.shadowRoot.querySelector("#user-input");switch(e){case"up":if(this.previousMessagesIndex>1){for(this.previousMessagesIndex--,r.devStatement(`Arrow Up pressed. Previous message index = ${this.previousMessagesIndex} and message index = ${this.messageIndex}`,"info");this.chatLog[this.previousMessagesIndex].author!==this.userName&&this.previousMessagesIndex>=1;)if(this.previousMessagesIndex--,this.previousMessagesIndex<1){this.previousMessagesIndex++;break}t.value=this.chatLog[this.previousMessagesIndex].message}break;case"down":if(this.previousMessagesIndex<this.messageIndex){for(this.previousMessagesIndex++;this.chatLog[this.previousMessagesIndex].author!==this.userName&&this.previousMessagesIndex<this.messageIndex;)if(this.previousMessagesIndex++,this.previousMessagesIndex>=this.messageIndex){this.previousMessagesIndex=this.messageIndex;break}this.previousMessagesIndex>=this.messageIndex?t.value="":t.value=this.chatLog[this.previousMessagesIndex].message}else t.value="";r.devStatement(`Arrow Down pressed. Previous message index = ${this.previousMessagesIndex} and message index = ${this.messageIndex}`,"info");break;default:r.devStatement(`Unknown direction: ${e}.`,"error")}}firstUpdated(){r.promptCharacterLimit>0&&this.shadowRoot.querySelector("#user-input").setAttribute("maxlength",`${r.promptCharacterLimit}`)}static get properties(){return{...super.properties,darkMode:{type:Boolean,attribute:"dark-mode",reflect:!0},userName:{type:String,attribute:"username"}}}}globalThis.customElements.define(ChatInput.tag,ChatInput);export{ChatInput};