/**
 * Copyright 2024 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{DDD as e}from"../../d-d-d/d-d-d.js";import{css as t,html as o}from"../../../lit/index.js";import{autorun as n,toJS as i}from"../../../mobx/dist/mobx.esm.js";import{ChatStore as l}from"./chat-agent-store.js";class ChatDeveloperPanel extends e{static get tag(){return"chat-developer-panel"}constructor(){super(),this.chatLog=[],this.context=null,this.engine=null,this.isFullView=null,n((()=>{this.chatLog=i(l.chatLog)})),n((()=>{this.context=i(l.context)})),n((()=>{this.engine=i(l.engine)})),n((()=>{this.isFullView=i(l.isFullView)}))}static get styles(){return[super.styles,t`
        /* https://haxtheweb.org/documentation/ddd */

        :host {
          container-type: inline-size;
          display: block;
        }

        .chat-developer-panel-wrapper {
          background-color: var(--ddd-theme-default-keystoneYellow);
          border-radius: var(--ddd-radius-sm);
          display: flex;
          flex-direction: column;
          gap: var(--ddd-spacing-2);
          padding: var(--ddd-spacing-1) var(--ddd-spacing-1);
        }

        .console-table {
          align-items: center;
          display: flex;
          gap: var(--ddd-spacing-1);
          justify-content: space-between;
        }

        .switches {
          align-items: center;
          display: flex;
          justify-content: center;
          gap: var(--ddd-spacing-1);
        }

        button,
        select {
          align-items: center;
          background-color: #2b2a33;
          border-radius: var(--ddd-radius-sm);
          color: var(--ddd-theme-default-white);
          cursor: pointer;
          display: flex;
          gap: var(--ddd-spacing-1);
          justify-content: center;
          font: var(--ddd-font-primary);
          font-size: 12px;
        }

        label {
          background-color: var(--ddd-theme-default-coalyGray);
          color: var(--ddd-theme-default-white);
          font-size: 14px;
          padding: var(--ddd-spacing-2);
        }

        button:hover,
        button:focus-visible {
          background-color: #52525e;
        }

        button > simple-icon-lite {
          --simple-icon-color: var(--ddd-theme-default-white);
        }

        simple-tooltip {
          --simple-tooltip-delay-in: 1000ms;
        }

        @container (max-width: 500px) {
          .btn-txt {
            display: none;
          }
        }

        @container (max-width: 180px) {
          .console-table {
            flex-wrap: wrap;
            justify-content: center;
          }
        }

        @media only screen and (max-height: 575px) {
          :host {
            display: none;
          }
        }
      `]}render(){return o`
      <div class="chat-developer-panel-wrapper">
        <div class="console-table">
          <!-- Maybe convert buttons to simple-cta -->
          <button
            id="console-table-user"
            @click=${this.handleConsoleTableButton}
            aria-label="Console table user chat log"
          >
            <div class="button-icon">
              <simple-icon-lite icon="hax:console-line"></simple-icon-lite>
              <simple-icon-lite icon="lrn:user"></simple-icon-lite>
            </div>
            <div class="button-text">
              <span class="btn-txt">console.table() user chat log</span>
            </div>
          </button>
          <simple-tooltip
            for="console-table-user"
            position="${this.isFullView?"right":"top"}"
            >Print User Chat Log as Table to Console</simple-tooltip
          >

          <button
            id="console-table-merlin"
            @click=${this.handleConsoleTableButton}
            aria-label="Console table merlin chat log"
          >
            <div class="button-icon">
              <simple-icon-lite icon="hax:console-line"></simple-icon-lite>
              <simple-icon-lite icon="hax:wizard-hat"></simple-icon-lite>
            </div>
            <div class="button-text">
              <span class="btn-txt">console.table() merlin chat log</span>
            </div>
          </button>
          <simple-tooltip
            for="console-table-merlin"
            position="${this.isFullView?"right":"top"}"
            >Print Merlin Chat Log as Table to Console</simple-tooltip
          >

          <button
            id="console-table-all"
            @click=${this.handleConsoleTableButton}
            aria-label="Console table entire chat log"
          >
            <div class="button-icon">
              <simple-icon-lite icon="hax:console-line"></simple-icon-lite>
              <simple-icon-lite icon="book"></simple-icon-lite>
            </div>
            <div class="button-text">
              <span class="btn-txt">console.table() entire chat log</span>
            </div>
          </button>
          <simple-tooltip
            for="console-table-all"
            position="${this.isFullView?"left":"top"}"
            >Print Entire Chat Log as Table to Console</simple-tooltip
          >

          <button
            id="download-as-json"
            @click=${this.handleDownloadAsJsonButton}
            aria-label="Download chat log as .json"
          >
            <div class="button-icon">
              <simple-icon-lite icon="icons:file-download"></simple-icon-lite>
              <simple-icon-lite icon="hax:code-json"></simple-icon-lite>
            </div>
            <div class="button-text">
              <span class="btn-txt">Download chat log as .json</span>
            </div>
          </button>
          <simple-tooltip
            for="download-as-json"
            position="${this.isFullView?"left":"top"}"
            >Download Chat Log as .json</simple-tooltip
          >
        </div>

        <div class="switches">
          <select
            name="select-engine"
            id="engine-selection"
            @change=${this.handleSwitchEngine}
          >
            <option value="alfred">Alfred (OpenAI)</option>
            <option value="robin">Robin (Anthropic)</option>
            <option value="Catwoman">Catwoman (ChatGPT)</option>
          </select>

          <select
            name="select-context"
            id="context-selection"
            @change=${this.handleContextChange}
          >
            <option value="phys211">Phys 211</option>
            <option value="haxcellence">HAX Docs</option>
            <option value="astro130">Astro 130</option>
            <option value="staxpython">Intro to Python</option>
            <option value="janetlaw">Janet Law</option>
            <option value="udni">UDNI</option>
            <option value="epubcyber440">Cyber 440</option>
            <option value="ciscopdfs">ciscopdfs</option>
          </select>
        </div>
      </div>
    `}firstUpdated(){const e=this.shadowRoot.querySelectorAll("#engine-selection option"),t=this.shadowRoot.querySelectorAll("#context-selection option");e.forEach((e=>{e.value===this.engine&&(e.selected=!0)})),t.forEach((e=>{e.value===l.context&&(e.selected=!0)}))}handleConsoleTableButton(e){const t=e.currentTarget.id;switch(console.info(`HAX-DEV-MODE: ${t} button pressed.`),t){case"console-table-user":console.table(this.compileChatLog(l.userName));break;case"console-table-merlin":console.table(this.compileChatLog("merlin"));break;case"console-table-all":console.table(this.chatLog)}}compileChatLog(e){l.devStatement(`Compiling "${e}" chat log...`,"info");let t=[];return this.chatLog.forEach((o=>{o.author===e&&t.push(o)})),t}handleDownloadAsJsonButton(){l.devStatement("Calling download funtion...","info"),l.handleDownload("json")}handleSwitchEngine(){l.engine=this.shadowRoot.querySelector("#engine-selection").value,l.devStatement(`Engine switched to ${l.engine}`,"info")}handleContextChange(){l.context=this.shadowRoot.querySelector("#context-selection").value,l.devStatement(`Context switched to ${l.context}`,"info")}static get properties(){return{...super.properties,context:{type:String,attribute:"context"},engine:{type:String,attribute:"engine"},isFullView:{type:Boolean,attribute:"is-full-view",reflect:!0}}}}globalThis.customElements.define(ChatDeveloperPanel.tag,ChatDeveloperPanel);export{ChatDeveloperPanel};