/**
 * Copyright 2024 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{DDD as t}from"../../d-d-d/d-d-d.js";import{css as e,html as o}from"../../../lit/index.js";import{autorun as i,toJS as l}from"../../../mobx/dist/mobx.esm.js";import{ChatStore as n}from"./chat-agent-store.js";class ChatControlBar extends t{static get tag(){return"chat-control-bar"}constructor(){super(),this.dataCollectionEnabled=null,this.isFullView=null,this.isInterfaceHidden=null,i((()=>{this.dataCollectionEnabled=l(n.dataCollectionEnabled)})),i((()=>{this.isFullView=l(n.isFullView)})),i((()=>{this.isInterfaceHidden=l(n.isInterfaceHidden)}))}static get styles(){return[super.styles,e`
        /* https://haxtheweb.org/documentation/ddd */

        :host {
          container-type: inline-size;
          display: block;
        }

        .chat-control-bar-wrapper {
          align-items: center;
          display: flex;
          justify-content: space-between;
          padding: var(--ddd-spacing-2) var(--ddd-spacing-0);
        }

        button {
          background-color: #2b2a33;
          border-radius: var(--ddd-radius-sm);
          color: var(--ddd-theme-default-white);
        }

        button:hover,
        button:focus-visible {
          background-color: #52525e;
        }

        button > simple-icon-lite {
          --simple-icon-color: var(--ddd-theme-default-white);
        }

        simple-tooltip {
          --simple-tooltip-delay-in: 1000ms;
        }

        .data-collection-icon {
          --simple-icon-color: var(--ddd-theme-default-original87Pink);
        }

        .data-collection-label {
          font: var(--ddd-font-primary);
          font-size: 12px;
        }

        :host([data-collection-enabled]) .data-collection-icon {
          --simple-icon-color: var(--ddd-theme-default-futureLime);
        }

        /* Phones */
        @media only screen and (max-width: 425px),
          only screen and (max-height: 616px) {
          #view-button {
            display: none;
          }
        }

        @container (max-width: 330px) {
          .data-collection-label {
            display: none;
          }
        }
      `]}render(){return o`
      <!-- https://open-apis.hax.cloud/?path=/story/media-icons--hax-iconset-story -->

      <div class="chat-control-bar-wrapper">
        <div class="left-side">
          <button
            id="download-button"
            @click=${this.handleDownloadLogButton}
            aria-label="Download Log as txt"
          >
            <simple-icon-lite icon="icons:file-download"></simple-icon-lite>
          </button>
          <simple-tooltip
            for="download-button"
            position="${this.isFullView?"right":"top"}"
            >Download Chat Log</simple-tooltip
          >

          <button
            id="reset-button"
            @click=${this.handleResetButton}
            aria-label="Reset Chat"
          >
            <simple-icon-lite icon="icons:refresh"></simple-icon-lite>
          </button>
          <simple-tooltip
            for="reset-button"
            position="${this.isFullView?"right":"top"}"
            >Reset Chat</simple-tooltip
          >

          <button
            id="data-collection-button"
            @click=${this.handleDataCollectionButton}
            aria-label="Toggle Data Collection"
          >
            <simple-icon-lite
              icon="lrn:data_usage"
              class="data-collection-icon"
            ></simple-icon-lite>
            <span class="data-collection-label">Data Collection</span>
          </button>
          <simple-tooltip
            for="data-collection-button"
            position="${this.isFullView?"right":"top"}"
            >Toggle Data Collection</simple-tooltip
          >

          <button
            id="dev-mode-button"
            @click=${this.handleDevModeButton}
            aria-label="Toggle Developer Mode"
          >
            <simple-icon-lite icon="hax:console-line"></simple-icon-lite>
          </button>
          <simple-tooltip
            for="dev-mode-button"
            position="${this.isFullView?"right":"top"}"
            >Toggle Developer Mode</simple-tooltip
          >
        </div>
        <div class="right-side">
          <button
            id="view-button"
            @click=${this.handleViewButton}
            aria-label="${this.isFullView?"Exit Full View":"Enter Full View"}"
          >
            <simple-icon-lite
              icon="${this.isFullView?"icons:fullscreen-exit":"icons:fullscreen"}"
            ></simple-icon-lite>
          </button>
          <simple-tooltip
            for="view-button"
            position="${this.isFullView?"left":"top"}"
            >${this.isFullView?"Exit Full View":"Enter Full View"}</simple-tooltip
          >

          ${this.isFullView?o`
                <button
                  id="hide-button"
                  @click=${this.handleHideButton}
                  aria-label="Hide Interface"
                >
                  <simple-icon-lite icon="remove"></simple-icon-lite>
                </button>
                <simple-tooltip
                  for="hide-button"
                  position="${this.isFullView?"left":"top"}"
                  >Hide Interface</simple-tooltip
                >
              `:""}
        </div>
      </div>
    `}handleDownloadLogButton(){n.devStatement("Download log button pressed.","log"),this.downloadChatLog()}handleResetButton(){n.devStatement("Reset button pressed.","log"),confirm("Reset the chat?")&&(confirm("Download the chat log before you reset?")?(n.devStatement("Download chat log before reset confirmed.","info"),this.downloadChatLog()):n.devStatement("Download chat log before reset denied.","warning"),this.resetChat())}handleDataCollectionButton(){n.dataCollectionEnabled=!n.dataCollectionEnabled,this.dataCollectionEnabled?alert("Your conversations will be used to train our AI models"):alert("Your conversations will not be used to train our AI models")}handleDevModeButton(){n.developerModeEnabled=!n.developerModeEnabled}handleViewButton(){n.devStatement("View switch button pressed.","log"),n.isFullView=!this.isFullView,this.requestUpdate(),n.devStatement("View switched to: "+(n.isFullView?"full":"standard"),"info")}handleHideButton(){n.devStatement("Hide button pressed.","log"),this.isInterfaceHidden||(n.isInterfaceHidden=!0)}downloadChatLog(){n.devStatement("Calling download function...","info"),n.handleDownload("txt")}resetChat(){n.devStatement("Resetting chat...","info"),n.chatLog=[],n.merlinIndex=0,n.messageIndex=0,n.userIndex=0,n.startAI()}static get properties(){return{...super.properties,dataCollectionEnabled:{type:Boolean,attribute:"data-collection-enabled",reflect:!0},isFullView:{type:Boolean,attribute:"is-full-view",reflect:!0},isInterfaceHidden:{type:Boolean,attribute:"is-interface-hidden",reflect:!0}}}}globalThis.customElements.define(ChatControlBar.tag,ChatControlBar);export{ChatControlBar};