/**
 * Copyright 2024 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{store as e}from"../../haxcms-elements/lib/core/haxcms-site-store.js";import{enableServices as t}from"../../micro-frontend-registry/lib/microServices.js";import{MicroFrontendRegistry as s}from"../../micro-frontend-registry/micro-frontend-registry.js";import{autorun as o,configure as n,makeObservable as i,observable as a,toJS as r}from"../../../mobx/dist/mobx.esm.js";n({enforceActions:!1}),t(["haxcms"]),s.add({endpoint:"/api/apps/haxcms/aiChat",name:"@haxcms/aiChat",title:"AI Chat",description:"AI based chat agent that can answer questions about a site",params:{site:"location of the HAXcms site OR site.json data",type:"site for site.json or link for remote loading",question:"Question to ask of the AI",engine:"which engine to use as we test multiple",context:"context to query based on. Course typical"}});globalThis.ChatAgentStore=globalThis.ChatAgentStore||{},globalThis.ChatAgentStore.requestAvailability=()=>(globalThis.ChatAgentStore.instance||(globalThis.ChatAgentStore.instance=document.createElement("chat-agent-store"),document.body.appendChild(globalThis.ChatAgentStore.instance)),globalThis.ChatAgentStore.instance);export const ChatStore=new class ChatAgentStore{constructor(){this.buttonIcon="hax:wizard-hat",this.buttonLabel="Merlin-AI",this.chatLog=[],this.context="phys211",this.currentSuggestions=[],this.darkMode=null,void 0!==e.darkMode?this.darkMode=e.darkMode:this.darkMode=!1,this.dataCollectionEnabled=!0,this.developerModeEnabled=!1,void 0!==e.editMode?this.editMode=e.editMode:this.editMode=!1,this.engine="alfred",this.isFullView=!1,this.isInterfaceHidden=!0,this.isLoading=null,this.merlinIndex=0,this.merlinTypeWriterSpeed=2,this.messageIndex=0,this.promptCharacterLimit,this.promptPlaceholder="Enter your prompt here...",this.userIndex=0,this.userTypeWriterSpeed=0,void 0!==e.userData.userName?this.userName=e.userData.userName:this.userName="guest",this.date=new Date,this.month=this.date.getMonth()+1,this.day=this.date.getDate(),i(this,{buttonIcon:a,chatLog:a,context:a,darkMode:a,dataCollectionEnabled:a,developerModeEnabled:a,editMode:a,engine:a,isFullView:a,isInterfaceHidden:a,isLoading:a,merlinIndex:a,messageIndex:a,userIndex:a}),o((()=>{r(this.buttonIcon),r(this.chatLog),r(this.context);const t=r(e.darkMode),s=(r(this.dataCollectionEnabled),r(this.developerModeEnabled),r(e.editMode)),o=(r(this.engine),r(this.isFullView),r(this.isInterfaceHidden),r(this.isLoading));r(this.merlinIndex),r(this.messageIndex),r(this.userIndex);this.buttonIcon=o?"hax:loading":"hax:wizard-hat",this.darkMode=!!t,this.editMode=!!s}))}startAI(){this.handleMessage("merlin",`Hello! My name is Merlin. I am currently in beta, and may not yet be feature complete, so you may encounter some bugs. By default I can answer questions about ${this.context}. How can I assist you today?`),2===this.month&&12===this.day||6===this.month&&6===this.day||7===this.month&&27===this.day||8===this.month&&15===this.day||9===this.month&&19===this.day||10===this.month&&1===this.day||10===this.month&&5===this.day||12===this.month&&5===this.day||12===this.month&&18===this.day?this.currentSuggestions=[{suggestion:"Who are you?",type:"hax"},{suggestion:"What can you do for me?",type:"help"},{suggestion:"How do I use you?",type:"help"},{suggestion:"Why is my character wearing a hat?",type:"hax"}]:this.currentSuggestions=[{suggestion:"Who are you?",type:"hax"},{suggestion:"What can you do for me?",type:"help"},{suggestion:"How do I use you?",type:"help"}];try{document.querySelector("chat-agent").shadowRoot.querySelector("chat-interface").shadowRoot.querySelector("chat-message").shadowRoot.querySelectorAll("chat-suggestion").forEach((e=>{e.hasAttribute("disabled")&&e.removeAttribute("disabled"),e.hasAttribute("chosen-prompt")&&e.removeAttribute("chosen-prompt")}))}catch(e){this.devStatement(e,"error")}}handleMessage(e,t){let s;switch(this.devStatement(`Writing message "${t}" by ${e} to chatLog.`,"info"),this.messageIndex++,e){case"merlin":this.merlinIndex++,s=this.merlinIndex;break;case this.userName:this.userIndex++,s=this.userIndex}let o=new Date;const n={messageID:this.messageIndex,author:e,message:t,authorMessageIndex:s,timestamp:o.toString().replace(/\s/g,"-")};this.chatLog.push(n),e===this.userName&&this.handleInteraction(t)}handleInteraction(e){switch(this.devStatement(`Prompt sent to: ${this.engine}. Prompt sent: ${e}`,"info"),this.currentSuggestions=[],e){case"Who are you?":this.currentSuggestions=[{suggestion:"What can you do for me?",type:"help"},{suggestion:"How do I use you?",type:"help"}],this.handleMessage("merlin","I am Merlin. I was created for use within HAX websites as an assistant to help you with your questions. How may I help you today?");break;case"What can you do for me?":this.currentSuggestions=[{suggestion:"Who are you?",type:"hax"},{suggestion:"How do I use you?",type:"help"}],this.handleMessage("merlin","I can answer questions and chat with you about information relevant to the website you are navigating. How can I help you?");break;case"How do I use you?":this.currentSuggestions=[{suggestion:"Who are you?",type:"hax"},{suggestion:"What can you do for me?",type:"help"}],this.handleMessage("merlin","I support numerous functions. You can ask me questions, as well as download our chat log and reset our chat. You can start asking me questions by clicking on one of the suggested prompts, or by typing a prompt in the input box below and pressing the send button or pressing the enter key on your keyboard. Here are some of the keyboard controls you can utilize: \n 1. Tab Key - Navigates you through the numerous usable buttons. \n 2. Enter Key (in text area) - Will submit the prompt you wrote. \n 3. Enter key (When focusing on a button) - Will act in the same way as clicking the button. \n 4. Up & Down Arrow Keys (in text area) - will navigate you through previously sent prompts so you can send them again.");break;case"Why is my character wearing a hat?":this.currentSuggestions=[{suggestion:"Who are you?",type:"hax"},{suggestion:"What can you do for me?",type:"help"},{suggestion:"How do I use you?",type:"help"}],this.handleMessage("merlin","Your character is wearing a hat because today is either a special (hat related) holiday, or another special occassion!");break;case"Why can't you connect?":this.currentSuggestions=[{suggestion:"How do I fix this connection issue?",type:"network"}],this.handleMessage("merlin","I am either unable to connect to the internet, or a service I connect to is not available, meaning I cannot research how to respond to your prompt.");break;case"How do I fix this connection issue?":this.currentSuggestions=[{suggestion:"Why can't you connect?",type:"network"}],this.handleMessage("merlin","Please ensure you are connected to the internet. I cannot respond to (most of) your questions if you are not connected to the internet. If you are connected, it is likely one of my connected services is having an issue, I will try to fix that and be back to help you soon.");break;default:globalThis.document.querySelector("base")&&globalThis.document.querySelector("base").href;const t={site:{file:"https://haxtheweb.org/site.json"},type:"site",question:e,engine:this.engine,context:this.context};this.isLoading=!0,s.call("@haxcms/aiChat",t).then((e=>{200==e.status&&(this.answers=[e.data.answers],this.question=e.data.question,this.currentSuggestions=[]),this.isLoading=!1,this.handleMessage("merlin",e.data.answers)})).catch((e=>{this.isLoading=!1,this.currentSuggestions=[{suggestion:"Why can't you connect?",type:"network"},{suggestion:"How do I fix this connection issue?",type:"network"}],this.handleMessage("merlin","I'm sorry, I'm having trouble connecting right now. Please try again soon. If you'd like to learn more, please click on one of the suggested prompts."),this.devStatement(e,"error")}))}}handleDownload(e){if(this.devStatement(`Downloading chatlog as ${e}.`,"info"),0!==this.chatLog.length){const t=JSON.stringify(this.chatLog,void 0,2);let s=new Date;const o=`${this.userName}-chat-log-${s.toString().replace(/\s/g,"-")}.${e}`;let n=document.createElement("a");n.setAttribute("href","data:text/plain;charset=utf-8,"+encodeURIComponent(t)),n.setAttribute("download",o),n.click(),n.remove()}}devStatement(e,t){if(this.developerModeEnabled)switch(t){case"log":console.log(`CHAT-AGENT-DEV-MODE: ${e}`);break;case"info":console.info(`CHAT-AGENT-DEV-MODE: ${e}`);break;case"warn":console.warn(`CHAT-AGENT-DEV-MODE: ${e}`);break;case"error":console.error(`CHAT-AGENT-DEV-MODE: ${e}`);break;default:console.error("No devStatement type specified")}}};