/**
 * Copyright 2024 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{DDD as t}from"../d-d-d/d-d-d.js";import{enableServices as e}from"../micro-frontend-registry/lib/microServices.js";import{MicroFrontendRegistry as i}from"../micro-frontend-registry/micro-frontend-registry.js";import"../rpg-character/rpg-character.js";import"../simple-icon/simple-icon.js";import"../simple-tooltip/simple-tooltip.js";import{css as a,html as r}from"../../lit/index.js";import{autorun as n,configure as s,toJS as o}from"../../mobx/dist/mobx.esm.js";import{ChatStore as d}from"./lib/chat-agent-store.js";import"./lib/chat-button.js";import"./lib/chat-control-bar.js";import"./lib/chat-developer-panel.js";import"./lib/chat-input.js";import"./lib/chat-interface.js";import"./lib/chat-message.js";import"./lib/chat-suggestion.js";s({enforceActions:!1}),e(["haxcms"]),i.add({endpoint:"/api/apps/haxcms/aiChat",name:"@haxcms/aiChat",title:"AI Chat",description:"AI based chat agent that can answer questions about a site",params:{site:"location of the HAXcms site OR site.json data",type:"site for site.json or link for remote loading",question:"Question to ask of the AI",engine:"which engine to use as we test multiple",context:"context to query based on. Course typical"}});class ChatAgent extends t{static get tag(){return"chat-agent"}constructor(){super(),this.isFullView=null,this.isInterfaceHidden=null,n((()=>{this.isFullView=o(d.isFullView)})),n((()=>{this.isInterfaceHidden=o(d.isInterfaceHidden)}))}static get styles(){return[super.styles,a`
        /* https://haxtheweb.org/documentation/ddd */

        :host {
          container-type: normal;
          display: block;
        }

        .chat-agent-wrapper {
          bottom: var(--ddd-spacing-2);
          display: flex;
          flex-direction: column;
          gap: var(--ddd-spacing-2);
          position: fixed;
          right: var(--ddd-spacing-2);
          width: 35%;
        }

        :host([is-full-view]) .chat-agent-wrapper {
          bottom: var(--ddd-spacing-0);
          gap: var(--ddd-spacing-0);
          right: var(--ddd-spacing-0);
          width: 25%;
          @media only screen and (min-height: 1000px) {
            width: 35%;
          }
        }

        :host([is-full-view]:host([is-interface-hidden])) .chat-agent-wrapper {
          bottom: var(--ddd-spacing-2);
          gap: var(--ddd-spacing-2);
          right: var(--ddd-spacing-2);
        }

        .agent-interface-wrapper {
          display: flex;
          justify-content: right;
        }

        .agent-button-wrapper {
          display: flex;
          justify-content: right;
        }

        @container (max-width: 600px) {
          .chat-agent-wrapper {
            width: 30%;
          }
        }

        @media only screen and (max-width: 425px) {
          .chat-agent-wrapper {
            width: 90%;
          }
        }
      `]}render(){return r`
      <div class="chat-agent-wrapper">
        <div class="agent-interface-wrapper">
          <chat-interface></chat-interface>
        </div>
        <div class="agent-button-wrapper">
          <chat-button>
            <span slot="label">${d.buttonLabel}</span>
          </chat-button>
        </div>
      </div>
    `}firstUpdated(){d.startAI()}static get properties(){return{...super.properties,isFullView:{type:Boolean,attribute:"is-full-view",reflect:!0},isInterfaceHidden:{type:Boolean,attribute:"is-interface-hidden",reflect:!0}}}}customElements.define(ChatAgent.tag,ChatAgent);export{ChatAgent};globalThis.ChatAgentStore=globalThis.ChatAgentStore||{},globalThis.ChatAgentStore.requestAvailability=()=>(globalThis.ChatAgentStore.instance||(globalThis.ChatAgentStore.instance=document.createElement("chat-agent"),document.body.appendChild(globalThis.ChatAgentStore.instance)),globalThis.ChatAgentStore.instance);export const ChatAgentModalStore=globalThis.ChatAgentStore.requestAvailability();