/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import{generateResourceID as s}from"../utils/utils.js";import"../es-global-bridge/es-global-bridge.js";const ChartistRenderSuper=function(t){return class extends t{static get styles(){return[i`
          .ct-label {
            fill: rgba(0, 0, 0, 0.4);
            color: rgba(0, 0, 0, 0.4);
            font-size: 0.75rem;
            line-height: 1;
          }

          .ct-chart-line .ct-label,
          .ct-chart-bar .ct-label {
            display: block;
            display: -webkit-box;
            display: -moz-box;
            display: -ms-flexbox;
            display: -webkit-flex;
            display: flex;
          }

          .ct-chart-pie .ct-label,
          .ct-chart-donut .ct-label {
            dominant-baseline: central;
          }

          .ct-label.ct-horizontal.ct-start {
            -webkit-box-align: flex-end;
            -webkit-align-items: flex-end;
            -ms-flex-align: flex-end;
            align-items: flex-end;
            -webkit-box-pack: flex-start;
            -webkit-justify-content: flex-start;
            -ms-flex-pack: flex-start;
            justify-content: flex-start;
            text-align: left;
            text-anchor: start;
          }

          .ct-label.ct-horizontal.ct-end {
            -webkit-box-align: flex-start;
            -webkit-align-items: flex-start;
            -ms-flex-align: flex-start;
            align-items: flex-start;
            -webkit-box-pack: flex-start;
            -webkit-justify-content: flex-start;
            -ms-flex-pack: flex-start;
            justify-content: flex-start;
            text-align: left;
            text-anchor: start;
          }

          .ct-label.ct-vertical.ct-start {
            -webkit-box-align: flex-end;
            -webkit-align-items: flex-end;
            -ms-flex-align: flex-end;
            align-items: flex-end;
            -webkit-box-pack: flex-end;
            -webkit-justify-content: flex-end;
            -ms-flex-pack: flex-end;
            justify-content: flex-end;
            text-align: right;
            text-anchor: end;
          }

          .ct-label.ct-vertical.ct-end {
            -webkit-box-align: flex-end;
            -webkit-align-items: flex-end;
            -ms-flex-align: flex-end;
            align-items: flex-end;
            -webkit-box-pack: flex-start;
            -webkit-justify-content: flex-start;
            -ms-flex-pack: flex-start;
            justify-content: flex-start;
            text-align: left;
            text-anchor: start;
          }

          .ct-chart-bar .ct-label.ct-horizontal.ct-start {
            -webkit-box-align: flex-end;
            -webkit-align-items: flex-end;
            -ms-flex-align: flex-end;
            align-items: flex-end;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            text-align: center;
            text-anchor: start;
          }

          .ct-chart-bar .ct-label.ct-horizontal.ct-end {
            -webkit-box-align: flex-start;
            -webkit-align-items: flex-start;
            -ms-flex-align: flex-start;
            align-items: flex-start;
            -webkit-box-pack: center;
            -webkit-justify-content: center;
            -ms-flex-pack: center;
            justify-content: center;
            text-align: center;
            text-anchor: start;
          }

          .ct-chart-bar.ct-horizontal-bars .ct-label.ct-horizontal.ct-start {
            -webkit-box-align: flex-end;
            -webkit-align-items: flex-end;
            -ms-flex-align: flex-end;
            align-items: flex-end;
            -webkit-box-pack: flex-start;
            -webkit-justify-content: flex-start;
            -ms-flex-pack: flex-start;
            justify-content: flex-start;
            text-align: left;
            text-anchor: start;
          }

          .ct-chart-bar.ct-horizontal-bars .ct-label.ct-horizontal.ct-end {
            -webkit-box-align: flex-start;
            -webkit-align-items: flex-start;
            -ms-flex-align: flex-start;
            align-items: flex-start;
            -webkit-box-pack: flex-start;
            -webkit-justify-content: flex-start;
            -ms-flex-pack: flex-start;
            justify-content: flex-start;
            text-align: left;
            text-anchor: start;
          }

          .ct-chart-bar.ct-horizontal-bars .ct-label.ct-vertical.ct-start {
            -webkit-box-align: center;
            -webkit-align-items: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: flex-end;
            -webkit-justify-content: flex-end;
            -ms-flex-pack: flex-end;
            justify-content: flex-end;
            text-align: right;
            text-anchor: end;
          }

          .ct-chart-bar.ct-horizontal-bars .ct-label.ct-vertical.ct-end {
            -webkit-box-align: center;
            -webkit-align-items: center;
            -ms-flex-align: center;
            align-items: center;
            -webkit-box-pack: flex-start;
            -webkit-justify-content: flex-start;
            -ms-flex-pack: flex-start;
            justify-content: flex-start;
            text-align: left;
            text-anchor: end;
          }

          .ct-grid {
            stroke: rgba(0, 0, 0, 0.2);
            stroke-width: 1px;
            stroke-dasharray: 2px;
          }

          .ct-grid-background {
            fill: none;
          }

          .ct-point {
            stroke-width: 10px;
            stroke-linecap: round;
          }

          .ct-line {
            fill: none;
            stroke-width: 4px;
          }

          .ct-area {
            stroke: none;
            fill-opacity: 0.1;
          }

          .ct-bar {
            fill: none;
            stroke-width: 10px;
          }

          .ct-slice-donut {
            fill: none;
            stroke-width: 60px;
          }

          .ct-series-a .ct-point,
          .ct-series-a .ct-line,
          .ct-series-a .ct-bar,
          .ct-series-a .ct-slice-donut {
            stroke: #d70206;
          }

          .ct-series-a .ct-slice-pie,
          .ct-series-a .ct-slice-donut-solid,
          .ct-series-a .ct-area {
            fill: #d70206;
          }

          .ct-series-b .ct-point,
          .ct-series-b .ct-line,
          .ct-series-b .ct-bar,
          .ct-series-b .ct-slice-donut {
            stroke: #f05b4f;
          }

          .ct-series-b .ct-slice-pie,
          .ct-series-b .ct-slice-donut-solid,
          .ct-series-b .ct-area {
            fill: #f05b4f;
          }

          .ct-series-c .ct-point,
          .ct-series-c .ct-line,
          .ct-series-c .ct-bar,
          .ct-series-c .ct-slice-donut {
            stroke: #f4c63d;
          }

          .ct-series-c .ct-slice-pie,
          .ct-series-c .ct-slice-donut-solid,
          .ct-series-c .ct-area {
            fill: #f4c63d;
          }

          .ct-series-d .ct-point,
          .ct-series-d .ct-line,
          .ct-series-d .ct-bar,
          .ct-series-d .ct-slice-donut {
            stroke: #d17905;
          }

          .ct-series-d .ct-slice-pie,
          .ct-series-d .ct-slice-donut-solid,
          .ct-series-d .ct-area {
            fill: #d17905;
          }

          .ct-series-e .ct-point,
          .ct-series-e .ct-line,
          .ct-series-e .ct-bar,
          .ct-series-e .ct-slice-donut {
            stroke: #453d3f;
          }

          .ct-series-e .ct-slice-pie,
          .ct-series-e .ct-slice-donut-solid,
          .ct-series-e .ct-area {
            fill: #453d3f;
          }

          .ct-series-f .ct-point,
          .ct-series-f .ct-line,
          .ct-series-f .ct-bar,
          .ct-series-f .ct-slice-donut {
            stroke: #59922b;
          }

          .ct-series-f .ct-slice-pie,
          .ct-series-f .ct-slice-donut-solid,
          .ct-series-f .ct-area {
            fill: #59922b;
          }

          .ct-series-g .ct-point,
          .ct-series-g .ct-line,
          .ct-series-g .ct-bar,
          .ct-series-g .ct-slice-donut {
            stroke: #0544d3;
          }

          .ct-series-g .ct-slice-pie,
          .ct-series-g .ct-slice-donut-solid,
          .ct-series-g .ct-area {
            fill: #0544d3;
          }

          .ct-series-h .ct-point,
          .ct-series-h .ct-line,
          .ct-series-h .ct-bar,
          .ct-series-h .ct-slice-donut {
            stroke: #6b0392;
          }

          .ct-series-h .ct-slice-pie,
          .ct-series-h .ct-slice-donut-solid,
          .ct-series-h .ct-area {
            fill: #6b0392;
          }

          .ct-series-i .ct-point,
          .ct-series-i .ct-line,
          .ct-series-i .ct-bar,
          .ct-series-i .ct-slice-donut {
            stroke: #f05b4f;
          }

          .ct-series-i .ct-slice-pie,
          .ct-series-i .ct-slice-donut-solid,
          .ct-series-i .ct-area {
            fill: #f05b4f;
          }

          .ct-series-j .ct-point,
          .ct-series-j .ct-line,
          .ct-series-j .ct-bar,
          .ct-series-j .ct-slice-donut {
            stroke: #dda458;
          }

          .ct-series-j .ct-slice-pie,
          .ct-series-j .ct-slice-donut-solid,
          .ct-series-j .ct-area {
            fill: #dda458;
          }

          .ct-series-k .ct-point,
          .ct-series-k .ct-line,
          .ct-series-k .ct-bar,
          .ct-series-k .ct-slice-donut {
            stroke: #eacf7d;
          }

          .ct-series-k .ct-slice-pie,
          .ct-series-k .ct-slice-donut-solid,
          .ct-series-k .ct-area {
            fill: #eacf7d;
          }

          .ct-series-l .ct-point,
          .ct-series-l .ct-line,
          .ct-series-l .ct-bar,
          .ct-series-l .ct-slice-donut {
            stroke: #86797d;
          }

          .ct-series-l .ct-slice-pie,
          .ct-series-l .ct-slice-donut-solid,
          .ct-series-l .ct-area {
            fill: #86797d;
          }

          .ct-series-m .ct-point,
          .ct-series-m .ct-line,
          .ct-series-m .ct-bar,
          .ct-series-m .ct-slice-donut {
            stroke: #b2c326;
          }

          .ct-series-m .ct-slice-pie,
          .ct-series-m .ct-slice-donut-solid,
          .ct-series-m .ct-area {
            fill: #b2c326;
          }

          .ct-series-n .ct-point,
          .ct-series-n .ct-line,
          .ct-series-n .ct-bar,
          .ct-series-n .ct-slice-donut {
            stroke: #6188e2;
          }

          .ct-series-n .ct-slice-pie,
          .ct-series-n .ct-slice-donut-solid,
          .ct-series-n .ct-area {
            fill: #6188e2;
          }

          .ct-series-o .ct-point,
          .ct-series-o .ct-line,
          .ct-series-o .ct-bar,
          .ct-series-o .ct-slice-donut {
            stroke: #a748ca;
          }

          .ct-series-o .ct-slice-pie,
          .ct-series-o .ct-slice-donut-solid,
          .ct-series-o .ct-area {
            fill: #a748ca;
          }

          .ct-square {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-square:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 100%;
          }
          .ct-square:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-square > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-minor-second {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-minor-second:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 93.75%;
          }
          .ct-minor-second:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-minor-second > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-major-second {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-major-second:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 88.88889%;
          }
          .ct-major-second:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-major-second > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-minor-third {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-minor-third:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 83.33333%;
          }
          .ct-minor-third:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-minor-third > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-major-third {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-major-third:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 80%;
          }
          .ct-major-third:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-major-third > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-perfect-fourth {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-perfect-fourth:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 75%;
          }
          .ct-perfect-fourth:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-perfect-fourth > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-perfect-fifth {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-perfect-fifth:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 66.66667%;
          }
          .ct-perfect-fifth:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-perfect-fifth > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-minor-sixth {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-minor-sixth:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 62.5%;
          }
          .ct-minor-sixth:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-minor-sixth > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-golden-section {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-golden-section:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 61.8047%;
          }
          .ct-golden-section:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-golden-section > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-major-sixth {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-major-sixth:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 60%;
          }
          .ct-major-sixth:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-major-sixth > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-minor-seventh {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-minor-seventh:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 56.25%;
          }
          .ct-minor-seventh:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-minor-seventh > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-major-seventh {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-major-seventh:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 53.33333%;
          }
          .ct-major-seventh:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-major-seventh > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-octave {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-octave:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 50%;
          }
          .ct-octave:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-octave > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-major-tenth {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-major-tenth:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 40%;
          }
          .ct-major-tenth:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-major-tenth > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-major-eleventh {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-major-eleventh:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 37.5%;
          }
          .ct-major-eleventh:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-major-eleventh > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-major-twelfth {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-major-twelfth:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 33.33333%;
          }
          .ct-major-twelfth:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-major-twelfth > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          .ct-double-octave {
            display: block;
            position: relative;
            width: 100%;
          }
          .ct-double-octave:before {
            display: block;
            float: left;
            content: "";
            width: 0;
            height: 0;
            padding-bottom: 25%;
          }
          .ct-double-octave:after {
            content: "";
            display: table;
            clear: both;
          }
          .ct-double-octave > svg {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
          }

          :host {
            display: block;
            width: 100%;
            padding: var(--chartist-padding, 0px);
            margin: var(--chartist-margin, 15px 0);
            background-color: var(--chartist-bg-color, transparent);
            color: var(--chartist-text-color, #000);
          }

          .sr-only {
            position: absolute;
            left: -999999px;
            height: 0;
            overflow: hidden;
          }

          .ct-axis-title {
            fill: var(--chartist-text-color);
          }

          ::slotted(table) {
            border: 1px solid var(--chartist-text-color);
            border-collapse: collapse;
            width: 100%;
            max-width: 100%;
            overflow: auto;
          }

          .ct-label {
            fill: var(--chartist-text-color, #000);
            color: var(--chartist-text-color, #000);
            font-size: var(--chartist-text-size, 0.75rem);
            line-height: var(--chartist-line-height, 1);
          }

          .ct-grid {
            stroke: var(--chartist-grid-color, rgba(0, 0, 0, 0.2));
            stroke-width: 1px;
            stroke-dasharray: 2px;
          }

          .ct-series-a .ct-point,
          .ct-series-a .ct-line,
          .ct-series-a .ct-bar,
          .ct-series-a .ct-slice-donut {
            stroke: var(--chartist-color-1, #d70206);
          }

          .ct-series-a .ct-slice-pie,
          .ct-series-a .ct-slice-donut-solid,
          .ct-series-a .ct-area {
            fill: var(--chartist-color-1, #d70206);
          }

          .ct-series-b .ct-point,
          .ct-series-b .ct-line,
          .ct-series-b .ct-bar,
          .ct-series-b .ct-slice-donut {
            stroke: var(--chartist-color-2, #f05b4f);
          }

          .ct-series-b .ct-slice-pie,
          .ct-series-b .ct-slice-donut-solid,
          .ct-series-b .ct-area {
            fill: var(--chartist-color-2, #f05b4f);
          }

          .ct-series-c .ct-point,
          .ct-series-c .ct-line,
          .ct-series-c .ct-bar,
          .ct-series-c .ct-slice-donut {
            stroke: var(--chartist-color-3, #f4c63d);
          }

          .ct-series-c .ct-slice-pie,
          .ct-series-c .ct-slice-donut-solid,
          .ct-series-c .ct-area {
            fill: var(--chartist-color-3, #f4c63d);
          }

          .ct-series-d .ct-point,
          .ct-series-d .ct-line,
          .ct-series-d .ct-bar,
          .ct-series-d .ct-slice-donut {
            stroke: var(--chartist-color-4, #d17905);
          }

          .ct-series-d .ct-slice-pie,
          .ct-series-d .ct-slice-donut-solid,
          .ct-series-d .ct-area {
            fill: var(--chartist-color-4, #d17905);
          }

          .ct-series-e .ct-point,
          .ct-series-e .ct-line,
          .ct-series-e .ct-bar,
          .ct-series-e .ct-slice-donut {
            stroke: var(--chartist-color-5, #453d3f);
          }

          .ct-series-e .ct-slice-pie,
          .ct-series-e .ct-slice-donut-solid,
          .ct-series-e .ct-area {
            fill: var(--chartist-color-5, #453d3f);
          }

          .ct-series-f .ct-point,
          .ct-series-f .ct-line,
          .ct-series-f .ct-bar,
          .ct-series-f .ct-slice-donut {
            stroke: var(--chartist-color-6, #59922b);
          }

          .ct-series-f .ct-slice-pie,
          .ct-series-f .ct-slice-donut-solid,
          .ct-series-f .ct-area {
            fill: var(--chartist-color-6, #59922b);
          }

          .ct-series-g .ct-point,
          .ct-series-g .ct-line,
          .ct-series-g .ct-bar,
          .ct-series-g .ct-slice-donut {
            stroke: var(--chartist-color-7, #0544d3);
          }

          .ct-series-g .ct-slice-pie,
          .ct-series-g .ct-slice-donut-solid,
          .ct-series-g .ct-area {
            fill: var(--chartist-color-7, #0544d3);
          }

          .ct-series-h .ct-point,
          .ct-series-h .ct-line,
          .ct-series-h .ct-bar,
          .ct-series-h .ct-slice-donut {
            stroke: var(--chartist-color-8, #6b0392);
          }

          .ct-series-h .ct-slice-pie,
          .ct-series-h .ct-slice-donut-solid,
          .ct-series-h .ct-area {
            fill: var(--chartist-color-8, #6b0392);
          }

          .ct-series-i .ct-point,
          .ct-series-i .ct-line,
          .ct-series-i .ct-bar,
          .ct-series-i .ct-slice-donut {
            stroke: var(--chartist-color-9, #f05b4f);
          }

          .ct-series-i .ct-slice-pie,
          .ct-series-i .ct-slice-donut-solid,
          .ct-series-i .ct-area {
            fill: var(--chartist-color-9, #f05b4f);
          }

          .ct-series-j .ct-point,
          .ct-series-j .ct-line,
          .ct-series-j .ct-bar,
          .ct-series-j .ct-slice-donut {
            stroke: var(--chartist-color-10, #dda458);
          }

          .ct-series-j .ct-slice-pie,
          .ct-series-j .ct-slice-donut-solid,
          .ct-series-j .ct-area {
            fill: var(--chartist-color-10, #dda458);
          }

          .ct-series-k .ct-point,
          .ct-series-k .ct-line,
          .ct-series-k .ct-bar,
          .ct-series-k .ct-slice-donut {
            stroke: var(--chartist-color-11, #eacf7d);
          }

          .ct-series-k .ct-slice-pie,
          .ct-series-k .ct-slice-donut-solid,
          .ct-series-k .ct-area {
            fill: var(--chartist-color-11, #eacf7d);
          }

          .ct-series-l .ct-point,
          .ct-series-l .ct-line,
          .ct-series-l .ct-bar,
          .ct-series-l .ct-slice-donut {
            stroke: var(--chartist-color-12, #86797d);
          }

          .ct-series-l .ct-slice-pie,
          .ct-series-l .ct-slice-donut-solid,
          .ct-series-l .ct-area {
            fill: var(--chartist-color-12, #86797d);
          }

          .ct-series-m .ct-point,
          .ct-series-m .ct-line,
          .ct-series-m .ct-bar,
          .ct-series-m .ct-slice-donut {
            stroke: var(--chartist-color-13, #b2c326);
          }

          .ct-series-m .ct-slice-pie,
          .ct-series-m .ct-slice-donut-solid,
          .ct-series-m .ct-area {
            fill: var(--chartist-color-13, #b2c326);
          }

          .ct-series-n .ct-point,
          .ct-series-n .ct-line,
          .ct-series-n .ct-bar,
          .ct-series-n .ct-slice-donut {
            stroke: var(--chartist-color-14, #6188e2);
          }

          .ct-series-n .ct-slice-pie,
          .ct-series-n .ct-slice-donut-solid,
          .ct-series-n .ct-area {
            fill: var(--chartist-color-14, #6188e2);
          }

          .ct-series-o .ct-point,
          .ct-series-o .ct-line,
          .ct-series-o .ct-bar,
          .ct-series-o .ct-slice-donut {
            stroke: var(--chartist-color-15, #a748ca);
          }

          .ct-series-o .ct-slice-pie,
          .ct-series-o .ct-slice-donut-solid,
          .ct-series-o .ct-area {
            fill: var(--chartist-color-15, #a748ca);
          }
        `]}render(){return e` <div id="${this.__chartId}-title" class="title">
          ${this.chartTitle}
          <slot name="heading"></slot>
        </div>
        <div id="${this.__chartId}-desc" class="desc">
          ${this.chartDesc}
          <slot name="desc"></slot>
        </div>
        <div
          id="chart"
          chart="${this.__chartId}"
          role="presentation"
          aria-label="${this.chartTitle}"
          aria-describedby="${this.__chartId}-table ${this.__chartId}-desc"
          class="ct-chart ${this.scale}"
        ></div>
        <div
          id="${this.__chartId}-table"
          class="${this.showTable?"table":"table sr-only"}"
        >
          <slot></slot>
        </div>`}static get properties(){return{...super.properties,chartTitle:{type:String,attribute:"chart-title"},chartData:{type:Array,attribute:"chart-data"},chartDesc:{type:String,attribute:"chart-desc"},data:{type:Object,attribute:"data"},dataSource:{type:String,attribute:"data-source",reflect:!0},id:{type:String},options:{type:Object},pluginAxisTitle:{type:Object},pluginPointLabels:{type:Object},pluginFillDonutItems:{type:Array},responsiveOptions:{type:Array,attribute:"responsive-options"},scale:{type:String},showTable:{type:Boolean,attribute:"show-table"},type:{type:String}}}constructor(){super(),this.windowControllers=new AbortController,this.id="chart",this.type="bar",this.scale="ct-minor-seventh",this.responsiveOptions=[],this.data=[],this.dataSource="",this.showTable=!1,this.__chartId=s("chart-"),globalThis.ESGlobalBridge.requestAvailability(),this._loadScripts("chartistLib","lib/chartist/dist/chartist.min.js",this._chartistLoaded),this._updateData(),this.observer.observe(this,{attributes:!1,childList:!0,subtree:!0}),this.dispatchEvent(new CustomEvent("chartist-render-ready",{bubbles:!0,cancelable:!0,composed:!0,detail:this})),"object"==typeof Chartist&&this._chartistLoaded.bind(this)}static get tag(){return"chartist-render"}get plugins(){return[["Chartist.plugins.ctAxisTitle","lib/chartist-plugin-axistitle/dist/chartist-plugin-axistitle.min.js"],["Chartist.plugins.CtPointLabels","lib/chartist-plugin-pointlabels/dist/chartist-plugin-pointlabels.min.js"],["Chartist.plugins.fillDonut","lib/chartist-plugin-fill-donut/dist/chartist-plugin-fill-donut.min.js"]]}get observer(){return new MutationObserver(((t,e)=>this._updateData(t,e)))}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"chartData"===e&&JSON.stringify(this.chartData)!==JSON.stringify(t)?(this.dispatchEvent(new CustomEvent("chart-data-changed",{detail:this})),this._getChart()):"dataSource"===e&&this.dataSource!==t?(this.dispatchEvent(new CustomEvent("data-source-changed",{detail:this})),""!==this.dataSource&&fetch(this.dataSource).then((t=>t.text())).then((t=>this.data=this._CSVtoArray(t)))):"data"===e&&JSON.stringify(this.data)!==JSON.stringify(t)?(this.dispatchEvent(new CustomEvent("data-changed",{detail:this})),this._renderTable(),this._updateChartData()):this._getChart()}))}makeChart(){return this._getChart(),this.chart}disconnectedCallback(){this.windowControllers.abort(),this.observer&&this.observer.disconnect&&this.observer.disconnect(),super.disconnectedCallback()}_chartistLoaded(){this.__chartistLoaded=!0,this._getChart(),this.plugins.forEach((t=>this._loadScripts(t[0],t[1])))}_CSVtoArray(t){let e,i="",s=[""],c=[s],l=0,r=0,a=!0;for(e in t)e=t[e],'"'===e?(a&&e===i&&(s[l]+=e),a=!a):","===e&&a?(null!==s[l].trim().match(/^\d+$/m)&&(s[l]=parseInt(s[l].trim())),e=s[++l]=""):"\n"===e&&a?("\r"===i&&(s[l]=s[l].slice(0,-1)),null!==s[l].trim().match(/^\d+$/m)&&(s[l]=parseInt(s[l].trim())),s=c[++r]=[e=""],l=0):s[l]+=e,i=e;return null!==s[l].trim().match(/^\d+$/m)&&(s[l]=parseInt(s[l].trim())),c}_getUniqueId(t){return t+Date.now()}get fullOptions(){let t={...this.options};return Chartist.plugins&&(t.plugins=[],"pie"!==this.type&&this.pluginAxisTitle&&Chartist.plugins.ctAxisTitle&&t.plugins.push(Chartist.plugins.ctAxisTitle(this.pluginAxisTitle)),"line"===this.type&&this.pluginPointLabels&&Chartist.plugins.ctPointLabels&&(this.pluginPointLabels.labelInterpolationFnc||(this.pluginPointLabels.labelInterpolationFnc=Chartist.noop),t.plugins.push(Chartist.plugins.ctPointLabels(this.pluginPointLabels))),"pie"===this.type&&t.donut&&this.pluginFillDonutItems&&Chartist.plugins.fillDonut&&t.plugins.push(Chartist.plugins.fillDonut({items:this.pluginFillDonutItems}))),t}_getChart(){let t=null,e=this.shadowRoot?this.shadowRoot.querySelector("#chart"):void 0;e&&"object"==typeof Chartist&&this.chartData&&("bar"==this.type?(void 0!==this.responsiveOptions&&this.responsiveOptions.length>0&&this.responsiveOptions.forEach((t=>{void 0!==t[1]&&(t[1].axisX&&"noop"==t[1].axisX.labelInterpolationFnc&&(t[1].axisX.labelInterpolationFnc=Chartist.noop),t[1].axisY&&"noop"==t[1].axisY.labelInterpolationFnc&&(t[1].axisY.labelInterpolationFnc=Chartist.noop))})),t=Chartist.Bar(e,this.chartData,this.fullOptions,this.responsiveOptions)):"line"===this.type?t=Chartist.Line(e,this.chartData,this.fullOptions,this.responsiveOptions):"pie"===this.type&&(t=Chartist.Pie(e,{labels:this.chartData.labels||[],series:this.chartData.series||[]},this.fullOptions,this.responsiveOptions)),this.dispatchEvent(new CustomEvent("chartist-render-data",{bubbles:!0,cancelable:!0,composed:!0,detail:t})),t&&(t.on("created",(t=>{this.dispatchEvent(new CustomEvent("chartist-render-created",{bubbles:!0,cancelable:!0,composed:!0,detail:t}))})),t.on("draw",(t=>{this.dispatchEvent(new CustomEvent("chartist-render-draw",{bubbles:!0,cancelable:!0,composed:!0,detail:t}))})),this.chart=t))}_loadScripts(t,e,i=this._getChart){let s=`${new URL("./chartist-render.js",import.meta.url).href+"/../"}${e}`;globalThis.addEventListener(`es-bridge-${t}-loaded`,i.bind(this),{signal:this.windowControllers.signal}),globalThis.ESGlobalBridge.requestAvailability().load(t,s)}_renderTable(){let t="",e=this.querySelector("table"),i=this.data;if(i){let s=i[1]&&i[1][0]&&isNaN(i[1][0]),c=i[0]&&i[0][s?1:0]&&isNaN(i[0][s?1:0])?{row:s?i[0][0]:void 0,col:s?i[0].slice(1,i[0].length):i[0]}:void 0,l=i.series?i.series:i.slice(c?1:0,i.length).map((t=>s?{th:t[0],td:t.slice(1,t.length)}:{td:t}));!c&&i.labels&&(c=i.labels),e=e||globalThis.document.createElement("table"),c&&(t+=`\n           <thead><tr>\n             ${c.row?`<th scope="row">${c.row}</th>`:""}\n             ${c.col?c.col.map((t=>`<th scope="col">${t}</th>`)).join(""):""}\n           </tr></thead>`),l.length>0&&(t+=`\n           <tbody>\n             ${l.map((t=>`\n               <tr>\n                 ${t.th?`<th scope="row">${t.th}</th>`:""}\n                 ${t.td?t.td.map((t=>`<td>${t}</td>`)).join(""):""}\n               </tr>\n             `)).join("")}\n           </tbody>`),e.innerHTML=t,this.appendChild(e)}else e&&(e.innerHTML="")}_updateChartData(){let t=this.data,e=t&&t[1]&&t[1][0]&&isNaN(t[1][0]),i=t&&t[0]&&t[0][e?1:0]&&isNaN(t[0][e?1:0]),s=i?t[0]:void 0,c=i&&t[1]?t.slice(1,t.length):t;e&&(s=s.slice(1,s.length),c=c.map((t=>t.slice(1,t.length)))),this.__dataReady=!0,this.chartData={labels:s,series:"pie"===this.type?c[0]:c}}_updateData(t,e){let i=this.querySelector("table"),s=[];i&&i.querySelectorAll("tr").forEach((t=>{let e=[];t.querySelectorAll("th,td").forEach((t=>{let i=t.innerHTML.trim();e.push(isNaN(i)?i:parseInt(i))})),s.push(e)})),JSON.stringify(this.data)!==JSON.stringify(s)&&(this.data=s)}}};class ChartistRender extends(ChartistRenderSuper(t)){}customElements.define(ChartistRender.tag,ChartistRender);export{ChartistRender,ChartistRenderSuper};