/**
 * Copyright 2021 collinkleest
 * @license MIT, see License.md for full text.
 */
import{LitElement as t,html as e,css as o}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import{store as r}from"../../haxcms-elements/lib/core/haxcms-site-store.js";import{autorun as s,toJS as a}from"../../../mobx/dist/mobx.esm.js";class BootstrapBreadcrumb extends t{static get styles(){return[o`
        :host {
          --bootstrap-dark-theme-secondary-background-color: #343a40;
          --simple-icon-height: 18px;
          --simple-icon-width: 18px;
          --simple-icon-color: #007bff;
        }
        a {
          color: #007bff;
        }

        .container {
          background-color: #e9ecef;
          border-radius: 5px;
        }

        .breadcrumb {
          -moz-box-shadow: inset 0 2px 4px 0 rgb(0 0 0 / 10%);
          -webkit-box-shadow: inset 0 2px 4px 0 rgb(0 0 0 / 10%);
          box-shadow: inset 0 2px 4px 0 rgb(0 0 0 / 10%);
          list-style-type: none;
          display: flex;
        }
        .breadcrumb-item {
          padding: 0.5rem 0.75rem;
        }

        simple-icon-lite {
          margin-bottom: 5px;
        }

        a:hover simple-icon-lite {
          text-decoration: underline;
        }

        /* dark mode */
        :host([color-theme="1"]) {
          --simple-icon-color: #999;
        }

        :host([color-theme="1"]) simple-icon-lite:hover {
          --simple-icon-color: #fff;
        }

        :host([color-theme="1"]) .breadcrumb {
          background-color: var(
            --bootstrap-dark-theme-secondary-background-color
          );
          -moz-box-shadow: inset 0 2px 4px 0
            rgb(var(--bootstrap-theme-light-secondary-background-color), 0.7);
          -webkit-box-shadow: inset 0 2px 4px 0
            rgb(var(--bootstrap-theme-light-secondary-background-color), 0.7);
          box-shadow: inset 0 2px 4px 0
            rgb(var(--bootstrap-theme-light-secondary-background-color), 0.7);
        }

        :host([color-theme="1"]) .container {
          background-color: var(
            --bootstrap-dark-theme-secondary-background-color
          );
        }

        :host([color-theme="1"]) a {
          color: #999;
        }

        :host([color-theme="1"]) a:hover {
          color: #fff;
        }

        /* palenight theme */
        :host([color-theme="2"]) {
          --simple-icon-color: var(--bootstrap-theme-palenight-color);
        }

        :host([color-theme="2"]) simple-icon-lite:hover {
          --simple-icon-color: var(--bootstrap-theme-palenight-color);
        }

        :host([color-theme="2"]) .breadcrumb {
          background-color: var(
            --bootstrap-theme-palenight-secondary-background-color
          );
          -moz-box-shadow: inset 0 2px 4px 0
            rgb(var(--bootstrap-theme-light-secondary-background-color), 0.7);
          -webkit-box-shadow: inset 0 2px 4px 0
            rgb(var(--bootstrap-theme-light-secondary-background-color), 0.7);
          box-shadow: inset 0 2px 4px 0
            rgb(var(--bootstrap-theme-light-secondary-background-color), 0.7);
        }

        :host([color-theme="2"]) .container {
          background-color: var(
            --bootstrap-theme-palenight-secondary-background-color
          );
        }

        :host([color-theme="2"]) a {
          color: var(--bootstrap-theme-palenight-color);
        }

        :host([color-theme="2"]) a:hover {
          color: var(--bootstrap-theme-palenight-color);
        }
      `]}static get tag(){return"bootstrap-breadcrumb"}static get properties(){return{items:{type:Array},homeItem:{type:Object},colorTheme:{type:String,reflect:!0,attribute:"color-theme"}}}constructor(){super(),this.items=[],this._activeItem={},this.homeItem={};let t=this.getBasePath(decodeURIComponent(import.meta.url));this._bootstrapPath=t+"bootstrap/dist/css/bootstrap.min.css",this.__disposer=this.__disposer?this.__disposer:[],s((t=>{let e=a(r.manifest.items[0]),o=a(r.activeItem);this.homeItem!==e&&(this.homeItem=e),o&&this._activeItem!==o&&(this.items=[],this._activeItem=o,this.items.push(o),o.parent&&this.addParentToItems(o)),this.__disposer.push(t)}))}render(){return e`
      <link rel="stylesheet" href="${this._bootstrapPath}" />
      <div class="container p-0 mb-3">
        <nav aria-label="breadcrumb">
          <ol class="breadcrumb m-auto">
            <li
              id="home"
              class="breadcrumb-item"
              data-bs-toggle="tooltip"
              data-bs-placement="top"
              title="${this.homeItem.title}"
            >
              <a href="${this.homeItem.slug}">
                <simple-icon-lite accent-color="blue" icon="home">
                </simple-icon-lite>
              </a>
            </li>
            ${this.items.map((t=>e`
                <li
                  class="breadcrumb-item"
                  data-bs-toggle="tooltip"
                  data-bs-placement="top"
                  title="${t.title}"
                >
                  <a href="${t.slug}"> ${t.title} </a>
                </li>
              `))}
          </ol>
        </nav>
      </div>
    `}getBasePath(t){return t.substring(0,t.lastIndexOf("/@haxtheweb/")+1)}getParentById(t){let e=r.manifest.items.map((t=>a(t.id))).indexOf(t);return a(r.manifest.items[e])}addParentToItems(t){let e=this.getParentById(t.parent);this.items.unshift(e),e.parent&&this.addParentToItems(e)}firstUpdated(t){}updated(t){t.forEach(((t,e)=>{}))}}customElements.define(BootstrapBreadcrumb.tag,BootstrapBreadcrumb);export{BootstrapBreadcrumb};