/**
 * Copyright 2021
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import"../es-global-bridge/es-global-bridge.js";import"../simple-icon/lib/simple-icon-button.js";var o;class BarcodeReader extends e{static get styles(){return i`
      :host([hidden]) {
        display: none;
      }
      canvas {
        display: none;
      }
      video {
        border-style: solid;
        border-color: rgba(0, 0, 0, 0.5);
        border-width: 5px;
      }
    `}static get properties(){return{value:{type:String,reflect:!0},scale:{type:Number,reflect:!0},hideinput:{type:Boolean}}}render(){return t`
      <div class="hidden" hidden>
        <div>
          <video
            muted
            autoplay
            playsinline
            width="${this.scale}%"
            height="${this.scale}%"
          ></video>
          <canvas style="display: none; float: bottom;"></canvas>
        </div>
      </div>
      <div class="input" ?hidden="${this.hideinput}">
        Result: <span><input type="text" .value="${this.value}" /> </span>
      </div>
      <span>
        <div class="hidden2" hidden>
          <div class="select">
            <label for="videoSource">Video source: </label>
            <select></select>
          </div>
          <button class="go">Scan</button>
        </div>
        <simple-icon-button
          aria-labelledby="label"
          icon="image:camera-alt"
          class="render"
        ></simple-icon-button>
        <label id="label">Initialize</label>
      </span>
    `}constructor(){super(),this.value="",this.hideinput=!1,globalThis.ESGlobalBridge.requestAvailability().load("ZXing",decodeURIComponent(import.meta.url)+"/../lib/zxing.js"),globalThis.addEventListener("es-bridge-zxing-loaded",this._control.bind(this))}_control(){let e=this.shadowRoot.querySelector("video"),t=this.shadowRoot.querySelector("canvas"),i=t.getContext("2d"),a=this.shadowRoot.querySelector(".go"),r=!1,n=!0,s=null,d=null;var tick=function(){globalThis.ZXing?setTimeout((()=>{console.log("loaded zxing instance"),s=new globalThis.ZXing,d=s.Runtime.addFunction(decodeCallback)}),100):setTimeout(tick,100)};tick();var decodeCallback=async(e,t,i,o)=>{var r=new Uint8Array(s.HEAPU8.buffer,e,t);console.log(String.fromCharCode.apply(null,r)),this.value=String.fromCharCode.apply(null,r),a.removeAttribute("disabled")};function scanBarcode(){if(null==s)return a.removeAttribute("disabled"),void alert("Barcode Reader is not ready!");var t=null,r=0,l=0;n?(t=i,r=640,l=480):(t=mobileCtx,r=240,l=320),t.drawImage(e,0,0,r,l);var c=globalThis.document.createElement("canvas");c.width=o.videoWidth,c.height=o.videoHeight;var h=c.getContext("2d"),u=o.videoWidth,v=o.videoHeight;h.drawImage(e,0,0,u,v);var m=h.getImageData(0,0,u,v).data,g=s._resize(u,v);console.time("decode barcode");for(var b=0,p=0;b<m.length;b+=4,p++)s.HEAPU8[g+p]=m[b];var y=s._decode_any(d);console.timeEnd("decode barcode"),console.log(y),-2==y?setTimeout(scanBarcode,30):-3==y?(console.error("error code: ",y),a.removeAttribute("disabled")):0===y&&a.removeAttribute("disabled")}n="pc"==function browserRedirect(){var e=globalThis.navigator.userAgent.toLowerCase(),t="ipad"==e.match(/ipad/i),i="iphone os"==e.match(/iphone os/i),o="midp"==e.match(/midp/i),a="rv:1.2.3.4"==e.match(/rv:1.2.3.4/i),r="ucweb"==e.match(/ucweb/i),n="android"==e.match(/android/i),s="windows ce"==e.match(/windows ce/i),d="windows mobile"==e.match(/windows mobile/i);return t||i||o||a||r||n||s||d?"phone":"pc"}(),a.onclick=()=>{console.log("click"),this.value="",t.style.display="none",r=!1,a.setAttribute("disabled",""),scanBarcode()};var l=this.shadowRoot.querySelector("select");function getStream(){a.removeAttribute("disabled"),globalThis.stream&&globalThis.stream.getTracks().forEach((function(e){e.stop()}));var e={video:{deviceId:{exact:l.value}}};globalThis.navigator.mediaDevices.getUserMedia(e).then(gotStream).catch(handleError)}function gotStream(t){globalThis.stream=t,e.srcObject=t}function handleError(e){console.error("Error: ",e)}globalThis.navigator.mediaDevices.enumerateDevices().then((function gotDevices(e){for(var t=e.length-1;t>=0;--t){var i=e[t],o=globalThis.document.createElement("option");o.value=i.deviceId,"videoinput"===i.kind?(o.text=i.label||"camera "+(l.length+1),l.appendChild(o)):console.log("Found one other kind of source/device: ",i)}})).then(getStream).catch(handleError),l.onchange=getStream,this.shadowRoot.querySelector(".render").addEventListener("click",(()=>{if("Show"===this.shadowRoot.querySelector(".render").innerHTML&&globalThis.stream){globalThis.stream.getTracks().forEach((function(e){}));let e={video:{deviceId:{exact:l.value}}};globalThis.navigator.mediaDevices.getUserMedia(e).then(gotStream).catch(handleError)}}))}static get tag(){return"barcode-reader"}updated(e){e.forEach(((e,t)=>{"value"===t&&this.dispatchEvent(new CustomEvent("value-changed",{detail:this}))}))}firstUpdated(){this.start().then((e=>{})),this.__context=this.shadowRoot.querySelector("canvas").getContext("2d"),this.__video=this.shadowRoot.querySelector("video"),this.__videoInputSelector=this.shadowRoot.querySelector("#videoInput"),o=this.shadowRoot.querySelector("video"),this._renderVideo().then((e=>{})),this.hideinput||this.shadowRoot.querySelector(".input").removeAttribute("hidden")}async _onFrame(){this.__video.videoWidth>0&&this._drawFrame(this.__video),this.__animationFrameId=requestAnimationFrame(this._onFrame.bind(this))}_drawFrame(e){this.__context.drawImage(e,0,0,this.width,this.height,0,0,this.width,this.height)}async start(){this.shadowRoot.querySelector("simple-icon-button").addEventListener("click",(()=>{"Initialize"===this.shadowRoot.querySelector(".render").innerHTML&&this._control()}))}async _renderVideo(){let e=this.shadowRoot.querySelector(".hidden"),t=this.shadowRoot.querySelector("simple-icon-button"),i=this.shadowRoot.querySelector(".hidden2");e.style.display="none",this.shadowRoot.querySelector("simple-icon-button").addEventListener("click",(()=>{setTimeout((()=>{"none"===e.style.display?(e.style.display="inline",t.innerHTML="Hide",i.style.display="inline"):(e.style.display="none",t.innerHTML="Show",i.style.display="none",globalThis.stream.getTracks().forEach((function(e){e.stop()})))}),100)}))}}customElements.define(BarcodeReader.tag,BarcodeReader);export{BarcodeReader};